/*--------------------------------------------------------------------------*
 Project:
 File: gyro_EvaSampling.h

*--------------------------------------------------------------------------*/
#ifndef __GYRO_EVA_SAMPLING_FORF_H__
#define __GYRO_EVA_SAMPLING_FORF_H__

#include <nn/types.h>
#include <nn/hid.h>
#include <nn/hid/CTR/hid_GyroscopeLowReader.h>
#include <nn/hid/CTR/hid_GyroscopeLowCalibrator.h>
#include <nw/ut.h>

#include "gyro_ExtReader.h"
#include "gyro_GraphDrawing.h"
#include "gyro_Types.h"    
#include "gyro_Logger.h"    
#include "sys.h"

using namespace uji;
using namespace uji::sys;
using namespace uji::seq;
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "../seq/TestResult.h"

namespace uji {
namespace eva {
namespace forF {

	bool StickTest( uji::seq::TestResult &result );

class GyroEvaSampling
{
public:
    GyroEvaSampling() 
     : m_GyroRawLastAddedIndex(0), m_GyroLastAddedIndex(0), m_AccLastAddedIndex(0), m_LastCalcLatestDataIndex(0),
       m_IsGyroGraphRaw(true), m_IsGraphRangeSmall(false), m_IsSDCardDetected(false), m_IsLogging(false)
    {
        m_ExtReader = new GyroExtReader(GyroExtReader::LOGGING_BUFFER_SIZE);
        
        m_GyroRawLine[gyro::AXIS_RAW_X] = new LineElement("X", GRAPH_WIDTH, 0.0f, 110.0f, nw::ut::FloatColor(1.0f, 0.0f, 0.0f, 1.0f));  
        m_GyroRawLine[gyro::AXIS_RAW_Y] = new LineElement("Y", GRAPH_WIDTH, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 1.0f, 0.0f, 1.0f)); 
        m_GyroRawLine[gyro::AXIS_RAW_Z] = new LineElement("Z", GRAPH_WIDTH, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 0.0f, 1.0f, 1.0f));        
        m_GyroLine[gyro::AXIS_RAW_X] = new LineElement("X", GRAPH_WIDTH, 0.0f, 110.0f, nw::ut::FloatColor(1.0f, 0.0f, 0.0f, 1.0f));  
        m_GyroLine[gyro::AXIS_RAW_Y] = new LineElement("Y", GRAPH_WIDTH, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 1.0f, 0.0f, 1.0f)); 
        m_GyroLine[gyro::AXIS_RAW_Z] = new LineElement("Z", GRAPH_WIDTH, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 0.0f, 1.0f, 1.0f));
        m_AccRawLine[gyro::AXIS_RAW_X] = new LineElement("X", GRAPH_WIDTH, 0.0f, 110.0f, nw::ut::FloatColor(1.0f, 0.0f, 0.0f, 1.0f));  
        m_AccRawLine[gyro::AXIS_RAW_Y] = new LineElement("Y", GRAPH_WIDTH, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 1.0f, 0.0f, 1.0f)); 
        m_AccRawLine[gyro::AXIS_RAW_Z] = new LineElement("Z", GRAPH_WIDTH, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 0.0f, 1.0f, 1.0f));
    
        m_AccRawDiff.x = m_AccRawDiff.y = m_AccRawDiff.z = 0;
        m_GyroRawDiff.x = m_GyroRawDiff.y = m_GyroRawDiff.z = 0;        
    }
    virtual ~GyroEvaSampling()
    {
        for (int i=0; i<gyro::AXIS_RAW_NUM; i++)
        {
            delete m_GyroRawLine[i];
            delete m_GyroLine[i];            
            delete m_AccRawLine[i];
        }
        delete m_ExtReader;      
    }

	seq::TestResult  Run2();
    
    static void StickVoid()
    {
        GyroEvaSampling e;
        e.Run2();
    }    
    
    
private:
    void CalculateMaxMin();
    void UpdateGraph();
    s32 UpdateScreen(sys::GraphicsDrawing* gfx, s64 elapsed_time);
    
    sys::TextWindow*    m_TWndDebug;
    sys::WindowManager  m_WndManager;

    GyroExtReader* m_ExtReader;

    // OSDɕۑ܂
    GyroLogger m_GyroLogger;

    /*
        Ot
    */
    GyroGraphDrawing* m_GyroRawGraphDrawing;
    GyroGraphDrawing* m_GyroGraphDrawing;    
    GyroGraphDrawing* m_AccRawGraphDrawing;    
    LineElement* m_GyroRawLine[gyro::AXIS_RAW_NUM];
    LineElement* m_GyroLine[gyro::AXIS_RAW_NUM];    
    LineElement* m_AccRawLine[gyro::AXIS_RAW_NUM];
    
    // Ot̃obt@ɔfExtReaderf[^̃CfbNX
    s64 m_GyroRawLastAddedIndex;    
    s64 m_GyroLastAddedIndex;
    s64 m_AccLastAddedIndex;
    
    s64 m_LastCalcLatestDataIndex;
    
    bool m_IsGyroGraphRaw;
    bool m_IsGraphRangeSmall;
    bool m_IsSDCardDetected;
    bool m_IsLogging;

    nn::hid::AccelerometerStatus m_AccRawDiff;
    nn::hid::GyroscopeLowStatus m_GyroRawDiff;

    static const s32 TWND_DEBUG_WIDTH    = 20;
    static const s32 TWND_DEBUG_HEIGHT   = 8;    
    static const s32 TWND_DEBUG_POS_X    = 0;
    static const s32 TWND_DEBUG_POS_Y    = 0;
    
    static const s32 GRAPH_WIDTH = 185;
    static const s32 GRAPH_HEIGHT = 220; 
};



} // namespace
} // namespace
}

#endif
