/*--------------------------------------------------------------------------*
 Project:
 File: gyro_EvaMenu.cpp


*--------------------------------------------------------------------------*/
#include "gyro_Controller.h"
#include "gyro_EvaSampling.h"
#include "gyro_UdsMaster.h"
#include "gyro_UdsClient.h"
#include "gyro_ShockTester.h"
#include "gyro_AgingTester.h"
#include "gyro_ClientTestFunction.h"
#include <nn.h>


namespace uji {
namespace eva {


static void TmpDoReception();

/*
  Desc: WC]j[
*/
void OpenGyroMenu()
{
    using namespace uji::sys;

    ClassMenu *m = new ClassMenu( "Gyro Evaluation Menu" );
    m->Add(                " SPI Controller",          EvaGyroController::sRun);
    m->Add(                " Sampling Graph",          GyroEvaSampling::sRun);
    m->Add(                " Shock Test",              ShockTester::sRun);
    m->Add(                " Aging Test",              GyroAgingTester::sTest);
    m->Add<GyroUdsMaster>( " UDS Master(Comm Test)",   GyroUdsMaster::GetInstance(),  &GyroUdsMaster::EvaCommunication, NULL);
#if 0
    m->Add<GyroUdsClient>( " UDS Client(Reception)",   client, &GyroUdsClient::DoReception, NULL);
#endif
    m->Add(                " UDS Client(Reception)",   TmpDoReception, NULL);
    m->Add(                " Set Default Cal",         gyroC::SetDefaultCal);
    m->Add(                " Check Stability",         GyroEvaSampling::CheckStability);
    m->Open();

    delete m;
}

static void TmpDoReception()
{
    GyroUdsClient* client = new GyroUdsClient;

    client->GyroUdsClient::DoReception();

    delete client;
}


}   // namespace
}
