/*--------------------------------------------------------------------------*
 Project:
 File: gyro_ControllerRegister.h

*--------------------------------------------------------------------------*/

#ifndef __TEST_GYRO_CONTROLLER_REGISTER_H__
#define __TEST_GYRO_CONTROLLER_REGISTER_H__

#include <nn.h>

namespace uji {
namespace eva {


// ]tO
typedef enum GyroT_DirectionFlag
{
    TT_DIR_RIGHT   = 0x00,
    TT_DIR_LEFT    = 0x01
} GyroT_DirectionFlag;

// ]
typedef enum GyroT_RPM
{
    TT_RPM_33      = 0x00,
    TT_RPM_45      = 0x01,
    TT_RPM_78      = 0x02,
    TT_RPM_78_     = 0x03,
        
    TT_RPM_MAX     = 0x03
} GyroT_RPM;

// vǔےʒm
typedef union GyroT_ResultNotice
{
    u8 raw;
    struct
    {
        u8 GO   :   1;
        u8 NG   :   1;
        u8 RUN  :   1;
        u8 rsv  :   5;
    };    
} GyroT_ResultNotice;

// Xe[^X
typedef union GyroT_Status
{
    u8 raw;
    struct
    {
        u8 STA_BF       :   1;  // X^[g{^tO
        u8 DIR_F        :   1;  // E/]tO
        u8 ROT_BF       :   1;  // ^[e[u]X^[g{^tO   
        u8 ROT_F        :   1;  // ]tO
        u8 EM_STP_F     :   1;  // ^[e[uً}~tO
        u8 ROT_DIR_F    :   1;  // E/]ʒmtO
        u8 STA_F        :   1;  // Q[킩̌vtO̎M
        u8 rsv          :   1;  // \i`j
    };
} GyroT_Status;


//============================================================================
//============================================================================
//                     WRITEWX^
//============================================================================
//============================================================================

// vX^[gtO
const u32   REGSPI_W_STA_F_ADDR     = 0x000000;
const s16   REGSPI_W_STA_F_SHIFT    = 0;
const bit32 REGSPI_W_STA_F_MASK     = 0x01;

// ]wtO
const u32   REGSPI_W_DIR_F_ADDR     = 0x000001;
const s16   REGSPI_W_DIR_F_SHIFT    = 0;
const bit32 REGSPI_W_DIR_F_MASK     = 0x01;

// ]w背WX^
const u32   REGSPI_W_RPM_ADDR       = 0x000002;
const s16   REGSPI_W_RPM_SHIFT      = 0;
const bit32 REGSPI_W_RPM_MASK       = 0x03;

// ]tO
const u32   REGSPI_W_ROT_EN_ADDR    = 0x000003;
const s16   REGSPI_W_ROT_EN_SHIFT   = 0;
const bit32 REGSPI_W_ROT_EN_MASK    = 0x01;

// vǔےʒmWX^
const u32   REGSPI_W_RESULT_ADDR    = 0x000005;
const s16   REGSPI_W_RESULT_SHIFT   = 0;
const bit32 REGSPI_W_RESULT_MASK    = 0x07;


//============================================================================
//============================================================================
//                     READWX^
//============================================================================
//============================================================================

/* ------------------------------------------------------------------------
      Xe[^XWX^
 ------------------------------------------------------------------------ */
// Xe[^XWX^AhX
const u32   REGSPI_R_STATUS_ADDR            = 0x000000;

// X^[g{^tO
const s16   REGSPI_R_STATUS_STA_BF_SHIFT    = 0;
const bit32 REGSPI_R_STATUS_STA_BF_MASK     = 0x01;

// E/]tO
const s16   REGSPI_R_STATUS_DIR_F_SHIFT     = 1;
const bit32 REGSPI_R_STATUS_DIR_F_MASK      = 0x01;

// ^[e[u]X^[g{^tO
const s16   REGSPI_R_STATUS_ROT_BF_SHIFT    = 2;
const bit32 REGSPI_R_STATUS_ROT_BF_MASK     = 0x01;

// ]tO
const s16   REGSPI_R_STATUS_ROT_F_SHIFT     = 3;
const bit32 REGSPI_R_STATUS_ROT_F_MASK      = 0x01;

// ^[e[uً}~tO
const s16   REGSPI_R_STATUS_EM_STP_F_SHIFT  = 4;
const bit32 REGSPI_R_STATUS_EM_STP_F_MASK   = 0x01;

// E/]ʒmtO
const s16   REGSPI_R_STATUS_ROT_DIR_F_SHIFT = 5;
const bit32 REGSPI_R_STATUS_ROT_DIR_F_MASK  = 0x01;

// Q[킩̌vtO̎M
const s16   REGSPI_R_STATUS_STA_F_SHIFT     = 6;
const bit32 REGSPI_R_STATUS_STA_F_MASK      = 0x01;

/* ------------------------------------------------------------------------
      ]
 ------------------------------------------------------------------------ */
// ]WX^LowAhX
const u32   REGSPI_R_RPM_L_ADDR             = 0x000001;

// D0`D3: 1 
const s16   REGSPI_R_RPM_L_DEC_SHIFT        = 0;
const bit32 REGSPI_R_RPM_L_DEC_MASK         = 0x0f;
//D4`D7: 1
const s16   REGSPI_R_RPM_L_INT1_SHIFT        = 4;
const bit32 REGSPI_R_RPM_L_INT1_MASK         = 0x0f;


// ]WX^HighAhX
const u32   REGSPI_R_RPM_H_ADDR             = (REGSPI_R_RPM_L_ADDR + 0x000001);

// D8`D11: 10
const s16   REGSPI_R_RPM_H_INT10_SHIFT      = 0;
const bit32 REGSPI_R_RPM_H_INT10_MASK       = 0x0f;


/* ------------------------------------------------------------------------
      \tgEFAo[W
 ------------------------------------------------------------------------ */
// \tgEFAo[WPoCg
const u32   REGSPI_R_SW_VER_1_ADDR          = 0x000007;
const s16   REGSPI_R_SW_VER_1_SHIFT         = 0;
const bit32 REGSPI_R_SW_VER_1_MASK          = 0xff;

// \tgEFAo[WQoCg
const u32   REGSPI_R_SW_VER_2_ADDR          = (REGSPI_R_SW_VER_1_ADDR + 1);
const s16   REGSPI_R_SW_VER_2_SHIFT         = 0;
const bit32 REGSPI_R_SW_VER_2_MASK          = 0xff;

// \tgEFAo[WRoCg
const u32   REGSPI_R_SW_VER_3_ADDR          = (REGSPI_R_SW_VER_1_ADDR + 2);
const s16   REGSPI_R_SW_VER_3_SHIFT         = 0;
const bit32 REGSPI_R_SW_VER_3_MASK          = 0xff;

    
//============================================================================
//============================================================================
//                     탌WX^NX
//============================================================================
//============================================================================
class GyroControllerRegister
{
public:
    GyroControllerRegister(int clock=CLOCK_4M_HZ) : m_Clock(clock), m_PolingInterval(10) {}
    virtual ~GyroControllerRegister(){}

    void Initialize();
    void Finalize();

    /*---------------------------------------------------------------------------
        Desc: vX^[gtOݒ
              ɌvX^[gtOłB̃rbgƁu]tOv
                u^[e[u]X^[g{^vANDŃ^[e[u܂B
              vIfalse(0)ɂĉ

        Args: permission - false: X^[gs / true: X^[g

        Rtns: Ȃ
    ---------------------------------------------------------------------------*/
    void SetMeasureStartPermissionFlag(bool permission)
    {
        this->Write(REGSPI_W_STA_F_ADDR, (u8)(permission & REGSPI_W_STA_F_MASK));
    }

    /*---------------------------------------------------------------------------
        Desc: ]wtO̐ݒ

        Args: dir - DIR_RIGHT: E] / DIR_LEFT: ]

        Rtns: Ȃ
    ---------------------------------------------------------------------------*/
    void SetTurnTableDirection(GyroT_DirectionFlag dir)
    {
        this->Write(REGSPI_W_DIR_F_ADDR, (u8)(dir & REGSPI_W_DIR_F_MASK));
    }

    /*---------------------------------------------------------------------------
        Desc: ]̎w

        Args: rpm - RPM_33 / RPM_45 / RPM_78

        Rtns: Ȃ
    ---------------------------------------------------------------------------*/
    void SetTurnTableRPM(GyroT_RPM rpm)
    {
        this->Write(REGSPI_W_RPM_ADDR, (u8)(rpm & REGSPI_W_RPM_MASK));
    }
    
    /*---------------------------------------------------------------------------
        Desc: ]tOݒ
              ɉ]rbgłB
              ]ێԁu1vɂ܂B]~ꍇ́u0vɂ܂
                
        Args: enable - false: ]s / true: ]

        Rtns: Ȃ
    ---------------------------------------------------------------------------*/
    void SetTurnEnable(bool enable)
    {
        this->Write(REGSPI_W_ROT_EN_ADDR, (u8)(enable & REGSPI_W_ROT_EN_MASK));
    }
    
    /*---------------------------------------------------------------------------
        Desc: vǔےʒmWX^()̐ݒ
              ɌGO/NG/vʒm邽߂̃WX^
                pgvCŎgpꍇɁB

        Args: result - ʒmWX^ɐݒ肷f[^
        
        Rtns: Ȃ
    ---------------------------------------------------------------------------*/
    void SetResultNoticeReg(GyroT_ResultNotice result)
    {
        this->Write(REGSPI_W_RESULT_ADDR, (u8)(result.raw & REGSPI_W_RESULT_MASK));
    }

public:
    /*---------------------------------------------------------------------------
        Desc: Xe[^XWX^[h
              8biťXe[^XׂĎ擾܂        

        Args: Ȃ

        Rtns: Xe[^X
    ---------------------------------------------------------------------------*/
    GyroT_Status GetStatus()
    {
        GyroT_Status status;
    
        status.raw = this->Read(REGSPI_R_STATUS_ADDR);

        return status;
    }

    /*---------------------------------------------------------------------------
        Desc: <STATUS>X^[g{^tO̎擾

        Args: Ȃ

        Rtns: 0   OFF
              1   ONi{^Ăj
    ---------------------------------------------------------------------------*/
    bool GetStartButtonFlag()
    {
        return static_cast<bool>((this->Read(REGSPI_R_STATUS_ADDR) >> REGSPI_R_STATUS_STA_BF_SHIFT) 
                & REGSPI_R_STATUS_STA_BF_MASK);
    }

    /*---------------------------------------------------------------------------
        Desc: <STATUS>E/]tO̎擾
              ɎwĂlBۂ̉]"GetCurrentRotDirectionFlag"Ŏ擾

        Args: Ȃ

        Rtns: DIR_RIGHT: E] / DIR_LEFT: ]
    ---------------------------------------------------------------------------*/
    GyroT_DirectionFlag GetDirectionFlag()
    {
        return static_cast<GyroT_DirectionFlag>((this->Read(REGSPI_R_STATUS_ADDR) >> REGSPI_R_STATUS_DIR_F_SHIFT) 
                & REGSPI_R_STATUS_DIR_F_MASK);
    }

    /*---------------------------------------------------------------------------
        Desc: <STATUS>^[e[u]X^[g{^tO

        Args: Ȃ

        Rtns: 0   OFF
              1   ONi{^Ăj
    ---------------------------------------------------------------------------*/
    bool GetRotStartButtonFlag()
    {
        return static_cast<bool>((this->Read(REGSPI_R_STATUS_ADDR) >> REGSPI_R_STATUS_ROT_BF_SHIFT) 
                & REGSPI_R_STATUS_ROT_BF_MASK);
    }

    /*---------------------------------------------------------------------------
        Desc: <STATUS>^[e[u]tO̎擾
              ~Ԃł͎IɃu[LONɂȂ܂

        Args: Ȃ

        Rtns: 0   ~
              1   ]
    ---------------------------------------------------------------------------*/
    bool GetRotFlag()
    {
        return static_cast<bool>((this->Read(REGSPI_R_STATUS_ADDR) >> REGSPI_R_STATUS_ROT_F_SHIFT) 
                & REGSPI_R_STATUS_ROT_F_MASK);
    }

    /*---------------------------------------------------------------------------
        Desc: <STATUS>^[e[uً}~tO̎擾
              ^[e[uXgbvXCb`ƁAtOu1vɂȂ܂
              ̃tOu1v̊Ԃ́A^[e[ủ]Ɋւ閽߂͎󂯕t܂
                CTR͌vȈsA̓dOFFɂĉB

        Args: Ȃ

        Rtns: 0
              1   XgbvXCb`ꂽ
    ---------------------------------------------------------------------------*/
    bool GetEmergencyStopFlag()
    {
        return static_cast<bool>((this->Read(REGSPI_R_STATUS_ADDR) >> REGSPI_R_STATUS_EM_STP_F_SHIFT) 
                & REGSPI_R_STATUS_EM_STP_F_MASK);
    }

    /*---------------------------------------------------------------------------
        Desc: <STATUS>E/]ʒmtO̎擾iۂɉ]Ăԁj

        Args: Ȃ

        Rtns: DIR_RIGHT: E] / DIR_LEFT: ]
    ---------------------------------------------------------------------------*/
    GyroT_DirectionFlag GetCurrentRotDirectionFlag()
    {
        return static_cast<GyroT_DirectionFlag>((this->Read(REGSPI_R_STATUS_ADDR) >> REGSPI_R_STATUS_ROT_DIR_F_SHIFT) 
                & REGSPI_R_STATUS_ROT_DIR_F_MASK);
    }
    
    /*---------------------------------------------------------------------------
        Desc: <STATUS>Q[킩̌vtO̎MԂ

        Args: Ȃ

        Rtns: 1:  0: s
    ---------------------------------------------------------------------------*/
    GyroT_DirectionFlag GetStartPermissionFlag()
    {
        return static_cast<GyroT_DirectionFlag>((this->Read(REGSPI_R_STATUS_ADDR) >> REGSPI_R_STATUS_STA_F_SHIFT) 
                & REGSPI_R_STATUS_STA_F_MASK);
    }
    
    /*---------------------------------------------------------------------------
        Desc: ^[e[ũA^C]̎擾
              vX^[gtOɊ֌WȂłv\

        Args: Ȃ

        Rtns: ]
    ---------------------------------------------------------------------------*/
    f32 GetRotationSpeed()
    {
        f32 dec1  = static_cast<f32>((this->Read(REGSPI_R_RPM_L_ADDR) >> REGSPI_R_RPM_L_DEC_SHIFT) & REGSPI_R_RPM_L_DEC_MASK);        
        f32 int1  = static_cast<f32>((this->Read(REGSPI_R_RPM_L_ADDR) >> REGSPI_R_RPM_L_INT1_SHIFT) & REGSPI_R_RPM_L_INT1_MASK);
        f32 int10 = static_cast<f32>((this->Read(REGSPI_R_RPM_H_ADDR) >> REGSPI_R_RPM_H_INT10_SHIFT) & REGSPI_R_RPM_H_INT10_MASK);
    
        return dec1/10.0f + int1 + int10*10.0f;
    }

    /*---------------------------------------------------------------------------
        Desc: \tgEFAo[W̎擾

        Args: Ȃ

        Rtns: TODO: vڍ׊mF
    ---------------------------------------------------------------------------*/
    u32 GetTesterFirmwareVersion()
    {
        u32 ver = static_cast<u8>((this->Read(REGSPI_R_SW_VER_1_ADDR) >> REGSPI_R_SW_VER_1_SHIFT) & REGSPI_R_SW_VER_1_MASK)         |
                 (static_cast<u8>((this->Read(REGSPI_R_SW_VER_2_ADDR) >> REGSPI_R_SW_VER_2_SHIFT) & REGSPI_R_SW_VER_2_MASK) << 8)   |        
                 (static_cast<u8>((this->Read(REGSPI_R_SW_VER_3_ADDR) >> REGSPI_R_SW_VER_3_SHIFT) & REGSPI_R_SW_VER_3_MASK) << 16);    
        
        return ver;
    }
   
    /*---------------------------------------------------------------------------
        Desc: NbN̎擾
    ---------------------------------------------------------------------------*/
    enum {
        CLOCK_512K_HZ = 0,
        CLOCK_1M_HZ,
        CLOCK_2M_HZ,
        CLOCK_4M_HZ,
        CLOCK_8M_HZ,
        CLOCK_16M_HZ,
        CLOCK_MAX
    };

    int GetClock() const
    {
        return m_Clock;   
    }

private:    
    void Write(u32 addr, u8 data);
    u8 Read(u32 addr);
    
    int m_Clock;
    int m_PolingInterval;
    
    nn::os::Mutex m_Mutex;
    
    static const u32 TESTER_W_ADDR_MAX = 0x000007;
    static const u32 TESTER_R_ADDR_MAX = 0x00000a;
    static const s32 ACCESS_DATA_SIZE = 1;
};


} // namespace
}

#endif
