/*--------------------------------------------------------------------------*
 Project:
 File: gyro_ControllerRegister.cpp

 WCSPIWX^ANZX

*--------------------------------------------------------------------------*/
#include "gyro_ControllerRegister.h"
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>

namespace uji {
namespace eva {

#define USE_FILESTREAM


/*---------------------------------------------------------------------------
  Desc: 

  Args: clock - SPINbN 

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void GyroControllerRegister::Initialize()
{
#ifdef USE_FILESTREAM
    nn::fs::CardSpiBaudRate baudRate;
        
    NN_ASSERTMSG(m_Clock < CLOCK_MAX, "Error: Invalid clock(%d)\n", m_Clock);
            
    switch (m_Clock)
    {
        case CLOCK_512K_HZ : baudRate = nn::fs::CARDSPI_BAUDRATE_512KHZ;   break;   
        case CLOCK_1M_HZ   : baudRate = nn::fs::CARDSPI_BAUDRATE_1MHZ;     break;   
        case CLOCK_2M_HZ   : baudRate = nn::fs::CARDSPI_BAUDRATE_2MHZ;     break;
        case CLOCK_4M_HZ   : baudRate = nn::fs::CARDSPI_BAUDRATE_4MHZ;     break;
        case CLOCK_8M_HZ   : baudRate = nn::fs::CARDSPI_BAUDRATE_8MHZ;     break;
        case CLOCK_16M_HZ  : baudRate = nn::fs::CARDSPI_BAUDRATE_16MHZ;    break;
        default:                                                           break;
    }
        
    nn::fs::SetCardSpiBaudRate( baudRate );
#endif
    // ~[ebNX    
    m_Mutex.Initialize(false);    
}

/*---------------------------------------------------------------------------
  Desc: I

  Args: Ȃ
 
  Rtns: Ȃ
---------------------------------------------------------------------------*/
void GyroControllerRegister::Finalize()
{
#ifdef USE_FILESTREAM
#endif
    // ~[ebNX̔j
    m_Mutex.Finalize();    
}


/*---------------------------------------------------------------------------
  Desc: 탌WX^Cg

  Args: addr - AhX
        data - ݃f[^

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void GyroControllerRegister::Write(u32 addr, u8 data)
{
    m_Mutex.Lock();    
#ifdef USE_FILESTREAM    
    NN_ASSERTMSG(addr <= TESTER_W_ADDR_MAX, "Error: Invalid addr(%Xh)\n", addr);

    nn::fs::Write( 0x02, addr, reinterpret_cast<const u32*>( &data ), ACCESS_DATA_SIZE );
#else
    (void)addr;
    (void)data;
#endif
    m_Mutex.Unlock();    
}

/*---------------------------------------------------------------------------
  Desc: 탌WX^[h

  Args: addr - AhX

  Rtns: ǂݍ݃f[^
---------------------------------------------------------------------------*/
u8 GyroControllerRegister::Read(u32 addr)
{
    m_Mutex.Lock();    
#ifdef USE_FILESTREAM

    NN_ASSERTMSG(addr <= TESTER_R_ADDR_MAX, "Error: Invalid addr(%Xh)\n", addr);
        
    u8 data[sizeof(u32)];
    nn::fs::Read( 0x03, addr, reinterpret_cast<u32*>(data), sizeof(data) );

    m_Mutex.Unlock();    
        
    return data[0];    
#else
    (void)addr;
    
    m_Mutex.Unlock();    
    
    return 0xff;
#endif    
}


}   // namespace
}
