/*--------------------------------------------------------------------------*
 Project:
 File: gyro_Controller.h

*--------------------------------------------------------------------------*/
#ifndef __GYRO_TESTER_CONTROLLER_H__
#define __GYRO_TESTER_CONTROLLER_H__


#include "gyro_ControllerRegister.h"
#include "sys.h"

#include <nn/types.h>
#include <nw/ut.h>
#include <vector>

namespace uji {
namespace eva {



/*
    Rg[NX
*/
class GyroController : public GyroControllerRegister
{
public:
    GyroController() : m_StartEnable(false) {}
    virtual ~GyroController(){}
    
    /* ------------------------------------------------------------------------
        G[lRg[p֐Q
    ------------------------------------------------------------------------ */   
    // G[R[h
    enum TCError {
        TCTRL_ERROR_START_PERMISSION    = -1,   // vX^[g̋Ȃ
        TCTRL_ERROR_ROT_F_STOP          = -2,   // ^[e[u~
        TCTRL_ERROR_DIR_F               = -3,   // ɐ]ʒmoĂȂ
        TCTRL_ERROR_ROT_DIR_F           = -4,   // ^[e[u̎ۂ̉]i܂jw肵łȂ        
        TCTRL_ERROR_EM_STP_F            = -5,   // ^[e[uً}~tOꂽ
        TCTRL_ERROR_FATAL               = -128, // vIG[
            
        TCTRL_ERROR_NONE                = 0     // I
    };
         
    TCError SetMeasureStartPermissionFlag(bool permission);
    TCError SetTurnTableDirection(GyroT_DirectionFlag dir);
    TCError SetTurnTableRPM(GyroT_RPM rpm);
    TCError SetTurnEnable(bool enable);
    TCError GetRealTimeRotationSpeed(f32* pRealTimeRPM);
    TCError CheckTurnTableRealRotDirection();
    
private:
    bool m_StartEnable;
    
    bool padding[3];
};


/*
    ]NX
*/
class EvaGyroController;

// j[̗vf
struct MenuElement {
    MenuElement(char* name, void (EvaGyroController::*function)())
     : m_Name(name), m_Function(function)
    {}

    char* m_Name;
    void (EvaGyroController::*m_Function)();    // o֐|C^
};

// ]NX
class EvaGyroController
{
public:
    EvaGyroController() : 
    m_Cursor(0), m_CancelEvent(false), m_ReadUpdateCount(0), m_RPM(0)
    {}
    virtual ~EvaGyroController() {}

    static void sRun()
    {
        EvaGyroController e;
        e.Run();
    }

private:
    // ]j[̎s
    void Run();

    // \p
    void PrintCommandMenu();
    void UpdateScreen(sys::GraphicsDrawing* gfx);
    
    // R}hp[^ݒEChE
    void CreateCommandSettingWindow(char* name, s32 w, s32 h, s32 pos_x=120, s32 pos_y=80);
    void DestroyCommandSettingWindow();
    
    /* ------------------------------------------------------------------------
            R}hs֐ij[Ăяopj
    ------------------------------------------------------------------------ */        
    void Exec_SetMeasureStartPermission();
    void Exec_SetTurnTableDirection();
    void Exec_SetTurnTableRPM();
    void Exec_SetTurnTableRotEnable();
    void Exec_GetReadRegister();
    void Exec_GetSoftwareVersion();
    
private:
    // A[Ŏsnh
    void ReadRegAlarmHandler(bool cancelled);
    static void s_ReadRegAlarmHandler(void* param, bool cancelled);
    
    // 퐧NX̃CX^X
    GyroController m_GyroTCtrl;

    // Cj[vf̔z
    std::vector<MenuElement*> m_MenuOrderArray;
        
    int m_Cursor;
    
    // A[
    nn::os::Alarm m_Alarm;
    nn::os::Event m_CancelEvent;    

    int m_ReadUpdateCount;    
    f32 m_RPM;
    GyroT_Status m_Status;

    sys::WindowManager      m_WindowManager;
    sys::TextWindow*        m_TWndMain;
    sys::InputTextWindow*   m_IWndCommand;
    sys::TextWindow*        m_TWndStatus;
    sys::TextWindow*        m_TWndRPM;    
    sys::TextWindow*        m_TWndLog;
    
    /* ------------------------------------------------------------------------
            EChEɊւ萔
    ------------------------------------------------------------------------ */    
    static const int FONT_SIZE_L = 14;    
    static const int FONT_SIZE_S = 12;    

    static const s32 TWND_MAIN_WIDTH    = 30;
    static const s32 TWND_MAIN_POS_X    = 0;
    static const s32 TWND_MAIN_POS_Y    = 0;
    static const s32 TWND_LOG_WIDTH     = 35; 
    static const s32 TWND_LOG_HEIGHT    = 15;
    static const s32 TWND_LOG_POS_X     = 0;
    static const s32 TWND_LOG_POS_Y     = 0;
    static const s32 TWND_STATUS_WIDTH  = 15; 
    static const s32 TWND_STATUS_HEIGHT = 11;
    static const s32 TWND_STATUS_POS_X  = 220;
    static const s32 TWND_STATUS_POS_Y  = 0;
    static const s32 TWND_RPM_WIDTH     = 15; 
    static const s32 TWND_RPM_HEIGHT    = 2;
    static const s32 TWND_RPM_POS_X     = 220;
    static const s32 TWND_RPM_POS_Y     = 145;    
    
    // [hA[̎
    static const s32 READ_ALARM_INTERVAL = 100;
};


} // namespace
}

#endif
