/*--------------------------------------------------------------------------*
 Project:
 File: gyro_Controller.cpp

 WC


 /TODOF
    E]ɋً}~{^ꂽꍇA͖ŉ]~B
      ̏ꍇA^[e[u͕s̈ʒuŒ~邽߁Ǎ܂ł
      u[LA蓮ňʒusKvB
*--------------------------------------------------------------------------*/
#include "gyro_Controller.h"
#include "gyro_EvaSampling.h"    
#include "gyro_UdsMaster.h"
#include "gyro_UdsClient.h"
#include "gyro_ShockTester.h"
#include <nn.h>


namespace uji {
namespace eva {


//============================================================================
//============================================================================
//                     Rg[
//============================================================================
//============================================================================

/*
  Desc: vX^[gݒ

  Args: permission - false: X^[gs / true: X^[g

  Rtns: G[R[h
*/
GyroController::TCError GyroController::SetMeasureStartPermissionFlag(bool permission)
{
    // TODO: ʃXbhŏ펞Ď܂B
    if (GyroControllerRegister::GetStatus().EM_STP_F == true)
    {
        return TCTRL_ERROR_EM_STP_F;
    }
        
    // vX^[gݒ
    GyroControllerRegister::SetMeasureStartPermissionFlag(m_StartEnable = permission);
    
    return TCTRL_ERROR_NONE;
}

/*
  Desc: ^[e[u]w
        ۂ̊ϓ_"ROT_DIR_F"ŊmF
        
  Args: dir - DIR_RIGHT: E] / DIR_LEFT: ]

  Rtns: G[R[h
*/
GyroController::TCError GyroController::SetTurnTableDirection(GyroT_DirectionFlag dir)
{    
    NN_ASSERTMSG((dir == TT_DIR_RIGHT || dir == TT_DIR_LEFT), "Error: Invalid dir(%d)\n", dir);    
    
    // TODO: ʃXbhŏ펞Ď܂B    
    if (GyroControllerRegister::GetStatus().EM_STP_F == true)
    {
        return TCTRL_ERROR_EM_STP_F;
    }
        
    // ݂̉]iROT_DIR_FjƉ]wiDIR_F)vĂȂԂ
    // t]w߂𔭍sƃfbhbNɊׂ\
    // ~AROT_DIR_FDIR_Fɒǐ邽߁A~̔Ȃ
    GyroT_Status status = GyroControllerRegister::GetStatus();    
    if ((status.DIR_F != status.ROT_DIR_F) && (status.DIR_F != dir))
    {
        return TCTRL_ERROR_ROT_DIR_F;
    }
        
    // ]wtO̐ݒ
    GyroControllerRegister::SetTurnTableDirection(dir);
        
    // ɐʒmomF
    nn::os::Tick current;
    nn::os::Tick start = nn::os::Tick::GetSystemCurrent();    
    do
    {
        // ^CAEg
        current = nn::os::Tick::GetSystemCurrent();
        if ((current - start).ToTimeSpan().GetMilliSeconds() > 1000)
        {
            return TCTRL_ERROR_DIR_F;
        }
    }
    while (GyroControllerRegister::GetStatus().DIR_F != dir);        
    
    return TCTRL_ERROR_NONE;
}

/*
  Desc: ^[e[u]w

  Args: rpm - RPM_33 / RPM_45 / RPM_78
  
  Rtns: G[R[h
*/
GyroController::TCError GyroController::SetTurnTableRPM(GyroT_RPM rpm)
{
    NN_ASSERTMSG(rpm <= TT_RPM_MAX, "Error: Invalid rpm(%d)\n", rpm);    
    
    // TODO: ʃXbhŏ펞Ď܂B    
    if (GyroControllerRegister::GetStatus().EM_STP_F == true)
    {
        return TCTRL_ERROR_EM_STP_F;   
    }
        
    // ]̐ݒ
    GyroControllerRegister::SetTurnTableRPM(rpm);
    
    return TCTRL_ERROR_NONE;
}

/*
  Desc: ^[e[u]

  Args: enable - false: ]s / true: ]

  Rtns: G[R[h
*/
GyroController::TCError GyroController::SetTurnEnable(bool enable)
{
    // TODO: ʃXbhŏ펞Ď܂B    
    if (GyroControllerRegister::GetStatus().EM_STP_F == true)
    {
        return TCTRL_ERROR_EM_STP_F;   
    }
        
    // ]tOݒ
    // L̏ꍇA^[e[u]X^[g{^ꂽ]Jn
    GyroControllerRegister::SetTurnEnable(enable);
    
    return TCTRL_ERROR_NONE;
}

/*
  Desc: vǔےʒmWX^̐ݒ

  Args: 

  Rtns: 
*/
// TODO:


/*
  Desc: ^[e[uA^C]̎擾

  Args: pRealTimeRPM - 擾]i[ϐւ̃|C^

  Rtns: G[R[h
*/
GyroController::TCError GyroController::GetRealTimeRotationSpeed(f32* pRealTimeRPM)
{
    // TODO: ʃXbhŏ펞Ď܂B    
    if (GyroControllerRegister::GetStatus().EM_STP_F == true)
    {
        return TCTRL_ERROR_EM_STP_F;   
    }
        
    *pRealTimeRPM = GyroControllerRegister::GetRotationSpeed();
    
    return TCTRL_ERROR_NONE;
}

/*
  Desc: ^[e[uwiݒjɉ]Ă邩H
        
  Args: Ȃ

  Rtns: G[R[h
*/
GyroController::TCError GyroController::CheckTurnTableRealRotDirection()
{    
    // TODO: ʃXbhŏ펞Ď܂B    
    if (GyroControllerRegister::GetStatus().EM_STP_F == true)
    {
        return TCTRL_ERROR_EM_STP_F;
    }
    
    GyroT_Status status = GyroControllerRegister::GetStatus();
    
    if (status.ROT_F != true)
    {
        return TCTRL_ERROR_ROT_F_STOP; // ~
    }
    
    if (status.DIR_F != status.ROT_DIR_F)
    {
        return TCTRL_ERROR_ROT_DIR_F; // wɉ]ĂȂ
    }
    
    return TCTRL_ERROR_NONE;    
}

/*
  Desc: \tgEFAo[W̃`FbN

  Args: 

  Rtns: G[R[h
*/
// TODO:


//============================================================================
//============================================================================
//                     ]j[
//============================================================================
//============================================================================

/*
  Desc: R}hj[̕\

  Args: Ȃ

  Rtns: Ȃ  
*/
void EvaGyroController::PrintCommandMenu()
{
    int i=0;    
    m_TWndMain->Printf("\f");
    
    for (std::vector<MenuElement*>::iterator itr = m_MenuOrderArray.begin(); 
            itr != m_MenuOrderArray.end(); itr++)
    {
        if (i != 0) 
        {
            m_TWndMain->Printf("\n");
        }        
        if (m_Cursor == i)
        {
            m_TWndMain->SetTextColor(sys::ATTR_COLOR_YELLOW);
            m_TWndMain->Printf(">");
        }
        else
        {
            m_TWndMain->SetTextColor(sys::ATTR_COLOR_WHITE);
            m_TWndMain->Printf(" ");   
        }
        m_TWndMain->Printf(" %d.%s", i+1, (*itr)->m_Name);
        ++i;
    }
    m_TWndMain->SetTextColor(sys::ATTR_COLOR_WHITE);    
}

/*
  Desc: ]j[̉ʍXV

  Args: gfx -

  Rtns: Ȃ  
*/
void EvaGyroController::UpdateScreen(sys::GraphicsDrawing* gfx)
{
    // R}hj[֏o
    PrintCommandMenu();
            
    // Xe[^XEChE֏o
    m_TWndStatus->Printf("\f");
    m_TWndStatus->SetTextColor(sys::ATTR_COLOR_GREEN);
    m_TWndStatus->Printf("> %d\n", m_ReadUpdateCount);
    m_TWndStatus->SetTextColor(sys::ATTR_COLOR_WHITE);      
    m_TWndStatus->Printf("R_STA_BF   : %01X\n", m_Status.STA_BF);
    m_TWndStatus->Printf("R_DIR_F    : %01X\n", m_Status.DIR_F);
    m_TWndStatus->Printf("R_ROT_BF   : %01X\n", m_Status.ROT_BF);
    m_TWndStatus->Printf("R_ROT_F    : %01X\n", m_Status.ROT_F);
    m_TWndStatus->Printf("R_EM_STP_F : %01X\n", m_Status.EM_STP_F);
    m_TWndStatus->Printf("R_ROT_DIR_F: %01X",   m_Status.ROT_DIR_F);
        
    // ]EChE֏o    
    m_TWndRPM->Printf("\f");
    m_TWndRPM->SetTextColor(sys::ATTR_COLOR_GREEN);      
    m_TWndRPM->Printf("> %d\n", m_ReadUpdateCount);  
    m_TWndRPM->SetTextColor(sys::ATTR_COLOR_WHITE);      
    m_TWndRPM->Printf("%.2lfrpm", m_RPM);
        
    /* ------------------------------------------------------------------------
                ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay0();

    gfx->m_DrawFramework->SwapBuffers();

    /* ------------------------------------------------------------------------
                ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay1();

    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*
  Desc: ]j[s

  Args: Ȃ

  Rtns: Ȃ
*/
void EvaGyroController::Run()
{
    int exec_count = 0;
    
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    m_GyroTCtrl.Initialize();
    m_ReadUpdateCount = 0;    

    // A[̏
    m_Alarm.Initialize();
   
    /* ------------------------------------------------------------------------
        j[vf̐
    ------------------------------------------------------------------------ */    
    m_MenuOrderArray.push_back(new MenuElement("Set Start Permission", &EvaGyroController::Exec_SetMeasureStartPermission));
    m_MenuOrderArray.push_back(new MenuElement("Set Turntable Direction", &EvaGyroController::Exec_SetTurnTableDirection));
    m_MenuOrderArray.push_back(new MenuElement("Set Turntable Speed", &EvaGyroController::Exec_SetTurnTableRPM));
    m_MenuOrderArray.push_back(new MenuElement("Set Allow Rotation", &EvaGyroController::Exec_SetTurnTableRotEnable));
    m_MenuOrderArray.push_back(new MenuElement("Get Read Register", &EvaGyroController::Exec_GetReadRegister));
    m_MenuOrderArray.push_back(new MenuElement("Get Software Version", &EvaGyroController::Exec_GetSoftwareVersion));

    /* ------------------------------------------------------------------------
        EChE
    ------------------------------------------------------------------------ */    
    m_TWndMain = new sys::TextWindow(TWND_MAIN_WIDTH, m_MenuOrderArray.size(), FONT_SIZE_L);
    m_TWndMain->SetTitle("SPI Command List");    
    m_WindowManager.CreateWindow(m_TWndMain, NN_GX_DISPLAY0, TWND_MAIN_POS_X, TWND_MAIN_POS_Y); 
    m_TWndLog = new sys::TextWindow(TWND_LOG_WIDTH, TWND_LOG_HEIGHT, FONT_SIZE_S);
    m_TWndLog->SetTitle("Command LOG");                       
    m_WindowManager.CreateWindow(m_TWndLog, NN_GX_DISPLAY1, TWND_LOG_POS_X, TWND_LOG_POS_Y); 
    m_TWndStatus = new sys::TextWindow(TWND_STATUS_WIDTH, TWND_STATUS_HEIGHT, FONT_SIZE_S);
    m_TWndStatus->SetTitle("STATUS Reg");             
    m_WindowManager.CreateWindow(m_TWndStatus, NN_GX_DISPLAY1, TWND_STATUS_POS_X, TWND_STATUS_POS_Y);
    m_TWndRPM = new sys::TextWindow(TWND_RPM_WIDTH, TWND_RPM_HEIGHT, FONT_SIZE_S);
    m_TWndRPM->SetTitle("RPM Reg");    
    m_WindowManager.CreateWindow(m_TWndRPM, NN_GX_DISPLAY1, TWND_RPM_POS_X, TWND_RPM_POS_Y);        

    // CEChEANeBu
    m_WindowManager.SetActiveWindow(m_TWndMain);

    // R}hOEChEɏo
    m_TWndLog->Printf("\f");
    m_TWndLog->Printf("%03d> ", exec_count);
   
    do
    {
        // pbhXV
        sys::Pad().UpdatePad();
                        
        // EChE
        m_WindowManager.Update();
        m_WindowManager.UpdatePad(sys::Pad());

        // j[I
        if (sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_DOWN) && (++m_Cursor > (m_MenuOrderArray.size() - 1)))
        {
            m_Cursor = 0;
		}
		if (sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_UP) && (--m_Cursor < 0))
        {
            m_Cursor = (m_MenuOrderArray.size() - 1);
        }

        // s
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A) && m_MenuOrderArray[m_Cursor]->m_Function)
		{            
            void (EvaGyroController::*fpFunc)() = m_MenuOrderArray[m_Cursor]->m_Function;
            (this->*fpFunc)();
            
            m_TWndLog->SetTextColor(sys::ATTR_COLOR_WHITE);            
            m_TWndLog->Printf("%03d> ", ++exec_count);
		}
        
        // ʍXV
        UpdateScreen(gfx);
        
	}while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));

    /* ------------------------------------------------------------------------
        I
    ------------------------------------------------------------------------ */    
    m_WindowManager.DestroyWindow(m_TWndMain);
    m_WindowManager.DestroyWindow(m_TWndStatus);
    m_WindowManager.DestroyWindow(m_TWndRPM);    
    m_WindowManager.DestroyWindow(m_TWndLog);

    // A[LZ
    m_Alarm.Cancel();

    // LZ܂őҋ@
    while(!m_Alarm.CanSet()) {     
        NN_LOG("Finalize: Wait Cancel\n");
        m_CancelEvent.Wait();
    }
    m_Alarm.Finalize();

    m_GyroTCtrl.Finalize();
    
	sys::Pad().ClearTriggerFlag();
}

/*
  Desc: R}hp[^ݒEChE̐

  Args: Ȃ 

  Rtns: Ȃ  
*/  
void EvaGyroController::CreateCommandSettingWindow(char* name, s32 w, s32 h, s32 pos_x, s32 pos_y) 
{
    m_IWndCommand = new sys::InputTextWindow(w, h, FONT_SIZE_L, this->m_WindowManager);
    m_IWndCommand->SetTitle(name);
    m_WindowManager.CreateWindow(m_IWndCommand, NN_GX_DISPLAY0, pos_x, pos_y);
}

/*
  Desc: R}hp[^ݒEChE̍폜
  
  Args: Ȃ 

  Rtns: Ȃ   
*/  
void EvaGyroController::DestroyCommandSettingWindow() 
{
    m_WindowManager.DestroyWindow(m_IWndCommand);
}

/*
  Desc: 苖tO̐ݒ

  Args: Ȃ 

  Rtns: Ȃ   
*/
void EvaGyroController::Exec_SetMeasureStartPermission()
{    
    // R}hp[^͗pEChE̐
    CreateCommandSettingWindow("Set Parameter", 20, 4);
       
    // p[^̓V[PX
    m_IWndCommand->Printf("\f");
    m_IWndCommand->Printf("0: False \n1: True");
    m_IWndCommand->Printf("\n\nT_STA_F= ");
    bool permission = static_cast<bool>(m_IWndCommand->InputData16(0));
    
    // ̐ݒ
    GyroController::TCError result = m_GyroTCtrl.SetMeasureStartPermissionFlag(permission);

    // OEBhE֌ʂo
    sys::ATTR_TEXT_COLOR color = (0 != result) ? sys::ATTR_COLOR_MAGENTA : sys::ATTR_COLOR_WHITE;
    m_TWndLog->SetTextColor(color);    
    m_TWndLog->Printf("SET: T_STA_F(%01X) Ret(%d)\n", permission, result);
       
    // EChE폜
    DestroyCommandSettingWindow();
}

/*
  Desc: ^[e[u]̐ݒ

  Args: Ȃ 

  Rtns: Ȃ  
*/
void EvaGyroController::Exec_SetTurnTableDirection()
{    
    CreateCommandSettingWindow("Set Parameter", 20, 4);

    GyroT_DirectionFlag direction;
    
    // p[^̓V[PX
    do
    {
        m_IWndCommand->Printf("\f");
        m_IWndCommand->Printf("0: Right \n1: Left");
        m_IWndCommand->Printf("\n\nT_DIR_F= ");
        direction = static_cast<GyroT_DirectionFlag>(m_IWndCommand->InputData16(0));
    } while(!(direction == TT_DIR_RIGHT || direction == TT_DIR_LEFT));
    
    // ̐ݒ
    GyroController::TCError result = m_GyroTCtrl.SetTurnTableDirection(direction);

    // OEBhE֌ʂo
    sys::ATTR_TEXT_COLOR color = (0 != result) ? sys::ATTR_COLOR_MAGENTA : sys::ATTR_COLOR_WHITE;
    m_TWndLog->SetTextColor(color);
    m_TWndLog->Printf("SET: T_DIR_F(%s) Ret(%d)\n", direction == TT_DIR_RIGHT?"Right":"Left", result);
       
    DestroyCommandSettingWindow();
}

/*
  Desc: ^[e[u]̐ݒ

  Args: Ȃ 

  Rtns: Ȃ   
*/
void EvaGyroController::Exec_SetTurnTableRPM()
{    
    char* strRPM[] = {"33", "45", "78", "78"};
    
    CreateCommandSettingWindow("Set Parameter", 20, 6);
       
    GyroT_RPM rpm;
    
    // p[^̓V[PX
    do 
    {
        m_IWndCommand->Printf("\f");
        m_IWndCommand->Printf("0: %srpm\n1: %srpm\n2: %srpm\n3: %srpm", strRPM[0], strRPM[1], strRPM[2], strRPM[3]);
        m_IWndCommand->Printf("\n\nT_RPM= ");
        rpm = static_cast<GyroT_RPM>(m_IWndCommand->InputData16(0));
    } while(!(rpm <= TT_RPM_MAX));
    
    // ̐ݒ
    GyroController::TCError result = m_GyroTCtrl.SetTurnTableRPM(rpm);

    // OEBhE֌ʂo
    sys::ATTR_TEXT_COLOR color = (0 != result) ? sys::ATTR_COLOR_MAGENTA : sys::ATTR_COLOR_WHITE;
    m_TWndLog->SetTextColor(color);
    m_TWndLog->Printf("SET: T_RPM(%s) Ret(%d)\n", strRPM[rpm], result);
       
    DestroyCommandSettingWindow();
}

/*
  Desc: ^[e[u]tO̐ݒ

  Args: Ȃ 

  Rtns: Ȃ   
*/
void EvaGyroController::Exec_SetTurnTableRotEnable()
{
    CreateCommandSettingWindow("Set Parameter", 20, 4);
       
    // p[^̓V[PX
    m_IWndCommand->Printf("\f");
    m_IWndCommand->Printf("0: Disable\n1: Enable");
    m_IWndCommand->Printf("\n\nT_ROT_EN= ");
    bool enable = static_cast<bool>(m_IWndCommand->InputData16(0));
    
    // ̐ݒ
    GyroController::TCError result = m_GyroTCtrl.SetTurnEnable(enable);

    // OEBhE֌ʂo
    sys::ATTR_TEXT_COLOR color = (0 != result) ? sys::ATTR_COLOR_MAGENTA : sys::ATTR_COLOR_WHITE;
    m_TWndLog->SetTextColor(color);
    m_TWndLog->Printf("SET: T_ROT_EN(%x) Ret(%d)\n", enable, result);
       
    DestroyCommandSettingWindow();
}

/*
  Desc: [hWX^̎擾

  Args: Ȃ

  Rtns: Ȃ  
*/
void EvaGyroController::Exec_GetReadRegister()
{
    CreateCommandSettingWindow("Set Parameter", 20, 4);

    // p[^̓V[PX
    m_IWndCommand->Printf("\f");
    m_IWndCommand->Printf("0: One Time\n1: %dms interval", READ_ALARM_INTERVAL);
    m_IWndCommand->Printf("\n\nUpdate= ");
    bool bUpdate = static_cast<bool>(m_IWndCommand->InputData16(0));
        
    // A[ݒł悤ɂȂ܂őҋ@
    m_Alarm.Cancel();
    while (!m_Alarm.CanSet()){ nn::os::Thread::Yield(); }      
    
    if (bUpdate)
    {
        // A[ݒi100~bj
        m_Alarm.SetPeriodic(nn::fnd::TimeSpan::FromMilliSeconds(READ_ALARM_INTERVAL), s_ReadRegAlarmHandler, this);
    }
    else
    {
        m_Alarm.SetOneShot(nn::fnd::TimeSpan::FromMilliSeconds(0), s_ReadRegAlarmHandler, this);
    }
    m_TWndLog->Printf("SET: %s\n", bUpdate ? "Read(100ms interval)" : "Read(One Time)");
            
    DestroyCommandSettingWindow();
}

/*
  Desc: \tgEFAo[W擾

  Args: Ȃ 

  Rtns: Ȃ  
*/
void EvaGyroController::Exec_GetSoftwareVersion()
{
    m_TWndLog->Printf("GET: R_SW_V(%06Xh)\n", m_GyroTCtrl.GetTesterFirmwareVersion());
}

/*
  Desc: A[Ŏsnh

  Args: pEvent      - LZʒmCxg
        cancelled   - LZꂽǂ\ϐ

  Rtns: Ȃ  
*/
void EvaGyroController::ReadRegAlarmHandler(bool cancelled)
{
    if (cancelled)
    {
        NN_LOG(" Cancelled ReadRegAlarm.\n");
        m_CancelEvent.Signal();
    }
    // ŃWX^[h    
    else
    {
        m_GyroTCtrl.GetRealTimeRotationSpeed(&m_RPM);
        m_Status = m_GyroTCtrl.GetStatus();
        
        ++m_ReadUpdateCount;
    }        
}

/*
  Desc: A[nh̃bv֐
  
  Args: param       - o֐s̃IuWFNg̃|C^
        cancelled   - LZ
  
  Rtns: Ȃ
*/
void EvaGyroController::s_ReadRegAlarmHandler(void* param, bool cancelled)
{
    EvaGyroController* pEvaGyroController = reinterpret_cast<EvaGyroController*>(param);
    pEvaGyroController->ReadRegAlarmHandler(cancelled);
}


}   // namespace
}
