/*--------------------------------------------------------------------------*
 Project:
 File: gyro_ClientTestFunction.h


*--------------------------------------------------------------------------*/
#ifndef __GYRO_CLIENT_TEST_FUNCTION_H__
#define __GYRO_CLIENT_TEST_FUNCTION_H__

#include <nn/types.h>
#include <nn/hid.h>
#include <nn/hid/CTR/hid_GyroscopeLowReader.h>
#include <nn/hid/CTR/hid_GyroscopeLowCalibrator.h>
#include <nw/ut.h>

#include "gyro_LoopBuffer.h"
#include "gyro_Logger.h"
#include "gyro_Types.h"            
#include "sys.h"
#include "../seq/TestResult.h"    


namespace uji {
namespace eva {
namespace gyroC {


extern bool ATTEST_C(seq::TestResult &result);
extern bool Initialize(seq::TestResult &result);
extern bool GetProgramVersion(seq::TestResult &result);
extern bool GetPry(seq::TestResult &result);
extern bool Calibrate_TTRotMotionless(seq::TestResult &result);
extern bool CalibrateZ_TTRotR78rpm(seq::TestResult &result);
extern bool CalibrateZ_TTRotL78rpm(seq::TestResult &result);
extern bool CalibrateY_TTRotR78rpm(seq::TestResult &result);
extern bool CalibrateY_TTRotL78rpm(seq::TestResult &result);
extern bool CalibrateX_TTRotR78rpm(seq::TestResult &result);
extern bool CalibrateX_TTRotL78rpm(seq::TestResult &result);
extern bool WriteSDLog(seq::TestResult &result);
extern bool SendTestData(seq::TestResult &result);
extern bool WriteProductionLogOK(seq::TestResult &result);
extern bool SetCal(seq::TestResult &result);
extern void SetDefaultCal();
extern bool CheckCal_Sensitivity(seq::TestResult &result);
extern bool CheckCal_ZeroRateOutput(seq::TestResult &result);

extern bool LoggerWriteLabel(GyroLogger* gyroLogger);
extern bool LoggerWriteTestData(
    GyroLogger* gyroLogger, 
    gyro::GyroTestStatus* ts, 
    int id_major, int id_minor, u32 micro, 
    bool test_result);


} // namespace
}
}

#endif
