/*--------------------------------------------------------------------------*
 Project:
 File: gyro_ClientTestFunction


*--------------------------------------------------------------------------*/
#include "gyro_ClientTestFunction.h"
#include "gyro_UdsClient.h"
#include "gyro_Types.h"
#include "gyro_Logger.h"
#include "gyro_UdsMaster.h"
#include "../seq/TestIdDefine.h"
#include "../seq/TestResult.h"
#include "../seq/Reception_board_interface.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../sys/sys_GetSerialNumber.h"
#include <nn/uds.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/drivers/cal/CTR/cal_Api.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;


namespace uji {
namespace eva {
namespace gyroC {


// ֐̐錾
namespace internal {

typedef struct {
    bool isError;

    s32 stable_num;             // 肵f[^
    s64 stable_start_index;     // f[^̊JnCfbNX

    nn::hid::GyroscopeLowStatus max;
    nn::hid::GyroscopeLowStatus min;
    nn::hid::GyroscopeLowStatus ave;
}
TurnningStatus;

u32 Calibrate(gyro::RotationAxis axis, gyro::RotationSpeed speed);
u32 TurnningCheck(nn::hid::GyroscopeLowStatus status, gyro::RotationAxis axis, gyro::RotationSpeed speed);
u32 TurnningCheckFixedPeriod(
    gyro::RotationAxis axis,
    gyro::RotationSpeed speed,
    const s32 stableCheckSize,
    const s16 rpm0_tolerance,
    const s16 turn_tolerance,
    TurnningStatus* TStatus);
s32 SetCalCore(nn::hid::GyroscopeLowCalibrateParam cal_param);
bool WriteSDLog(int id_major, int id_minor, u32 micro, bool test_result);

} // namesoace internal


//============================================================================
//      MISC
//============================================================================

/*
    Desc: WC ATTEST
          UDSŃpPbg̑MmFeXgłB
*/
bool ATTEST_C(seq::TestResult &result)
{
    // MasterMpPbg
    GPacket* pRecvPacket = GyroUdsClient::GetRecvPacket();

    // Master֕ԐMpPbg
    GPacket* pSendPacket = GyroUdsClient::GetSendPacket();
#ifdef GYRO_ATTEST_SIMPLECOMM
    std::memcpy(&pSendPacket->m_Data[0], reinterpret_cast<u8*>(&pRecvPacket->m_Data[0]), sizeof(u16));
    std::memcpy(&pSendPacket->m_Data[2], reinterpret_cast<u8*>(&pRecvPacket->m_Data[2]), sizeof(u16));
    std::memcpy(&pSendPacket->m_Data[4], reinterpret_cast<u8*>(&pRecvPacket->m_Data[4]), sizeof(u16));
    pSendPacket->m_DataLength = pRecvPacket->m_DataLength;
#else
    // f[^ɃV[PTME[hێ
    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
    std::memcpy(reinterpret_cast<u8*>(&(ts->m_Rtc)),      reinterpret_cast<u8*>(pRecvPacket->m_Data),                     sizeof(ts->m_Rtc));
    std::memcpy(reinterpret_cast<u8*>(&(ts->m_TestMode)), reinterpret_cast<u8*>(pRecvPacket->m_Data + sizeof(ts->m_Rtc)), sizeof(ts->m_TestMode));

    // eXg[hfobOo
    GyroUdsClient::DebugPrintf(sys::ATTR_COLOR_WHITE, "TestMode(%d)\n", ts->m_TestMode);

    // mFpƂĎMf[^ԐM
    std::memcpy(pSendPacket->m_Data, reinterpret_cast<u8*>(pRecvPacket->m_Data), sizeof(gyro::TestTime) + sizeof(ts->m_TestMode));
    pSendPacket->m_DataLength = pRecvPacket->m_DataLength;
    std::sprintf(result.m_String, "TestMode(%X) RecvDataLen(%d)", ts->m_TestMode, pRecvPacket->m_DataLength);
#endif
    return result.m_Result = true;
}

/*
    Desc: 
*/
bool Initialize(seq::TestResult &result)
{
    // ̃NA
    GyroUdsClient::InitializeTestStatus();

    // obt@̃NA
    GyroUdsClient::GetExtReader()->GetExtdevCalib().loopBuffer->Clear();
    GyroUdsClient::GetExtReader()->GetAccCalib().loopBuffer->Clear();

    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();

    // MACAhX̎擾
    {
        uji::sys::GetMacAddress(ts->mac);
        std::sprintf(result.m_String,
            "%02X-%02X-%02X-%02X-%02X-%02X,",
            ts->mac[0], ts->mac[1], ts->mac[2], ts->mac[3], ts->mac[4], ts->mac[5]
        );
    }

    // VAԍ̎擾
    {
        sys::GetSerialNumber(ts->serialNo);
    }
    return result.m_Result = true;
}

/*
    Desc: vOo[W}X^[ɕԂ
*/
bool GetProgramVersion(seq::TestResult &result)
{
    GPacket* pSendPacket = GyroUdsClient::GetSendPacket();

    // o[W𐔒lϊĕԐMpPbgɊi[
    pSendPacket->m_Data[0] = VERSION_STRING[0]-'0';
    pSendPacket->m_Data[1] = VERSION_STRING[2]-'0';
    pSendPacket->m_DataLength = sizeof(u8)*2;

    std::sprintf(result.m_String, "%s Ver.[%X].[%X]", VERSION_STRING, pSendPacket->m_Data[0], pSendPacket->m_Data[1]);
    return result.m_Result = true;
}


//============================================================================
//      EC^[tF[Xp֐
//============================================================================

/*
    Desc: l̕ςZoăV[PTɕԂ
*/
bool GetPry(seq::TestResult &result)
{
    const int Config_SamplingDataNum = 20;  // ɗpf[^
    const int reserveDataNum = 10;          // \iTvOJn̎gpȂjf[^

    GyroExtReader reader(Config_SamplingDataNum + reserveDataNum);
    nn::hid::GyroscopeLowReader extDevReader;
    nn::hid::AccelerometerCalibrator accCalibReader;
    nn::hid::GyroscopeLowCalibrator extDevCalibrator;

    reader.Initialize();
    reader.SamplingStart(extDevCalibrator, extDevReader, accCalibReader);

    // TvO
    LoopBuffer<nn::hid::GyroscopeLowStatus>* pLoopBuffer = reader.GetExtdevCalib().loopBuffer;
    while (pLoopBuffer->GetValidDataNum() < Config_SamplingDataNum + reserveDataNum)
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1));
    }
    reader.SamplingStop();

    // f[^擾
    s32 sum_x, sum_y, sum_z;
    sum_x=sum_y=sum_z = 0;
    for (int i=0; i<Config_SamplingDataNum; i++)
    {
        s64 index = pLoopBuffer->LatestDataIndex() - i;
        nn::hid::GyroscopeLowStatus tmp = pLoopBuffer->GetData(index);

        sum_x += tmp.x;
        sum_y += tmp.y;
        sum_z += tmp.z;
    }
    // ϒlZo
    nn::hid::GyroscopeLowStatus ave = {
        static_cast<s16>(sum_x / Config_SamplingDataNum),
        static_cast<s16>(sum_y / Config_SamplingDataNum),
        static_cast<s16>(sum_z / Config_SamplingDataNum)
    };

    // readerI
    reader.Finalize();

    // V[PTɐΒlƂăoCiԂ܂
    nn::hid::GyroscopeLowStatus abs_ave = { std::abs(ave.x), std::abs(ave.y), std::abs(ave.z) };
    seq::g_CommC2T->WriteDpramBinary(reinterpret_cast<u8*>(&abs_ave), sizeof(nn::hid::GyroscopeLowStatus));

    sprintf(
        result.m_String,
        "X:Y:Z(%d %d %d)\n" "SamplingNum(%d)\n" "SendBin(%Xh)",
         ave.x, ave.y, ave.z, Config_SamplingDataNum, sizeof(nn::hid::GyroscopeLowStatus)
    );
    return result.m_Result = true;
}

//============================================================================
//      Lu[V
//============================================================================

/*
    Desc: l𔻒肷ׂ̊MASTER擾
*/

/*
    Desc: G[bZ[W̍쐬
*/
void MakeCalibrationErrorMessage(char* string, gyro::RotationAxis axis, gyro::RotationSpeed speed)
{
    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();

#ifndef FTR_ACC_GYRO
    sprintf(string,
        "CHECK BUILD OPTION [FTR_ACC]\n""\n""max_X:Y:Z(%d %d %d)\n" "min_X:Y:Z(%d %d %d)\n""max-min_X:Y:Z(%d %d %d)\n" ,
        ts->m_GyroStatusMax[axis][speed].x,
        ts->m_GyroStatusMax[axis][speed].y,
        ts->m_GyroStatusMax[axis][speed].z,
        ts->m_GyroStatusMin[axis][speed].x,
        ts->m_GyroStatusMin[axis][speed].y,
        ts->m_GyroStatusMin[axis][speed].z,
        ts->m_GyroStatusMax[axis][speed].x - ts->m_GyroStatusMin[axis][speed].x,
        ts->m_GyroStatusMax[axis][speed].y - ts->m_GyroStatusMin[axis][speed].y,
        ts->m_GyroStatusMax[axis][speed].z - ts->m_GyroStatusMin[axis][speed].z
    );
#else
    sprintf(string,
        "\n""max_X:Y:Z(%d %d %d)\n" "min_X:Y:Z(%d %d %d)\n""max-min_X:Y:Z(%d %d %d)\n" ,
        ts->m_GyroStatusMax[axis][speed].x,
        ts->m_GyroStatusMax[axis][speed].y,
        ts->m_GyroStatusMax[axis][speed].z,
        ts->m_GyroStatusMin[axis][speed].x,
        ts->m_GyroStatusMin[axis][speed].y,
        ts->m_GyroStatusMin[axis][speed].z,
        ts->m_GyroStatusMax[axis][speed].x - ts->m_GyroStatusMin[axis][speed].x,
        ts->m_GyroStatusMax[axis][speed].y - ts->m_GyroStatusMin[axis][speed].y,
        ts->m_GyroStatusMax[axis][speed].z - ts->m_GyroStatusMin[axis][speed].z
    );
#endif
}

/*
    Desc: Lu[Vi]j
*/
bool Calibrate_TTRotMotionless(seq::TestResult &result)
{
    result.m_Micro = internal::Calibrate(gyro::ROTATION_AXIS_RAW_Z, gyro::ROTATION_SPEED_0);
    result.m_Result = (result.m_Micro == ERROR_MICRO_CALIB_NONE) ? true : false;

    if (result.m_Result)
    {
        gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
        sprintf(result.m_String, "Cal_X:Y:Z(%d %d %d)",
            ts->m_ExtDevCalibParam.x.rpm0,
            ts->m_ExtDevCalibParam.y.rpm0,
            ts->m_ExtDevCalibParam.z.rpm0);
    }
    else
    {
        MakeCalibrationErrorMessage(result.m_String, gyro::ROTATION_AXIS_RAW_Z, gyro::ROTATION_SPEED_0);

        // SD֌f[^ۑ(G[R}h̓}X^[pgp)
        internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CALIB_MOTIONLESS, result.m_Micro, false);
    }
    return result.m_Result;
}

/*
    Desc: Lu[ViZ E]j
*/
bool CalibrateZ_TTRotR78rpm(seq::TestResult &result)
{
    result.m_Micro = internal::Calibrate(gyro::ROTATION_AXIS_RAW_Z, gyro::ROTATION_SPEED_78_POSITIVE);
    result.m_Result = (result.m_Micro == ERROR_MICRO_CALIB_NONE) ? true : false;

    if (result.m_Result)
    {
        gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
        sprintf(result.m_String, "Cal_Z_Posi(%d)", ts->m_ExtDevCalibParam.z.rpmPositive);
    }
    else
    {
        MakeCalibrationErrorMessage(result.m_String, gyro::ROTATION_AXIS_RAW_Z, gyro::ROTATION_SPEED_78_POSITIVE);
        internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CALIB_Z_R78, result.m_Micro, false);
    }
    return result.m_Result;
}

/*
    Desc: Lu[ViZ ]j
*/
bool CalibrateZ_TTRotL78rpm(seq::TestResult &result)
{
    result.m_Micro = internal::Calibrate(gyro::ROTATION_AXIS_RAW_Z, gyro::ROTATION_SPEED_78_NEGATIVE);
    result.m_Result = (result.m_Micro == ERROR_MICRO_CALIB_NONE) ? true : false;

    if (result.m_Result)
    {
        gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
        sprintf(result.m_String, "Cal_Z_Nega(%d)", ts->m_ExtDevCalibParam.z.rpmNegative);
    }
    else
    {
        MakeCalibrationErrorMessage(result.m_String, gyro::ROTATION_AXIS_RAW_Z, gyro::ROTATION_SPEED_78_NEGATIVE);
        internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CALIB_Z_L78, result.m_Micro, false);
    }
    return result.m_Result;
}

/*
    Desc: Lu[ViY E]j
*/
bool CalibrateY_TTRotR78rpm(seq::TestResult &result)
{
    result.m_Micro = internal::Calibrate(gyro::ROTATION_AXIS_RAW_Y, gyro::ROTATION_SPEED_78_POSITIVE);
    result.m_Result = (result.m_Micro == ERROR_MICRO_CALIB_NONE) ? true : false;

    if (result.m_Result)
    {
        gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
        sprintf(result.m_String, "Cal_Y_Nega(%d)", ts->m_ExtDevCalibParam.y.rpmNegative);
    }
    else
    {
        MakeCalibrationErrorMessage(result.m_String, gyro::ROTATION_AXIS_RAW_Y, gyro::ROTATION_SPEED_78_POSITIVE);
        internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CALIB_Y_R78, result.m_Micro, false);
    }
    return result.m_Result;
}

/*
    Desc: Lu[ViY ]j
*/
bool CalibrateY_TTRotL78rpm(seq::TestResult &result)
{
    result.m_Micro = internal::Calibrate(gyro::ROTATION_AXIS_RAW_Y, gyro::ROTATION_SPEED_78_NEGATIVE);
    result.m_Result = (result.m_Micro == ERROR_MICRO_CALIB_NONE) ? true : false;

    if (result.m_Result)
    {
        gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
        sprintf(result.m_String, "Cal_Y_Posi(%d)", ts->m_ExtDevCalibParam.y.rpmPositive);
    }
    else
    {
        MakeCalibrationErrorMessage(result.m_String, gyro::ROTATION_AXIS_RAW_Y, gyro::ROTATION_SPEED_78_NEGATIVE);
        internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CALIB_Y_L78, result.m_Micro, false);
    }
    return result.m_Result;
}

/*
    Desc: Lu[ViX E]j
*/
bool CalibrateX_TTRotR78rpm(seq::TestResult &result)
{
    result.m_Micro = internal::Calibrate(gyro::ROTATION_AXIS_RAW_X, gyro::ROTATION_SPEED_78_POSITIVE);
    result.m_Result = (result.m_Micro == ERROR_MICRO_CALIB_NONE) ? true : false;

    if (result.m_Result)
    {
        gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
        sprintf(result.m_String, "Cal_X_Posi(%d)", ts->m_ExtDevCalibParam.x.rpmPositive);
    }
    else
    {
        MakeCalibrationErrorMessage(result.m_String, gyro::ROTATION_AXIS_RAW_X, gyro::ROTATION_SPEED_78_POSITIVE);
        internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CALIB_X_R78, result.m_Micro, false);
    }
    return result.m_Result;
}

/*
    Desc: Lu[ViX ]j
*/
bool CalibrateX_TTRotL78rpm(seq::TestResult &result)
{
    result.m_Micro = internal::Calibrate(gyro::ROTATION_AXIS_RAW_X, gyro::ROTATION_SPEED_78_NEGATIVE);
    result.m_Result = (result.m_Micro == ERROR_MICRO_CALIB_NONE) ? true : false;

    if (result.m_Result)
    {
        gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
        sprintf(result.m_String, "Cal_X_Nega(%d)", ts->m_ExtDevCalibParam.x.rpmNegative);
    }
    else
    {
        MakeCalibrationErrorMessage(result.m_String, gyro::ROTATION_AXIS_RAW_X, gyro::ROTATION_SPEED_78_NEGATIVE);
        internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CALIB_X_L78, result.m_Micro, false);
    }
    return result.m_Result;
}

namespace internal {

/*
    Desc: xɂݒuԂ̃`FbN
*/
// TODO: 

/*
    Desc: ^[e[u̎v肪\]ł邩H
*/
bool GetMakerAxisClockWise(gyro::RotationAxis axis, gyro::RotationSpeed speed)
{
    bool MakerAxisClockWise[][gyro::ROTATION_AXIS_RAW_NUM] = {
        {true, false, true},    // InvenSense
        {false, false, false},  // InvenSensei\PbgCp
        {true, true, true}      // SPFL
    };

    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
    int mode = (ts->m_TestMode == seq::pl::REPAIR)                     ? 1 :
               (uji::sys::PLATFORM_CTR == uji::sys::GetPlatformType())  ? 0 : 2;

    bool val = MakerAxisClockWise[mode][axis];
    return  (speed == gyro::ROTATION_SPEED_78_POSITIVE) ? val : !val;
}

/*
    Desc: w莲̊pxLu
          Lupf[^̎Zo܂ōs܂BNAND(Cal)ւ݂͕̏ʂ̃eXgōs܂B

    Args: axis    - eXg]
          speed   - eXg]x

    Rtns: trueiLuj/falseiLusj
*/
u32 Calibrate(gyro::RotationAxis axis, gyro::RotationSpeed speed)
{
    const s32 Config_CalibStableJudgeNum = 154;
    const s32 Config_CalibJudgeNum = 154; // 2(])/0.0013(1msł̉]) =1538(ms)  1538/10 = 154
    const s32 Config_CalibStableTimeOut = G_TIMEOUT_CALIBRATION_C;
    const int SAMPLING_INTERVAL_MSEC = 10;

    const s16 Config_rpm0_tolerance = 32;
    const s16 Config_turn_tolerance = 42;
    const s16 Config_Margin_tolerance = 32; // {̃XybN邽߂ɉZ}[W
                                            // xǂׂɈ莞ԓɈ肵ȂꍇɎgp
    s16 rpm0_tolerance;
    s16 turn_tolerance;

    u32 err = ERROR_MICRO_CALIB_FATAL;

    TurnningStatus TStatus;
    // 
    TStatus.stable_num = 0;
    TStatus.stable_start_index = 0;

    nn::os::Tick current;
    nn::os::Tick start = nn::os::Tick::GetSystemCurrent();

    do
    {
        // ^[e[u肵ԂŁAɏ\ȃf[^TvÔ҂܂B
        nn::os::Thread::Sleep(
            nn::fnd::TimeSpan::FromMilliSeconds((Config_CalibStableJudgeNum - TStatus.stable_num)*SAMPLING_INTERVAL_MSEC)
        );
        current = nn::os::Tick::GetSystemCurrent();
        if ((current - start).ToTimeSpan().GetMilliSeconds() < G_ACCURATE_CARIBRATION_TIME)
        {
            // XybN茵
            rpm0_tolerance = Config_rpm0_tolerance;
            turn_tolerance = Config_turn_tolerance;
        }
        else
        {
            // {̃XybNł̔
            rpm0_tolerance = Config_rpm0_tolerance + Config_Margin_tolerance;
            turn_tolerance = Config_turn_tolerance + Config_Margin_tolerance;
        }

        // Ԏw莲E]x̊pxł邱ƂmF
        err = TurnningCheckFixedPeriod(axis, speed, Config_CalibStableJudgeNum, rpm0_tolerance, turn_tolerance, &TStatus);
        if (err == ERROR_MICRO_CALIB_NONE)
        {
            LoopBuffer<nn::hid::GyroscopeLowStatus>* pLoopBuffer = GyroUdsClient::GetExtReader()->GetExtdevCalib().loopBuffer;
            s32 offset_index = Config_CalibStableJudgeNum - Config_CalibJudgeNum;
            gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
            nn::hid::GyroscopeLowStatus tmp_status;
            struct sum_status {
                s32 x;
                s32 y;
                s32 z;
            }sum_status = {0, 0, 0};

            // ɗv
            ts->m_StableTime[axis][speed] = (current - start).ToTimeSpan().GetMilliSeconds();

            // f[^ێlZo
            for (s32 i = 0; i < Config_CalibJudgeNum; i++)
            {
                tmp_status = pLoopBuffer->GetData(TStatus.stable_start_index + offset_index + i);

                // őlEŏl̍XV
                ts->m_GyroStatusMax[axis][speed].x = ::std::max(ts->m_GyroStatusMax[axis][speed].x, tmp_status.x);
                ts->m_GyroStatusMax[axis][speed].y = ::std::max(ts->m_GyroStatusMax[axis][speed].y, tmp_status.y);
                ts->m_GyroStatusMax[axis][speed].z = ::std::max(ts->m_GyroStatusMax[axis][speed].z, tmp_status.z);
                ts->m_GyroStatusMin[axis][speed].x = ::std::min(ts->m_GyroStatusMin[axis][speed].x, tmp_status.x);
                ts->m_GyroStatusMin[axis][speed].y = ::std::min(ts->m_GyroStatusMin[axis][speed].y, tmp_status.y);
                ts->m_GyroStatusMin[axis][speed].z = ::std::min(ts->m_GyroStatusMin[axis][speed].z, tmp_status.z);

                // SUM
                sum_status.x += tmp_status.x;
                sum_status.y += tmp_status.y;
                sum_status.z += tmp_status.z;
            }

            // ϒl
            nn::hid::GyroscopeLowStatus ave_status = {
                static_cast<s16>(sum_status.x / Config_CalibJudgeNum),
                static_cast<s16>(sum_status.y / Config_CalibJudgeNum),
                static_cast<s16>(sum_status.z / Config_CalibJudgeNum)
            };

            // SĂ̑f[^0̏ꍇ̓foCX삵ĂȂƂ݂ȂăG[
            if (ts->m_GyroStatusMax[axis][speed].x == 0 && ts->m_GyroStatusMax[axis][speed].y == 0 && ts->m_GyroStatusMax[axis][speed].z == 0 &&
                ts->m_GyroStatusMin[axis][speed].x == 0 && ts->m_GyroStatusMin[axis][speed].y == 0 && ts->m_GyroStatusMin[axis][speed].z == 0)
            {
                GyroUdsClient::DebugPrintf(sys::ATTR_COLOR_CYAN, "NG Sp:Ax(%d,%d) All Data is 0\n", speed, axis);
                GyroUdsClient::UpdateDisplay();

                return ERROR_MICRO_CALIB_ALL_ZERO;
            }
            else
            {

#ifndef FTR_ACC_GYRO
                // fobOo
                GyroUdsClient::DebugPrintf(sys::ATTR_COLOR_CYAN, "OK Sp:Ax(%d,%d) Max-Min(%d, %d, %d) StNum(%d)\n",
                    speed, axis,
                    ts->m_GyroStatusMax[axis][speed].x - ts->m_GyroStatusMin[axis][speed].x,
                    ts->m_GyroStatusMax[axis][speed].y - ts->m_GyroStatusMin[axis][speed].y,
                    ts->m_GyroStatusMax[axis][speed].z - ts->m_GyroStatusMin[axis][speed].z,
                    TStatus.stable_num);
                GyroUdsClient::UpdateDisplay();
#endif
                // Lupf[^i[ieXgΏۂ̎̒l̂݁j
                switch (speed)
                {
                case gyro::ROTATION_SPEED_0:
                    ts->m_ExtDevCalibParam.x.rpm0 = ave_status.x;
                    ts->m_ExtDevCalibParam.y.rpm0 = ave_status.y;
                    ts->m_ExtDevCalibParam.z.rpm0 = ave_status.z;
#ifdef FTR_ACC_GYRO
                    ts->m_ExtDevCalibParam.x.rpmPositive = 6727 + ts->m_ExtDevCalibParam.x.rpm0;
                    ts->m_ExtDevCalibParam.y.rpmPositive = 6727 + ts->m_ExtDevCalibParam.y.rpm0;
                    ts->m_ExtDevCalibParam.z.rpmPositive = 6727 + ts->m_ExtDevCalibParam.z.rpm0;
                    ts->m_ExtDevCalibParam.x.rpmNegative = -6728 + ts->m_ExtDevCalibParam.x.rpm0;
                    ts->m_ExtDevCalibParam.y.rpmNegative = -6728 + ts->m_ExtDevCalibParam.y.rpm0;
                    ts->m_ExtDevCalibParam.z.rpmNegative = -6728 + ts->m_ExtDevCalibParam.z.rpm0;
#endif
                    break;

                case gyro::ROTATION_SPEED_78_POSITIVE:
                case gyro::ROTATION_SPEED_78_NEGATIVE:

                    if (GetMakerAxisClockWise(axis, speed))
                    {
                        switch (axis)
                        {
                        case gyro::ROTATION_AXIS_RAW_X:

#ifdef FTR_ACC_GYRO
                            ts->m_ExtDevCalibParam.x.rpmPositive = 6727 + ts->m_ExtDevCalibParam.x.rpm0;
#else
                            ts->m_ExtDevCalibParam.x.rpmPositive = ave_status.x;
#endif
                            break;
                        case gyro::ROTATION_AXIS_RAW_Y:
#ifdef FTR_ACC_GYRO
                            ts->m_ExtDevCalibParam.y.rpmPositive = 6727 + ts->m_ExtDevCalibParam.y.rpm0;
#else
                            ts->m_ExtDevCalibParam.y.rpmPositive = ave_status.y;
#endif
                            break;
                        case gyro::ROTATION_AXIS_RAW_Z:
#ifdef FTR_ACC_GYRO
                            ts->m_ExtDevCalibParam.z.rpmPositive = 6727 + ts->m_ExtDevCalibParam.z.rpm0;
#else
                            ts->m_ExtDevCalibParam.z.rpmPositive = ave_status.z;
#endif
                            break;
                        default:
                            break;
                        }
                    }
                    else
                    {
                        switch (axis)
                        {
                        case gyro::ROTATION_AXIS_RAW_X:
#ifdef FTR_ACC_GYRO
                            ts->m_ExtDevCalibParam.x.rpmNegative = -6728 + ts->m_ExtDevCalibParam.x.rpm0;
#else
                            ts->m_ExtDevCalibParam.x.rpmNegative = ave_status.x;
#endif
                            break;
                        case gyro::ROTATION_AXIS_RAW_Y:
#ifdef FTR_ACC_GYRO
                            ts->m_ExtDevCalibParam.y.rpmNegative = -6728 + ts->m_ExtDevCalibParam.y.rpm0;
#else
                            ts->m_ExtDevCalibParam.y.rpmNegative = ave_status.y;
#endif
                            break;
                        case gyro::ROTATION_AXIS_RAW_Z:
#ifdef FTR_ACC_GYRO
                            ts->m_ExtDevCalibParam.z.rpmNegative = -6728 + ts->m_ExtDevCalibParam.z.rpm0;
#else
                            ts->m_ExtDevCalibParam.z.rpmNegative = ave_status.z;
#endif
                            break;
                        default:
                            break;
                        }
                    }
                    break;

                default:
                    break;
                }

                return ERROR_MICRO_CALIB_NONE;
            }
        }
    }
    while ((current - start).ToTimeSpan().GetMilliSeconds() < Config_CalibStableTimeOut);

    // G[f[^ێ
    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
    ts->m_GyroStatusMax[axis][speed].x = TStatus.max.x;
    ts->m_GyroStatusMax[axis][speed].y = TStatus.max.y;
    ts->m_GyroStatusMax[axis][speed].z = TStatus.max.z;
    ts->m_GyroStatusMin[axis][speed].x = TStatus.min.x;
    ts->m_GyroStatusMin[axis][speed].y = TStatus.min.y;
    ts->m_GyroStatusMin[axis][speed].z = TStatus.min.z;

    ts->m_StableTime[axis][speed] = Config_CalibStableTimeOut;

    // Lus
    return err;
}

/*
    Desc: WC̊pxuԁvw莲E]xł邱Ƃ`FbN

    Args: axis              - CTRݒuĂ鎲
          speed             - ^[e[u]x
          stableCheckSize   - 𔻒肷邽߂̃f[^
          rpm0_tolerance    - ]̈
          turn_tolerance    - ]̈
          TStatus           - Zof[^i[邽߂̃obt@

    Rtns: trueiԁj/ falseiꂩ̎̉]x͈͊Oj
*/
u32 TurnningCheckFixedPeriod(
    gyro::RotationAxis axis,
    gyro::RotationSpeed speed,
    const s32 stableCheckSize,
    const s16 rpm0_tolerance,
    const s16 turn_tolerance,
    TurnningStatus* TStatus)
{
    s32 sum_status_x = 0;
    s32 sum_status_y = 0;
    s32 sum_status_z = 0;
    s16 judge_tolerance = (speed == gyro::ROTATION_SPEED_0) ? rpm0_tolerance : turn_tolerance;
    nn::hid::GyroscopeLowStatus max_status = {-37268/2, -32768/2, -32768/2};
    nn::hid::GyroscopeLowStatus min_status = { 37267/2,  32767/2,  32767/2};

    TStatus->max = max_status;
    TStatus->min = min_status;
    TStatus->stable_num = 0;

    // li[p̃Oobt@
    LoopBuffer<nn::hid::GyroscopeLowStatus>* pLoopBuffer;
    pLoopBuffer = GyroUdsClient::GetExtReader()->GetExtdevCalib().loopBuffer;

    // Lȑf[^ɖȂꍇ͏I
    if (stableCheckSize > pLoopBuffer->GetValidDataNum())
    {
        return ERROR_MICRO_CALIB_VALID_DATA_SHORT;
    }

    s64 latestIndex = pLoopBuffer->LatestDataIndex();
    for (TStatus->stable_num = 0; TStatus->stable_num < stableCheckSize; (TStatus->stable_num)++)
    {
        s64 index = latestIndex - TStatus->stable_num;
        nn::hid::GyroscopeLowStatus tmp_status = pLoopBuffer->GetData(index);

        // őlEŏl̍XV
        TStatus->max.x = ::std::max(TStatus->max.x, tmp_status.x);
        TStatus->max.y = ::std::max(TStatus->max.y, tmp_status.y);
        TStatus->max.z = ::std::max(TStatus->max.z, tmp_status.z);
        TStatus->min.x = ::std::min(TStatus->min.x, tmp_status.x);
        TStatus->min.y = ::std::min(TStatus->min.y, tmp_status.y);
        TStatus->min.z = ::std::min(TStatus->min.z, tmp_status.z);

        // ϒl̎Zo
        sum_status_x += tmp_status.x;
        sum_status_y += tmp_status.y;
        sum_status_z += tmp_status.z;
        TStatus->ave.x = static_cast<s16>(sum_status_x / (TStatus->stable_num + 1));
        TStatus->ave.y = static_cast<s16>(sum_status_y / (TStatus->stable_num + 1));
        TStatus->ave.z = static_cast<s16>(sum_status_z / (TStatus->stable_num + 1));

        // 肵Ă邩mF
        if ((TStatus->max.x - TStatus->min.x > judge_tolerance) ||
            (TStatus->max.y - TStatus->min.y > judge_tolerance) ||
            (TStatus->max.z - TStatus->min.z > judge_tolerance))
        {
#ifndef FTR_ACC_GYRO
            GyroUdsClient::DebugPrintf(
                sys::ATTR_COLOR_WHITE,
                "NG Sp:Ax(%d,%d) Max-Min(%d, %d, %d) StNum(%d)\n",
                speed, axis,
                TStatus->max.x - TStatus->min.x,
                TStatus->max.y - TStatus->min.y,
                TStatus->max.z - TStatus->min.z,
                TStatus->stable_num);
            GyroUdsClient::UpdateDisplay();
#endif
            return ERROR_MICRO_CALIB_STABLE;
        }
        else
        {
            // el̐`FbN
            u32 err = TurnningCheck(TStatus->ave, axis, speed);
            if (err == ERROR_MICRO_CALIB_NONE)
            {
                // Lȃf[^̊JnCfbNXێ
                TStatus->stable_start_index = index;
            }
            else
            {
#ifndef FTR_ACC_GYRO
                GyroUdsClient::DebugPrintf(
                    sys::ATTR_COLOR_WHITE, "NG Sp:Ax(%d,%d) StNum(%d)\n",
                    speed, axis, TStatus->stable_num);
                GyroUdsClient::DebugPrintf(
                    sys::ATTR_COLOR_WHITE, "Max/Min xyz(%d,%d,%d/%d,%d,%d)\n",
                    TStatus->max.x, TStatus->max.y, TStatus->max.z,
                    TStatus->min.x, TStatus->min.y, TStatus->min.z);
                GyroUdsClient::UpdateDisplay();
#endif
                return err;
            }
        }
    }

    return ERROR_MICRO_CALIB_NONE;
}

/*
    Desc: WC̊pxw莲E]xł邱Ƃ`FbN

    Args: status  - WCf[^
          axis    - 肷]
          speed   - 肷]x

    Rtns: trueiԁj/ falseiꂩ̎̉]x͈͊Oj
*/
u32 TurnningCheck(nn::hid::GyroscopeLowStatus status, gyro::RotationAxis axis, gyro::RotationSpeed speed)
{
    const s16 Config_t78_min    = CONFIG_T78RPM_MIN;
    const s16 Config_t78_max    = CONFIG_T78RPM_MAX;
    const s16 Config_t0_margin  = CONFIG_T0RPM_MARGIN;

    s32 j_max, j_min;
    u32 err = 0x0;

    // 0_ItZbgQƗp
    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();

    // 
    switch (speed)
    {
    // [_i[VXj
    case gyro::ROTATION_SPEED_0:
        err = ((status.x < -Config_t0_margin) || (Config_t0_margin < status.x) ||
               (status.y < -Config_t0_margin) || (Config_t0_margin < status.y) ||
               (status.z < -Config_t0_margin) || (Config_t0_margin < status.z))
                ? ERROR_MICRO_CALIB_RANGE : ERROR_MICRO_CALIB_NONE;
        break;

    // ] ]̒l̔̓[_ItZbgĔ
    case gyro::ROTATION_SPEED_78_POSITIVE:
    case gyro::ROTATION_SPEED_78_NEGATIVE:
        if (GetMakerAxisClockWise(axis, speed))
        {
            j_max = Config_t78_max;
            j_min = Config_t78_min;
        }
        else
        {
            j_max = -Config_t78_min;
            j_min = -Config_t78_max;
        }

        switch (axis)
        {
        // X]
        case gyro::ROTATION_AXIS_RAW_X:
            err = ((j_min > (status.x - ts->m_ExtDevCalibParam.x.rpm0)) ||
                   (j_max < (status.x - ts->m_ExtDevCalibParam.x.rpm0)))
                    ? ERROR_MICRO_CALIB_RANGE : ERROR_MICRO_CALIB_NONE;

            err |= ((status.y < -Config_t0_margin) || (Config_t0_margin < status.y) ||
                    (status.z < -Config_t0_margin) || (Config_t0_margin < status.z))
                    ? ERROR_MICRO_CALIB_CROSSAXIS : ERROR_MICRO_CALIB_NONE;
            break;

        // Y]
        case gyro::ROTATION_AXIS_RAW_Y:
            err = ((j_min > (status.y - ts->m_ExtDevCalibParam.y.rpm0)) ||
                   (j_max < (status.y - ts->m_ExtDevCalibParam.y.rpm0)))
                    ? ERROR_MICRO_CALIB_RANGE : ERROR_MICRO_CALIB_NONE;

            err |= ((status.x < -Config_t0_margin) || (Config_t0_margin < status.x) ||
                    (status.z < -Config_t0_margin) || (Config_t0_margin < status.z))
                    ? ERROR_MICRO_CALIB_CROSSAXIS : ERROR_MICRO_CALIB_NONE;
            break;

        // Z]
        case gyro::ROTATION_AXIS_RAW_Z:
            err = ((j_min > (status.z - ts->m_ExtDevCalibParam.z.rpm0)) ||
                   (j_max < (status.z - ts->m_ExtDevCalibParam.z.rpm0)))
                    ? ERROR_MICRO_CALIB_RANGE : ERROR_MICRO_CALIB_NONE;

            err |= ((status.y < -Config_t0_margin) || (Config_t0_margin < status.y) ||
                    (status.x < -Config_t0_margin) || (Config_t0_margin < status.x))
                    ? ERROR_MICRO_CALIB_CROSSAXIS : ERROR_MICRO_CALIB_NONE;
            break;

        // sȃp[^
        default:
            NN_ASSERTMSG(false, "Error: Invalid axis(%d)\n", axis);
            err = ERROR_MICRO_CALIB_FATAL;
            break;
        }
        break;

    // sȃp[^
    default:
        NN_ASSERTMSG(false, "Error: Invalid speed(%d)\n", speed);
        err = ERROR_MICRO_CALIB_FATAL;
        break;
    }

    return err;
}

} // namespace internal


//============================================================================
//      f[^SDۑ
//============================================================================

/*
    Desc: eXgf[^SDJ[hɕۑ܂
        ijʂ true ̏ꍇɎgp
*/
bool WriteSDLog(seq::TestResult &result)
{
    return result.m_Result = internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_WRITE_SDLOG, 0, true);
}

/*
    Desc: eXgf[^̑M
*/
bool SendTestData(seq::TestResult &result)
{

    GPacket* pSendPacket = GyroUdsClient::GetSendPacket();

    std::memcpy(pSendPacket->m_Data, reinterpret_cast<u8*>(GyroUdsClient::GetTestStatus()), sizeof(gyro::GyroTestStatus));
    pSendPacket->m_DataLength = sizeof(gyro::GyroTestStatus);

    std::sprintf(result.m_String, "data_length= %d", pSendPacket->m_DataLength);
    return result.m_Result = true;
}

/*
    Desc: x̕ۑ
*/
bool LoggerWriteLabel(GyroLogger* gyroLogger)
{
    if (gyroLogger->GetFileSize() == 0)
    {
        // /̏
        gyroLogger->Printf("TestVer.,""NG Code,""Mode,""MacAddress,""SerialNo.,""UniqueID,""Time,");
        // CAL
        gyroLogger->Printf(
            "Cal_X[rpm0],Cal_X[rpm78],Cal_X[rpm-78],"
            "Cal_Y[rpm0],Cal_Y[rpm78],Cal_Y[rpm-78],"
            "Cal_Z[rpm0],Cal_Z[rpm78],Cal_Z[rpm-78],");
        // eeXgMAXAMINAMAX-MIN
        char *szRpm[]  = {"rpm0", "rpm78", "rpm-78"};
        char *szAxis[] = {"AxisX", "AxisY", "AxisZ"};

        for (int elems = 0; elems < 4; elems++)
        {
            for (int axis = 0; axis < gyro::ROTATION_AXIS_RAW_NUM; axis++)
            {
                for (int speed = 0; speed < gyro::ROTATION_SPEED_NUM; speed++)
                {
                    if (axis != gyro::ROTATION_AXIS_RAW_Z && speed == 0)
                    {
                        // ]̑Zł̂ݍsĂׁAȊỎ]̌̃O͎cȂ
                        continue;
                    }

                    char* r = szRpm[speed];
                    char* a = szAxis[axis];

                    switch (elems)
                    {
                    case 0: gyroLogger->Printf("Stable[%s%s](ms),", r, a);                                   break;
                    case 1: gyroLogger->Printf("Max_X[%s%s],Max_Y[%s%s],Max_Z[%s%s],", r, a, r, a, r, a);    break;
                    case 2: gyroLogger->Printf("Min_X[%s%s],Min_Y[%s%s],Min_Z[%s%s],", r, a, r, a, r, a);    break;
                    case 3: gyroLogger->Printf("Diff_X[%s%s],Diff_Y[%s%s],Diff_Z[%s%s],", r, a, r, a, r, a); break;
                    default:
                        break;
                    }
                }
            }
        }

        // CAL OffsetZ
        gyroLogger->Printf(
            "Sens_X[rpm0],Sens_X[rpm78],Sens_X[rpm-78],"
            "Sens_Y[rpm0],Sens_Y[rpm78],Sens_Y[rpm-78],"
            "Sens_Z[rpm0],Sens_Z[rpm78],Sens_Z[rpm-78],");

        /*
            oׁE[ĥ݌vEZof[^
        */
        // xY
        gyroLogger->Printf(
            "Rate_CalSensDiff_X[rpm78](%%),RateCalSensDiff_X[rpm-78](%%),"
            "Rate_CalSensDiff_Y[rpm78](%%),RateCalSensDiff_Y[rpm-78](%%),"
            "Rate_CalSensDiff_Z[rpm78](%%),RateCalSensDiff_Z[rpm-78](%%),");
        // Cx
        gyroLogger->Printf("LineSense_X[rpm78](lsb),LineSense_Y[rpm78](lsb),LineSense_Z[rpm78](lsb),");
        // o/ƍH̃[_̐Βl
        gyroLogger->Printf("Diff_ZeroRateOutput_X,Diff_ZeroRateOutput_Y,Diff_ZeroRateOutput_Z,");
        // s
        gyroLogger->Printf("\n");

        return true;
    }

    return false;
}

/*
    Desc: eXgf[^̃Cg
*/
bool LoggerWriteTestData(GyroLogger* gyroLogger, gyro::GyroTestStatus* ts, int id_major, int id_minor, u32 micro, bool test_result)
{
    // vOo[W
    gyroLogger->Printf("Ver.%s,", VERSION_STRING);
    // NGR[h
    if (test_result)    gyroLogger->Printf("-,");
    else                gyroLogger->Printf("%d-%d-%d,", id_major, id_minor, micro);
    // eXg[h
    gyroLogger->Printf("%s,", ts->m_TestMode == uji::seq::pl::LINE   ? "LINE"      :
                              ts->m_TestMode == uji::seq::pl::QC     ? "QC"        :
                              ts->m_TestMode == uji::seq::pl::ACCEPT ? "ACCEPT"    :
                              ts->m_TestMode == uji::seq::pl::REPAIR ? "SOCKET"    :
                              ts->m_TestMode == uji::seq::pl::DEBUG  ? "FATAL_ERR" : "?");
    // MACAhX
    gyroLogger->Printf(
        "%02X-%02X-%02X-%02X-%02X-%02X,",
        ts->mac[0], ts->mac[1], ts->mac[2], ts->mac[3], ts->mac[4], ts->mac[5]
    );
    // VAԍ
    gyroLogger->Printf("%s,", ts->serialNo);
    // UniqueID
#ifdef EVA_GYRO_C
    GyroUdsClient* guc = new GyroUdsClient;
    gyroLogger->Printf("%04X,", guc->GetUniqueID());
    delete guc;
#else
    gyroLogger->Printf("%04X,", GyroUdsMaster::GetInstance()->GetUniqueID());
#endif
    // 
    gyroLogger->Printf("%04d/%02d/%02d %02d:%02d,",
        ts->m_Rtc.year, ts->m_Rtc.month, ts->m_Rtc.day, ts->m_Rtc.hour, ts->m_Rtc.minute);

    /*
        e푪EZof[^
    */
    // CAL
    gyroLogger->Printf(
        "%d,%d,%d,%d,%d,%d,%d,%d,%d,",
        ts->m_ExtDevCalibParam.x.rpm0, ts->m_ExtDevCalibParam.x.rpmPositive, ts->m_ExtDevCalibParam.x.rpmNegative,
        ts->m_ExtDevCalibParam.y.rpm0, ts->m_ExtDevCalibParam.y.rpmPositive, ts->m_ExtDevCalibParam.y.rpmNegative,
        ts->m_ExtDevCalibParam.z.rpm0, ts->m_ExtDevCalibParam.z.rpmPositive, ts->m_ExtDevCalibParam.z.rpmNegative
    );

    // eeXgMAXAMINAMAX-MIN
    for (int elems = 0; elems < 4; elems++)
    {
        for (int axis = 0; axis < gyro::ROTATION_AXIS_RAW_NUM; axis++)
        {
            for (int speed = 0; speed < gyro::ROTATION_SPEED_NUM; speed++)
            {
                if (axis != gyro::ROTATION_AXIS_RAW_Z && speed == 0)
                {
                    // ]̑Zł̂ݍsĂׁAȊỎ]̌̃O͎cȂ
                    continue;
                }
                nn::hid::GyroscopeLowStatus max = {
                    ts->m_GyroStatusMax[axis][speed].x,
                    ts->m_GyroStatusMax[axis][speed].y,
                    ts->m_GyroStatusMax[axis][speed].z
                };
                nn::hid::GyroscopeLowStatus min = {
                    ts->m_GyroStatusMin[axis][speed].x,
                    ts->m_GyroStatusMin[axis][speed].y,
                    ts->m_GyroStatusMin[axis][speed].z
                };

                switch (elems)
                {
                case 0: gyroLogger->Printf("%d,",ts->m_StableTime[axis][speed]);                 break;
                case 1: gyroLogger->Printf("%d,%d,%d,", max.x, max.y, max.z);                    break;
                case 2: gyroLogger->Printf("%d,%d,%d,", min.x, min.y, min.z);                    break;
                case 3: gyroLogger->Printf("%d,%d,%d,", max.x-min.x, max.y-min.y, max.z-min.z);  break;
                default:
                    break;
                }
            }
        }
    }

    // CAL OffsetZ
    gyroLogger->Printf(
        "%d,%d,%d,%d,%d,%d,%d,%d,%d,",
        ts->m_ExtDevCalibParam.x.rpm0        - ts->m_ExtDevCalibParam.x.rpm0,
        ts->m_ExtDevCalibParam.x.rpmPositive - ts->m_ExtDevCalibParam.x.rpm0,
        ts->m_ExtDevCalibParam.x.rpmNegative - ts->m_ExtDevCalibParam.x.rpm0,
        ts->m_ExtDevCalibParam.y.rpm0        - ts->m_ExtDevCalibParam.y.rpm0,
        ts->m_ExtDevCalibParam.y.rpmPositive - ts->m_ExtDevCalibParam.y.rpm0,
        ts->m_ExtDevCalibParam.y.rpmNegative - ts->m_ExtDevCalibParam.y.rpm0,
        ts->m_ExtDevCalibParam.z.rpm0        - ts->m_ExtDevCalibParam.z.rpm0,
        ts->m_ExtDevCalibParam.z.rpmPositive - ts->m_ExtDevCalibParam.z.rpm0,
        ts->m_ExtDevCalibParam.z.rpmNegative - ts->m_ExtDevCalibParam.z.rpm0);

    /*
        oׁE[ĥ݌vEZof[^
    */
    // xY
    for (int axis = 0; axis < gyro::ROTATION_AXIS_RAW_NUM; axis++)
    {
        gyroLogger->Printf(
            "%.2llf,%.2llf,",
            ts->m_RateCalSensDifference[axis].rpmPositive, ts->m_RateCalSensDifference[axis].rpmNegative);
    }
    // Cx
    for (int axis = 0; axis < gyro::ROTATION_AXIS_RAW_NUM; axis++)
    {
        gyroLogger->Printf("%.2llf,", ts->m_LineSens[axis]);
    }
    // o/ƍH̃[_̐Βl
    for (int axis = 0; axis < gyro::AXIS_RAW_NUM; axis++)
    {
        gyroLogger->Printf("%d,", ts->m_ZeroRateOutputDiff[axis]);
    }
    // s
    gyroLogger->Printf("\n");

    return true;
}

namespace internal {

/*
    Desc: eXgf[^̕ۑ
*/
bool WriteSDLog(int id_major, int id_minor, u32 micro, bool test_result)
{
    GyroLogger gyroLogger;

    // SDJ[ho
    if (gyroLogger.IsSdmcInserted())
    {
        nn::Result nnResult = nn::fs::MountSdmc();
        if (nnResult.IsSuccess())
        {
            // fBNgȂꍇ͐
            gyroLogger.CreateDirectory();

            // t@CI[v
            gyroLogger.OpenFile(
            L"Calibration.csv", static_cast<u32>(1024*10), GyroLogger::SDLOG_WRITE_TYPE_CONTINUANCE);

            // x݂܂
            LoggerWriteLabel(&gyroLogger);

            // eXgɑEZof[^̏
            gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
            LoggerWriteTestData(&gyroLogger, ts, id_major, id_minor, micro, test_result);

            // SDɕۑ
            gyroLogger.Flush();

            // I
            gyroLogger.CloseFile();

            // SD J[h A}Eg
            NN_UTIL_PANIC_IF_FAILED(nn::fs::Unmount("sdmc:"));
        }
    }

    return true;
}

} // namespace internal

//============================================================================
//      O
//============================================================================

/*
    Desc: {NAND֌O݂܂
*/
seq::LogResult WriteProductionLog(bool result, int minor, u32 micro, char* string)
{
    seq::LogResult lr;

    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();

    pdl->Initialize();
    {
        char strNgCode[seq::pl::LOG_MSG_LEN];
        char strDate[0x10], strTime[0x10];

        gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();
        std::sprintf(strDate, "%04d/%02d/%02d", ts->m_Rtc.year, ts->m_Rtc.month, ts->m_Rtc.day);
        std::sprintf(strTime, "%02d:%02d", ts->m_Rtc.hour, ts->m_Rtc.minute);

        if (result == true) std::sprintf(strNgCode, "OK");
        else                std::sprintf(strNgCode, "%02d-%02d-%02d", G_GYRO_MASTER, minor, static_cast<int>(micro));

#ifdef FTR_ACC_GYRO
        uji::seq::Config config;
        ts->m_TestMode = config.Get().TestMode;
#endif

        lr = pdl->Add_1Line(ts->m_TestMode, "Gyroscope", strNgCode, VERSION_STRING, strDate, strTime, "", string);
    }
    delete pdl;

    return lr;
}

/*
    Desc: {NANDցuOKvO݂܂
*/
bool WriteProductionLogOK(seq::TestResult &result)
{

    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();

    if (ts->m_TestMode != seq::pl::DEBUG)
    {
        seq::LogResult lr = WriteProductionLog(true, 0, 0, "");
        result.m_Result = (lr == seq::LogResultCode::SUCCESS) ? true : false;
        sprintf(result.m_String, "LogResult(%d)", lr);
    }
    else
    {
        // DEBUG̏ꍇ́A[h̎擾sȂi΂ꂽjƔ
        result.m_Result = false;
        result.m_Micro = 999;
        sprintf(result.m_String, "ERR: Wrong TestMode(%X)", ts->m_TestMode);
    }

    return result.m_Result;
}

//============================================================================
//      CAL
//============================================================================

/*
    Desc: Call̕ۑieXgĂяopj
*/
bool SetCal(seq::TestResult &result)
{
    //khmdݒȊOł͌ɂnjŕԂB
    uji::seq::Config c;
    if( c.Get().TestMode !=uji::seq::pl::LINE )
    {
        strcpy( result.m_String, "SKIPPED" );
        result.m_Result = true;
        return result.m_Result;
    }

    result.m_Micro = 0;
    nn::hid::GyroscopeLowStatus gs;

    // eXgɑEZof[^擾
    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();

    /*
        CALl̐𔻒
    */
    // [_
    gs.x = ts->m_ExtDevCalibParam.x.rpm0;
    gs.y = ts->m_ExtDevCalibParam.y.rpm0;
    gs.z = ts->m_ExtDevCalibParam.z.rpm0;
    if (internal::TurnningCheck(gs, gyro::ROTATION_AXIS_RAW_Z, gyro::ROTATION_SPEED_0) != ERROR_MICRO_CALIB_NONE)           result.m_Micro |= 0x1;

    // X
    gs.y = gs.z = 0;
    gs.x = ts->m_ExtDevCalibParam.x.rpmPositive;
    if (internal::TurnningCheck(gs, gyro::ROTATION_AXIS_RAW_X, gyro::ROTATION_SPEED_78_POSITIVE) != ERROR_MICRO_CALIB_NONE) result.m_Micro |= 0x2;
    gs.x = ts->m_ExtDevCalibParam.x.rpmNegative;
    if (internal::TurnningCheck(gs, gyro::ROTATION_AXIS_RAW_X, gyro::ROTATION_SPEED_78_NEGATIVE) != ERROR_MICRO_CALIB_NONE) result.m_Micro |= 0x4;

    // Y
    gs.x = gs.z = 0;
    if (uji::sys::PLATFORM_CTR == uji::sys::GetPlatformType())
    {
        // t]Ȃ̂ŁAւ܂
        gs.y = ts->m_ExtDevCalibParam.y.rpmPositive;
        if (internal::TurnningCheck(gs, gyro::ROTATION_AXIS_RAW_Y, gyro::ROTATION_SPEED_78_NEGATIVE) != ERROR_MICRO_CALIB_NONE) result.m_Micro |= 0x8;
        gs.y = ts->m_ExtDevCalibParam.y.rpmNegative;
        if (internal::TurnningCheck(gs, gyro::ROTATION_AXIS_RAW_Y, gyro::ROTATION_SPEED_78_POSITIVE) != ERROR_MICRO_CALIB_NONE) result.m_Micro |= 0x10;
    }
    else
    {
        gs.y = ts->m_ExtDevCalibParam.y.rpmPositive;
        if (internal::TurnningCheck(gs, gyro::ROTATION_AXIS_RAW_Y, gyro::ROTATION_SPEED_78_POSITIVE) != ERROR_MICRO_CALIB_NONE) result.m_Micro |= 0x8;
        gs.y = ts->m_ExtDevCalibParam.y.rpmNegative;
        if (internal::TurnningCheck(gs, gyro::ROTATION_AXIS_RAW_Y, gyro::ROTATION_SPEED_78_NEGATIVE) != ERROR_MICRO_CALIB_NONE) result.m_Micro |= 0x10;
    }

    // Z
    gs.x = gs.y = 0;
    gs.z = ts->m_ExtDevCalibParam.z.rpmPositive;
    if (internal::TurnningCheck(gs, gyro::ROTATION_AXIS_RAW_Z, gyro::ROTATION_SPEED_78_POSITIVE) != ERROR_MICRO_CALIB_NONE) result.m_Micro |= 0x20;
    gs.z = ts->m_ExtDevCalibParam.z.rpmNegative;
    if (internal::TurnningCheck(gs, gyro::ROTATION_AXIS_RAW_Z, gyro::ROTATION_SPEED_78_NEGATIVE) != ERROR_MICRO_CALIB_NONE) result.m_Micro |= 0x40;

    if (result.m_Micro != 0)
    {
        sprintf(result.m_String, "Wrong Cal(0x%X), Can't Set \n  [0] x:%5d y:%5d z:%5d \n[+78] x:%5d y:%5d z:%5d \n[-78] x:%5d y:%5d z:%5d \n",
         result.m_Micro, ts->m_ExtDevCalibParam.x.rpm0, ts->m_ExtDevCalibParam.y.rpm0, ts->m_ExtDevCalibParam.z.rpm0,
         ts->m_ExtDevCalibParam.x.rpmPositive, ts->m_ExtDevCalibParam.y.rpmPositive, ts->m_ExtDevCalibParam.z.rpmPositive,
         ts->m_ExtDevCalibParam.x.rpmNegative, ts->m_ExtDevCalibParam.y.rpmNegative, ts->m_ExtDevCalibParam.z.rpmNegative);
        result.m_Result = false;
    }
    else
    {
        // NANDɕۑ
        s32 ret = internal::SetCalCore(ts->m_ExtDevCalibParam);
        sprintf(result.m_String, "Ret(%d)", ret);
        result.m_Result = (ret == 0) ? true : false;
    }
    return result.m_Result;
}

/*
    Desc: ftHgCallݒiEvaj[Ăяopj
*/
void SetDefaultCal()
{
    nn::hid::GyroscopeLowCalibrateParam cal_param = {
        {0, 6727, -6728},
        {0, 6727, -6728},
        {0, 6727, -6728}
    };

    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    s32 ret = -128;

    do
    {
        sys::Pad().UpdatePad();

        if ( sys::Pad().IsButtonDown( sys::Pad::BUTTON_A ) )
        {
            ret = internal::SetCalCore(cal_param);
        }

        sys::Menu::m_SubWindow->Printf ("\f");
        sys::Menu::m_SubWindow->Printf (" GYRO Set Cal(for Debug Only)\n\n");
        sys::Menu::m_SubWindow->Printf ("    -- usage --\n\n");
        sys::Menu::m_SubWindow->Printf ("    [A] Set Default\n");
        sys::Menu::m_SubWindow->Printf ("    [S] Exit\n\n");
        sys::Menu::m_SubWindow->Printf ("    Result(%d)= %s", ret, ret==0?"PASS":"FAIL");
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_START));
}

namespace internal {

/*
    Desc: CallNANDɕۑ܂
*/
s32 SetCalCore(nn::hid::GyroscopeLowCalibrateParam cal_param)
{
    using namespace nn::drivers::cal::CTR;

    enum ERROR_SEQ {
        ERROR_GET   = -1,
        ERROR_SET   = -2,
        ERROR_FLUSH = -3
    };

    Calibration calibration;
    GyroscopeCalDataCore gyroCalDataCore;

    // Cal ̏
    // Lȃf[^x[XΓǂݍ
    // Lȃf[^x[XȂ΃ftHglŖ߂f[^x[X쐬
    calibration.Initialize();

    // l̎擾
    if (!calibration.Get(&gyroCalDataCore, CAL_DATA_GYRO_SCOPE)) { return ERROR_GET; }

    // l̐ݒ
    gyroCalDataCore.x.raw_rpm_0             = cal_param.x.rpm0;
    gyroCalDataCore.x.raw_rpm_positive_78   = cal_param.x.rpmPositive;
    gyroCalDataCore.x.raw_rpm_negative_78   = cal_param.x.rpmNegative;
    gyroCalDataCore.y.raw_rpm_0             = cal_param.y.rpm0;
    gyroCalDataCore.y.raw_rpm_positive_78   = cal_param.y.rpmPositive;
    gyroCalDataCore.y.raw_rpm_negative_78   = cal_param.y.rpmNegative;
    gyroCalDataCore.z.raw_rpm_0             = cal_param.z.rpm0;
    gyroCalDataCore.z.raw_rpm_positive_78   = cal_param.z.rpmPositive;
    gyroCalDataCore.z.raw_rpm_negative_78   = cal_param.z.rpmNegative;

    if (!calibration.Set(&gyroCalDataCore, CAL_DATA_GYRO_SCOPE)) { return ERROR_SET; }

    // t@Cɕۑ
    if (!calibration.Flush()) { return ERROR_FLUSH; }

    return 0;
}

} // namespace internal

/*
    oׁEɂCall̔ixj
*/
bool CheckCal_Sensitivity(seq::TestResult &result)
{
    // OԂ̐錾
    using namespace nn::drivers::cal::CTR;

    // eXgɑEZof[^擾
    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();

    // 
    double Config_DiffRate = (ts->m_TestMode == seq::pl::QC) ? 8.0 : 10.0; // %

    // CALl̎擾
    Calibration calibration;
    GyroscopeCalDataCore Cal;
    // Cal ̏
    calibration.Initialize();
    // LutO̊mF
    // TODO:
    // l̎擾
    if (!calibration.Get(&Cal, CAL_DATA_GYRO_SCOPE))
    {
        result.m_Micro = 0x1;
        return result.m_Result = false;
    }

    // f[^ƍHCallƂ̃YZoE
    // X
    ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_X].rpmPositive =
        (static_cast<double>(std::abs(ts->m_ExtDevCalibParam.x.rpmPositive - Cal.x.raw_rpm_positive_78)) /
         static_cast<double>(Cal.x.raw_rpm_positive_78))*100.0f;
    if (ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_X].rpmPositive > Config_DiffRate)
    {
        result.m_Micro |= 0x2;
    }
    ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_X].rpmNegative =
        (static_cast<double>(std::abs(ts->m_ExtDevCalibParam.x.rpmNegative - Cal.x.raw_rpm_negative_78)) /
         static_cast<double>(Cal.x.raw_rpm_negative_78))*(-100.0f);
    if (ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_X].rpmNegative > Config_DiffRate)
    {
        result.m_Micro |= 0x4;
    }

    // Y
    ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_Y].rpmPositive =
        (static_cast<double>(std::abs(ts->m_ExtDevCalibParam.y.rpmPositive - Cal.y.raw_rpm_positive_78)) /
         static_cast<double>(Cal.y.raw_rpm_positive_78))*100.0f;
    if (ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_Y].rpmPositive > Config_DiffRate)
    {
        result.m_Micro |= 0x8;
    }
    ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_Y].rpmNegative =
        (static_cast<double>(std::abs(ts->m_ExtDevCalibParam.y.rpmNegative - Cal.y.raw_rpm_negative_78)) /
         static_cast<double>(Cal.y.raw_rpm_negative_78))*(-100.0f);
    if (ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_Y].rpmNegative > Config_DiffRate)
    {
        result.m_Micro |= 0x10;
    }

    // Z
    ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_Z].rpmPositive =
        (static_cast<double>(std::abs(ts->m_ExtDevCalibParam.z.rpmPositive - Cal.z.raw_rpm_positive_78)) /
         static_cast<double>(Cal.z.raw_rpm_positive_78))*100.0f;
    if (ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_Z].rpmPositive > Config_DiffRate)
    {
        result.m_Micro |= 0x20;
    }
    ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_Z].rpmNegative =
        (static_cast<double>(std::abs(ts->m_ExtDevCalibParam.z.rpmNegative - Cal.z.raw_rpm_negative_78)) /
         static_cast<double>(Cal.z.raw_rpm_negative_78))*(-100.0f);
    if (ts->m_RateCalSensDifference[gyro::ROTATION_AXIS_RAW_Z].rpmNegative > Config_DiffRate)
    {
        result.m_Micro |= 0x40;
    }

    // 
    if (result.m_Micro == 0)
    {
        result.m_Result = true;
    }
    else
    {
        result.m_Result = false;
        internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CHECK_CAL_SENS, result.m_Micro, false);
    }
    std::sprintf(result.m_String, "micro_code= %Xh", result.m_Micro);
    return result.m_Result;
}

/*
    oׁEɂCall̔i[_j
*/
bool CheckCal_ZeroRateOutput(seq::TestResult &result)
{
    // OԂ̐錾
    using namespace nn::drivers::cal::CTR;

    // eXgɑEZof[^擾
    gyro::GyroTestStatus* ts = GyroUdsClient::GetTestStatus();

    // 
    int Config_dps = (ts->m_TestMode == seq::pl::QC) ? 50 : 54; // dps

    // CALl̎擾
    Calibration calibration;
    GyroscopeCalDataCore Cal;
    // Cal ̏
    calibration.Initialize();
    // LutO̊mF
    // TODO:
    // l̎擾
    if (!calibration.Get(&Cal, CAL_DATA_GYRO_SCOPE))
    {
        result.m_Micro = 0x1;
        return result.m_Result = false;
    }

    const double tmp_coef = 78*(360/60);
    double lineSense;
    s16 zeroAbsDiff;

    // X
    // CCal犴xZo
    ts->m_LineSens[gyro::ROTATION_AXIS_RAW_X] = static_cast<double>(Cal.x.raw_rpm_positive_78) / tmp_coef;
    lineSense = ts->m_LineSens[gyro::ROTATION_AXIS_RAW_X];
    // [_̐Βl
    ts->m_ZeroRateOutputDiff[gyro::AXIS_RAW_X] = std::abs(ts->m_ExtDevCalibParam.x.rpm0 - Cal.x.raw_rpm_0);
    zeroAbsDiff = ts->m_ZeroRateOutputDiff[gyro::AXIS_RAW_X];
    if (lineSense*Config_dps < static_cast<double>(zeroAbsDiff))
    {
        result.m_Micro |= 0x2;
    }

    // Y
    ts->m_LineSens[gyro::ROTATION_AXIS_RAW_Y] = static_cast<double>(Cal.y.raw_rpm_positive_78) / tmp_coef;
    lineSense = ts->m_LineSens[gyro::ROTATION_AXIS_RAW_Y];
    ts->m_ZeroRateOutputDiff[gyro::AXIS_RAW_Y] = std::abs(ts->m_ExtDevCalibParam.y.rpm0 - Cal.y.raw_rpm_0);
    zeroAbsDiff = ts->m_ZeroRateOutputDiff[gyro::AXIS_RAW_Y];
    if (lineSense*Config_dps < static_cast<double>(zeroAbsDiff))
    {
        result.m_Micro |= 0x4;
    }

    // Z
    ts->m_LineSens[gyro::ROTATION_AXIS_RAW_Z] = static_cast<double>(Cal.z.raw_rpm_positive_78) / tmp_coef;
    lineSense = ts->m_LineSens[gyro::ROTATION_AXIS_RAW_Z];
    ts->m_ZeroRateOutputDiff[gyro::AXIS_RAW_Z] = std::abs(ts->m_ExtDevCalibParam.z.rpm0 - Cal.z.raw_rpm_0);
    zeroAbsDiff = ts->m_ZeroRateOutputDiff[gyro::AXIS_RAW_Z];
    if (lineSense*Config_dps < static_cast<double>(zeroAbsDiff))
    {
        result.m_Micro |= 0x8;
    }

    // 
    if (result.m_Micro == 0)
    {
        result.m_Result = true;
    }
    else
    {
        result.m_Result = false;
        internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CHECK_CAL_ZERO, result.m_Micro, false);
    }
    std::sprintf(result.m_String, "micro_code= %Xh", result.m_Micro);
    return result.m_Result;
}


} // namespace
}
}
