/*--------------------------------------------------------------------------*
 Project:
 File: gyro_AgingTester.h
 vۂC
*--------------------------------------------------------------------------*/
#ifndef __GYRO_AGING_TESTER_H__
#define __GYRO_AGING_TESTER_H__

#include <nn/types.h>
#include <nn/hid.h>
#include <nn/hid/CTR/hid_GyroscopeLowReader.h>
#include <nw/ut.h>

#include "gyro_ExtReader.h"
#include "gyro_GraphDrawing.h"
#include "gyro_Types.h"    
#include "sys.h"
#include "gyro_Logger.h"    
#include "../seq/TestResult.h"    


namespace uji {
namespace eva {


/*
    Desc: WCG[WO
*/
class GyroAgingTester
{
public:
    // RXgN^
    GyroAgingTester() 
     : m_GyroRawLastAddedIndex(0), m_GyroPrevLatestIndex(0), 
       m_ScreenWidth(185), m_ScreenHeight(170), m_TestSequence(0), m_TestSubSeqence(0), m_IsLogging(false),
       m_IsSDCardDetected(false), m_Is3DMode(true)
    {
        // g[_̃CX^X𐶐
        m_ExtReader = new GyroExtReader(GyroExtReader::LOGGING_BUFFER_SIZE);

        // Ot̐
        m_GyroRawLine[gyro::AXIS_RAW_X] = new LineElement("X", m_ScreenWidth, 0.0f, 85.0f, nw::ut::FloatColor(1.0f, 0.0f, 0.0f, 1.0f));  
        m_GyroRawLine[gyro::AXIS_RAW_Y] = new LineElement("Y", m_ScreenWidth, 0.0f, 85.0f, nw::ut::FloatColor(0.0f, 1.0f, 0.0f, 1.0f)); 
        m_GyroRawLine[gyro::AXIS_RAW_Z] = new LineElement("Z", m_ScreenWidth, 0.0f, 85.0f, nw::ut::FloatColor(0.0f, 0.0f, 1.0f, 1.0f));        
        m_AccRawLine[gyro::AXIS_RAW_X]  = new LineElement("X", m_ScreenWidth, 0.0f, 85.0f, nw::ut::FloatColor(1.0f, 0.0f, 0.0f, 1.0f));  
        m_AccRawLine[gyro::AXIS_RAW_Y]  = new LineElement("Y", m_ScreenWidth, 0.0f, 85.0f, nw::ut::FloatColor(0.0f, 1.0f, 0.0f, 1.0f)); 
        m_AccRawLine[gyro::AXIS_RAW_Z]  = new LineElement("Z", m_ScreenWidth, 0.0f, 85.0f, nw::ut::FloatColor(0.0f, 0.0f, 1.0f, 1.0f));

        // pf[^̃NA
        std::memset(&m_Aging1stMax, 0, sizeof(nn::hid::GyroscopeLowStatus));
        std::memset(&m_Aging1stMin, 0, sizeof(nn::hid::GyroscopeLowStatus));
        std::memset(&m_Aging1stAve, 0, sizeof(nn::hid::GyroscopeLowStatus));
        std::memset(&m_Aging2ndMax, 0, sizeof(nn::hid::GyroscopeLowStatus));
        std::memset(&m_Aging2ndMin, 0, sizeof(nn::hid::GyroscopeLowStatus));
        std::memset(&m_Aging2ndAve, 0, sizeof(nn::hid::GyroscopeLowStatus));        
        std::memset(&m_PulseMax, 0, sizeof(nn::hid::GyroscopeLowStatus));
        std::memset(&m_PulseMin, 0, sizeof(nn::hid::GyroscopeLowStatus));    
        std::memset(&m_PulseAve, 0, sizeof(nn::hid::GyroscopeLowStatus));  
        std::memset(&m_AbsDiff, 0, sizeof(nn::hid::GyroscopeLowStatus));        
                
        m_Aging1stStableTime = m_Aging2ndStableTime = m_PulseStableTime = m_PulseStableTimeEx = 0;
        m_TestErrorSeqence = TESTSEQ_MAX;
        
        // CeXgƂȊOŔύX
        if (seq::Config().Get().TestMode == 0)
        {
            // CeXg
            Config_AgingAveDiffMax  = static_cast<s16>(seq::Config().Get().GyroAgingAveDiffMax);
            Config_PulseMax         = static_cast<s16>(seq::Config().Get().GyroAgingPulseMax);
            Config_PulseMaxEx       = static_cast<s16>(seq::Config().Get().GyroAgingPulseMaxEx);                         
        }        
        else
        {
            Config_AgingAveDiffMax  = static_cast<s16>(seq::Config().Get().GyroAgingAveDiffMax) + 10;
            Config_PulseMax         = static_cast<s16>(seq::Config().Get().GyroAgingPulseMax) + 6;
            Config_PulseMaxEx       = static_cast<s16>(seq::Config().Get().GyroAgingPulseMaxEx) + 6;                
        }
    }

    // fXgN^
    virtual ~GyroAgingTester()
    {
        for (int i=0; i<gyro::AXIS_RAW_NUM; i++)
        {
            delete m_GyroRawLine[i];
            delete m_AccRawLine[i];
        }      
        
        delete m_ExtReader;
    }
    
    static void sTest()
    {        
        GyroAgingTester g;
        g.EvaGyroAging();
    }    

    bool Test(seq::TestResult &result);
    void EvaGyroAging();
    
private:    
    void SetInfoLedRed();
    void UpdateScreen(sys::GraphicsDrawing* gfx);       
    void UpdateGraph();
    nn::hid::GyroscopeLowStatus GetAverage(nn::hid::GyroscopeLowStatus* pData, int dataNum);
    void InitSDCard();    
    void SaveTestDataToSD(GyroLogger* gyroLogger, bool isAllTestPass, u32 micro);    
    bool TestAging();   
    
    GyroExtReader* m_ExtReader;
    // ExtReader[hf[^̂ǂ܂łOt
    // obt@ɔf?CfbNX
    s64 m_GyroRawLastAddedIndex;
    
    s64 m_GyroPrevLatestIndex;    
    
    // f[^ێpobt@
    nn::hid::GyroscopeLowStatus m_Aging1stStableData[100];
    nn::hid::GyroscopeLowStatus m_Aging2ndStableData[100];
    nn::hid::GyroscopeLowStatus m_PulseStableData[500];
    nn::hid::GyroscopeLowStatus m_PulseExStableData[100];

    
    // pXeXgV[PXԍ
    enum PULSETESET_SEQUENCE
    {
        PULSESEQ_START,
        PULSESEQ_CLEAR,
        PULSESEQ_CHEK,
        PULSESEQ_PASS,
        PULSESEQ_FAIL
    };
    
    /* 
        f[^    
    */     
    // ėp̃oϐ    
    PULSETESET_SEQUENCE m_PulseCheckSeqID;
    nn::os::Tick::Tick m_PulseCheckSeqStart; 
    int m_GyroStableDataNum;
    int m_GyroStableDataNumEx;    
    int m_PulseTestPassSamplingNum;
    int m_PulseTestPassSamplingNumEx;    
    int m_msPulseTestTimeOut;
    bool m_IsPass;
    bool m_IsPassEx;    
    
    // G[WO
    nn::hid::GyroscopeLowStatus m_Aging1stMax;
    nn::hid::GyroscopeLowStatus m_Aging1stMin;
    nn::hid::GyroscopeLowStatus m_Aging1stAve;
    nn::hid::GyroscopeLowStatus m_Aging2ndMax;
    nn::hid::GyroscopeLowStatus m_Aging2ndMin;
    nn::hid::GyroscopeLowStatus m_Aging2ndAve;
    nn::hid::GyroscopeLowStatus m_AbsDiff;
    int m_Aging1stStableTime;
    int m_Aging2ndStableTime;
    
    // pX
    nn::hid::GyroscopeLowStatus m_PulseMax;
    nn::hid::GyroscopeLowStatus m_PulseMin;
    nn::hid::GyroscopeLowStatus m_PulseAve;
    int m_PulseStableTime;
    int m_PulseStableTimeEx;
    
    int GetNewIndex(s64& startIndex, s64& latestIndex);    
    // pX
    bool CheckPulse(
        s64 startIndex,
        s64 latestIndex,        
        s32 pulseMaxThreshold,
        nn::hid::GyroscopeLowStatus& GStatMax, 
        nn::hid::GyroscopeLowStatus& GStatMin);
    // pXeXgV[PX
    void ResetPulseTestSequence(int msPassSamplingNum, int passSamplingNumEx, int msTimeOut);
    PULSETESET_SEQUENCE DoPulseTestSequence(
        nn::hid::GyroscopeLowStatus& GStatMax, 
        nn::hid::GyroscopeLowStatus& GStatMin, 
        int& refStableTime,
        int& refStableTimeEx,
        nn::hid::GyroscopeLowStatus* pStableData,
        nn::hid::GyroscopeLowStatus* pStableDataEx
    );    
    
    /* 
        Ot
    */
    GyroGraphDrawing* m_GyroRawGraphDrawing;
    GyroGraphDrawing* m_AccRawGraphDrawing;    
    LineElement* m_GyroRawLine[gyro::AXIS_RAW_NUM];
    LineElement* m_AccRawLine[gyro::AXIS_RAW_NUM];    
    s32 m_ScreenWidth;
    s32 m_ScreenHeight;
    
    // OSDɕۑ܂
    GyroLogger m_GyroLogger;
    GyroLogger m_GyroDataLogger;

    // Jpeg\
    sys::JpegDrawer* jpegDrawer;    
    
    /*
        eXgV[PX
    */
    int m_TestSequence;
    int m_TestSubSeqence;
    int m_TestErrorSeqence;

    // eXgV[PXԍ
    enum TEST_SEQUENCE 
    {
        TESTSEQ_MEASUREMENT_AGING_1ST,
        TESTSEQ_MEASUREMENT_AGING_2ND,
        TESTSEQ_PULSE_CHECK,          
        TESTSEQ_AGING_CHECK,
        TESTSEQ_COLLECT_DATA,
        TESTSEQ_SAVETOSD,            
        TESTSEQ_RESULT,
        TESTSEQ_MAX
    };
        
    static char* GetTestSequenceName(int seq_id)
    {
        char* strAgingTestSeq[] = { 
            "AGING 1ST",
            "AGING 2ND",
            "PULSE TEST",
            "AGING TEST",
            "COLLECT_DATA",
            "SAVE TO SD",
            "RESULT"
        };       
        
        return strAgingTestSeq[seq_id];    
    }
        
    bool m_IsLogging;
    bool m_IsSDCardDetected;        
    bool m_Is3DMode;

    // EChE}l[W    
    sys::WindowManager m_WndManager;    
    // EChE
    sys::TextWindow* m_DebugWnd;
        
    s16 Config_AgingAveDiffMax;
    s32 Config_PulseMax;        
    s32 Config_PulseMaxEx;        
        
    static const int Config_SamplingDataNum = 1000;    
  
    static const int ERROR_MICRO_PULSE      = 1;
    static const int ERROR_MICRO_AGING      = 2; 
    static const int ERROR_MICRO_PULSE_EX   = 3;
    static const int ERROR_MICRO_PULSE_BOTH = 4;        
};

namespace gyroC {

bool GyroAgingTest(seq::TestResult &result);

}

} // namespace
}

#endif
