/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */

#include <nn/gx.h>
#include <nn/math.h>
#include <nn/fs.h>
#include <nn/os.h>
#include <nn/init.h>
#include <nn/fnd/fnd_ExpHeap.h>
#include <nw/font.h>
#include "sys.h"
#include "Common/Allocator.h"
#include "Common/Display.h"
#include "../seq/TestResult.h"
#include "gputest.h"

#define TEST_FRAME_NUM 170

namespace gputest {

using namespace common;

namespace ClipEquation{extern int sample_main();}
namespace Fog{extern int sample_main();}
namespace GasCessna{extern int sample_main();}
namespace GasColorOptimal{extern int sample_main();}
namespace GasColorSimple{extern int sample_main();}
namespace LightingAniso{extern int sample_main();}
namespace LightingDistanceAtte{extern int sample_main();}
namespace LightingFresnel{extern int sample_main();}
namespace LightingMicrofacet{extern int sample_main();}
namespace LightingSpotAtte{extern int sample_main();}
namespace LightingSss{extern int sample_main();}
namespace LightingToonApple{extern int sample_main();}
namespace LightingVertex{extern int sample_main();}
namespace LineSimple{extern int sample_main();}
namespace PartsysGas{extern int sample_main();}
namespace PartsysSimple{extern int sample_main();}
namespace PointSprite{extern int sample_main();}
namespace ProctexClamp{extern int sample_main();}
namespace ProctexFFunction{extern int sample_main();}
namespace ProctexGFunction{extern int sample_main();}
namespace ProctexRandom{extern int sample_main();}
namespace ShadowKnot{extern int sample_main();}
namespace ShadowKnotCube{extern int sample_main();}
namespace SilhouetteSimple{extern int sample_main();}
namespace SubdivisionLoop{extern int sample_main();}
namespace SubdivisionLoopSimple{extern int sample_main();}
namespace SubdivisionSimple{extern int sample_main();}
namespace AlphaTest{extern int sample_main();}
namespace LogicOp{extern int sample_main();}
namespace PipelineTest{extern int sample_main();}
namespace StencilTestFunc{extern int sample_main();}
namespace StencilTestOp{extern int sample_main();}
namespace TextureAll{extern int sample_main();}

struct testitem_t
{
	int (*func)(void);
	int id;
} testitem_[] = {
	{	ClipEquation::sample_main,				1	},
	{	Fog::sample_main,						2	},
	{	GasCessna::sample_main,					3	},
	{	GasColorOptimal::sample_main,			4	},
	{	GasColorSimple::sample_main,			5	},
	{	LightingAniso::sample_main,				6	},
	{	LightingDistanceAtte::sample_main,		7	},
	{	LightingFresnel::sample_main,			8	},
	{	LightingMicrofacet::sample_main,		9	},
	{	LightingSpotAtte::sample_main,			10	},
	{	LightingSss::sample_main,				11	},
	{	LightingToonApple::sample_main,			12	},
	{	LightingVertex::sample_main,			13	},
	{	LineSimple::sample_main,				14	},
	{	PartsysGas::sample_main,				15	},
	{	PartsysSimple::sample_main,				16	},
	{	PointSprite::sample_main,				17	},
	{	ProctexClamp::sample_main,				18	},
	{	ProctexFFunction::sample_main,			19	},
	{	ProctexGFunction::sample_main,			20	},
	{	ProctexRandom::sample_main,				21	},
	{	ShadowKnot::sample_main,				22	},
	{	ShadowKnotCube::sample_main,			23	},
	{	SilhouetteSimple::sample_main,			24	},
	{	SubdivisionLoop::sample_main,			25	},
	{	SubdivisionLoopSimple::sample_main,		26	},
	{	SubdivisionSimple::sample_main,			27	},
	{	AlphaTest::sample_main,					28	},
	{	LogicOp::sample_main,					29	},
	{	PipelineTest::sample_main,				30	},
	{	StencilTestFunc::sample_main,			31	},
	{	StencilTestOp::sample_main,				32	},
	{	TextureAll::sample_main,				33	},
	{	0,0	}
};

void AppendString(int code, char* str, int pos, int* next_pos)
{
	// write code string
	if (pos != 0)
	{
		str[pos++] = ',';
	}
	int figure = 0;
	for (int i = code; i != 0; i /= 10)
	{
		figure++;
	}
	if (figure == 0) figure = 1;
	
	for (int i = 0; i < figure; i++)
	{
		str[pos + figure - 1 - i] = '0' + (code % 10);
		code /= 10;
	}
	*next_pos = pos + figure;
}

bool TestGPU(uji::sys::DemoAllocator* pAllocator,
	uji::sys::DemoDeviceMemoryAllocator* pDeviceMemoryAllocator,
	demo::RenderSystemUji* pRenderSystem,
	uji::seq::TestResult &Result,
    s64 startTick)
{
	(void)pDeviceMemoryAllocator;	// not used
	
	int error;
	
	// set allocator
	cmn_SetAllocator(pAllocator);
	// set rendersystem
	cmn_InitializeFramework(pRenderSystem, TEST_FRAME_NUM, startTick);

	Result.m_Micro = 0;
	int first_error = 0;
	int error_count = 0;
	int string_pos = 0;
	
	//#define CHECK_OBJ_LEAK
	#ifdef CHECK_OBJ_LEAK
	GLuint refobjs[10];
	{
		glGenTextures(1, &refobjs[0]);
		glGenBuffers(1, &refobjs[1]);
		glGenRenderbuffers(1, &refobjs[2]);
		glGenFramebuffers(1, &refobjs[3]);
		refobjs[4] = glCreateProgram();
		refobjs[5] = glCreateShader(GL_VERTEX_SHADER);
		
		glDeleteTextures(1, &refobjs[0]);
		glDeleteBuffers(1, &refobjs[1]);
		glDeleteRenderbuffers(1, &refobjs[2]);
		glDeleteFramebuffers(1, &refobjs[3]);
		glDeleteProgram(refobjs[4]);
		glDeleteShader(refobjs[5]);
	}
	#endif
	
	// test loop
	for (int i = 0; testitem_[i].id != 0; i++)
	{
		// disable previous state
		for (int index = 0; index < 12; index++)
			glDisableVertexAttribArray(index);
		glBindTexture(GL_TEXTURE_COLLECTION_DMP, 0);
		for (int tex = 0; tex < 3; tex++)
		{
			glActiveTexture(GL_TEXTURE0 + tex);
			glBindTexture(GL_TEXTURE_2D, 0);
			glBindTexture(GL_TEXTURE_CUBE_MAP, 0);
		}
		for (int lut = 0; lut < 32; lut++)
			glBindTexture(GL_LUT_TEXTURE0_DMP + lut, 0);
		glDisable(GL_CULL_FACE);
		glDisable(GL_DEPTH_TEST);
		glDisable(GL_SCISSOR_TEST);
		glDisable(GL_STENCIL_TEST);
		glDisable(GL_BLEND);
		glDisable(GL_COLOR_LOGIC_OP);
		glActiveTexture(GL_TEXTURE0);
		glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
		glDepthMask(GL_TRUE);
		glUseProgram(0);

		// call test main function
		cmn_setTestID(testitem_[i].id);
		testitem_[i].func();
		
		#ifdef CHECK_OBJ_LEAK
		// check leak
		{
			glUseProgram(0);
			GLuint objs[10];
			glGenTextures(1, &objs[0]);
			glGenBuffers(1, &objs[1]);
			glGenRenderbuffers(1, &objs[2]);
			glGenFramebuffers(1, &objs[3]);
			objs[4] = glCreateProgram();
			objs[5] = glCreateShader(GL_VERTEX_SHADER);
			
			for (int j = 0; j < 6; j++)
				if (objs[j] != refobjs[j])
					NN_LOG("forget free object %d in %d\n", j, testitem_[i].id);
			
			glDeleteTextures(1, &objs[0]);
			glDeleteBuffers(1, &objs[1]);
			glDeleteRenderbuffers(1, &objs[2]);
			glDeleteFramebuffers(1, &objs[3]);
			glDeleteProgram(objs[4]);
			glDeleteShader(objs[5]);
		}
		#endif

		// check error
		error = cmn_getTestError();
		if (error != -1)
		{
			// Write Result.m_String if more than 2 error occured.
			switch (error_count)
			{
				case 0:
					first_error = testitem_[i].id;
					break;
				case 1:
					AppendString(first_error, Result.m_String, string_pos, &string_pos);
				default:
					AppendString(testitem_[i].id, Result.m_String, string_pos, &string_pos);
					break;
			}
			error_count++;
		}
	}
	if (error_count == 1)
	{
		Result.m_Micro = first_error;
		NN_LOG("GPU test fail %d\n", Result.m_Micro);
	}
	else if (error_count > 1)
	{
		Result.m_Micro = 900 + error_count;
		Result.m_String[string_pos] = '\0';
		NN_LOG("GPU test fail %s\n", Result.m_String);
	}

	// restore gl state
	for (int index = 0; index < 12; index++)
		glDisableVertexAttribArray(index);
	glBindTexture(GL_TEXTURE_COLLECTION_DMP, 0);
	for (int tex = 0; tex < 3; tex++)
	{
		glActiveTexture(GL_TEXTURE0 + tex);
		glBindTexture(GL_TEXTURE_2D, 0);
		glBindTexture(GL_TEXTURE_CUBE_MAP, 0);
	}
	for (int lut = 0; lut < 32; lut++)
		glBindTexture(GL_LUT_TEXTURE0_DMP + lut, 0);
	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_SCISSOR_TEST);
	glDisable(GL_STENCIL_TEST);
	glDisable(GL_BLEND);
	glDisable(GL_COLOR_LOGIC_OP);
	glActiveTexture(GL_TEXTURE0);
	glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
	glDepthMask(GL_TRUE);
	cmn_FinalizeFramework();
	
	return (Result.m_Micro == 0) ? true : false;
}

}
