/*--------------------------------------------------------------------------*
 Project:
 File: gpu_Eva.cpp

       
*--------------------------------------------------------------------------*/
#include "gpu_Eva.h"
#ifdef EVA_ENABLE_GPUTEST    
#include "gputest.h"    
#endif    
#include "../seq/Reception_board_interface.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

    

namespace uji {
namespace eva {
namespace gpu {

/*
    Desc: GPUeXg
*/
bool TestGpu(seq::TestResult &result, s64 startTick)
{
#ifdef EVA_ENABLE_GPUTEST    
    uji::sys::DemoAllocator memAllocator;
    uji::sys::DemoDeviceMemoryAllocator devMemAllocator;
    demo::RenderSystemUji* renderSystem = uji::sys::GraphicsDrawing::GetInstance()->m_DrawFramework;
    
    // GPUeXg̎s
    result.m_Result = gputest::TestGPU(&memAllocator, &devMemAllocator, renderSystem, result, startTick);    

    return result.m_Result;
#else
    (void)startTick;
    return result.m_Result=false;    
#endif
}

bool TestGpu(seq::TestResult &result)
{
    return TestGpu(result, nn::os::Tick::GetSystemCurrent());
}


/*
    Desc: GPUeXgiEVAj[Ăяopj
*/
void EvaTestGpu()
{
    seq::TestResult result;    
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
/*    
    do
    {        
*/    
#ifdef EVA_ENABLE_GPUTEST    
        TestGpu(result);

        sys::Menu::m_SubWindow->Printf("\f");
        sys::Menu::m_SubWindow->Printf("<GPU EVA>\n");    
        sys::Menu::m_SubWindow->Printf("Result(%s)\n Msg:%s\n", result.m_Result ? "PASS" : "FAIL", result.m_String);
#else
        sys::Menu::m_SubWindow->Printf("\f");
        sys::Menu::m_SubWindow->Printf("<GPU EVA>\n");    
        sys::Menu::m_SubWindow->Printf("Unimplemented\n");
#endif    
        sys::Menu::m_SubWindow->Printf("\n - Push B Button To Exit -");            
    
        // ʍXV
	    sys::Menu::m_WindowManager.Update();
	    sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
	    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
	    gfx->m_DrawFramework->Clear();        
	    sys::Menu::m_WindowManager.DrawDisplay1();
	    gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
/*
    }
*/    
    do
    {
        sys::Pad().UpdatePad();
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));

}
        
} // namespace
}
}
