/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */
 
/*
 * Comments
 * --------
 *
 * ̃Tv͑SʃVhE}bsOiL[uVhE}bsOj̃TvłB
 * 1stpX6ʕ̃VhEeNX`쐬܂B̂߁A1stpXł6񕪂̃V[
 * _OKvƂȂ܂B
 */

#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>

#include "Display.h"
#include "Util.h"
#include "Vecalg.h"
#include "Loader.h"
#include "File.h"

#include <string.h>
#include <math.h>

#include "Memory.h"

#define APP_NAME "ShadowKnotCube"
#define WIDTH 240
#define HEIGHT 400
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

using namespace gputest::common;

namespace gputest{
namespace ShadowKnotCube{

/* shadow setting */
static const float fSZBiasScale[] = {1.7f, 1.3f, 1.3f};
static const float fSZScale[] = {1.f, 2.f, 4.f};
/* shadow artifact suppression SETTINGS 0 - lowest 2 - highest */ 
/* A[eBt@Ng}̂߂̃p[^łB傫قǗ}̌ʂ͑傫Ȃ܂B*/
#define SDW_SETTINGS 0
/* VhEeNX`̃TCYłBSʃVhE}bvŎgpVhEeNX`
 * L[u}bvƓlɐ`̃TCYKvƂȂ܂B*/
#define SBWIDTHHEIGHT 128

/* GL object name */
/* program object */
static GLuint lr_prog_name, sdw_prog_name;
/* shader object */
static GLuint shaders_name[2];
/* texture object */
static GLuint shadow_tex_name;
/* frame buffer object */
static GLuint fbo_name;

/* lut texture object */
GLuint lutids[3];

/* obj loader class object */
static dat_t knot, cube;
static dat_t* objects[] = {&knot, &cube, 0};

/* 1st pass (shadow accumulation pass) frustum parameter */
/* SʃVhE}bvł͓IL[u}bv̏ꍇƓl
 * 1stpXŎgpJ̎p90xƂȂ΂Ȃ܂B
 * ̂nearʂɑ΂left(r)top(t)̒l͓lɂKv܂B*/
static GLfloat n = 0.2f, f = 10.f, r = 0.2f, t = 0.2f;

/* light position */
static GLfloat lpos0[] = {0.9f, 0.f, 0.f, 1.f};

/* frame number */
static unsigned int frame_no = 0;


static void reder_objects_shadow(dat_t& _objs)
{
	/* 1stpXł̒_͒_W̕ϊsȂ̂
	 * Lɂ钸_͒_Ŵ݂łB*/
	glEnableVertexAttribArray(0);

	for (int i = 0; i < _objs.obj_num; i++)
	{
		glBindBuffer(GL_ARRAY_BUFFER, _objs.posVB);
		glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, (void*)_objs.obj[i].vtx_offset);
		for (unsigned j = _objs.obj[i].patch_offset; j < _objs.obj[i].patch_size + _objs.obj[i].patch_offset; j++)
		{
			glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, _objs.idxVB);
			glDrawElements(GL_TRIANGLES, _objs.patch[j].elm_size,
				GL_UNSIGNED_SHORT, (GLvoid*)(_objs.patch[j].elm_offset + _objs.obj[i].elm_offset));
		}
	}

	glDisableVertexAttribArray(0);
}

static void render_objects_shadowed(dat_t& _objs)
{
	/* 2ndpXł̓tOgCeBOsߖ@xNgKvłB
	 * Lɂ钸_͒_WƖ@ƂȂ܂B*/
	glEnableVertexAttribArray(0);
	glEnableVertexAttribArray(1);

	for (int i = 0; i < _objs.obj_num; i++)
	{
		glBindBuffer(GL_ARRAY_BUFFER, _objs.posVB);
		glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, (void*)_objs.obj[i].vtx_offset);
		glBindBuffer(GL_ARRAY_BUFFER, _objs.normVB);
		glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 0, (void*)_objs.obj[i].nrm_offset);
		for (unsigned j = _objs.obj[i].patch_offset; j < _objs.obj[i].patch_size + _objs.obj[i].patch_offset; j++)
		{
			GLfloat ma[4] = {0.f, 0.f, 0.f, 1.f};
			GLfloat md[4] = {0.f, 0.f, 0.f, 1.f};
			GLfloat ms[4] = {0.f, 0.f, 0.f, 1.f};
			for (int col = 0; col < 3; col++)
			{
				ma[col] = _objs.patch[j].ambient[col];
				md[col] = _objs.patch[j].diffuse[col];
				ms[col] = _objs.patch[j].specular[col];
			}

			glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_FragmentMaterial.ambient"), 1, ma);
			glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_FragmentMaterial.diffuse"), 1, md);
			glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_FragmentMaterial.specular0"), 1, ms);
			glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_FragmentMaterial.specular1"), 1, ms);

			glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, _objs.idxVB);
			glDrawElements(GL_TRIANGLES, _objs.patch[j].elm_size,
				GL_UNSIGNED_SHORT, (GLvoid*)(_objs.patch[j].elm_offset + _objs.obj[i].elm_offset));
		}
	}

	glDisableVertexAttribArray(0);
	glDisableVertexAttribArray(1);
}

static void render_shadow_buffer(dat_t** _objs, vec3_t lpos)
{
    GLfloat m[16];
    mat4_t modelview;

    glUseProgram(sdw_prog_name);

	/* SʃVhE}bvł1stpX6ʕ̃_OKvƂȂ܂B
	 * Cgʒu݂V[_ÔŎ_ʒu̓CgʒuƂȂ邱
	 * ɒӂĉB*/

	// rendering +x cube
	/* lookAt֐̑4,5,6͎_݂^[Qbg̈ʒu\܂B
	 * ܂4lpos[0]+1.fx̐͌̕Ă邱ƂӖ܂B*/
	modelview = mat4_t::lookAt(lpos[0], lpos[1], lpos[2], lpos[0] + 1.f, lpos[1], lpos[2], 0.f, -1.f, 0.f);
	modelview.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(sdw_prog_name, "uModelView"), 1, GL_FALSE, m);

	/* t[obt@IuWFNgɃVhEeNX`A^b`܂A
	 * eʂƂɈقȂ^[Qbgw肵Ă邱ƂɒӂĉB*/
	glFramebufferTexture2D(
		GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_CUBE_MAP_POSITIVE_X, shadow_tex_name, 0);
	glCheckFramebufferStatus(GL_FRAMEBUFFER);

	glClear(GL_COLOR_BUFFER_BIT);

    for (int i = 0; _objs[i] != 0; i++)
    {
	    reder_objects_shadow(*_objs[i]);
    }

	// rendering -x cube
	modelview = mat4_t::lookAt(lpos[0], lpos[1], lpos[2], lpos[0] - 1.f, lpos[1], lpos[2], 0.f, -1.f, 0.f);
	modelview.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(sdw_prog_name, "uModelView"), 1, GL_FALSE, m);

	glFramebufferTexture2D(
		GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, shadow_tex_name, 0);

	glClear(GL_COLOR_BUFFER_BIT);

    for (int i = 0; _objs[i] != 0; i++)
    {
	    reder_objects_shadow(*_objs[i]);
    }

	// rendering +y cube
	modelview = mat4_t::lookAt(lpos[0], lpos[1], lpos[2], lpos[0], lpos[1] + 1.f, lpos[2], 0.f, 0.f, 1.f);
	modelview.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(sdw_prog_name, "uModelView"), 1, GL_FALSE, m);

    glFramebufferTexture2D(
    	GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, shadow_tex_name, 0);

	glClear(GL_COLOR_BUFFER_BIT);

    for (int i = 0; _objs[i] != 0; i++)
    {
	    reder_objects_shadow(*_objs[i]);
    }

	// rendering -y cube
	modelview = mat4_t::lookAt(lpos[0], lpos[1], lpos[2], lpos[0], lpos[1] - 1.f, lpos[2], 0.f, 0.f, -1.f);
	modelview.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(sdw_prog_name, "uModelView"), 1, GL_FALSE, m);

    glFramebufferTexture2D(
    	GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, shadow_tex_name, 0);

	glClear(GL_COLOR_BUFFER_BIT);

    for (int i = 0; _objs[i] != 0; i++)
    {
	    reder_objects_shadow(*_objs[i]);
    }

	// rendering +z cube
	modelview = mat4_t::lookAt(lpos[0], lpos[1], lpos[2], lpos[0], lpos[1], lpos[2] + 1.f, 0.f, -1.f, 0.f);
	modelview.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(sdw_prog_name, "uModelView"), 1, GL_FALSE, m);

	glFramebufferTexture2D(
		GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, shadow_tex_name, 0);

	glClear(GL_COLOR_BUFFER_BIT);

    for (int i = 0; _objs[i] != 0; i++)
    {
	    reder_objects_shadow(*_objs[i]);
    }

	// rendering -z cube
	modelview = mat4_t::lookAt(lpos[0], lpos[1], lpos[2], lpos[0], lpos[1], lpos[2] - 1.f, 0.f, -1.f, 0.f);
	modelview.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(sdw_prog_name, "uModelView"), 1, GL_FALSE, m);

	glFramebufferTexture2D(
		GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, shadow_tex_name, 0);

	glClear(GL_COLOR_BUFFER_BIT);

    for (int i = 0; _objs[i] != 0; i++)
    {
	    reder_objects_shadow(*_objs[i]);
    }
}

static void render_light(dat_t& _objs)
{
	glUseProgram(lr_prog_name);

	glEnableVertexAttribArray(0);
	glEnableVertexAttribArray(1);

	/* ̓tOgCeBǑʂł͂ȂA萔J[gĕ`悵܂B*/
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_FragmentLighting.enabled"), GL_FALSE);
	glUniform3i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].srcRgb"), GL_CONSTANT, GL_CONSTANT, GL_CONSTANT);
	glUniform3i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].srcAlpha"), GL_CONSTANT, GL_CONSTANT, GL_CONSTANT);

	glDisable(GL_CULL_FACE);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	for (int i = 0; i < _objs.obj_num; i++)
	{
		glBindBuffer(GL_ARRAY_BUFFER, _objs.posVB);
		glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, (void*)_objs.obj[i].vtx_offset);
		glBindBuffer(GL_ARRAY_BUFFER, _objs.normVB);
		glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 0, (void*)_objs.obj[i].nrm_offset);
		for (unsigned j = _objs.obj[i].patch_offset; j < _objs.obj[i].patch_size + _objs.obj[i].patch_offset; j++)
		{
			glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, _objs.idxVB);
			glDrawElements(GL_TRIANGLES, _objs.patch[j].elm_size,
				GL_UNSIGNED_SHORT, (GLvoid*)(_objs.patch[j].elm_offset + _objs.obj[i].elm_offset));
		}
	}

	glEnable(GL_CULL_FACE);
	glDisable(GL_BLEND);

	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_FragmentLighting.enabled"), GL_TRUE);
	glUniform3i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].srcRgb"), GL_FRAGMENT_PRIMARY_COLOR_DMP, GL_CONSTANT, GL_CONSTANT);
	glUniform3i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].srcAlpha"), GL_FRAGMENT_PRIMARY_COLOR_DMP, GL_CONSTANT, GL_CONSTANT);

	glDisableVertexAttribArray(0);
	glDisableVertexAttribArray(1);
}

static int setup_1st_psss_shader()
{
	mat4_t proj;
	GLfloat m[16];

	sdw_prog_name = glCreateProgram();

	glAttachShader(sdw_prog_name, shaders_name[0]);
	glAttachShader(sdw_prog_name, GL_DMP_FRAGMENT_SHADER_DMP);
	glBindAttribLocation(sdw_prog_name, 0, "aPosition");

	glLinkProgram(sdw_prog_name);
    glUseProgram(sdw_prog_name);

	/* 1stpXn[hVhÊ߂̃_Os܂B̂
	 * eNX`tOgCeBOgp܂B
	 * n[hVhEł̓J[Ƃč(0.0, 0.0, 0.0, 0.0)o͂
	 * Kv̂ŃeNX`RoCi̓̓Iyh0ԖڂƂ
	 * 萔J[w肵ă[hGL_REPLACEƂĂ̂܂܏o͂Ă܂B*/
    glUniform1i(glGetUniformLocation(sdw_prog_name, "dmp_Texture[0].samplerType"), GL_FALSE);
	glUniform1i(glGetUniformLocation(sdw_prog_name, "dmp_FragmentLighting.enabled"), GL_FALSE);
	glUniform1i(glGetUniformLocation(sdw_prog_name, "dmp_FragmentLightSource[0].enabled"), GL_FALSE);

	GLfloat color[] = {0.f, 0.f, 0.f, 0.f};
	glUniform4fv(glGetUniformLocation(sdw_prog_name, "dmp_TexEnv[0].constRgba"), 1, color);
	glUniform1i(glGetUniformLocation(sdw_prog_name, "dmp_TexEnv[0].combineRgb"), GL_REPLACE);
	glUniform1i(glGetUniformLocation(sdw_prog_name, "dmp_TexEnv[0].combineAlpha"), GL_REPLACE);
	glUniform3i(glGetUniformLocation(sdw_prog_name, "dmp_TexEnv[0].operandRgb"), GL_SRC_COLOR, GL_SRC_COLOR, GL_SRC_COLOR);
	glUniform3i(glGetUniformLocation(sdw_prog_name, "dmp_TexEnv[0].operandAlpha"), GL_SRC_ALPHA, GL_SRC_ALPHA, GL_SRC_ALPHA);
	glUniform3i(glGetUniformLocation(sdw_prog_name, "dmp_TexEnv[0].srcRgb"), GL_CONSTANT, GL_CONSTANT, GL_CONSTANT);
	glUniform3i(glGetUniformLocation(sdw_prog_name, "dmp_TexEnv[0].srcAlpha"), GL_CONSTANT, GL_CONSTANT, GL_CONSTANT);

	/* tOgIy[VVhEݐσ[hƂA
	 * VhEeNX`Ɋi[fvXlwZȂ
	 * Kvł邱ƂɒӂĉBXP[OWƂăJfarl
	 * ݒ肵܂Bڍׂ̓vO~OKChDMPVhEQƂĉB*/
	glUniform1f(glGetUniformLocation(sdw_prog_name, "dmp_FragOperation.wScale"), 1.f / f);
	glUniform1i(glGetUniformLocation(sdw_prog_name, "dmp_FragOperation.mode"), GL_FRAGOP_MODE_SHADOW_DMP);

	/* r = 0.1, t = 0.1ł邱Ƃ炱
	 * tX^̏cAщ̎p90xƂȂ܂B*/
	proj = mat4_t::frustum(-r, r, -t, t, n, f);
	proj.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(sdw_prog_name, "uProjection"), 1, GL_FALSE, m);

	glValidateProgram(sdw_prog_name);

	return 1;
}

static int setup_2nd_psss_shader()
{
	mat4_t proj;
	GLfloat m[16];

	lr_prog_name = glCreateProgram();

	glAttachShader(lr_prog_name, shaders_name[1]);
	glAttachShader(lr_prog_name, GL_DMP_FRAGMENT_SHADER_DMP);
	glBindAttribLocation(lr_prog_name, 0, "aPosition");
	glBindAttribLocation(lr_prog_name, 1, "aNormal");

	glLinkProgram(lr_prog_name);
    glUseProgram(lr_prog_name);

	/* tOgCeBO̐ݒ̏ڍׂ̓vO~OKCh
	 * DMPtOgCeBOƃtOgCeBO̊eTvvO
	 * QƂĉB*/
	GLfloat ld0[] = {1.f, 1.f, 1.f, 1.f};
	GLfloat ls0[] = {0.f, 0.f, 0.f, 0.f};
	GLfloat ls1[] = {1.f, 1.f, 1.f, 1.f};
	GLfloat la0[] = {1.f, 1.f, 1.f, 1.f};

	glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_FragmentLightSource[0].diffuse"), 1, ld0);
	glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_FragmentLightSource[0].specular0"), 1, ls0);
	glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_FragmentLightSource[0].specular1"), 1, ls1);
	glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_FragmentLightSource[0].ambient"), 1, la0);

	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_FragmentLighting.enabled"), GL_TRUE);
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_FragmentLightSource[0].enabled"), GL_TRUE);
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_FragmentLightSource[0].shadowed"), GL_TRUE);
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_LightEnv.lutInputRR"), GL_LIGHT_ENV_NH_DMP);
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_LightEnv.lutEnabledRefl"), GL_TRUE);
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_LightEnv.config"), GL_LIGHT_ENV_LAYER_CONFIG1_DMP);

	/* tOgCeBÕvC}J[(fBt[Yj
	 * ɃVhE̊^܂B*/
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_LightEnv.shadowPrimary"), GL_TRUE);

	glGenTextures(3, lutids);
	glBindTexture(GL_TEXTURE_COLLECTION_DMP, lutids[0]);
	
	GLfloat lut[512];
	memset(lut, 0, sizeof(lut));

	int j;

	for (j = 1; j < 128; j++)
	{
		lut[j] = powf( (float)j / 127.f, 30.f);
		lut[j + 255] = lut[j] - lut[j - 1];
	}

	glBindTexture(GL_LUT_TEXTURE0_DMP, lutids[1]);
	glTexImage1D(GL_LUT_TEXTURE0_DMP, 0, GL_LUMINANCEF_DMP, 512, 0, GL_LUMINANCEF_DMP, GL_FLOAT, lut);
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_FragmentMaterial.samplerRR"), 0);

	/* eNX`̃TvO^CvSʃVhÊ̂Ƃ܂B*/
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_Texture[0].samplerType"), GL_TEXTURE_SHADOW_CUBE_DMP);

	/* shadowZScale̓A[eBt@Ng}̂߂̃p[^łB
	 * shadowZBias͕KA[eBt@Ng}̂߂̃p[^ł͂܂񂪁A
	 * oCAX[邱ƂɂāAA[eBt@Ng}̎菕ƂȂ܂B*/
	glUniform1f(glGetUniformLocation(lr_prog_name, "dmp_Texture[0].shadowZScale"), fSZScale[SDW_SETTINGS] / SBWIDTHHEIGHT);
	glUniform1f(glGetUniformLocation(lr_prog_name, "dmp_Texture[0].shadowZBias"), n * fSZBiasScale[SDW_SETTINGS] / (f - n));

	/* VhEeNX`ւ̃_OɃtX^Ƃēe
	 * gꂽꍇAperspectiveShadow͗LɂKv܂BiftHgj*/
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_Texture[0].perspectiveShadow"), GL_TRUE);

	/* Őݒ肵萔J[͌`悷鎞Ɏgp܂B*/
	GLfloat color[] = {1.f, 1.f, 0.f, 0.5f};
	glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].constRgba"), 1, color);

	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].combineRgb"), GL_REPLACE);
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].combineAlpha"), GL_REPLACE);
	glUniform3i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].operandRgb"), GL_SRC_COLOR, GL_SRC_COLOR, GL_SRC_COLOR);
	glUniform3i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].operandAlpha"), GL_SRC_ALPHA, GL_SRC_ALPHA, GL_SRC_ALPHA);
	glUniform3i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].srcRgb"), GL_FRAGMENT_PRIMARY_COLOR_DMP, GL_CONSTANT, GL_CONSTANT);
	glUniform3i(glGetUniformLocation(lr_prog_name, "dmp_TexEnv[0].srcAlpha"), GL_FRAGMENT_PRIMARY_COLOR_DMP, GL_CONSTANT, GL_CONSTANT);

	/* tOgIy[VʏOpenGLƓl̓s[hƂA
	 * fvXobt@Ɋi[fvXlʏOpenGLƓlwZꂽ̂ƂȂ܂B*/
	glUniform1f(glGetUniformLocation(lr_prog_name, "dmp_FragOperation.wScale"), 0.f);
	glUniform1i(glGetUniformLocation(lr_prog_name, "dmp_FragOperation.mode"), GL_FRAGOP_MODE_GL_DMP);

	proj = mat4_t::frustum( -0.1f, 0.1f, -0.1f * HEIGHT / WIDTH, 0.1f * HEIGHT / WIDTH, 0.2f, 10.f);
	proj.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(lr_prog_name, "uProjection"), 1, GL_FALSE, m);

	glValidateProgram(lr_prog_name);

	return 1;
}

static int setup_shader()
{
	/* DMPGL2.0ł̃VF[_̃ZbgAbvOpenGLES2.0Ɠl
	 * JjYgčs܂BDMPGL2.0ł͒_VF[_̂
	 * [U`̂̂쐬\ł邽ߍ쐬VF[_IuWFNg
	 * _VF[_̂̂łB̃Tvł1stpX2ndpXňقȂ
	 * _ŝłQ̃VF[_IuWFNg쐬܂B*/
    shaders_name[0] = glCreateShader(GL_VERTEX_SHADER);
    shaders_name[1] = glCreateShader(GL_VERTEX_SHADER);

	int fsize;
	unsigned char* binary = ReadFile(FILE_APP_ROOT "shader.shbin", &fsize);
	if (!binary)
		return -1;
	
	glShaderBinary(2, shaders_name, GL_PLATFORM_BINARY_DMP, binary, fsize);
	free(binary);

	setup_1st_psss_shader();
	setup_2nd_psss_shader();

	return 1;
}

static void load_objects()
{
	loadDAT(FILE_APP_ROOT "knot.dat", &knot);
	loadDAT(FILE_APP_ROOT "rcube.dat", &cube);
}

/* unload objects */
static void unload_objects(void)
{
	unloadDAT(&knot);
	unloadDAT(&cube);
}

static void draw_1st_pass()
{
	glBindFramebuffer(GL_FRAMEBUFFER, fbo_name);
	glBindTexture(GL_TEXTURE_CUBE_MAP, 0);

	glViewport(0, 0, SBWIDTHHEIGHT, SBWIDTHHEIGHT);

	render_shadow_buffer(objects, vec3_t(lpos0));

	//glBindFramebuffer(GL_FRAMEBUFFER, 0);
	cmn_setRenderTarget(0);
}

static void  draw_2nd_pass()
{
	mat4_t modelview;
	GLfloat m[16];

	glViewport(0, 0, WIDTH, HEIGHT);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glUseProgram(lr_prog_name);

	/* 2ndpXł1stpXō쐬VhEeNX`ɃANZX܂B*/
	glBindTexture(GL_TEXTURE_CUBE_MAP, shadow_tex_name);

	modelview = mat4_t::lookAt(
		3.f * sinf((float)frame_no * (float)M_PI / 180.f),
		1.f,
		3.f * cosf((float)frame_no * (float)M_PI / 180.f), 0.f, 0.f, 0.f, 0.f, 1.f, 0.f);
	modelview.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(lr_prog_name, "uModelView"), 1, GL_FALSE, m);

	vec4_t l(lpos0);
	l = modelview * l;
	glUniform4fv(glGetUniformLocation(lr_prog_name, "dmp_FragmentLightSource[0].position"), 1, &l.x);

	/* 2ndpXł͓K؂ȃeNX`}gNXݒ肷Kv܂Bڍׂ
	 * vO~OKChDMPVhEQƂĉB*/
	mat4_t tex = mat4_t::scale(1.f / (f - n), 1.f / (f - n), 1.f / (f - n));
	tex = tex * mat4_t::translate(-lpos0[0], -lpos0[1], -lpos0[2]);
	tex.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(lr_prog_name, "uTexture"), 1, GL_FALSE, m);

	render_objects_shadowed(cube);
	render_objects_shadowed(knot);

	/* ̕`s܂B*/
	modelview = modelview*mat4_t::translate(lpos0[0], lpos0[1], lpos0[2]);
	modelview = modelview*mat4_t::scale( 0.02f, 0.02f, 0.02f );
	modelview.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(lr_prog_name, "uModelView"), 1, GL_FALSE, m);

	render_light(cube);
}

int drawframe(void)
{
	/* light position */
	lpos0[0] = 0.9f;
	lpos0[1] = 0.5f * sinf(frame_no * 5.f * (float)M_PI / 180.f);
	lpos0[2] = 0.5f * cosf(frame_no * 5.f * (float)M_PI / 180.f);
	lpos0[3] = 1.f;

	/* shadow accumulation pass */
	draw_1st_pass();
	/* shadow test pass */
	draw_2nd_pass();

	swap_buffer();

	/* it is possible to save the content of the buffer */
	/*
	char fname[256];
	sprintf(fname, "frame-%04d.tga", frame_no);
	outputImage(WIDTH, HEIGHT, fname);
	*/

	frame_no++;

	return !glGetError();
}

int initialize()
{
	frame_no = 0;
	
	/* Initialize display */
	init_display(WIDTH, HEIGHT, APP_NAME, drawframe);

	load_objects();

	if (!setup_shader())
		return -1;

	/* 1stpXł̃VhEeNX`̃NAɂ̓J[(1.f, 1.f, 1.f, 1.f)
	 * gKv̂łŃJ[obt@̃NAJ[ȉ̂悤ɐݒ肵Ă܂B*/
	glClearColor(1.f, 1.f, 1.f, 1.f);

	glClearDepthf(1.f);

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LESS);

	glEnable(GL_CULL_FACE);
	glFrontFace(GL_CCW);
	glCullFace(GL_BACK);

    glGenTextures(1, &shadow_tex_name);
    glBindTexture(GL_TEXTURE_CUBE_MAP, shadow_tex_name);

	/* VhEeNX`ANZX鎞̃AhbVO[h
	 * GL_CLAMP_TO_BORDERłB܂̂Ƃ{[_[J[ƂĔ(1.f, 1.f, 1.f, 1.f)
	 * ݒ肷Kv܂B邱ƂŃIuWFNgVhEeNX`
	 * ͈͊OꍇAVhẺe󂯂Ȃ_OʂƂȂ邱Ƃۏ؂܂B*/
	GLfloat bcolor[] = {1.f, 1.f, 1.f, 1.f};
	glTexParameterfv(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_BORDER_COLOR, bcolor);
	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER);
	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER);

	/* VhEeNX`̓~bv}bv
	 * T|[gĂȂƂɒӂĉB*/
	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MIN_LOD, 0);

	for (unsigned int face = 0; face < 6; face++)
		glTexImage2D(
			GL_TEXTURE_CUBE_MAP_POSITIVE_X + face, 0, GL_SHADOW_DMP, SBWIDTHHEIGHT, SBWIDTHHEIGHT,
			0, GL_SHADOW_DMP, GL_UNSIGNED_INT, 0);

    glBindTexture(GL_TEXTURE_CUBE_MAP, 0);

    glGenFramebuffers(1, &fbo_name);

	return 0;
}

#ifdef _NO_OS
int main(int argc, char* argv[])
#else
int sample_main(void)
#endif
{
	/* initialization */
	if (initialize() >= 0)
	{
		/* Enter loop */
		draw_loop();
	}
	
	unload_objects();
	glDeleteTextures(3, lutids);
    glDeleteTextures(1, &shadow_tex_name);
    glDeleteFramebuffers(1, &fbo_name);
	glDeleteProgram(sdw_prog_name);
	glDeleteProgram(lr_prog_name);
	glDeleteShader(shaders_name[0]);
	glDeleteShader(shaders_name[1]);
	
	/* shutdown_display */
	shutdown_display();

	return 0;
}

}
}

