//
//------------------------------------------------------------
// Copyright(c) 2009-2010 by Digital Media Professionals Inc.
// All rights reserved.
//------------------------------------------------------------
// This source code is the confidential and proprietary
// of Digital Media Professionals Inc.
//------------------------------------------------------------
//

//------------------------------------------
//	related cmp
//------------------------------------------
#define	CMP_MODE_EQ			0
#define	CMP_MODE_NE			1
#define	CMP_MODE_LT			2
#define	CMP_MODE_LE			3
#define	CMP_MODE_GT			4
#define	CMP_MODE_GE			5

//------------------------------------------
//	related condition
//------------------------------------------
#define	COND_MODE_OR		0
#define	COND_MODE_AND		1
#define	COND_MODE_STA0		2
#define	COND_MODE_STA1		3

//------------------------------------------
//	related status reg
//------------------------------------------
#define	STAT0_0				0
#define	STAT0_1				1
#define	STAT1_0				0
#define	STAT1_1				1

// Input registers map
#define aPosition		v0
#define aNormal			v1

// Output registers map
#define vPosition		o0
#define vQuaternion		o1
#define vNormal			o1
#define vView			o2
#define vTexCoord		o3

// Constant registers map
#define MATRIX_ModelView	c0
#define MATRIX_ModelView0	c0
#define MATRIX_ModelView00	c0
#define MATRIX_ModelView01	c1
#define MATRIX_ModelView02	c2
#define MATRIX_ModelView03	c3

#define MATRIX_Proj			c4
#define MATRIX_Proj0		c4
#define MATRIX_Proj1		c5
#define MATRIX_Proj2		c6
#define MATRIX_Proj3		c7

#define MATRIX_Texture		c8

#define EQ					0
#define NEQ					1
#define LESS				2
#define LEQ					3
#define GT					4
#define GEQ					5

// Temporary registers map
#define TEMP0				r0
#define TEMP1				r1
#define TEMP2				r2
#define TEMP3				r3
#define TEMP4				r4

#define TEMP_TEX0			r10
#define TEMP_TEX1			r11
#define TEMP_TEX2			r12
#define TEMP_TEX3			r13
#define TEMP_TANG			r13
#define TEMP_NORM			r14
#define TEMP_VIEW			r15
#define TEMP_POS			r12

// Constant registers
#define CONSTANT			c76

def		CONSTANT[0], 0.0, 1.0, 2.0, 3.0
def		CONSTANT[1], 0.125, 0.0, 0.5, 0.25
def		CONSTANT[2], 8.0, 0.75, 0.25, 16.0
def		CONSTANT[3], 0.015625, 0.005859375, 0.22265625, 0.171875			// 1/64   , 3/512    , 57/256  , 11/64
def		CONSTANT[4], 0.09375, 0.00390625, 0.0234375, 0.26171875				// 3/32  , 1/256  , 3/128, 67/256
def		CONSTANT[5], 0.14453125, 0.04296875, 0.1796875, 0.21875				// 37/256  , 11/256 , 23/128, 7/32
def		CONSTANT[6], 0.375, 0.0009765625, 0.0654296875, 0.271484375			// 3/8, 1/1024, 67/1024  , 139/512
def		CONSTANT[7], -0.58333334, 0.1666667, 0.02777778, 0.41666666				// 1-alpha, beta, gamma, alpha for valence3 lev 1
def		CONSTANT[8], -0.61805565, 0.1666667, 0.03935185, 0.38194435		// 1-alpha, beta, gamma, alpha for valence3 lev 2
def		CONSTANT[9], -0.4375, 0.09375, 0.015625, 0.5625							// 1-alpha, beta, gamma, alpha for valence4 lev 1
def		CONSTANT[10], -0.60546874, 0.126953125, 0.02441406, 0.39453126			// 1-alpha, beta, gamma, alpha for valence4 lev 2
def		CONSTANT[11], -3.5, 3.0, 0.5, 0.0
def		CONSTANT[12], -5.75, 9.5, 2.0, 0.0
def		CONSTANT[13], 12.25, -21.0, -3.5, 0.0
def		CONSTANT[14], 4.0, 5.0, 6.0, 65535.5
def		CONSTANT[15], 0.5625, 0.1875, 0.0625, 0.1875
def		CONSTANT[16], 0.375, 0.125, 0.0, 0.0

#define CONST_0					CONSTANT[0].x
#define CONST_1					CONSTANT[0].y
#define CONST_2					CONSTANT[0].z
#define CONST_3					CONSTANT[0].w
#define CONST_HALF				CONSTANT[1].z
#define CONST_QUARTER			CONSTANT[1].w
#define CONST_1__4				CONSTANT[1].w
#define CONST_1__8				CONSTANT[1].x
#define CONST_1__16				CONSTANT[15].z
#define CONST_1__64				CONSTANT[3].x
#define CONST_1__256			CONSTANT[4].y
#define CONST_1__1024			CONSTANT[6].y
#define CONST_3__512			CONSTANT[3].y
#define CONST_57__256			CONSTANT[3].z
#define CONST_3__32				CONSTANT[4].x
#define CONST_139__512			CONSTANT[6].w
#define CONST_67_1024			CONSTANT[6].z
#define CONST_3__4				CONSTANT[2].y
#define CONST_11__256			CONSTANT[5].y
#define CONST_23__128			CONSTANT[5].z
#define CONST_7__32				CONSTANT[5].w
#define CONST_3__8				CONSTANT[6].x
#define CONST_11__64			CONSTANT[3].w
#define CONST_3__128			CONSTANT[4].z
#define CONST_67__256			CONSTANT[4].w
#define CONST_37__256			CONSTANT[5].x
#define CONST_4					CONSTANT[14].x
#define CONST_5					CONSTANT[14].y
#define CONST_6					CONSTANT[14].z
#define CONST_8					CONSTANT[2].x
#define CONST_16				CONSTANT[2].w
#define CONST_2000				CONSTANT[0].zxxx
#define CONST_2_1				CONSTANT[0].zy
#define CONST_0_1				CONSTANT[0].xy
#define CONST_0_1_0_1			CONSTANT[0].xyxy
#define CONST_1_0				CONSTANT[0].yx
#define CONST_1_0_1_0			CONSTANT[0].yxyx
#define CONST_VAL3_COEFFS1		CONSTANT[7]
#define CONST_VAL3_COEFFS2		CONSTANT[8]
#define CONST_VAL4_COEFFS1		CONSTANT[9]
#define CONST_VAL4_COEFFS2		CONSTANT[10]
#define CONST_VAL_COEFFS01		CONSTANT[11]
#define CONST_VAL_COEFFS02		CONSTANT[12]
#define CONST_VAL_COEFFS12		CONSTANT[13]

#pragma bind_symbol(aPosition.xyz,v0,v0)
#pragma bind_symbol(aNormal.xyz,v1,v1)

#pragma bind_symbol(uModelView,c0,c3)
#pragma bind_symbol(uProjection,c4,c7)
#pragma bind_symbol(uTexture,c8,c11)

#pragma output_map ( position, o0 )
#pragma output_map ( quaternion, o1 )
#pragma output_map ( view, o2 )
#pragma output_map ( texture0, o3.xy )
#pragma output_map ( texture0w, o3.z )


main:
	m4x4	TEMP_VIEW,		aPosition,		MATRIX_ModelView
	dp3		TEMP_NORM.z,	aNormal,		MATRIX_ModelView[2]
	dp3		TEMP_NORM.x,	aNormal,		MATRIX_ModelView[0]
	dp3		TEMP_NORM.y,	aNormal,		MATRIX_ModelView[1]
	mov		TEMP_POS,		MATRIX_Proj[2]
	add		TEMP_POS,		TEMP_POS,		MATRIX_Proj[3]
	mov		vView,			-TEMP_VIEW
	mul		TEMP_POS,		TEMP_POS,		-CONST_HALF
	dp4		vPosition.x,	TEMP_VIEW,		MATRIX_Proj[0]
	dp4		vPosition.y,	TEMP_VIEW,		MATRIX_Proj[1]
	cmp		EQ, EQ,			TEMP_NORM.z,	-CONST_1			// compare z component of norm with -1.0
	add		r4,				TEMP_NORM.z,	CONST_1				// n.z + 1.0 is in r4
	dp4		vPosition.z,	TEMP_VIEW,		TEMP_POS
	dp4		vPosition.w,	TEMP_VIEW,		MATRIX_Proj[3]
	mul		r4,				r4,				CONST_HALF			// 0.5*(n.z + 1.0) is in r4
	dp4		vTexCoord.x,	aPosition,		MATRIX_Texture[0]
	dp4		vTexCoord.y,	aPosition,		MATRIX_Texture[1]
	rsq		r4,				r4.x								// 1/sqrt(0.5*(n.z + 1.0)) is in r4
	mov		vQuaternion.w,	CONST_0								// zero out quat.w component
	dp4		vTexCoord.z,	aPosition,		MATRIX_Texture[2]
	mov		vTexCoord.w,	CONST_1
	mul		r5,				TEMP_NORM,		CONST_HALF			// 0.5*n is in r5
	ifc 1, 1, 2
		mov vQuaternion.xyz,CONST_1_0
	else
		rcp vQuaternion.z,	r4.x								// sqrt(0.5*(n.z + 1.0)) is in quat.z component
		mul vQuaternion.xy,	r5,				r4					// 0.5*n*quat.z is in quat.xy
	endif
	end
endmain:
