/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */

#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>

#include "Display.h"
#include "Util.h"
#include "Vecalg.h"
#include "File.h"

#include <string.h>

#include "Memory.h"

#define APP_NAME "PointSprite"
#define WIDTH 240
#define HEIGHT 400

#define DMP_PI	(3.1415926f)
#define REV_PI	(1.0f/DMP_PI)

using namespace gputest::common;

namespace gputest{
namespace PointSprite{

/* buffer id */
GLuint array_buffer_id;
GLuint element_array_buffer_id;

/* program id */
GLuint pgid;

/* shader id */
GLuint shids[2];

GLuint texid;

/* generate simple subdivision object */
static void load_objects(void)
{
	GLfloat coords[] = {
		 0.5f, 0.5f, 0.f, 1.f,
		 0.0f, 0.7f, 0.f, 1.f,
		 0.0f,-0.7f, 0.f, 1.f,
		 0.7f, 0.0f, 0.f, 1.f,
		-0.7f, 0.0f, 0.f, 1.f,
		 0.5f,-0.5f, 0.f, 1.f,
		-0.5f, 0.5f, 0.f, 1.f,
		-0.5f,-0.5f, 0.f, 1.f
	};
	GLfloat color[] = {
		1.f, 0.0f, 0.0f,
		1.f, 0.0f, 0.0f,
		1.f, 0.0f, 0.0f,
		1.f, 0.0f, 0.0f,
		1.f, 0.0f, 0.0f,
		1.f, 0.0f, 0.0f,
		0.f, 1.0f, 0.0f,
		0.f, 0.0f, 1.0f
	};
	GLfloat pointsize[] = {
		30.f, 40.f, 10.f, 50.f, 70.f, 20.f, 60.f, 100.f
	};

	GLushort idxs[] = {0, 1, 2, 3, 4, 5, 6, 7};

	glGenBuffers(1, &array_buffer_id);
	glBindBuffer(GL_ARRAY_BUFFER, array_buffer_id);
	glBufferData(GL_ARRAY_BUFFER, sizeof(coords) + sizeof(color) + sizeof(pointsize), 0, GL_STATIC_DRAW);
	glBufferSubData(GL_ARRAY_BUFFER, 0, sizeof(coords), coords);
	glBufferSubData(GL_ARRAY_BUFFER, sizeof(coords), sizeof(color), color);
	glBufferSubData(GL_ARRAY_BUFFER, sizeof(coords) + sizeof(color), sizeof(pointsize), pointsize);
	
	glGenBuffers(1, &element_array_buffer_id);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, element_array_buffer_id);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, sizeof(idxs), idxs, GL_STATIC_DRAW);

	glEnableVertexAttribArray(0);
	glEnableVertexAttribArray(1);
	glEnableVertexAttribArray(2);

	glVertexAttribPointer(0, 4, GL_FLOAT, GL_FALSE, 0, 0) ;
	glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 0, (GLvoid*)sizeof(coords));
	glVertexAttribPointer(2, 1, GL_FLOAT, GL_FALSE, 0, (GLvoid*)(sizeof(coords) + sizeof(color)));

	float wh[2] = {0};
	wh[0] = 1.f / (float)WIDTH;
	wh[1] = 1.f / (float)HEIGHT;
	glUniform2fv(glGetUniformLocation(pgid, "dmp_Point.viewport"), 1, wh);
	glUniform1i(glGetUniformLocation(pgid, "dmp_Point.distanceAttenuation"), GL_FALSE);

	glGenTextures(1, &texid);
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, texid);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	bool bUseAlpha ;
	loadTexture(FILE_APP_ROOT "dmp0256.tga", GL_TEXTURE_2D, 0, bUseAlpha);
	glUniform1i(glGetUniformLocation(pgid, "dmp_Texture[0].samplerType"), GL_TEXTURE_2D);
	glUniform1i(glGetUniformLocation(pgid, "dmp_TexEnv[0].combineRgb"), GL_REPLACE);
	glUniform1i(glGetUniformLocation(pgid, "dmp_TexEnv[0].combineAlpha"), GL_REPLACE);
	glUniform3i(glGetUniformLocation(pgid, "dmp_TexEnv[0].operandRgb"), GL_SRC_COLOR, GL_SRC_COLOR, GL_SRC_COLOR);
	glUniform3i(glGetUniformLocation(pgid, "dmp_TexEnv[0].operandAlpha"), GL_SRC_ALPHA, GL_SRC_ALPHA, GL_SRC_ALPHA);
	glUniform3i(glGetUniformLocation(pgid, "dmp_TexEnv[0].srcRgb"), GL_TEXTURE0, GL_PRIMARY_COLOR, GL_PRIMARY_COLOR);
	glUniform3i(glGetUniformLocation(pgid, "dmp_TexEnv[0].srcAlpha"), GL_TEXTURE0, GL_PRIMARY_COLOR, GL_PRIMARY_COLOR);
}

static int frame = 0;

int drawframe(void)
{
	glClearColor(0.36f+(frame%100)*0.0064f, 0.42f, 0.5f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	GLfloat m[16];

	mat4_t proj = mat4_t::frustum(-0.02f, 0.02f, -0.02f*HEIGHT/WIDTH, 0.02f*HEIGHT/WIDTH, 0.2f, 20.f);
	proj.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(pgid, "uProjection"), 1, GL_FALSE, m);

	mat4_t mv = mat4_t::lookAt(0.f, 0.4f, 7.5f, 0.f, 0.f, 0.f, 1.f, 0.f, 0.f);
	mv = mv * mat4_t::rotate(-6.f*frame, 0.f, 0.f, 1.f);
	mv.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(pgid, "uModelView"), 1, GL_FALSE, m);

	glDrawElements(GL_GEOMETRY_PRIMITIVE_DMP, 8, GL_UNSIGNED_SHORT, 0);

	mv = mat4_t::lookAt(0.f, 0.4f, 7.5f, 0.f, 0.f, 0.f, 1.f, 0.f, 0.f);
	mv = mv * mat4_t::rotate(6.f*frame, 0.f, 0.f, 1.f);
	mv = mv * mat4_t::scale(0.5f, 0.5f, 0.5f);
	mv.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(pgid, "uModelView"), 1, GL_FALSE, m);

	glDrawElements(GL_GEOMETRY_PRIMITIVE_DMP, 8, GL_UNSIGNED_SHORT, 0);
	glFinish();

	swap_buffer();

	frame++;

	return !glGetError();
}

/* initialization */
static int initialize(void)
{
	frame = 0;
	
	/* Initialize display */
	init_display(WIDTH, HEIGHT, APP_NAME, drawframe);

	pgid = glCreateProgram();
	shids[0] = glCreateShader(GL_VERTEX_SHADER);
	shids[1] = glCreateShader(GL_GEOMETRY_SHADER_DMP);	/* shader order need to be the same as the link order. */

	int fsize;
	unsigned char* binary = ReadFile(FILE_APP_ROOT "shader.shbin", &fsize);
	if (!binary)
		return -1;

	glShaderBinary(2, shids, GL_PLATFORM_BINARY_DMP, binary, fsize);
	free(binary);

	glAttachShader(pgid, shids[0]);
	glAttachShader(pgid, shids[1]);
	glAttachShader(pgid, GL_DMP_FRAGMENT_SHADER_DMP);

	glBindAttribLocation(pgid, 0, "aPosition");
	glBindAttribLocation(pgid, 1, "aColor");
	glBindAttribLocation(pgid, 2, "aPointSize");

	glLinkProgram(pgid);
	glValidateProgram(pgid);
	glUseProgram(pgid);

	glClearDepthf(1.f);

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LESS);
	glEnable(GL_CULL_FACE);
	glFrontFace(GL_CCW);
	glCullFace(GL_BACK);

	load_objects();
	
	return 0;
}

#ifdef _NO_OS
int main(int argc, char* argv[])
#else
int sample_main(void)
#endif
{
	/* initialization */
	if (initialize() >= 0)
	{
		/* Enter loop */
		draw_loop();
	}
	
	glDeleteBuffers(1, &array_buffer_id);
	glDeleteBuffers(1, &element_array_buffer_id);
	glDeleteTextures(1, &texid);
	glDeleteProgram(pgid);
	glDeleteShader(shids[0]);
	glDeleteShader(shids[1]);
	
	/* shutdown_display */
	shutdown_display();

	return 0;
}

}
}

