//
//------------------------------------------------------------
// Copyright(c) 2009-2010 by Digital Media Professionals Inc.
// All rights reserved.
//------------------------------------------------------------
// This source code is the confidential and proprietary
// of Digital Media Professionals Inc.
//------------------------------------------------------------
//


// Output registers map
#define dmp_Position		o0
#define dmp_PMVS_Radii0		o1
#define dmp_PMVS_Radii1		o2
#define dmp_PMVS_Radii2		o3
#define dmp_PMVS_Radii3		o4

#pragma output_map ( position,	o0 )
#pragma output_map ( generic,	o1 )
#pragma output_map ( generic,	o2 )
#pragma output_map ( generic,	o3 )
#pragma output_map ( generic,	o4 )

// Input registers map
#pragma bind_symbol(attrCtrPointIndex.x, v0, v0)		//expecting only input 0,1,2,3

// Uniform definitions
#pragma bind_symbol(uProjection,	c55,	c58)		// Projection Matrix
#pragma bind_symbol(uModelView,		c59,	c62)		// ModelView Matrix
#pragma bind_symbol(uCenter,		c63,	c66)		// control point positions
#pragma bind_symbol(uRadii,			c71,	c74)		// radii around each control points

#define uProjection					c55
#define uModelView					c59
#define dmp_PartSys_center			c63		// 4*(x,y,z,w) control point positions
#define dmp_PartSys_radii			c71		// 4*(x,y,z,?) box radii around each control points

//internal calculation
#define CONSTANT					c76		//starting register index for constant values
def		CONSTANT[0],	0.0, 1.0, 2.0, 3.0
def		CONSTANT[1],	0.125, 0.0, 0.5, 0.25
#define CONST_0					CONSTANT[0].x
#define CONST_1					CONSTANT[0].y
#define CONST_2					CONSTANT[0].z
#define CONST_3					CONSTANT[0].w
#define CONST_HALF				CONSTANT[1].z
#define CONST_QUARTER			CONSTANT[1].w
#define CONST_1__4				CONSTANT[1].w
#define CONST_1__8				CONSTANT[1].x


main:
	mova	a0.x,					v0.x												//this is the tricky part. Select the current control point (0..3)
	mov		r12,					uProjection[2]
	add		r12,					r12,							uProjection[3]
	mov		r1,						dmp_PartSys_center[a0.x]
	m4x4	r0,						r1,								uModelView			//control point position projected in model view space
	mul		r12,					r12,							-CONST_HALF
	mov		r2,						dmp_PartSys_radii[a0.x]
	mul		r1.x,					r2.x,							uModelView[0].x		//Projection of the radii in modelview space
	mul		r1.y,					r2.x,							uModelView[1].x
	mul		r1.z,					r2.x,							uModelView[2].x
	dp3		dmp_PMVS_Radii0.x,		uProjection[0],					r1					//Projection of the radii in camera space
	dp3		dmp_PMVS_Radii1.x,		uProjection[1],					r1					//Projection of the radii in camera space
	dp3		dmp_PMVS_Radii2.x,		r12,							r1					//Projection of the radii in camera space
	dp3		dmp_PMVS_Radii3.x,		uProjection[3],					r1					//Projection of the radii in camera space
	mul		r1.x,					r2.y,							uModelView[0].y
	mul		r1.y,					r2.y,							uModelView[1].y
	mul		r1.z,					r2.y,							uModelView[2].y
	dp4		dmp_Position.x,			r0,								uProjection[0]		//control point position output (camera space) (X)
	dp4		dmp_Position.y,			r0,								uProjection[1]		//control point position output (camera space) (Y)
	dp3		dmp_PMVS_Radii0.y,		uProjection[0],					r1
	dp3		dmp_PMVS_Radii1.y,		uProjection[1],					r1
	dp3		dmp_PMVS_Radii2.y,		r12,							r1
	dp3		dmp_PMVS_Radii3.y,		uProjection[3],					r1
	mul		r1.x,					r2.z,							uModelView[0].z
	mul		r1.y,					r2.z,							uModelView[1].z
	mul		r1.z,					r2.z,							uModelView[2].z
	dp4		dmp_Position.z,			r0,								r12					//control point position output (camera space) (Z)
	dp4		dmp_Position.w,			r0,								uProjection[3]		//control point position output (camera space) (W)
	mov		dmp_PMVS_Radii0.w,		CONST_0
	mov		dmp_PMVS_Radii1.w,		CONST_0
	dp3		dmp_PMVS_Radii0.z,		uProjection[0],					r1
	dp3		dmp_PMVS_Radii1.z,		uProjection[1],					r1
	dp3		dmp_PMVS_Radii2.z,		r12,							r1
	dp3		dmp_PMVS_Radii3.z,		uProjection[3],					r1
	mov		dmp_PMVS_Radii2.w,		CONST_0
	mov		dmp_PMVS_Radii3.w,		CONST_0
	end
endmain:
