/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */

namespace gputest{
namespace PartsysSimple{

enum PARTSYS_PATTERN
{
	PARTSYS_DEFAULT = 0x0,
	PARTSYS_EXPLOSION1,
	PARTSYS_EXPLOSION2,
	PARTSYS_SNOW,
	PARTSYS_SPIN,
	PARTSYS_LAST
};

/**********************************************************************************************************/
/********************Basic particle pattern****************************************************************/
/**********************************************************************************************************/
static void loadParticleSystem_1(struct _particleSys *pp)
{
	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point positions---------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_center[0][0] = 0.0f;		/*|*/	pp->m_partsys_center[1][0] = -10.0f;
	pp->m_partsys_center[0][1] = -10.0f;	/*|*/	pp->m_partsys_center[1][1] = -5.0f;
	pp->m_partsys_center[0][2] = 0.0f;		/*|*/	pp->m_partsys_center[1][2] = 0.0f;
	pp->m_partsys_center[0][3] = 1.0f;		/*|*/	pp->m_partsys_center[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_center[2][0] = 10.0f;		/*|*/	pp->m_partsys_center[3][0] = 0.0f;
	pp->m_partsys_center[2][1] = 5.0f;		/*|*/	pp->m_partsys_center[3][1] = 10.0f;
	pp->m_partsys_center[2][2] = 0.0f;		/*|*/	pp->m_partsys_center[3][2] = 0.0f;
	pp->m_partsys_center[2][3] = 1.0f;		/*|*/	pp->m_partsys_center[3][3] = 1.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point colors------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_color[0][0] = 0.0f;		/*|*/	pp->m_partsys_color[1][0] = 1.0f;
	pp->m_partsys_color[0][1] = 0.0f;		/*|*/	pp->m_partsys_color[1][1] = 0.0f;
	pp->m_partsys_color[0][2] = 0.0f;		/*|*/	pp->m_partsys_color[1][2] = 0.0f;
	pp->m_partsys_color[0][3] = 1.0f;		/*|*/	pp->m_partsys_color[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_color[2][0] = 0.0f;		/*|*/	pp->m_partsys_color[3][0] = 0.0f;
	pp->m_partsys_color[2][1] = 1.0f;		/*|*/	pp->m_partsys_color[3][1] = 0.0f;
	pp->m_partsys_color[2][2] = 0.0f;		/*|*/	pp->m_partsys_color[3][2] = 1.0f;
	pp->m_partsys_color[2][3] = 0.5f;		/*|*/	pp->m_partsys_color[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 bounding boxes------------------------------------------*/
	/*--------Radii in X, Y and Z direction. W not used ----------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_radius[0][0] = 0.0f;		/*|*/	pp->m_partsys_radius[1][0] = 1.0f;
	pp->m_partsys_radius[0][1] = 0.0f;		/*|*/	pp->m_partsys_radius[1][1] = 1.0f;
	pp->m_partsys_radius[0][2] = 0.0f;		/*|*/	pp->m_partsys_radius[1][2] = 1.0f;
	pp->m_partsys_radius[0][3] = 0.0f;		/*|*/	pp->m_partsys_radius[1][3] = 0.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_radius[2][0] = 1.0f;		/*|*/	pp->m_partsys_radius[3][0] = 10.0f;
	pp->m_partsys_radius[2][1] = 1.0f;		/*|*/	pp->m_partsys_radius[3][1] = 1.0f;
	pp->m_partsys_radius[2][2] = 1.0f;		/*|*/	pp->m_partsys_radius[3][2] = 1.0f;
	pp->m_partsys_radius[2][3] = 1.0f;		/*|*/	pp->m_partsys_radius[3][3] = 1.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the particle aspect-------------------------------------------*/
	/*--------Particle size, texture coordinates !!!??TBD	------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*Rotation disabled: Size, unused,unused,unused/alpha                                 */
	/*Rotation Enabled:  Size, Angle, Radius, unused/alpha                                */
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_aspect[0][0] = 10.0f;		/*|*/	pp->m_partsys_aspect[1][0] = 30.0f;
	pp->m_partsys_aspect[0][1] = 0.0f;		/*|*/	pp->m_partsys_aspect[1][1] = 0.0f;
	pp->m_partsys_aspect[0][2] = 0.9f;		/*|*/	pp->m_partsys_aspect[1][2] = 0.9f;
	pp->m_partsys_aspect[0][3] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_aspect[2][0] = 30.0f;		/*|*/	pp->m_partsys_aspect[3][0] = 10.0f;
	pp->m_partsys_aspect[2][1] = 0.0f;		/*|*/	pp->m_partsys_aspect[3][1] = 0.0f;
	pp->m_partsys_aspect[2][2] = 0.9f;		/*|*/	pp->m_partsys_aspect[3][2] = 0.9f;
	pp->m_partsys_aspect[2][3] = 0.0f;		/*|*/	pp->m_partsys_aspect[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	pp->m_size_min_max[0] = 1.0f;
	pp->m_size_min_max[1] = (GLfloat)REAL_HEIGHT / 2.0f;

	pp->m_random_seed[0] = 45.0f;
	pp->m_random_seed[1] = 82.564f + pp->m_random_seed[0];
	pp->m_random_seed[2] = 18.15f + pp->m_random_seed[0];
	pp->m_random_seed[3] = 819.9875f + pp->m_random_seed[0];

	/* Core value for random
	 Algorithm is based Pseudo-random number generators: X(n+1) = (a*Xn+b) mod m
	 Expected values for uniform are
	 [0] = a, [1] = b, [2] = m, [3] = 1/m
	*/
	pp->m_prng[0] = 17.0f;								/* a */
	pp->m_prng[1] = 37.0f;								/* b */
	pp->m_prng[2] = 65535.0f;							/* m */
	pp->m_prng[3] = 1.0f / (pp->m_prng[2]);				/* 1/m */

	pp->m_speed = 1.0f;				/*  emitter->particle_speed  */
	pp->m_particleCountMax = 20.0f;	/*  particle number          */

	/* Application only */
	pp->simulationTime = 2.0f;
	pp->NFrame = 256;
	pp->dTime = pp->simulationTime/pp->NFrame;
}

/************************************************************************************************************/
/*********************Explosition like     ******************************************************************/
/************************************************************************************************************/
/* all the control are in (0,0,0)
 Bounding boxes have different radii 
 this gives the effect of grow/shrink for the particles
*/
static void loadParticleSystem_Explositon1(struct _particleSys *pp)
{
	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point positions---------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_center[0][0] = 0.0f;	/*|*/	pp->m_partsys_center[1][0] = 0.0f;
	pp->m_partsys_center[0][1] = 0.0f;	/*|*/	pp->m_partsys_center[1][1] = 0.0f;
	pp->m_partsys_center[0][2] = 0.0f;	/*|*/	pp->m_partsys_center[1][2] = 0.0f;
	pp->m_partsys_center[0][3] = 1.0f;	/*|*/	pp->m_partsys_center[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_center[2][0] = 0.0f;	/*|*/	pp->m_partsys_center[3][0] = 0.0f;
	pp->m_partsys_center[2][1] = 0.0f;	/*|*/	pp->m_partsys_center[3][1] = 0.0f;
	pp->m_partsys_center[2][2] = 0.0f;	/*|*/	pp->m_partsys_center[3][2] = 0.0f;
	pp->m_partsys_center[2][3] = 1.0f;	/*|*/	pp->m_partsys_center[3][3] = 1.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point colors------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_color[0][0] = 1.0f;		/*|*/	pp->m_partsys_color[1][0] = 1.0f;
	pp->m_partsys_color[0][1] = 1.0f;		/*|*/	pp->m_partsys_color[1][1] = 0.0f;
	pp->m_partsys_color[0][2] = 1.0f;		/*|*/	pp->m_partsys_color[1][2] = 0.0f;
	pp->m_partsys_color[0][3] = 1.0f;		/*|*/	pp->m_partsys_color[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_color[2][0] = 0.0f;		/*|*/	pp->m_partsys_color[3][0] = 0.0f;
	pp->m_partsys_color[2][1] = 1.0f;		/*|*/	pp->m_partsys_color[3][1] = 0.0f;
	pp->m_partsys_color[2][2] = 0.0f;		/*|*/	pp->m_partsys_color[3][2] = 1.0f;
	pp->m_partsys_color[2][3] = 1.0f;		/*|*/	pp->m_partsys_color[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 bounding boxes------------------------------------------*/
	/*--------Radii in X, Y and Z direction. W not used ----------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_radius[0][0] = 1.0f;		/*|*/	pp->m_partsys_radius[1][0] = 10.0f;
	pp->m_partsys_radius[0][1] = 1.0f;		/*|*/	pp->m_partsys_radius[1][1] = 10.0f;
	pp->m_partsys_radius[0][2] = 1.0f;		/*|*/	pp->m_partsys_radius[1][2] = 10.0f;
	pp->m_partsys_radius[0][3] = 1.0f;		/*|*/	pp->m_partsys_radius[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_radius[2][0] = 20.0f;		/*|*/	pp->m_partsys_radius[3][0] = 50.0f;
	pp->m_partsys_radius[2][1] = 20.0f;		/*|*/	pp->m_partsys_radius[3][1] = 50.0f;
	pp->m_partsys_radius[2][2] = 20.0f;		/*|*/	pp->m_partsys_radius[3][2] = 50.0f;
	pp->m_partsys_radius[2][3] = 1.0f;		/*|*/	pp->m_partsys_radius[3][3] = 1.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the particle aspect-------------------------------------------*/
	/*--------Particle size, texture coordinates !!!??TBD	------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*Rotation disabled: Size, unused,unused,unused/alpha                                 */
	/*Rotation Enabled:  Size, Angle, Radius, unused/alpha                                */
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_aspect[0][0] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][0] = 2.0f;
	pp->m_partsys_aspect[0][1] = 0.0f;		/*|*/	pp->m_partsys_aspect[1][1] = 0.0f;
	pp->m_partsys_aspect[0][2] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][2] = 1.0f;
	pp->m_partsys_aspect[0][3] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_aspect[2][0] = 30.0f;		/*|*/	pp->m_partsys_aspect[3][0] = 50.0f;
	pp->m_partsys_aspect[2][1] = 0.0f;		/*|*/	pp->m_partsys_aspect[3][1] = 0.0f;
	pp->m_partsys_aspect[2][2] = 1.0f;		/*|*/	pp->m_partsys_aspect[3][2] = 1.0f;
	pp->m_partsys_aspect[2][3] = 0.0f;		/*|*/	pp->m_partsys_aspect[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	pp->m_size_min_max[0] = 1.0f;
	pp->m_size_min_max[1] = (GLfloat)REAL_HEIGHT / 2.0f;

	pp->m_random_seed[0] = 15.8794f;
	pp->m_random_seed[1] = 2.564f + pp->m_random_seed[0];
	pp->m_random_seed[2] = 1.15f + pp->m_random_seed[0];
	pp->m_random_seed[3] = 0.9875f + pp->m_random_seed[0];

	/* Core value for random
	 Algorithm is based Pseudo-random number generators: X(n+1) = (a*Xn+b) mod m
	 Expected values for uniform are
	 [0] = a, [1] = b, [2] = m, [3] = 1/m
	*/
	pp->m_prng[0] = 147.0f;						/* a */
	pp->m_prng[1] = 17.0f;						/* b */
	pp->m_prng[2] = 256847.0f;					/* m */
	pp->m_prng[3] = 1.0f / (pp->m_prng[2]);		/* 1/m */

	pp->m_speed = 0.55f;				/*  emitter->particle_speed  */
	pp->m_particleCountMax = 100.0f;	/*  particle number          */

	/* Application only */
	pp->simulationTime = 10.0f;
	pp->NFrame = 512;
	pp->dTime = pp->simulationTime/pp->NFrame;
}

/***********************************************************************************************************/
/********************Explosition like     ******************************************************************/
/***********************************************************************************************************/
/* all the control are in (0,0,0)
 Bounding boxes have growing radii 
 this gives the expanding for the particles */
static void loadParticleSystem_Explositon2(struct _particleSys *pp)
{
	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point positions---------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_center[0][0] = 0.0f;	/*|*/	pp->m_partsys_center[1][0] = 0.0f;
	pp->m_partsys_center[0][1] = 0.0f;	/*|*/	pp->m_partsys_center[1][1] = 0.0f;
	pp->m_partsys_center[0][2] = 0.0f;	/*|*/	pp->m_partsys_center[1][2] = 0.0f;
	pp->m_partsys_center[0][3] = 1.0f;	/*|*/	pp->m_partsys_center[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_center[2][0] = 0.0f;	/*|*/	pp->m_partsys_center[3][0] = 0.0f;
	pp->m_partsys_center[2][1] = 0.0f;	/*|*/	pp->m_partsys_center[3][1] = 0.0f;
	pp->m_partsys_center[2][2] = 0.0f;	/*|*/	pp->m_partsys_center[3][2] = 0.0f;
	pp->m_partsys_center[2][3] = 1.0f;	/*|*/	pp->m_partsys_center[3][3] = 1.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point colors------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_color[0][0] = 1.0f;		/*|*/	pp->m_partsys_color[1][0] = 1.0f;
	pp->m_partsys_color[0][1] = 1.0f;		/*|*/	pp->m_partsys_color[1][1] = 0.0f;
	pp->m_partsys_color[0][2] = 1.0f;		/*|*/	pp->m_partsys_color[1][2] = 0.0f;
	pp->m_partsys_color[0][3] = 1.0f;		/*|*/	pp->m_partsys_color[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_color[2][0] = 0.0f;		/*|*/	pp->m_partsys_color[3][0] = 0.0f;
	pp->m_partsys_color[2][1] = 1.0f;		/*|*/	pp->m_partsys_color[3][1] = 0.0f;
	pp->m_partsys_color[2][2] = 0.0f;		/*|*/	pp->m_partsys_color[3][2] = 1.0f;
	pp->m_partsys_color[2][3] = 1.0f;		/*|*/	pp->m_partsys_color[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 bounding boxes------------------------------------------*/
	/*--------Radii in X, Y and Z direction. W not used ----------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_radius[0][0] = 1.0f;		/*|*/	pp->m_partsys_radius[1][0] = 1.0f;
	pp->m_partsys_radius[0][1] = 1.0f;		/*|*/	pp->m_partsys_radius[1][1] = 1.0f;
	pp->m_partsys_radius[0][2] = 1.0f;		/*|*/	pp->m_partsys_radius[1][2] = 1.0f;
	pp->m_partsys_radius[0][3] = 1.0f;		/*|*/	pp->m_partsys_radius[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_radius[2][0] = 80.0f;		/*|*/	pp->m_partsys_radius[3][0] = 0.0f;
	pp->m_partsys_radius[2][1] = 80.0f;		/*|*/	pp->m_partsys_radius[3][1] = 0.0f;
	pp->m_partsys_radius[2][2] = 80.0f;		/*|*/	pp->m_partsys_radius[3][2] = 0.0f;
	pp->m_partsys_radius[2][3] = 1.0f;		/*|*/	pp->m_partsys_radius[3][3] = 1.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the particle aspect-------------------------------------------*/
	/*--------Particle size, texture coordinates !!!??TBD	------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*Rotation disabled: Size, unused,unused,unused/alpha                                 */
	/*Rotation Enabled:  Size, Angle, Radius, unused/alpha                                */
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_aspect[0][0] = 0.0f;		/*|*/	pp->m_partsys_aspect[1][0] = 3.0f;
	pp->m_partsys_aspect[0][1] = 0.0f;		/*|*/	pp->m_partsys_aspect[1][1] = 3.0f;
	pp->m_partsys_aspect[0][2] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][2] = 1.0f;
	pp->m_partsys_aspect[0][3] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_aspect[2][0] = 20.0f;		/*|*/	pp->m_partsys_aspect[3][0] = 0.0f;
	pp->m_partsys_aspect[2][1] = -3.0f;		/*|*/	pp->m_partsys_aspect[3][1] = -6.0f;
	pp->m_partsys_aspect[2][2] = 1.0f;		/*|*/	pp->m_partsys_aspect[3][2] = 1.0f;
	pp->m_partsys_aspect[2][3] = 0.0f;		/*|*/	pp->m_partsys_aspect[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	pp->m_size_min_max[0] = 1.0f;
	pp->m_size_min_max[1] = (GLfloat)REAL_HEIGHT / 2.0f;

	pp->m_random_seed[0] = 735.0f;
	pp->m_random_seed[1] = 2.564f + pp->m_random_seed[0];
	pp->m_random_seed[2] = 1.15f + pp->m_random_seed[0];
	pp->m_random_seed[3] = 0.9875f + pp->m_random_seed[0];

	/* Core value for random
	 Algorithm is based Pseudo-random number generators: X(n+1) = (a*Xn+b) mod m
	 Expected values for uniform are
	 [0] = a, [1] = b, [2] = m, [3] = 1/m
	*/
	pp->m_prng[0] = 147.0f;					/* a */
	pp->m_prng[1] = 17.0f;					/* b */
	pp->m_prng[2] = 256847.0f;				/* m */
	pp->m_prng[3] = 1.0f / (pp->m_prng[2]);	/* 1/m */

	pp->m_speed = 0.55f;				/*  emitter->particle_speed  */
	pp->m_particleCountMax = 100.0f;	/*  particle number          */

	/* Application only */
	pp->simulationTime = 10.0f;
	pp->NFrame = 512;
	pp->dTime = pp->simulationTime/pp->NFrame;
}
/*********************************************************************************************************/
/********************Snow / Falling flocon ***************************************************************/
/*********************************************************************************************************/
/* all the control are in (0,0,0)
 Falling particles */
static void loadParticleSystem_Snow(struct _particleSys *pp)
{
	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point positions---------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_center[0][0] = 0.0f;	/*|*/	pp->m_partsys_center[1][0] = 0.0f;
	pp->m_partsys_center[0][1] = 35.0f;	/*|*/	pp->m_partsys_center[1][1] = 10.0f;
	pp->m_partsys_center[0][2] = 0.0f;	/*|*/	pp->m_partsys_center[1][2] = 0.0f;
	pp->m_partsys_center[0][3] = 1.0f;	/*|*/	pp->m_partsys_center[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_center[2][0] = 0.0f;	/*|*/	pp->m_partsys_center[3][0] = 0.0f;
	pp->m_partsys_center[2][1] = -5.0f;	/*|*/	pp->m_partsys_center[3][1] = -60.0f;
	pp->m_partsys_center[2][2] = 0.0f;	/*|*/	pp->m_partsys_center[3][2] = 0.0f;
	pp->m_partsys_center[2][3] = 1.0f;	/*|*/	pp->m_partsys_center[3][3] = 1.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point colors------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_color[0][0] = 1.0f;		/*|*/	pp->m_partsys_color[1][0] = 1.0f;
	pp->m_partsys_color[0][1] = 1.0f;		/*|*/	pp->m_partsys_color[1][1] = 1.0f;
	pp->m_partsys_color[0][2] = 1.0f;		/*|*/	pp->m_partsys_color[1][2] = 1.0f;
	pp->m_partsys_color[0][3] = 1.0f;		/*|*/	pp->m_partsys_color[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_color[2][0] = 1.0f;		/*|*/	pp->m_partsys_color[3][0] = 1.0f;
	pp->m_partsys_color[2][1] = 1.0f;		/*|*/	pp->m_partsys_color[3][1] = 1.0f;
	pp->m_partsys_color[2][2] = 1.0f;		/*|*/	pp->m_partsys_color[3][2] = 1.0f;
	pp->m_partsys_color[2][3] = 0.0f;		/*|*/	pp->m_partsys_color[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 bounding boxes------------------------------------------*/
	/*--------Radii in X, Y and Z direction. W not used ----------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_radius[0][0] = 100.0f;	/*|*/	pp->m_partsys_radius[1][0] = 100.0f;
	pp->m_partsys_radius[0][1] = 1.0f;		/*|*/	pp->m_partsys_radius[1][1] = 10.0f;
	pp->m_partsys_radius[0][2] = 1.0f;		/*|*/	pp->m_partsys_radius[1][2] = 10.0f;
	pp->m_partsys_radius[0][3] = 1.0f;		/*|*/	pp->m_partsys_radius[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_radius[2][0] = 100.0f;	/*|*/	pp->m_partsys_radius[3][0] = 100.0f;
	pp->m_partsys_radius[2][1] = 10.0f;		/*|*/	pp->m_partsys_radius[3][1] = 10.0f;
	pp->m_partsys_radius[2][2] = 20.0f;		/*|*/	pp->m_partsys_radius[3][2] = 50.0f;
	pp->m_partsys_radius[2][3] = 1.0f;		/*|*/	pp->m_partsys_radius[3][3] = 1.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the particle aspect-------------------------------------------*/
	/*--------Particle size, texture coordinates !!!??TBD	------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*Rotation disabled: Size, unused,unused,unused/alpha                                 */
	/*Rotation Enabled:  Size, Angle, Radius, unused/alpha                                */
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_aspect[0][0] = 10.0f;		/*|*/	pp->m_partsys_aspect[1][0] = 10.0f;
	pp->m_partsys_aspect[0][1] = 0.0f;		/*|*/	pp->m_partsys_aspect[1][1] = 1.0f;
	pp->m_partsys_aspect[0][2] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][2] = 1.0f;
	pp->m_partsys_aspect[0][3] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_aspect[2][0] = 10.0f;		/*|*/	pp->m_partsys_aspect[3][0] = 10.0f;
	pp->m_partsys_aspect[2][1] = 6.0f;		/*|*/	pp->m_partsys_aspect[3][1] = 0.0f;
	pp->m_partsys_aspect[2][2] = 1.0f;		/*|*/	pp->m_partsys_aspect[3][2] = 1.0f;
	pp->m_partsys_aspect[2][3] = 0.0f;		/*|*/	pp->m_partsys_aspect[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	pp->m_size_min_max[0] = 1.0f;
	pp->m_size_min_max[1] = (GLfloat)REAL_HEIGHT / 2.0f;

	pp->m_random_seed[0] = 735.0f;
	pp->m_random_seed[1] = 2.564f + pp->m_random_seed[0];
	pp->m_random_seed[2] = 1.15f + pp->m_random_seed[0];
	pp->m_random_seed[3] = 0.9875f + pp->m_random_seed[0];

	/* Core value for random
	 Algorithm is based Pseudo-random number generators: X(n+1) = (a*Xn+b) mod m
	 Expected values for uniform are
	 [0] = a, [1] = b, [2] = m, [3] = 1/m
	*/
	pp->m_prng[0] = 17.0f;						/* a */
	pp->m_prng[1] = 37.0f;						/* b */
	pp->m_prng[2] = 16777215.0f;				/* m */
	pp->m_prng[3] = 1.0f / (pp->m_prng[2]);		/* 1/m */

	pp->m_speed = 0.15f;				/*  emitter->particle_speed  */
	pp->m_particleCountMax = 100.0f;	/*  particle number          */

	/* Application only */
	pp->simulationTime = 10.0f;
	pp->NFrame = 512;
	pp->dTime = pp->simulationTime/pp->NFrame;
}

/*********************************************************************************************************/
/********************Spinning / Fake blurry effect********************************************************/
/*********************************************************************************************************/
/* all the control are in (0,0,0)
 Falling particles */
static void loadParticleSystem_Spin(struct _particleSys *pp)
{
	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point positions---------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_center[0][0] = 0.0f;	/*|*/	pp->m_partsys_center[1][0] = 0.0f;
	pp->m_partsys_center[0][1] = 0.0f;	/*|*/	pp->m_partsys_center[1][1] = 0.0f;
	pp->m_partsys_center[0][2] = 0.0f;	/*|*/	pp->m_partsys_center[1][2] = 0.0f;
	pp->m_partsys_center[0][3] = 1.0f;	/*|*/	pp->m_partsys_center[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_center[2][0] = 0.0f;	/*|*/	pp->m_partsys_center[3][0] = 0.0f;
	pp->m_partsys_center[2][1] = 0.0f;	/*|*/	pp->m_partsys_center[3][1] = 0.0f;
	pp->m_partsys_center[2][2] = 0.0f;	/*|*/	pp->m_partsys_center[3][2] = 0.0f;
	pp->m_partsys_center[2][3] = 1.0f;	/*|*/	pp->m_partsys_center[3][3] = 1.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 control point colors------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_color[0][0] = 1.0f;		/*|*/	pp->m_partsys_color[1][0] = 0.0f;
	pp->m_partsys_color[0][1] = 0.0f;		/*|*/	pp->m_partsys_color[1][1] = 1.0f;
	pp->m_partsys_color[0][2] = 0.0f;		/*|*/	pp->m_partsys_color[1][2] = 0.0f;
	pp->m_partsys_color[0][3] = 1.0f;		/*|*/	pp->m_partsys_color[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_color[2][0] = 0.0f;		/*|*/	pp->m_partsys_color[3][0] = 1.0f;
	pp->m_partsys_color[2][1] = 1.0f;		/*|*/	pp->m_partsys_color[3][1] = 1.0f;
	pp->m_partsys_color[2][2] = 1.0f;		/*|*/	pp->m_partsys_color[3][2] = 1.0f;
	pp->m_partsys_color[2][3] = 0.0f;		/*|*/	pp->m_partsys_color[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the 4 bounding boxes------------------------------------------*/
	/*--------Radii in X, Y and Z direction. W not used ----------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_radius[0][0] = 0.0f;		/*|*/	pp->m_partsys_radius[1][0] = 0.0f;
	pp->m_partsys_radius[0][1] = 0.0f;		/*|*/	pp->m_partsys_radius[1][1] = 0.0f;
	pp->m_partsys_radius[0][2] = 0.0f;		/*|*/	pp->m_partsys_radius[1][2] = 0.0f;
	pp->m_partsys_radius[0][3] = 0.0f;		/*|*/	pp->m_partsys_radius[1][3] = 0.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_radius[2][0] = 0.0f;		/*|*/	pp->m_partsys_radius[3][0] = 0.0f;
	pp->m_partsys_radius[2][1] = 0.0f;		/*|*/	pp->m_partsys_radius[3][1] = 0.0f;
	pp->m_partsys_radius[2][2] = 0.0f;		/*|*/	pp->m_partsys_radius[3][2] = 0.0f;
	pp->m_partsys_radius[2][3] = 0.0f;		/*|*/	pp->m_partsys_radius[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------------------*/
	/*--------Definition of the particle aspect-------------------------------------------*/
	/*--------Particle size, texture coordinates !!!??TBD	------------------------------*/
	/*------------------------------------------------------------------------------------*/
	/*Rotation disabled: Size, unused,unused,unused/alpha                                 */
	/*Rotation Enabled:  Size, Angle, Radius, unused/alpha                                */
	/*-----------Control Point 1---------------------Control Point 2----------------------*/
	pp->m_partsys_aspect[0][0] = 30.0f;		/*|*/	pp->m_partsys_aspect[1][0] = 30.0f;
	pp->m_partsys_aspect[0][1] = 0.0f;		/*|*/	pp->m_partsys_aspect[1][1] = -3.1415f / 0.15f;
	pp->m_partsys_aspect[0][2] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][2] = 1.0f;
	pp->m_partsys_aspect[0][3] = 1.0f;		/*|*/	pp->m_partsys_aspect[1][3] = 1.0f;
	/*-----------Control Point 3---------------------Control Point 4----------------------*/
	pp->m_partsys_aspect[2][0] = 30.0f;		/*|*/	pp->m_partsys_aspect[3][0] = 30.0f;
	pp->m_partsys_aspect[2][1] = 0.0f;		/*|*/	pp->m_partsys_aspect[3][1] = 3.1415f / 0.15f;
	pp->m_partsys_aspect[2][2] = 1.0f;		/*|*/	pp->m_partsys_aspect[3][2] = 1.0f;
	pp->m_partsys_aspect[2][3] = 0.0f;		/*|*/	pp->m_partsys_aspect[3][3] = 0.0f;
	/*------------------------------------------------------------------------------------*/
	/*------------------------------------------------------------------------------------*/
	pp->m_size_min_max[0] = 1.0f;
	pp->m_size_min_max[1] = (GLfloat)REAL_HEIGHT / 2.0f;

	pp->m_random_seed[0] = 735.0f;
	pp->m_random_seed[1] = 2.564f + pp->m_random_seed[0];
	pp->m_random_seed[2] = 1.15f + pp->m_random_seed[0];
	pp->m_random_seed[3] = 0.9875f + pp->m_random_seed[0];

	/* Core value for random
	 Algorithm is based Pseudo-random number generators: X(n+1) = (a*Xn+b) mod m
	 Expected values for uniform are
	 [0] = a, [1] = b, [2] = m, [3] = 1/m
	*/
	pp->m_prng[0] = 147.0f;						/* a */
	pp->m_prng[1] = 17.0f;						/* b */
	pp->m_prng[2] = 256847.0f;					/* m */
	pp->m_prng[3] = 1.0f / (pp->m_prng[2]);		/* 1/m */

	pp->m_speed = 0.15f;				/*  emitter->particle_speed  */
	pp->m_particleCountMax = 5.0f;	/*  particle number          */

	/* Application only */
	pp->simulationTime = 10.0f;
	pp->NFrame = 512;
	pp->dTime = pp->simulationTime/pp->NFrame;
}

/**********************************************************************************************************/
/********************Particle Pattern selector*************************************************************/
/**********************************************************************************************************/

void loadParticlePattern(struct _particleSys *pp, PARTSYS_PATTERN pt)
{
	switch(pt)
	{
		case PARTSYS_EXPLOSION1:	loadParticleSystem_Explositon1(pp);		break;
		case PARTSYS_EXPLOSION2:	loadParticleSystem_Explositon2(pp);		break;
		case PARTSYS_SNOW:			loadParticleSystem_Snow(pp);			break;
		case PARTSYS_SPIN:			loadParticleSystem_Spin(pp);			break;
		case PARTSYS_DEFAULT: 
		default:
									loadParticleSystem_1(pp);				break;
	}
}

}
}

