//
// s.h
//

#include <math.h>
#include <string.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846264338327950288 
#endif

namespace gputest{
namespace LightingDistanceAtte{

static void _norm_vec( float *v )
{
    double x = v[0];
    double y = v[1];
    double z = v[2];
    double d = sqrt( x*x + y*y + z*z );

	if ( d > 0.0 ) {
		v[0] = (float)( x / d );
		v[1] = (float)( y / d );
		v[2] = (float)( z / d );
	}
}

static void _outp_vec( float *ans, float *v1, float *v2 ) /* ans = v1 * v2 */
{
    ans[0] = ( v1[1] * v2[2] - v1[2] * v2[1] );
    ans[1] = ( v1[2] * v2[0] - v1[0] * v2[2] );
    ans[2] = ( v1[0] * v2[1] - v1[1] * v2[0] );
}

static void _store_array( int idx, float *v, float *n, float *t, float *b, float *st, float *c,
						float *v_array, float *n_array, float *t_array, float *b_array, float *st_array, float *c_array, unsigned short *i_array )
{
	for ( unsigned int i = 0; i < 3; i++ ) {
		v_array[idx*3+i] = v[i];
		//v_array[idx*4+i] = v[i];
		n_array[idx*3+i] = n[i];
		t_array[idx*3+i] = t[i];
		b_array[idx*3+i] = b[i];
	}
	//v_array[idx*4+3] = 1.f;
	for ( unsigned int i = 0; i < 2; i++ )
		st_array[idx*2+i] = st[i];
	for ( unsigned int i = 0; i < 4; i++ )
		c_array[idx*4+i] = c[i];
	i_array[idx] = idx;
}

static void _tToVTBN( float *v, float *t, float *b, float *n, float *st, float r )
{
	float theta = ( float )M_PI * st[1];
	float phai = 2.f * ( float )M_PI * st[0];
	float y = - r * cos( theta );
	float z = r * sin( theta ) * cos( phai );
	float x = r * sin( theta ) * sin( phai );
	float dxdt = r * cos( theta ) * sin( phai );
	float dzdt = r * cos( theta ) * cos( phai );
	float dydt = r * sin( theta );
	float dxdp = cos( phai );
	float dzdp = - sin( phai );
	float dydp = 0.f;
	v[0] = x;
	v[1] = y;
	v[2] = z;
	t[0] = dxdp;
	t[1] = dydp;
	t[2] = dzdp;
	_norm_vec( t );
	b[0] = dxdt;
	b[1] = dydt;
	b[2] = dzdt;
	_norm_vec( b );
	_outp_vec( n, t, b );
	_norm_vec( n );
}

static void _tToVTBN2( float *v, float *t, float *b, float *n, float *st, float l )
{
	v[0] = l * ( st[0] - 0.5f );
	v[1] = l * ( st[1] - 0.5f );
	v[2] = 0.f;
	t[0] = 1.f;
	t[1] = 0.f;
	t[2] = 0.f;
	n[0] = 0.f;
	n[1] = 0.f;
	n[2] = 1.f;
	b[0] = 0.f;
	b[1] = 1.f;
	b[2] = 0.f;
}


//
// namespace util
//

//namespace util {

typedef struct vertex_attr {
	float x, y, z;
	float nx, ny, nz;
	float tx, ty, tz;
	float s, t;
	float r, g, b, a;
} vertex_attr_t;

class base
{
public:
	base()
	{
		m_vertex	= 0;
		m_normal	= 0;
		m_tangent	= 0;
		m_binormal	= 0;
		m_color		= 0;
		m_texture	= 0;
		m_index		= 0;
		m_vertex_attr = 0;
		m_triangle_count = 0;
		m_index_count = 0;
		m_vertex_attr_stride = sizeof( vertex_attr_t );
	}
	virtual ~base()
	{
		if ( m_vertex )
			delete [] m_vertex;
		if ( m_normal )
			delete [] m_normal;
		if ( m_tangent )
			delete [] m_tangent;
		if ( m_binormal )
			delete [] m_binormal;
		if ( m_color )
			delete [] m_color;
		if ( m_texture )
			delete [] m_texture;
		if ( m_index )
			delete [] m_index;
		if ( m_vertex_attr )
			delete [] m_vertex_attr;
	}
	
public:
	virtual float *get_vertex() { return m_vertex; }
	virtual float *get_normal() { return m_normal; }
	virtual float *get_tangent() { return m_tangent; }
	virtual float *get_binormal() { return m_binormal; }
	virtual float *get_color() { return m_color; }
	virtual float *get_texture() { return m_texture; }
	virtual	void *get_vertex_array() { return ( void* )m_vertex_attr; }
	virtual unsigned short *get_index() { return m_index; }
	virtual unsigned int get_triangle_count() { return m_triangle_count; }
	virtual unsigned int get_index_count() { return m_index_count; }
	virtual unsigned int get_vertex_attr_stride() { return m_vertex_attr_stride; }

protected:
	float	*m_vertex;
	float	*m_normal;
	float	*m_tangent;
	float	*m_binormal;
	float	*m_color;
	float	*m_texture;
	vertex_attr_t	*m_vertex_attr;
	unsigned short	*m_index;
	unsigned int	m_triangle_count;
	unsigned int	m_index_count; // = vertex count
	unsigned int	m_vertex_attr_stride;
};

class sphere : public base
{
public:
	sphere();
	sphere( unsigned int i, unsigned int j, float r );
	virtual ~sphere();
};

sphere::sphere()
{
	sphere( 10, 10, 1.f );
}

sphere::sphere( unsigned int ni, unsigned int nj, float r )
{
	float v[3], n[3], t[3], b[3], st[2], c[4];

	m_triangle_count = ni * nj * 2;
	m_index_count = m_triangle_count * 3;

	m_vertex  = new float [ m_index_count * 3 ];
	//m_vertex  = new float [ m_index_count * 4 ];
	m_normal = new float [ m_index_count * 3 ];
	m_tangent = new float [ m_index_count * 3 ];
	m_binormal = new float [ m_index_count * 3 ];
	m_color = new float [ m_index_count * 4 ];
	m_texture = new float [ m_index_count * 2 ];
	m_index = new unsigned short [ m_index_count ];
	m_vertex_attr = new vertex_attr_t [ m_index_count ];

	int idx = 0;
	for ( unsigned int i = 0; i < ni; i++ ) {
		for ( unsigned int j = 0; j < nj; j++ ) {

			if ( j != 0 ) {
				// 0-0
				st[0] = ( float )i / ( float )ni;
				st[1] = ( float )j / ( float )nj;
				_tToVTBN( v, t, b, n, st, r );
				c[0] = 1.f; c[1] = 0.f; c[2] = 0.f; c[3] = 1.f;
				_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
				// 0-1
				st[0] = ( float )( i + 1 ) / ( float )ni;
				st[1] = ( float )j / ( float )nj;
				_tToVTBN( v, t, b, n, st, r );
				c[0] = 0.f; c[1] = 1.f; c[2] = 0.f; c[3] = 1.f;
				_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
				// 0-2
				st[0] = ( float )( i + 1 ) / ( float )ni;
				st[1] = ( float )( j + 1 ) / ( float )nj;
				_tToVTBN( v, t, b, n, st, r );
				c[0] = 0.f; c[1] = 0.f; c[2] = 1.f; c[3] = 1.f;
				_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
			}
			if ( j != nj-1 ) {
				// 1-0
				st[0] = ( float )i / ( float )ni;
				st[1] = ( float )j / ( float )nj;
				_tToVTBN( v, t, b, n, st, r );
				c[0] = 1.f; c[1] = 1.f; c[2] = 0.f; c[3] = 1.f;
				_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
				// 1-1
				st[0] = ( float )( i + 1 ) / ( float )ni;
				st[1] = ( float )( j + 1 ) / ( float )nj;
				_tToVTBN( v, t, b, n, st, r );
				c[0] = 1.f; c[1] = 0.f; c[2] = 1.f; c[3] = 1.f;
				_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
				// 1-2
				st[0] = ( float )i / ( float )ni;
				st[1] = ( float )( j + 1 ) / ( float )nj;
				_tToVTBN( v, t, b, n, st, r );
				c[0] = 0.f; c[1] = 1.f; c[2] = 1.f; c[3] = 1.f;
				_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
			}
		}
	}

	m_index_count = idx;

	for ( unsigned int i = 0; i < m_index_count; i++ ) {
		memcpy( &m_vertex_attr[i].x,	&m_vertex[ i*3 ],	sizeof( float )*3 );
		memcpy( &m_vertex_attr[i].nx,	&m_normal[ i*3 ],	sizeof( float )*3 );
		memcpy( &m_vertex_attr[i].tx,	&m_tangent[ i*3 ],	sizeof( float )*3 );
		memcpy( &m_vertex_attr[i].s,	&m_texture[ i*2 ],	sizeof( float )*2 );
		memcpy( &m_vertex_attr[i].r,	&m_color[ i*4 ],	sizeof( float )*4 );
	}
}

sphere::~sphere()
{
}

class squre : public base
{
public:
	squre();
	squre( unsigned int i, unsigned int j, float l );
	virtual ~squre();
};

squre::squre()
{
	squre( 10, 10, 1.f );
}

squre::squre( unsigned int ni, unsigned int nj, float l )
{
	float v[3], n[3], t[3], b[3], st[2], c[4];

	m_triangle_count = ni * nj * 2;
	m_index_count = m_triangle_count * 3;

	m_vertex  = new float [ m_index_count * 3 ];
	m_normal = new float [ m_index_count * 3 ];
	m_tangent = new float [ m_index_count * 3 ];
	m_binormal = new float [ m_index_count * 3 ];
	m_color = new float [ m_index_count * 4 ];
	m_texture = new float [ m_index_count * 2 ];
	m_index = new unsigned short [ m_index_count ];

	int idx = 0;
	for ( unsigned int i = 0; i < ni; i++ ) {
		for ( unsigned int j = 0; j < nj; j++ ) {

			// 0-0
			st[0] = ( float )i / ( float )ni;
			st[1] = ( float )j / ( float )nj;
			_tToVTBN2( v, t, b, n, st, l );
			c[0] = 1.f; c[1] = 0.f; c[2] = 0.f; c[3] = 1.f;
			_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
			// 0-1
			st[0] = ( float )( i + 1 ) / ( float )ni;
			st[1] = ( float )j / ( float )nj;
			_tToVTBN2( v, t, b, n, st, l );
			c[0] = 0.f; c[1] = 1.f; c[2] = 0.f; c[3] = 1.f;
			_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
			// 0-2
			st[0] = ( float )( i + 1 ) / ( float )ni;
			st[1] = ( float )( j + 1 ) / ( float )nj;
			_tToVTBN2( v, t, b, n, st, l );
			c[0] = 0.f; c[1] = 0.f; c[2] = 1.f; c[3] = 1.f;
			_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
			// 1-0
			st[0] = ( float )i / ( float )ni;
			st[1] = ( float )j / ( float )nj;
			_tToVTBN2( v, t, b, n, st, l );
			c[0] = 1.f; c[1] = 1.f; c[2] = 0.f; c[3] = 1.f;
			_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
			// 1-1
			st[0] = ( float )( i + 1 ) / ( float )ni;
			st[1] = ( float )( j + 1 ) / ( float )nj;
			_tToVTBN2( v, t, b, n, st, l );
			c[0] = 1.f; c[1] = 0.f; c[2] = 1.f; c[3] = 1.f;
			_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
			// 1-2
			st[0] = ( float )i / ( float )ni;
			st[1] = ( float )( j + 1 ) / ( float )nj;
			_tToVTBN2( v, t, b, n, st, l );
			c[0] = 0.f; c[1] = 1.f; c[2] = 1.f; c[3] = 1.f;
			_store_array( idx++, v, n, t, b, st, c, m_vertex, m_normal, m_tangent, m_binormal, m_texture, m_color, m_index );
		}
	}

	m_index_count = idx;
}

squre::~squre()
{
}

//} // end namespace
}
}


