/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */

#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>

#include "Display.h"
#include "Util.h"
#include "Vecalg.h"
#include "Loader.h"
#include "File.h"

#include <string.h>
#include <math.h>
#include <stdio.h>

#include "Memory.h"
#include "s.h"

#define APP_NAME "LightingDistanceAtte"
#define WIDTH 240
#define HEIGHT 400

#define DMP_PI	(3.1415926f)
#define REV_PI	(1.0f/DMP_PI)

using namespace gputest::common;

namespace gputest{
namespace LightingDistanceAtte{

/* buffer id */
GLuint array_buffer_id;
GLuint element_array_buffer_id;

/* program id */
GLuint pgid;

/* shader id */
GLuint shid;

/* sphere object */
sphere *obj = 0;

GLuint lutids[1];

static void set_render_state(void)
{
	GLfloat la[] = {1.f, 1.f, 1.f, 1.f};
	GLfloat ld[] = {1.f, 1.f, 1.f, 1.f};
	glUniform4fv(glGetUniformLocation(pgid, "dmp_FragmentLightSource[0].ambient"), 1, la);
	glUniform4fv(glGetUniformLocation(pgid, "dmp_FragmentLightSource[0].diffuse"), 1, ld);

	/* setup lookup table */
	glGenTextures(1, lutids);

	GLfloat lut[512];
	int j;

	/* ̃Tvł͋̎Qƃe[u
	   ֐ y=1-x ŕ\킳镪zgp܂ */
	memset(lut, 0, sizeof(lut));
	for (j = 0; j < 256; j++)
	{
		float x = (float)j / 255.f;
		float y = 1 - x;
		lut[j] = y;
	}
	for (j = 0; j < 255; j++)
		lut[j + 256] = lut[j + 1] - lut[j];
	lut[255 + 256] = 0.f - lut[255];
	
	glBindTexture(GL_LUT_TEXTURE0_DMP, lutids[0]);
	glTexImage1D(GL_LUT_TEXTURE0_DMP, 0, GL_LUMINANCEF_DMP, 512, 0, GL_LUMINANCEF_DMP, GL_FLOAT, lut);
	glUniform1i(glGetUniformLocation(pgid, "dmp_FragmentLightSource[0].samplerDA"), 0);
	glUniform1i(glGetUniformLocation(pgid, "dmp_FragmentLightSource[0].distanceAttenuationEnabled"), GL_TRUE );
	/* Qƃe[u̓͒lɑ΂XP[ƃoCAX͈ʂ
	   JnstartAIendƂꍇA
	   XP[=1.0/(end - start)AoCAX=-start/(end - start)Ɛݒ肷
	   startendꂼ͒l0.01.0Ƀ}bsO܂
	   ̃TvŎgpl͂̂ł͂܂ */
	glUniform1f(glGetUniformLocation(pgid, "dmp_FragmentLightSource[0].distanceAttenuationScale"), 0.07f );
	glUniform1f(glGetUniformLocation(pgid, "dmp_FragmentLightSource[0].distanceAttenuationBias"), 0.f );
}

/* generate simple object */
static void load_objects(void)
{
	obj = new sphere(20, 20, 1.f);

	glGenBuffers(1, &array_buffer_id);
	glBindBuffer(GL_ARRAY_BUFFER, array_buffer_id);
	glBufferData(GL_ARRAY_BUFFER, obj->get_index_count()*3*sizeof(float)*2, 0, GL_STATIC_DRAW);
	glBufferSubData(GL_ARRAY_BUFFER, 0, obj->get_index_count()*3*sizeof(float), obj->get_vertex());
	glBufferSubData(GL_ARRAY_BUFFER, obj->get_index_count()*3*sizeof(float), obj->get_index_count()*3*sizeof(float), obj->get_normal());
	
	glGenBuffers(1, &element_array_buffer_id);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, element_array_buffer_id);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, obj->get_index_count()*sizeof(unsigned short), obj->get_index(), GL_STATIC_DRAW);

	glEnableVertexAttribArray(0);
	glEnableVertexAttribArray(1);

	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, 0);
	glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 0, (GLvoid*)(obj->get_index_count()*3*sizeof(float)));
}

static void unload_objects(void)
{
	glDeleteBuffers(1, &array_buffer_id);
	glDeleteBuffers(1, &element_array_buffer_id);

	delete obj;

	return;
}

void draw_sphere()
{
	glBindBuffer(GL_ARRAY_BUFFER, array_buffer_id);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, element_array_buffer_id);

	glDrawElements(GL_TRIANGLES, obj->get_index_count(), GL_UNSIGNED_SHORT, 0);
}

static int frame = 0;

int drawframe(void)
{
	GLfloat m[16];
	mat4_t proj, mv;

	glClearColor(0.36f+(frame%100)*0.0064f, 0.42f, 0.5f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	/* setup projection matrix */
	proj = mat4_t::frustum(-0.06f, 0.06f, -0.06f*HEIGHT/WIDTH, 0.06f*HEIGHT/WIDTH, 0.2f, 200.f);
	proj.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(pgid, "uProjection"), 1, GL_FALSE, m);

	mv = mat4_t::rotate(-90.f, 0.f, 0.f, 1.f);
	mv = mv * mat4_t::lookAt(0.f, 15.0f, 20.f, 0.f, 0.f, 0.f, 0.f, 1.f, 0.f);

	/* setup light direction */
	GLfloat lpos0[] = {0.f, 0.f, 0.f, 1.f};
	lpos0[1] = 5.f * cosf(2.f * frame / 60.f) + 7.f;
	vec4_t lpos = mv * vec4_t(lpos0);
	glUniform4fv(glGetUniformLocation(pgid, "dmp_FragmentLightSource[0].position"), 1, &lpos.x);

	GLfloat sphere_a[] = {0.f, 0.f, 0.f, 1.f};
	GLfloat sphere_d[] = {1.f, 1.f, 0.f, 1.f};
	glUniform4fv(glGetUniformLocation(pgid, "dmp_FragmentMaterial.ambient"), 1, sphere_a);
	glUniform4fv(glGetUniformLocation(pgid, "dmp_FragmentMaterial.diffuse"), 1, sphere_d);

#define N ( 3 )
	for (unsigned k = 0; k < N*2+1; k++)
	{
		for (unsigned j = 0; j < N*2+1; j++)
		{
			float x = -3.f*N + (float)k*N;
			float z = -3.f*N + (float)j*N;
			mat4_t mv2;
			mv2 = mv * mat4_t::translate(x, 0.f, z);
			mv2.toFloatArr(m);
			glUniformMatrix4fv(glGetUniformLocation(pgid, "uModelView"), 1, GL_FALSE, m);

			draw_sphere();
		}
	}

	/* draw light object */
	GLfloat light_a[] = {1.f, 0.f, 0.f, 1.f};
	GLfloat light_d[] = {0.f, 0.f, 0.f, 1.f};
	glUniform4fv(glGetUniformLocation(pgid, "dmp_FragmentMaterial.ambient"), 1, light_a);
	glUniform4fv(glGetUniformLocation(pgid, "dmp_FragmentMaterial.diffuse"), 1, light_d);

	mat4_t mv2;
	mv2 = mv * mat4_t::translate( lpos0[0], lpos0[1], lpos0[2] );
	mv2 = mv2 * mat4_t::scale( 0.3f, 0.3f, 0.3f );
	mv2.toFloatArr(m);
	glUniformMatrix4fv(glGetUniformLocation(pgid, "uModelView"), 1, GL_FALSE, m);

	draw_sphere();
	
	glFinish();

	swap_buffer();

	frame++;

	return !glGetError();
}

/* initialization */
static int initialize(void)
{
	frame = 0;
	
	/* Initialize display */
	init_display(WIDTH, HEIGHT, APP_NAME, drawframe);

	pgid = glCreateProgram();
	shid = glCreateShader(GL_VERTEX_SHADER);

	int fsize;
	unsigned char* binary = ReadFile(FILE_APP_ROOT "shader.shbin", &fsize);
	if (!binary)
		return -1;
	
	glShaderBinary(1, &shid, GL_PLATFORM_BINARY_DMP, binary, fsize);
	free(binary);

	glAttachShader(pgid, shid);
	glAttachShader(pgid, GL_DMP_FRAGMENT_SHADER_DMP);

	glBindAttribLocation(pgid, 0, "aPosition");
	glBindAttribLocation(pgid, 1, "aNormal");

	glLinkProgram(pgid);
	glValidateProgram(pgid);
	glUseProgram(pgid);

	glClearDepthf(1.f);

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LESS);
	glEnable(GL_CULL_FACE);
	glFrontFace(GL_CCW);
	glCullFace(GL_BACK);

	load_objects();

	/* set another render state */
	set_render_state();

	/* enable DMP fragment lighting */
	glUniform1i(glGetUniformLocation(pgid, "dmp_FragmentLighting.enabled"), GL_TRUE);
	glUniform1i(glGetUniformLocation(pgid, "dmp_FragmentLightSource[0].enabled"), GL_TRUE);

	/* this sample use only fragment primary color */
	glUniform1i(glGetUniformLocation(pgid, "dmp_TexEnv[0].combineRgb"), GL_REPLACE);
	glUniform1i(glGetUniformLocation(pgid, "dmp_TexEnv[0].combineAlpha"), GL_REPLACE);
	glUniform3i(glGetUniformLocation(pgid, "dmp_TexEnv[0].operandRgb"), GL_SRC_COLOR, GL_SRC_COLOR, GL_SRC_COLOR);
	glUniform3i(glGetUniformLocation(pgid, "dmp_TexEnv[0].operandAlpha"), GL_SRC_ALPHA, GL_SRC_ALPHA, GL_SRC_ALPHA);
	glUniform3i(glGetUniformLocation(pgid, "dmp_TexEnv[0].srcRgb"), GL_FRAGMENT_PRIMARY_COLOR_DMP, GL_CONSTANT, GL_CONSTANT);
	glUniform3i(glGetUniformLocation(pgid, "dmp_TexEnv[0].srcAlpha"), GL_CONSTANT, GL_CONSTANT, GL_CONSTANT);
	
	return 0;
}

#ifdef _NO_OS
int main(int argc, char* argv[])
#else
int sample_main(void)
#endif
{
	/* initialization */
	if (initialize() >= 0)
	{
		/* Enter loop */
		draw_loop();
	}
	
	unload_objects();
	glDeleteTextures(1, lutids);
	glDeleteBuffers(1, &array_buffer_id);
	glDeleteBuffers(1, &element_array_buffer_id);
	glDeleteProgram(pgid);
	glDeleteShader(shid);
	
	/* shutdown_display */
	shutdown_display();

	return 0;
}

}
}
