/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */
#ifndef __GAS_H__
#define __GAS_H__

/*
 * Definitions
 */

#define APP_NAME			"GasColorSimple"

/* Buffer size */
#define DISPLAY_WIDTH		(240)
#define DISPLAY_HEIGHT		(400)

/* accumulation buffer should have same size as display buffer */
#define GAS_ACC_WIDTH		(DISPLAY_WIDTH)
#define GAS_ACC_HEIGHT		(DISPLAY_HEIGHT)
/* texture should have powered by 2 size which is bigger than DISPLAY size */
#define GAS_TEX_WIDTH		(512)
#define GAS_TEX_HEIGHT		(512)

/* Default buffer ID */
#define DISPLAY_BUFFER		(0)		/* default frame buffer */

/* Particle pattern */
#define PARTICLE_PATTERNS	(1)
#define PARTICLE_FILES		FILE_APP_ROOT "ptcl0.tga"

namespace gputest{
namespace GasColorSimple{

struct gas_data
{
	/* Gas geometry definition (accumulation pass) */
	GLuint			gasgeo_tri_ID;				/* used in accumulation pass. Vertex Index buffer ID */
	GLuint			gasgeo_center_ID;			/* used in accumulation pass. Vertex position buffer ID */
	GLuint			gasgeo_tx0_ID;				/* used in accumulation pass. Vertex Texture coordinates buffer ID */
	GLuint			gasgeo_density_ID;			/* used in accumulation pass. Vertex color buffer ID */
	GLuint			pattern[PARTICLE_PATTERNS];	/* Texture ID applied to each particle */
	GLsizei			gasgeo_size;				/* Number of elements (triangles) defining the gaseous object*/
	GLfloat			_dela_z;					/* used in accumulation pass, to control final alpha blending*/

	GLint			_autoAcc;					/* used in post synthesis pass */
	float			_densMax;					/* used in post synthesis pass. Shading control*/
	GLfloat			_lightDirX;					/* used in post synthesis pass. Shading control */
	GLfloat			_lightDirY;					/* used in post synthesis pass. Shading control */
	GLfloat			_LightXY[4];				/* used in post synthesis pass. Shading control */
	GLfloat			_LightZ[4];					/* used in post synthesis pass. Shading control */
	GLuint			FogLut_ID;					/* used in post synthesis pass. Look up table ID */
	GLuint			CollectionLUT_ID;			/* used in post synthesis pass. Texture collection ID */
	GLuint			gasTransfert_ID[3];			/* used in post synthesis pass. Lookup table ID for gas color look up table */
	float			RR[16],GG[16],BB[16];		/* used in post synthesis pass. Lookup table for gas color content */
	float			fogTable[256];				/* used in post synthesis pass. Fog look up table for density to alpha conversion*/
	GLenum			shadingDensitySrc;			/* used in post synthesis pass. Density selection for shading input*/
	GLenum			colorLutInput;				/* used in post synthesis pass. Input selection for the gas color look up*/
	/* Gas geometry definition / simple quad (post synthesis pass) */
	GLuint			quad_index_ID;				/* used in post synthesis pass. Vertex Index buffer ID */
	GLuint			quad_vertBuf_ID;			/* used in post synthesis pass. Vertex position buffer ID */
	GLuint			quad_texBuf_ID;				/* used in post synthesis pass. Vertex Texture coordinates buffer ID */
	GLuint			quad_colBuf_ID;				/* used in post synthesis pass. Vertex color buffer ID */

};

/*
 * Function declarations
 */

/* buffer initialization */
void gas_initialize(GLuint depthbufferID);

/* buffer finalization */
void gas_finalize(void);

/* gaseous object data structure default initialization */
void defaultGasObject(struct gas_data *gas,float *gasColorTable);

/* accumulation pass */
void gas_accumulation();

/* shading pass */
void gas_shading(void);

}
}

#endif /* __GAS_H__ */
