//
//------------------------------------------------------------
// Copyright(c) 2009-2010 by Digital Media Professionals Inc.
// All rights reserved.
//------------------------------------------------------------
// This source code is the confidential and proprietary
// of Digital Media Professionals Inc.
//------------------------------------------------------------
//

#include "Commonasm.h"

// Input registers map
#define aPosition		v0
#define aColor			v1
#define aPointSize		v2

// Output registers map
#define vPosition		o0
#define vQuaternion		o1
#define vView			o2
#define vTexCoord		o3

// Constant registers map
#define MATRIX_ModelView	c0
#define MATRIX_ModelView0	c0
#define MATRIX_ModelView00	c0
#define MATRIX_ModelView01	c1
#define MATRIX_ModelView02	c2
#define MATRIX_ModelView03	c3

#define MATRIX_Proj			c4
#define MATRIX_Proj0		c4
#define MATRIX_Proj1		c5
#define MATRIX_Proj2		c6
#define MATRIX_Proj3		c7

#define CONST				c95		// 0.0 0.5 1.0 3.0
// Constant registers
def		CONST,				0.0, 0.5, 1.0, 3.0

#pragma bind_symbol(aPosition.xyzw,v0,v0)
#pragma bind_symbol(aColor.x,v1,v1)
#pragma bind_symbol(aPointSize.x,v2,v2)

#pragma output_map (position, o0)
#pragma output_map (generic,  o1)
#pragma output_map (texture0, o2.xy)
#pragma output_map (color,    o3)

#pragma bind_symbol(uProjection,c0,c3)
#pragma bind_symbol(uModelView,c4,c7)

main:
	call	l_position
	mov		o1, aPointSize.x
	mov		o2, r0			// dummy output
	mov		o3, aColor.xxxx
	end
endmain:
