/*------------------------------------------------------------*/
/* Copyright(c) 2002-2007 by Digital Media Professionals Inc. */
/* All rights reserved.                                       */
/*------------------------------------------------------------*/
/* This source code is the confidential and proprietary       */
/* of Digital Media Professionals Inc.                        */
/*------------------------------------------------------------*/
#include "GLES2/gl2.h"

namespace gputest{
namespace GasCessna{

/* ======================================================= */
/* Sample specific. Different color variation for gas	   */
/* ======================================================= */
GLfloat gasColorTable[6][24]=
{
	{	//red flame
		0.0f,	0.0f,	0.0f,	//0
		0.2f,	0.15f,	0.05f,	//1
		0.6f,	0.25f,	0.15f,	//2
		0.9f,	0.35f,	0.2f,	//3
		0.92f,	0.6f,	0.15f,	//4
		0.95f,	0.85f,	0.05f,	//5
		1.0f,	0.95f,	0.0f,	//6
		1.0f,	1.0f,	1.0f	//7
	},
	{ // blue flame
		0.00f,	0.00f,	0.00f,	//0
		0.05f,	0.15f,	0.20f,	//1
		0.15f,	0.25f,	0.60f,	//2
		0.20f,	0.35f,	0.90f,	//3
		0.15f,	0.60f,	0.92f,	//4
		0.05f,	0.85f,	0.95f,	//5
		0.00f,	0.95f,	1.00f,	//6
		1.00f,	1.00f,	1.00f	//7
	},
	{ // Grey Gradient
		0.000000f,	 0.000000f,	0.000000f,
		0.140000f,	 0.140000f,	0.140000f,
		0.280000f,	 0.280000f,	0.280000f,
		0.420000f,	 0.420000f,	0.420000f,
		0.560000f,	 0.560000f,	0.560000f,
		0.700000f,	 0.700000f,	0.700000f,
		0.840000f,	 0.840000f,	0.840000f,
		1.000000f,	 1.000000f,	1.000000f
	},	
	{	//Pastel color
		255.0f	/255.0f,	191.0f/255.0f,	191.0f/255.0f,	//0
		255.0f/255.0f,		238.0f/255.0f,	191.0f/255.0f,	//1
		222.0f/255.0f,		255.0f/255.0f,	191.0f/255.0f,	//2
		191.0f/255.0f,		255.0f/255.0f,	207.0f/255.0f,	//3
		191.0f/255.0f,		254.0f/255.0f,	255.0f/255.0f,	//4
		191.0f/255.0f,		206.0f/255.0f,	255.0f/255.0f,	//5
		223.0f/255.0f,		191.0f/255.0f,	255.0f/255.0f,	//6
		255.0f/255.0f,		191.0f/255.0f,	238.0f/255.0f	//7
	},
	{// Greenish
		125.0f/255.0f,				255.0f/255.0f,	1.0f/255.0f,//0
		173.0f/255.0f,				255.0f/255.0f,	35.0f/255.0f,//1
		189.0f/255.0f,				255.0f/255.0f,	46.0f/255.0f,//2
		204.0f/255.0f,				255.0f/255.0f,	57.0f/255.0f,//3
		219.0f/255.0f,				255.0f/255.0f,	68.0f/255.0f,//4
		229.0f/255.0f,				247.0f/255.0f,	65.0f/255.0f,//5
		234.0f/255.0f,				230.0f/255.0f,	53.0f/255.0f,//6
		239.0f/255.0f,				212.0f/255.0f,	40.0f/255.0f,//7
	},
	{//Red strips
		 0.000000f,			 0.000000f,	 0.000000f,
		 1.000000f,			 0.500000f,	 0.000000f,
		 0.500000f,			 0.000000f,	 0.000000f,
		 1.000000f,			 0.500000f,	 0.000000f,
		 0.500000f,			 0.000000f,	 0.000000f,
		 1.000000f,			 0.50000f,	 0.000000f,
		 0.500000f,			 0.000000f,	 0.000000f,
		 1.000000f,			 0.200000f,	 0.300000f,
	}
};

GLfloat particleData[] =
{
	512.f,
	-4.81795f,	-0.0143084f,	3.50394f,	/* position */
	0.355893f,								/* size     */
	0.0916013f,								/* density  */
	-5.27714f,	0.282026f,	-0.92329f,		/* position */
	0.874994f,								/* size     */
	0.0535044f,								/* density  */
	-4.79241f,	0.413767f,	3.9594f,		/* position */
	0.746015f,								/* size     */
	0.0510337f,								/* density  */
	-4.89468f,	0.611789f,	-2.67679f,		/* position */
	0.562485f,								/* size     */
	0.0953587f,								/* density  */
	-5.07371f,	0.696837f,	3.16479f,		/* position */
	0.715993f,								/* size     */
	0.0203638f,								/* density  */
	-5.27281f,	0.7632f,	3.55445f,		/* position */
	0.343266f,								/* size     */
	0.0962474f,								/* density  */
	-5.17131f,	0.982318f,	-0.410703f,		/* position */
	0.896357f,								/* size     */
	0.0963622f,								/* density  */
	-4.88768f,	1.29709f,	-0.504471f,		/* position */
	0.494963f,								/* size     */
	0.023589f,								/* density  */
	-4.72506f,	1.65529f,	3.53317f,		/* position */
	0.782123f,								/* size     */
	0.0288821f,								/* density  */
	-4.96806f,	1.91471f,	-3.98264f,		/* position */
	0.746035f,								/* size     */
	0.0224244f,								/* density  */
	-4.94865f,	0.184582f,	3.36529f,		/* position */
	0.47009f,								/* size     */
	0.022505f,								/* density  */
	-4.5571f,	0.248008f,	0.751571f,		/* position */
	0.328637f,								/* size     */
	0.0225074f,								/* density  */
	-4.59564f,	0.294687f,	1.21843f,		/* position */
	0.865648f,								/* size     */
	0.0637562f,								/* density  */
	-4.98912f,	0.382493f,	-2.70993f,		/* position */
	0.77127f,								/* size     */
	0.0915305f,								/* density  */
	-4.72216f,	0.491328f,	-2.84021f,		/* position */
	0.669319f,								/* size     */
	0.058695f,								/* density  */
	-4.95706f,	0.661163f,	-0.0940209f,	/* position */
	0.617895f,								/* size     */
	0.0523325f,								/* density  */
	-5.12642f,	0.676148f,	0.986115f,		/* position */
	0.47627f,								/* size     */
	0.0834492f,								/* density  */
	-4.92667f,	0.949822f,	-0.164781f,		/* position */
	0.371f,									/* size     */
	0.0531797f,								/* density  */
	-4.87258f,	1.23369f,	-0.474158f,		/* position */
	0.55991f,								/* size     */
	0.0794574f,								/* density  */
	-4.8422f,	1.51905f,	-4.08524f,		/* position */
	0.74737f,								/* size     */
	0.0724528f,								/* density  */
	-5.04856f,	1.71812f,	-3.99109f,		/* position */
	0.316219f,								/* size     */
	0.0638636f,								/* density  */
	-4.5854f,	1.80111f,	3.85431f,		/* position */
	0.842473f,								/* size     */
	0.0498154f,								/* density  */
	-4.40415f,	0.0212046f,	3.20482f,		/* position */
	0.831658f,								/* size     */
	0.0437214f,								/* density  */
	-4.72383f,	0.145953f,	3.41051f,		/* position */
	0.92659f,								/* size     */
	0.087839f,								/* density  */
	-4.4054f,	0.173173f,	1.3876f,		/* position */
	0.454201f,								/* size     */
	0.0928294f,								/* density  */
	-4.64833f,	0.253792f,	-1.23167f,		/* position */
	0.484319f,								/* size     */
	0.0571642f,								/* density  */
	-4.51003f,	0.454622f,	-0.829422f,		/* position */
	0.549343f,								/* size     */
	0.0217481f,								/* density  */
	-4.38541f,	0.541883f,	-3.15208f,		/* position */
	0.371191f,								/* size     */
	0.0262111f,								/* density  */
	-4.9769f,	0.71154f,	4.19138f,		/* position */
	0.783572f,								/* size     */
	0.0405866f,								/* density  */
	-4.70805f,	0.861991f,	4.1769f,		/* position */
	0.375502f,								/* size     */
	0.0609265f,								/* density  */
	-4.77643f,	1.11288f,	4.01264f,		/* position */
	0.610723f,								/* size     */
	0.0821943f,								/* density  */
	-4.6877f,	1.35439f,	-0.465522f,		/* position */
	0.445923f,								/* size     */
	0.075258f,								/* density  */
	-4.74818f,	1.50056f,	3.77901f,		/* position */
	0.707524f,								/* size     */
	0.0989673f,								/* density  */
	-4.67231f,	1.88139f,	-4.48375f,		/* position */
	0.674697f,								/* size     */
	0.0321805f,								/* density  */
	-4.57275f,	0.0747866f,	2.28638f,		/* position */
	0.47833f,								/* size     */
	0.0389654f,								/* density  */
	-4.39568f,	0.126665f,	-1.29326f,		/* position */
	0.754542f,								/* size     */
	0.0556041f,								/* density  */
	-4.33062f,	0.245399f,	1.13306f,		/* position */
	0.507075f,								/* size     */
	0.0635267f,								/* density  */
	-4.26874f,	0.213887f,	-1.11249f,		/* position */
	0.487695f,								/* size     */
	0.030933f,								/* density  */
	-4.558f,	0.322776f,	1.62049f,		/* position */
	0.719827f,								/* size     */
	0.0968188f,								/* density  */
	-4.29884f,	0.300732f,	1.26926f,		/* position */
	0.640765f,								/* size     */
	0.0826704f,								/* density  */
	-4.80228f,	0.444427f,	1.37085f,		/* position */
	0.482774f,								/* size     */
	0.0305741f,								/* density  */
	-4.22127f,	0.416046f,	1.7921f,		/* position */
	0.460477f,								/* size     */
	0.0507089f,								/* density  */
	-4.57456f,	0.56706f,	3.61655f,		/* position */
	0.535991f,								/* size     */
	0.0289529f,								/* density  */
	-4.48809f,	0.702401f,	-0.799366f,		/* position */
	0.767703f,								/* size     */
	0.0247047f,								/* density  */
	-4.59085f,	0.906676f,	3.66725f,		/* position */
	0.92163f,								/* size     */
	0.0609119f,								/* density  */
	-4.79952f,	1.0242f,	3.69933f,		/* position */
	0.556782f,								/* size     */
	0.0395099f,								/* density  */
	-4.54558f,	1.30788f,	-0.581778f,		/* position */
	0.340329f,								/* size     */
	0.0823701f,								/* density  */
	-4.30258f,	1.58106f,	0.0618334f,		/* position */
	0.640097f,								/* size     */
	0.0523447f,								/* density  */
	-4.47633f,	1.7842f,	2.95394f,		/* position */
	0.783782f,								/* size     */
	0.0413263f,								/* density  */
	-4.1828f,	-0.0260762f,	1.43467f,	/* position */
	0.606489f,								/* size     */
	0.0377471f,								/* density  */
	-4.59737f,	0.0458808f,	0.78866f,		/* position */
	0.555618f,								/* size     */
	0.0254787f,								/* density  */
	-4.48724f,	0.209693f,	-0.859673f,		/* position */
	0.614996f,								/* size     */
	0.063058f,								/* density  */
	-4.40169f,	0.253046f,	1.37594f,		/* position */
	0.769934f,								/* size     */
	0.0891916f,								/* density  */
	-4.39239f,	0.304117f,	1.21879f,		/* position */
	0.507189f,								/* size     */
	0.0724967f,								/* density  */
	-4.07778f,	0.355516f,	3.52702f,		/* position */
	0.550239f,								/* size     */
	0.0374566f,								/* density  */
	-4.34905f,	0.416691f,	2.22501f,		/* position */
	0.864523f,								/* size     */
	0.0980468f,								/* density  */
	-4.39731f,	0.649753f,	-1.24893f,		/* position */
	0.56361f,								/* size     */
	0.0432844f,								/* density  */
	-4.38668f,	0.77597f,	3.99714f,		/* position */
	0.398066f,								/* size     */
	0.0825239f,								/* density  */
	-4.33341f,	0.924807f,	1.51981f,		/* position */
	0.693714f,								/* size     */
	0.0317631f,								/* density  */
	-4.6608f,	1.09794f,	-0.0304708f,	/* position */
	0.581063f,								/* size     */
	0.0275124f,								/* density  */
	-4.40879f,	1.35366f,	0.0426592f,		/* position */
	0.315018f,								/* size     */
	0.0423591f,								/* density  */
	-4.41598f,	1.73946f,	2.66455f,		/* position */
	0.610437f,								/* size     */
	0.0341435f,								/* density  */
	-4.1207f,	0.0964776f,	1.62449f,		/* position */
	0.676471f,								/* size     */
	0.0833125f,								/* density  */
	-4.05217f,	0.291482f,	3.86396f,		/* position */
	0.470491f,								/* size     */
	0.0513584f,								/* density  */
	-4.52583f,	0.469881f,	-0.776143f,		/* position */
	0.623827f,								/* size     */
	0.0282229f,								/* density  */
	-4.02207f,	0.627281f,	4.30427f,		/* position */
	0.518195f,								/* size     */
	0.092075f,								/* density  */
	-4.34993f,	0.798005f,	4.28358f,		/* position */
	0.727781f,								/* size     */
	0.0720475f,								/* density  */
	-4.53051f,	1.10021f,	1.54058f,		/* position */
	0.74304f,								/* size     */
	0.0322269f,								/* density  */
	-4.00742f,	1.26497f,	-4.4394f,		/* position */
	0.540244f,								/* size     */
	0.0654823f,								/* density  */
	-4.0296f,	1.46335f,	-3.05995f,		/* position */
	0.849969f,								/* size     */
	0.0934666f,								/* density  */
	-4.28699f,	-0.0483203f,	-2.38826f,	/* position */
	0.672218f,								/* size     */
	0.0983642f,								/* density  */
	-3.88316f,	0.369252f,	3.86875f,		/* position */
	0.677768f,								/* size     */
	0.0321683f,								/* density  */
	-4.02789f,	0.582947f,	-0.630269f,		/* position */
	0.445904f,								/* size     */
	0.0551817f,								/* density  */
	-3.97538f,	0.809705f,	-4.60932f,		/* position */
	0.477529f,								/* size     */
	0.0519663f,								/* density  */
	-3.80799f,	1.05317f,	-4.28838f,		/* position */
	0.5152f,								/* size     */
	0.052418f,								/* density  */
	-4.06833f,	1.20401f,	-2.69378f,		/* position */
	0.797897f,								/* size     */
	0.0692691f,								/* density  */
	-4.27713f,	1.36525f,	-4.28565f,		/* position */
	0.556801f,								/* size     */
	0.0622279f,								/* density  */
	-4.06096f,	1.69803f,	-3.05305f,		/* position */
	0.733694f,								/* size     */
	0.0682388f,								/* density  */
	-3.6859f,	0.295514f,	-1.29411f,		/* position */
	0.52201f,								/* size     */
	0.0285672f,								/* density  */
	-3.94748f,	0.51135f,	3.35078f,		/* position */
	0.548828f,								/* size     */
	0.0353496f,								/* density  */
	-3.74892f,	0.689135f,	-1.0393f,		/* position */
	0.385229f,								/* size     */
	0.0838032f,								/* density  */
	-3.75033f,	1.05227f,	-4.01091f,		/* position */
	0.487753f,								/* size     */
	0.0604968f,								/* density  */
	-3.77297f,	1.21005f,	-4.76839f,		/* position */
	0.366976f,								/* size     */
	0.0911716f,								/* density  */
	-4.09484f,	1.54314f,	-2.19087f,		/* position */
	0.736154f,								/* size     */
	0.0621863f,								/* density  */
	-4.16614f,	1.70258f,	-2.30231f,		/* position */
	0.889471f,								/* size     */
	0.0355522f,								/* density  */
	-4.03263f,	0.3103f,	4.03843f,		/* position */
	0.363409f,								/* size     */
	0.0865987f,								/* density  */
	-3.52038f,	0.653846f,	-0.749592f,		/* position */
	0.590333f,								/* size     */
	0.0961522f,								/* density  */
	-3.77114f,	0.883456f,	-1.10583f,		/* position */
	0.350934f,								/* size     */
	0.0954198f,								/* density  */
	-3.62551f,	1.19157f,	-4.59897f,		/* position */
	0.324555f,								/* size     */
	0.0738542f,								/* density  */
	-3.6356f,	1.56471f,	-4.74971f,		/* position */
	0.798011f,								/* size     */
	0.0614832f,								/* density  */
	-3.4659f,	1.64224f,	-4.91668f,		/* position */
	0.533721f,								/* size     */
	0.0633363f,								/* density  */
	-3.81446f,	1.90242f,	-4.17513f,		/* position */
	0.490537f,								/* size     */
	0.0743669f,								/* density  */
	-3.89414f,	0.11764f,	-4.30895f,		/* position */
	0.416187f,								/* size     */
	0.0834761f,								/* density  */
	-3.90446f,	0.442039f,	-0.940313f,		/* position */
	0.64559f,								/* size     */
	0.0516465f,								/* density  */
	-3.49188f,	0.78038f,	-0.795918f,		/* position */
	0.812393f,								/* size     */
	0.0539293f,								/* density  */
	-3.38454f,	0.91797f,	-1.09876f,		/* position */
	0.501391f,								/* size     */
	0.0411652f,								/* density  */
	-3.32636f,	1.15491f,	-2.30974f,		/* position */
	0.812107f,								/* size     */
	0.0741154f,								/* density  */
	-3.61604f,	1.55993f,	-4.30381f,		/* position */
	0.808674f,								/* size     */
	0.0308695f,								/* density  */
	-3.54815f,	1.77257f,	-2.32248f,		/* position */
	0.562065f,								/* size     */
	0.0730094f,								/* density  */
	-3.30446f,	1.87014f,	-3.13776f,		/* position */
	0.805164f,								/* size     */
	0.064662f,								/* density  */
	-3.49652f,	1.91723f,	-4.54614f,		/* position */
	0.589112f,								/* size     */
	0.067062f,								/* density  */
	-3.3075f,	0.00122074f,	2.97272f,	/* position */
	0.383169f,								/* size     */
	0.0277346f,								/* density  */
	-3.67485f,	0.633899f,	3.51125f,		/* position */
	0.66825f,								/* size     */
	0.0655385f,								/* density  */
	-3.64759f,	0.869028f,	-2.0422f,		/* position */
	0.671493f,								/* size     */
	0.0315726f,								/* density  */
	-3.44287f,	1.20125f,	-2.38964f,		/* position */
	0.920753f,								/* size     */
	0.0443635f,								/* density  */
	-3.51638f,	1.5105f,	-2.06025f,		/* position */
	0.692188f,								/* size     */
	0.0254372f,								/* density  */
	-3.47163f,	1.64468f,	-2.07682f,		/* position */
	0.424579f,								/* size     */
	0.0522422f,								/* density  */
	-3.21116f,	1.77099f,	-2.70977f,		/* position */
	0.787101f,								/* size     */
	0.0795453f,								/* density  */
	-3.46011f,	1.89139f,	3.89022f,		/* position */
	0.448479f,								/* size     */
	0.0795843f,								/* density  */
	-3.0443f,	0.151893f,	-3.75411f,		/* position */
	0.352899f,								/* size     */
	0.0869967f,								/* density  */
	-3.23586f,	0.192467f,	0.682675f,		/* position */
	0.428642f,								/* size     */
	0.0450642f,								/* density  */
	-3.03715f,	0.378309f,	0.995228f,		/* position */
	0.443424f,								/* size     */
	0.036502f,								/* density  */
	-3.5359f,	0.604016f,	-2.31224f,		/* position */
	0.862024f,								/* size     */
	0.0646889f,								/* density  */
	-3.25509f,	0.774386f,	3.1281f,		/* position */
	0.848825f,								/* size     */
	0.0341069f,								/* density  */
	-3.30989f,	1.0722f,	-2.46771f,		/* position */
	0.454278f,								/* size     */
	0.061471f,								/* density  */
	-3.24353f,	1.62701f,	-4.90147f,		/* position */
	0.354787f,								/* size     */
	0.0400812f,								/* density  */
	-3.35185f,	1.77979f,	-3.69977f,		/* position */
	0.588807f,								/* size     */
	0.0973168f,								/* density  */
	-3.32948f,	0.0529067f,	3.71374f,		/* position */
	0.767397f,								/* size     */
	0.0911032f,								/* density  */
	-3.41394f,	0.241307f,	0.932732f,		/* position */
	0.923862f,								/* size     */
	0.0864009f,								/* density  */
	-2.88529f,	0.423973f,	3.27836f,		/* position */
	0.88043f,								/* size     */
	0.0335795f,								/* density  */
	-3.35129f,	0.528776f,	0.506102f,		/* position */
	0.826127f,								/* size     */
	0.0259279f,								/* density  */
	-2.86947f,	0.762446f,	2.76486f,		/* position */
	0.63098f,								/* size     */
	0.0867354f,								/* density  */
	-2.98474f,	1.10342f,	-2.44455f,		/* position */
	0.533225f,								/* size     */
	0.0309305f,								/* density  */
	-3.40034f,	1.46051f,	-4.84652f,		/* position */
	0.321598f,								/* size     */
	0.0655336f,								/* density  */
	-3.31899f,	1.66309f,	-2.5185f,		/* position */
	0.605935f,								/* size     */
	0.051793f,								/* density  */
	-2.69323f,	0.175089f,	0.258144f,		/* position */
	0.538547f,								/* size     */
	0.0259279f,								/* density  */
	-2.94646f,	0.453521f,	-3.09544f,		/* position */
	0.59472f,								/* size     */
	0.0999512f,								/* density  */
	-3.13791f,	0.487908f,	1.02054f,		/* position */
	0.796009f,								/* size     */
	0.0289773f,								/* density  */
	-3.10077f,	0.630826f,	-2.90874f,		/* position */
	0.550487f,								/* size     */
	0.0217505f,								/* density  */
	-2.90322f,	1.22678f,	-0.932216f,		/* position */
	0.568302f,								/* size     */
	0.0523106f,								/* density  */
	-2.69068f,	1.46502f,	-2.64166f,		/* position */
	0.396731f,								/* size     */
	0.021128f,								/* density  */
	-2.84361f,	1.46436f,	-4.90683f,		/* position */
	0.782123f,								/* size     */
	0.0769353f,								/* density  */
	-3.22349f,	1.62734f,	0.443544f,		/* position */
	0.72656f,								/* size     */
	0.0537413f,								/* density  */
	-3.03854f,	0.172381f,	3.4043f,		/* position */
	0.349237f,								/* size     */
	0.0777142f,								/* density  */
	-2.9577f,	0.227875f,	3.57172f,		/* position */
	0.886763f,								/* size     */
	0.0209741f,								/* density  */
	-2.97531f,	0.465983f,	0.327797f,		/* position */
	0.60029f,								/* size     */
	0.0873946f,								/* density  */
	-3.08782f,	0.68365f,	-4.00854f,		/* position */
	0.936527f,								/* size     */
	0.0651942f,								/* density  */
	-2.7555f,	1.001f,	-2.73635f,			/* position */
	0.796791f,								/* size     */
	0.0256008f,								/* density  */
	-2.59875f,	1.1333f,	4.86522f,		/* position */
	0.75889f,								/* size     */
	0.0521323f,								/* density  */
	-2.5507f,	1.38937f,	-5.01668f,		/* position */
	0.391467f,								/* size     */
	0.082353f,								/* density  */
	-2.69972f,	1.64312f,	-0.0965577f,	/* position */
	0.566509f,								/* size     */
	0.0920872f,								/* density  */
	-2.71863f,	1.67006f,	-0.165735f,		/* position */
	0.717805f,								/* size     */
	0.0712589f,								/* density  */
	-2.90634f,	0.0716069f,	-1.44933f,		/* position */
	0.629244f,								/* size     */
	0.0506357f,								/* density  */
	-2.8725f,	0.329259f,	-1.95754f,		/* position */
	0.443825f,								/* size     */
	0.0883615f,								/* density  */
	-2.35304f,	0.697484f,	3.89818f,		/* position */
	0.569599f,								/* size     */
	0.0232179f,								/* density  */
	-2.77086f,	0.937909f,	4.92177f,		/* position */
	0.493341f,								/* size     */
	0.0589611f,								/* density  */
	-2.93474f,	1.25484f,	-0.0780559f,	/* position */
	0.568646f,								/* size     */
	0.0551134f,								/* density  */
	-2.78707f,	1.42929f,	-4.77343f,		/* position */
	0.601987f,								/* size     */
	0.0694449f,								/* density  */
	-2.63761f,	1.55335f,	-2.73303f,		/* position */
	0.360147f,								/* size     */
	0.0925071f,								/* density  */
	-2.57524f,	-0.0220487f,	3.42467f,	/* position */
	0.935821f,								/* size     */
	0.071315f,								/* density  */
	-2.75818f,	0.502936f,	3.07747f,		/* position */
	0.783591f,								/* size     */
	0.074865f,								/* density  */
	-2.19358f,	0.787436f,	3.71412f,		/* position */
	0.777411f,								/* size     */
	0.0455696f,								/* density  */
	-2.47058f,	1.17906f,	4.65574f,		/* position */
	0.506025f,								/* size     */
	0.0367119f,								/* density  */
	-2.45113f,	0.0148949f,	3.33083f,		/* position */
	0.786014f,								/* size     */
	0.0497665f,								/* density  */
	-2.15224f,	0.183941f,	-1.99829f,		/* position */
	0.825764f,								/* size     */
	0.0803388f,								/* density  */
	-2.35282f,	0.774185f,	4.19646f,		/* position */
	0.336972f,								/* size     */
	0.0949705f,								/* density  */
	-2.05202f,	1.31503f,	4.32707f,		/* position */
	0.525824f,								/* size     */
	0.0801605f,								/* density  */
	-2.22795f,	0.155236f,	-1.60439f,		/* position */
	0.856435f,								/* size     */
	0.0997559f,								/* density  */
	-1.87647f,	0.638231f,	3.93821f,		/* position */
	0.653563f,								/* size     */
	0.0720182f,								/* density  */
	-2.09656f,	0.891495f,	3.37479f,		/* position */
	0.913581f,								/* size     */
	0.0632704f,								/* density  */
	-1.98084f,	1.28128f,	4.97508f,		/* position */
	0.452904f,								/* size     */
	0.0478231f,								/* density  */
	-1.75964f,	0.367886f,	3.42061f,		/* position */
	0.841901f,								/* size     */
	0.0954125f,								/* density  */
	-1.93322f,	0.684508f,	3.31789f,		/* position */
	0.896205f,								/* size     */
	0.076657f,								/* density  */
	-2.33728f,	1.0941f,	3.71145f,		/* position */
	0.312595f,								/* size     */
	0.0910813f,								/* density  */
	-2.19604f,	1.61406f,	3.51825f,		/* position */
	0.700161f,								/* size     */
	0.0275076f,								/* density  */
	-1.94427f,	0.715067f,	3.03316f,		/* position */
	0.413078f,								/* size     */
	0.0891574f,								/* density  */
	-1.59935f,	0.873998f,	-4.07305f,		/* position */
	0.631781f,								/* size     */
	0.0300076f,								/* density  */
	-2.15172f,	1.14668f,	0.854661f,		/* position */
	0.632925f,								/* size     */
	0.0464583f,								/* density  */
	-1.5959f,	1.39417f,	2.04068f,		/* position */
	0.760798f,								/* size     */
	0.0637342f,								/* density  */
	-1.64545f,	1.56987f,	3.03248f,		/* position */
	0.389903f,								/* size     */
	0.0271657f,								/* density  */
	-1.88336f,	1.80493f,	3.43178f,		/* position */
	0.70493f,								/* size     */
	0.0424226f,								/* density  */
	-1.68988f,	0.156426f,	-2.72643f,		/* position */
	0.640669f,								/* size     */
	0.0654091f,								/* density  */
	-1.99551f,	0.708662f,	3.38686f,		/* position */
	0.570839f,								/* size     */
	0.0756487f,								/* density  */
	-1.79519f,	0.801381f,	-0.838863f,		/* position */
	0.364801f,								/* size     */
	0.0750383f,								/* density  */
	-1.9008f,	0.896813f,	-3.07374f,		/* position */
	0.914993f,								/* size     */
	0.0558165f,								/* density  */
	-1.62249f,	1.0756f,	2.02292f,		/* position */
	0.895365f,								/* size     */
	0.0949608f,								/* density  */
	-1.75536f,	1.13587f,	2.24909f,		/* position */
	0.872858f,								/* size     */
	0.09781f,								/* density  */
	-1.77293f,	1.31783f,	-3.821f,		/* position */
	0.476785f,								/* size     */
	0.0280789f,								/* density  */
	-1.76532f,	1.38182f,	2.52215f,		/* position */
	0.480695f,								/* size     */
	0.0757683f,								/* density  */
	-1.55705f,	1.45281f,	-0.860817f,		/* position */
	0.721009f,								/* size     */
	0.0238331f,								/* density  */
	-1.85953f,	1.60702f,	-1.4119f,		/* position */
	0.529792f,								/* size     */
	0.0440022f,								/* density  */
	-1.98063f,	1.68523f,	1.87327f,		/* position */
	0.391867f,								/* size     */
	0.0377129f,								/* density  */
	-1.75161f,	1.8228f,	-0.739359f,		/* position */
	0.869577f,								/* size     */
	0.079494f,								/* density  */
	-2.0195f,	1.88522f,	2.18201f,		/* position */
	0.884188f,								/* size     */
	0.0478549f,								/* density  */
	-1.3151f,	0.106681f,	0.808364f,		/* position */
	0.424503f,								/* size     */
	0.0578112f,								/* density  */
	-1.62141f,	0.265742f,	-2.56843f,		/* position */
	0.893897f,								/* size     */
	0.0987231f,								/* density  */
	-1.34772f,	0.655709f,	3.40142f,		/* position */
	0.567196f,								/* size     */
	0.0245851f,								/* density  */
	-1.58647f,	0.821982f,	2.36835f,		/* position */
	0.42704f,								/* size     */
	0.0432307f,								/* density  */
	-1.61201f,	0.963928f,	3.09117f,		/* position */
	0.761122f,								/* size     */
	0.0674258f,								/* density  */
	-1.59354f,	1.03431f,	-3.91066f,		/* position */
	0.808693f,								/* size     */
	0.0948509f,								/* density  */
	-1.51763f,	1.15287f,	-0.407093f,		/* position */
	0.440182f,								/* size     */
	0.0622669f,								/* density  */
	-1.3941f,	1.23526f,	3.50402f,		/* position */
	0.469956f,								/* size     */
	0.0874899f,								/* density  */
	-1.32607f,	1.32752f,	-4.14333f,		/* position */
	0.316715f,								/* size     */
	0.0590002f,								/* density  */
	-1.37642f,	1.58479f,	-3.98096f,		/* position */
	0.795551f,								/* size     */
	0.0205591f,								/* density  */
	-1.49573f,	1.66079f,	1.63926f,		/* position */
	0.518576f,								/* size     */
	0.06287f,								/* density  */
	-1.48995f,	1.77404f,	2.83354f,		/* position */
	0.888632f,								/* size     */
	0.0722208f,								/* density  */
	-1.35516f,	1.86375f,	1.85694f,		/* position */
	0.332814f,								/* size     */
	0.0773821f,								/* density  */
	-1.58988f,	1.87501f,	-0.807305f,		/* position */
	0.53519f,								/* size     */
	0.0773382f,								/* density  */
	-1.21498f,	0.0106719f,	4.82032f,		/* position */
	0.356161f,								/* size     */
	0.0502915f,								/* density  */
	-1.63925f,	0.400383f,	-3.24186f,		/* position */
	0.353509f,								/* size     */
	0.0419733f,								/* density  */
	-1.6769f,	0.582366f,	-4.88628f,		/* position */
	0.352174f,								/* size     */
	0.0620325f,								/* density  */
	-1.69636f,	0.828098f,	-4.37047f,		/* position */
	0.873735f,								/* size     */
	0.0723063f,								/* density  */
	-1.48425f,	0.822769f,	1.96135f,		/* position */
	0.755266f,								/* size     */
	0.0580676f,								/* density  */
	-1.10518f,	0.985052f,	-4.17401f,		/* position */
	0.392916f,								/* size     */
	0.0350493f,								/* density  */
	-1.5866f,	1.07916f,	-2.67203f,		/* position */
	0.450482f,								/* size     */
	0.0917649f,								/* density  */
	-1.10481f,	1.34007f,	-4.29431f,		/* position */
	0.41365f,								/* size     */
	0.0922459f,								/* density  */
	-1.51573f,	1.45088f,	3.31894f,		/* position */
	0.842072f,								/* size     */
	0.0525156f,								/* density  */
	-1.11544f,	1.56007f,	2.62276f,		/* position */
	0.466161f,								/* size     */
	0.0248146f,								/* density  */
	-1.12181f,	1.67913f,	2.11591f,		/* position */
	0.844495f,								/* size     */
	0.0231568f,								/* density  */
	-1.2901f,	1.74412f,	-1.17344f,		/* position */
	0.750422f,								/* size     */
	0.0765838f,								/* density  */
	-1.68539f,	1.85861f,	2.91025f,		/* position */
	0.776133f,								/* size     */
	0.0753581f,								/* density  */
	-1.23547f,	1.86492f,	3.57431f,		/* position */
	0.705998f,								/* size     */
	0.0520786f,								/* density  */
	-1.10127f,	1.93886f,	1.77561f,		/* position */
	0.789466f,								/* size     */
	0.0545836f,								/* density  */
	-1.44111f,	0.183538f,	0.664665f,		/* position */
	0.837457f,								/* size     */
	0.0906467f,								/* density  */
	-1.22289f,	0.470141f,	-2.65364f,		/* position */
	0.806766f,								/* size     */
	0.0415754f,								/* density  */
	-0.992014f,	0.641874f,	-3.28182f,		/* position */
	0.636874f,								/* size     */
	0.0607092f,								/* density  */
	-1.37823f,	0.898029f,	3.38523f,		/* position */
	0.855195f,								/* size     */
	0.0215992f,								/* density  */
	-1.2227f,	1.14061f,	-2.67455f,		/* position */
	0.476423f,								/* size     */
	0.0287088f,								/* density  */
	-1.20221f,	1.33034f,	-4.42894f,		/* position */
	0.7249f,								/* size     */
	0.0871163f,								/* density  */
	-1.23301f,	1.63572f,	3.37433f,		/* position */
	0.881251f,								/* size     */
	0.0818207f,								/* density  */
	-1.54013f,	1.8282f,	3.52799f,		/* position */
	0.555675f,								/* size     */
	0.0798505f,								/* density  */
	-1.39305f,	1.93929f,	2.16531f,		/* position */
	0.882681f,								/* size     */
	0.0729582f,								/* density  */
	-1.07356f,	0.117856f,	0.270332f,		/* position */
	0.673877f,								/* size     */
	0.0968456f,								/* density  */
	-1.38374f,	0.390339f,	-2.41919f,		/* position */
	0.687706f,								/* size     */
	0.0874679f,								/* density  */
	-1.30016f,	0.66217f,	-2.814f,		/* position */
	0.756106f,								/* size     */
	0.0558849f,								/* density  */
	-1.13963f,	0.758956f,	-4.42433f,		/* position */
	0.661059f,								/* size     */
	0.0581945f,								/* density  */
	-1.28523f,	0.808412f,	-1.96396f,		/* position */
	0.61593f,								/* size     */
	0.0924802f,								/* density  */
	-1.0019f,	0.944547f,	3.57744f,		/* position */
	0.340711f,								/* size     */
	0.0661f,								/* density  */
	-1.02019f,	1.20872f,	3.66432f,		/* position */
	0.326214f,								/* size     */
	0.0575793f,								/* density  */
	-1.23682f,	1.46386f,	3.14239f,		/* position */
	0.335465f,								/* size     */
	0.0219752f,								/* density  */
	-1.13872f,	0.168094f,	0.769057f,		/* position */
	0.381663f,								/* size     */
	0.0418635f,								/* density  */
	-0.979778f,	0.56274f,	-4.92779f,		/* position */
	0.646125f,								/* size     */
	0.0858907f,								/* density  */
	-1.20178f,	0.746507f,	-2.01089f,		/* position */
	0.736002f,								/* size     */
	0.0261428f,								/* density  */
	-0.770268f,	1.0113f,	-1.85417f,		/* position */
	0.678035f,								/* size     */
	0.0956249f,								/* density  */
	-0.959311f,	1.4246f,	3.59112f,		/* position */
	0.823132f,								/* size     */
	0.0278152f,								/* density  */
	-1.15862f,	1.85909f,	3.84901f,		/* position */
	0.695202f,								/* size     */
	0.0358525f,								/* density  */
	-1.07964f,	0.28846f,	-2.22244f,		/* position */
	0.397246f,								/* size     */
	0.0225513f,								/* density  */
	-0.952449f,	0.690702f,	-4.80902f,		/* position */
	0.471082f,								/* size     */
	0.0659267f,								/* density  */
	-1.0541f,	1.02029f,	-1.71362f,		/* position */
	0.550506f,								/* size     */
	0.0615857f,								/* density  */
	-0.994088f,	1.42298f,	3.70763f,		/* position */
	0.619535f,								/* size     */
	0.0676553f,								/* density  */
	-0.910796f,	0.344309f,	-2.70892f,		/* position */
	0.802665f,								/* size     */
	0.091738f,								/* density  */
	-0.727304f,	0.603639f,	-1.67367f,		/* position */
	0.896338f,								/* size     */
	0.0447151f,								/* density  */
	-0.608034f,	1.14497f,	-2.63391f,		/* position */
	0.738462f,								/* size     */
	0.0709952f,								/* density  */
	-0.717295f,	0.00896577f,	4.14258f,	/* position */
	0.435928f,								/* size     */
	0.0501352f,								/* density  */
	-0.291828f,	0.510132f,	-2.3483f,		/* position */
	0.333615f,								/* size     */
	0.0603113f,								/* density  */
	-0.227034f,	0.967736f,	-2.3275f,		/* position */
	0.683262f,								/* size     */
	0.0382427f,								/* density  */
	-0.663372f,	1.51903f,	-2.71566f,		/* position */
	0.907458f,								/* size     */
	0.0350713f,								/* density  */
	-0.120014f,	0.668194f,	-2.10147f,		/* position */
	0.728467f,								/* size     */
	0.0610852f,								/* density  */
	-0.547941f,	1.35536f,	-2.70845f,		/* position */
	0.91566f,								/* size     */
	0.0689615f,								/* density  */
	-0.160432f,	1.59424f,	-2.38326f,		/* position */
	0.434231f,								/* size     */
	0.0719034f,								/* density  */
	-0.396459f,	0.289757f,	-2.24537f,		/* position */
	0.576428f,								/* size     */
	0.052899f,								/* density  */
	0.120238f,	1.23235f,	-2.08861f,		/* position */
	0.777621f,								/* size     */
	0.0714054f,								/* density  */
	-0.0249918f,	1.43294f,	-3.30865f,	/* position */
	0.630808f,								/* size     */
	0.0908127f,								/* density  */
	0.020805f,	1.71676f,	3.5344f,		/* position */
	0.585526f,								/* size     */
	0.0890255f,								/* density  */
	-0.0543277f,	1.88861f,	3.39787f,	/* position */
	0.331193f,								/* size     */
	0.0843818f,								/* density  */
	-0.121759f,	0.429844f,	2.5878f,		/* position */
	0.593823f,								/* size     */
	0.0688028f,								/* density  */
	0.269145f,	0.730001f,	-2.07796f,		/* position */
	0.728963f,								/* size     */
	0.0713248f,								/* density  */
	-0.248507f,	1.08123f,	4.45399f,		/* position */
	0.377104f,								/* size     */
	0.0730021f,								/* density  */
	-0.275019f,	1.24583f,	4.79516f,		/* position */
	0.643836f,								/* size     */
	0.0422517f,								/* density  */
	-0.286082f,	1.50441f,	-4.74222f,		/* position */
	0.933285f,								/* size     */
	0.0417682f,								/* density  */
	-0.0577086f,	1.69388f,	-2.87299f,	/* position */
	0.491567f,								/* size     */
	0.0565831f,								/* density  */
	0.177112f,	1.89456f,	3.73068f,		/* position */
	0.907363f,								/* size     */
	0.0674917f,								/* density  */
	0.27326f,	0.0367891f,	1.09181f,		/* position */
	0.829255f,								/* size     */
	0.0997119f,								/* density  */
	0.166655f,	0.280532f,	2.90886f,		/* position */
	0.386584f,								/* size     */
	0.0381085f,								/* density  */
	0.353638f,	0.415597f,	-2.39593f,		/* position */
	0.628443f,								/* size     */
	0.0588366f,								/* density  */
	0.359665f,	0.565996f,	-0.795994f,		/* position */
	0.919017f,								/* size     */
	0.0558873f,								/* density  */
	0.135278f,	0.67111f,	3.96928f,		/* position */
	0.367891f,								/* size     */
	0.0255959f,								/* density  */
	0.200759f,	0.875568f,	4.01982f,		/* position */
	0.699189f,								/* size     */
	0.0762151f,								/* density  */
	0.0505701f,	1.20032f,	0.761465f,		/* position */
	0.706971f,								/* size     */
	0.0564562f,								/* density  */
	0.430926f,	1.43047f,	-2.64227f,		/* position */
	0.469842f,								/* size     */
	0.0959227f,								/* density  */
	0.442218f,	1.66298f,	-2.51208f,		/* position */
	0.728486f,								/* size     */
	0.0901389f,								/* density  */
	0.427397f,	1.89682f,	-3.19521f,		/* position */
	0.709641f,								/* size     */
	0.072172f,								/* density  */
	0.149216f,	0.0677501f,	-0.019179f,		/* position */
	0.778747f,								/* size     */
	0.0624598f,								/* density  */
	0.00478759f,	0.202099f,	-0.786066f,	/* position */
	0.317764f,								/* size     */
	0.0822236f,								/* density  */
	0.623341f,	0.367895f,	-0.763077f,		/* position */
	0.559471f,								/* size     */
	0.0394562f,								/* density  */
	0.128159f,	0.400952f,	3.95414f,		/* position */
	0.604867f,								/* size     */
	0.0931663f,								/* density  */
	0.119804f,	0.571257f,	-1.92436f,		/* position */
	0.590428f,								/* size     */
	0.0631947f,								/* density  */
	0.480647f,	0.718816f,	4.50123f,		/* position */
	0.596437f,								/* size     */
	0.0995239f,								/* density  */
	0.443644f,	0.965614f,	-0.797878f,		/* position */
	0.500837f,								/* size     */
	0.0386798f,								/* density  */
	0.483013f,	1.13183f,	0.575241f,		/* position */
	0.734514f,								/* size     */
	0.0917502f,								/* density  */
	0.132965f,	1.27781f,	-3.34367f,		/* position */
	0.59205f,								/* size     */
	0.0970898f,								/* density  */
	0.101417f,	1.25573f,	4.30568f,		/* position */
	0.737337f,								/* size     */
	0.0551939f,								/* density  */
	0.410436f,	1.48498f,	-2.97465f,		/* position */
	0.560997f,								/* size     */
	0.077636f,								/* density  */
	0.0336467f,	1.52632f,	1.44861f,		/* position */
	0.50036f,								/* size     */
	0.0863424f,								/* density  */
	0.15904f,	1.67962f,	3.90819f,		/* position */
	0.533702f,								/* size     */
	0.0586657f,								/* density  */
	0.554807f,	1.84315f,	0.76735f,		/* position */
	0.72696f,								/* size     */
	0.0249953f,								/* density  */
	0.28201f,	1.88629f,	3.17301f,		/* position */
	0.929661f,								/* size     */
	0.052042f,								/* density  */
	0.292782f,	0.108645f,	-0.412253f,		/* position */
	0.856893f,								/* size     */
	0.08425f,								/* density  */
	0.426339f,	0.22908f,	-1.9582f,		/* position */
	0.531013f,								/* size     */
	0.0814057f,								/* density  */
	0.477305f,	0.326232f,	2.08092f,		/* position */
	0.937061f,								/* size     */
	0.095576f,								/* density  */
	0.715006f,	0.369005f,	0.134324f,		/* position */
	0.483137f,								/* size     */
	0.0268264f,								/* density  */
	0.466871f,	0.617494f,	-0.849216f,		/* position */
	0.457081f,								/* size     */
	0.0620106f,								/* density  */
	0.649772f,	0.82129f,	4.45505f,		/* position */
	0.892829f,								/* size     */
	0.0669008f,								/* density  */
	0.18633f,	0.965146f,	4.30538f,		/* position */
	0.488268f,								/* size     */
	0.02438f,								/* density  */
	0.319677f,	1.28091f,	0.184136f,		/* position */
	0.725835f,								/* size     */
	0.0573083f,								/* density  */
	0.392997f,	1.35565f,	-3.10188f,		/* position */
	0.417751f,								/* size     */
	0.0771233f,								/* density  */
	0.667054f,	1.50788f,	3.18795f,		/* position */
	0.546863f,								/* size     */
	0.0802655f,								/* density  */
	0.713919f,	1.57206f,	1.52495f,		/* position */
	0.896777f,								/* size     */
	0.0355254f,								/* density  */
	0.563653f,	1.73541f,	0.0730489f,		/* position */
	0.343648f,								/* size     */
	0.0277932f,								/* density  */
	0.648132f,	1.73017f,	1.10299f,		/* position */
	0.750784f,								/* size     */
	0.0498178f,								/* density  */
	0.523292f,	1.89738f,	-0.150213f,		/* position */
	0.796199f,								/* size     */
	0.0992993f,								/* density  */
	0.475526f,	0.00417436f,	-2.67435f,	/* position */
	0.385115f,								/* size     */
	0.070734f,								/* density  */
	0.381701f,	0.0943146f,	-4.48186f,		/* position */
	0.610075f,								/* size     */
	0.0406916f,								/* density  */
	0.819527f,	0.221876f,	-3.94357f,		/* position */
	0.630331f,								/* size     */
	0.0927952f,								/* density  */
	0.313644f,	0.403178f,	-2.06538f,		/* position */
	0.566128f,								/* size     */
	0.0828852f,								/* density  */
	0.732568f,	0.673275f,	0.282368f,		/* position */
	0.88127f,								/* size     */
	0.078703f,								/* density  */
	0.854699f,	0.849481f,	0.115818f,		/* position */
	0.763411f,								/* size     */
	0.0852266f,								/* density  */
	0.458417f,	1.06477f,	4.05585f,		/* position */
	0.688393f,								/* size     */
	0.0747136f,								/* density  */
	0.699437f,	1.28733f,	0.411661f,		/* position */
	0.839364f,								/* size     */
	0.0292776f,								/* density  */
	0.808159f,	1.43838f,	3.81773f,		/* position */
	0.45134f,								/* size     */
	0.034705f,								/* density  */
	0.705273f,	1.52827f,	-4.84069f,		/* position */
	0.581845f,								/* size     */
	0.0945775f,								/* density  */
	0.631609f,	1.61865f,	3.62535f,		/* position */
	0.893611f,								/* size     */
	0.0950023f,								/* density  */
	0.365202f,	1.63616f,	4.12992f,		/* position */
	0.713036f,								/* size     */
	0.0767351f,								/* density  */
	0.777984f,	1.79715f,	2.95918f,		/* position */
	0.872171f,								/* size     */
	0.0376543f,								/* density  */
	0.803409f,	1.858f,	1.31941f,			/* position */
	0.634337f,								/* size     */
	0.0670742f,								/* density  */
	0.474172f,	1.88685f,	1.42873f,		/* position */
	0.426086f,								/* size     */
	0.0906418f,								/* density  */
	0.760793f,	0.0470471f,	0.957466f,		/* position */
	0.771537f,								/* size     */
	0.0332499f,								/* density  */
	0.742024f,	0.308178f,	0.746716f,		/* position */
	0.891207f,								/* size     */
	0.0913987f,								/* density  */
	0.898908f,	0.342366f,	1.25158f,		/* position */
	0.933494f,								/* size     */
	0.0670962f,								/* density  */
	0.982739f,	0.56017f,	0.430034f,		/* position */
	0.410598f,								/* size     */
	0.0250221f,								/* density  */
	0.89784f,	0.842005f,	-0.714004f,		/* position */
	0.732892f,								/* size     */
	0.0775335f,								/* density  */
	0.653044f,	1.0489f,	-4.71576f,		/* position */
	0.896567f,								/* size     */
	0.0439509f,								/* density  */
	0.720947f,	1.26882f,	-4.74788f,		/* position */
	0.599698f,								/* size     */
	0.0566466f,								/* density  */
	0.931392f,	1.32742f,	4.37584f,		/* position */
	0.831143f,								/* size     */
	0.0458138f,								/* density  */
	0.869153f,	1.43905f,	-0.187984f,		/* position */
	0.702698f,								/* size     */
	0.0373077f,								/* density  */
	0.614648f,	1.54867f,	-2.64509f,		/* position */
	0.358507f,								/* size     */
	0.0513901f,								/* density  */
	1.0902f,	1.58246f,	3.60958f,		/* position */
	0.57164f,								/* size     */
	0.0658144f,								/* density  */
	0.516168f,	1.76165f,	1.21309f,		/* position */
	0.479017f,								/* size     */
	0.0984252f,								/* density  */
	0.696513f,	1.87526f,	1.36157f,		/* position */
	0.655414f,								/* size     */
	0.0389703f,								/* density  */
	0.836856f,	0.177019f,	-4.48239f,		/* position */
	0.754866f,								/* size     */
	0.0666274f,								/* density  */
	1.14517f,	0.455376f,	0.934257f,		/* position */
	0.633993f,								/* size     */
	0.0959325f,								/* density  */
	0.832068f,	0.714993f,	-4.78694f,		/* position */
	0.373384f,								/* size     */
	0.0223951f,								/* density  */
	1.16989f,	0.970504f,	4.54938f,		/* position */
	0.701115f,								/* size     */
	0.0234425f,								/* density  */
	0.786348f,	1.14865f,	2.43388f,		/* position */
	0.420726f,								/* size     */
	0.0591784f,								/* density  */
	0.982467f,	1.24628f,	0.296735f,		/* position */
	0.398638f,								/* size     */
	0.0435285f,								/* density  */
	0.782113f,	1.39333f,	4.48501f,		/* position */
	0.918311f,								/* size     */
	0.0491806f,								/* density  */
	0.65239f,	1.421f,	4.80079f,			/* position */
	0.656081f,								/* size     */
	0.0618372f,								/* density  */
	1.07835f,	1.65831f,	1.59289f,		/* position */
	0.520503f,								/* size     */
	0.0237599f,								/* density  */
	0.814615f,	1.72717f,	1.32106f,		/* position */
	0.791145f,								/* size     */
	0.0614393f,								/* density  */
	1.40198f,	0.1514f,	0.639034f,		/* position */
	0.831753f,								/* size     */
	0.081186f,								/* density  */
	1.35155f,	0.390167f,	-0.874737f,		/* position */
	0.458817f,								/* size     */
	0.0564415f,								/* density  */
	0.864031f,	0.39238f,	0.513121f,		/* position */
	0.362283f,								/* size     */
	0.072902f,								/* density  */
	0.976435f,	0.607498f,	0.703223f,		/* position */
	0.639086f,								/* size     */
	0.0599207f,								/* density  */
	1.28461f,	0.743169f,	4.77374f,		/* position */
	0.649005f,								/* size     */
	0.0563512f,								/* density  */
	1.36989f,	1.08408f,	-2.20187f,		/* position */
	0.416568f,								/* size     */
	0.0608411f,								/* density  */
	1.14824f,	1.14954f,	2.859f,			/* position */
	0.922222f,								/* size     */
	0.0768426f,								/* density  */
	1.32093f,	1.30238f,	4.56559f,		/* position */
	0.735258f,								/* size     */
	0.0931053f,								/* density  */
	1.28204f,	1.48096f,	4.90182f,		/* position */
	0.745844f,								/* size     */
	0.0931394f,								/* density  */
	0.986773f,	1.6075f,	4.63797f,		/* position */
	0.572499f,								/* size     */
	0.058153f,								/* density  */
	1.21002f,	1.81657f,	4.82913f,		/* position */
	0.693009f,								/* size     */
	0.0658266f,								/* density  */
	1.21877f,	0.451816f,	-4.48891f,		/* position */
	0.436024f,								/* size     */
	0.0880416f,								/* density  */
	1.47024f,	0.677085f,	-4.4963f,		/* position */
	0.644942f,								/* size     */
	0.0801996f,								/* density  */
	1.25699f,	0.806906f,	4.31693f,		/* position */
	0.651713f,								/* size     */
	0.0705826f,								/* density  */
	1.24557f,	0.93065f,	-4.55346f,		/* position */
	0.807186f,								/* size     */
	0.0693057f,								/* density  */
	1.08014f,	1.16424f,	-2.06838f,		/* position */
	0.903624f,								/* size     */
	0.0732023f,								/* density  */
	1.37718f,	1.19733f,	4.579f,			/* position */
	0.465093f,								/* size     */
	0.0732804f,								/* density  */
	1.27042f,	1.32137f,	-2.47152f,		/* position */
	0.681946f,								/* size     */
	0.0866622f,								/* density  */
	1.03333f,	1.44561f,	2.05049f,		/* position */
	0.862882f,								/* size     */
	0.0233033f,								/* density  */
	1.33994f,	1.46533f,	4.5646f,		/* position */
	0.576523f,								/* size     */
	0.0236427f,								/* density  */
	1.46051f,	1.77167f,	3.03443f,		/* position */
	0.361768f,								/* size     */
	0.0257057f,								/* density  */
	1.24247f,	0.642771f,	2.4875f,		/* position */
	0.448098f,								/* size     */
	0.0639369f,								/* density  */
	1.32823f,	0.801461f,	2.12708f,		/* position */
	0.421794f,								/* size     */
	0.0976025f,								/* density  */
	1.66109f,	0.967442f,	-4.41277f,		/* position */
	0.698731f,								/* size     */
	0.0722477f,								/* density  */
	1.28234f,	1.05924f,	4.91752f,		/* position */
	0.340711f,								/* size     */
	0.0729215f,								/* density  */
	1.6778f,	1.19896f,	3.36032f,		/* position */
	0.440716f,								/* size     */
	0.0849678f,								/* density  */
	1.58508f,	1.30198f,	4.17462f,		/* position */
	0.458092f,								/* size     */
	0.0306082f,								/* density  */
	1.09453f,	1.46263f,	1.92924f,		/* position */
	0.661308f,								/* size     */
	0.0606165f,								/* density  */
	1.61461f,	1.60631f,	3.24126f,		/* position */
	0.414394f,								/* size     */
	0.0478939f,								/* density  */
	1.81368f,	0.580503f,	-2.25614f,		/* position */
	0.812317f,								/* size     */
	0.0543516f,								/* density  */
	1.59616f,	0.812901f,	3.03826f,		/* position */
	0.473771f,								/* size     */
	0.090969f,								/* density  */
	1.2574f,	1.08905f,	2.60776f,		/* position */
	0.432991f,								/* size     */
	0.0339433f,								/* density  */
	1.42882f,	1.22634f,	3.76596f,		/* position */
	0.909976f,								/* size     */
	0.0293875f,								/* density  */
	1.38203f,	1.38774f,	3.14243f,		/* position */
	0.840184f,								/* size     */
	0.0957884f,								/* density  */
	1.78365f,	1.41488f,	-4.53691f,		/* position */
	0.60235f,								/* size     */
	0.0205713f,								/* density  */
	1.74329f,	1.57103f,	-4.99637f,		/* position */
	0.372259f,								/* size     */
	0.0552159f,								/* density  */
	1.26122f,	1.75402f,	4.75614f,		/* position */
	0.755495f,								/* size     */
	0.0469979f,								/* density  */
	1.85438f,	0.678094f,	2.23471f,		/* position */
	0.65177f,								/* size     */
	0.0325541f,								/* density  */
	1.9436f,	0.877183f,	1.85831f,		/* position */
	0.534598f,								/* size     */
	0.0880392f,								/* density  */
	2.02906f,	1.2186f,	2.69087f,		/* position */
	0.894202f,								/* size     */
	0.056925f,								/* density  */
	1.42063f,	1.3741f,	3.32866f,		/* position */
	0.744242f,								/* size     */
	0.0783856f,								/* density  */
	1.4984f,	1.46503f,	-2.15364f,		/* position */
	0.86582f,								/* size     */
	0.0938939f,								/* density  */
	1.55289f,	1.47511f,	3.46818f,		/* position */
	0.717748f,								/* size     */
	0.0411115f,								/* density  */
	2.00573f,	1.66949f,	-5.26705f,		/* position */
	0.554931f,								/* size     */
	0.0987744f,								/* density  */
	1.98601f,	1.77094f,	3.48229f,		/* position */
	0.679199f,								/* size     */
	0.0649428f,								/* density  */
	2.09882f,	0.779063f,	2.26233f,		/* position */
	0.641299f,								/* size     */
	0.0844429f,								/* density  */
	2.1031f,	1.14247f,	-2.43087f,		/* position */
	0.891894f,								/* size     */
	0.0557506f,								/* density  */
	1.73874f,	1.291f,	3.97681f,			/* position */
	0.509554f,								/* size     */
	0.0647475f,								/* density  */
	1.73928f,	1.3984f,	-4.70282f,		/* position */
	0.36173f,								/* size     */
	0.0558507f,								/* density  */
	1.70596f,	1.57418f,	-2.55412f,		/* position */
	0.381682f,								/* size     */
	0.0496396f,								/* density  */
	1.61627f,	1.6853f,	3.79762f,		/* position */
	0.478769f,								/* size     */
	0.0458773f,								/* density  */
	2.2632f,	-0.0146632f,	4.19587f,	/* position */
	0.485559f,								/* size     */
	0.0971191f,								/* density  */
	2.00738f,	1.05629f,	-2.49417f,		/* position */
	0.836426f,								/* size     */
	0.0275906f,								/* density  */
	1.8981f,	1.36589f,	2.41961f,		/* position */
	0.423912f,								/* size     */
	0.0709342f,								/* density  */
	2.18523f,	1.47936f,	-2.46138f,		/* position */
	0.813519f,								/* size     */
	0.070109f,								/* density  */
	1.85324f,	1.65591f,	3.06229f,		/* position */
	0.604791f,								/* size     */
	0.0899802f,								/* density  */
	1.81513f,	1.86169f,	3.24858f,		/* position */
	0.769972f,								/* size     */
	0.0399371f,								/* density  */
	1.9619f,	0.000415815f,	1.13464f,	/* position */
	0.385573f,								/* size     */
	0.071298f,								/* density  */
	2.40192f,	0.486944f,	2.24828f,		/* position */
	0.770278f,								/* size     */
	0.0321976f,								/* density  */
	2.30554f,	1.24189f,	-2.87096f,		/* position */
	0.653125f,								/* size     */
	0.0937938f,								/* density  */
	2.44528f,	1.64326f,	-5.06168f,		/* position */
	0.69257f,								/* size     */
	0.0637098f,								/* density  */
	2.19398f,	1.71358f,	3.35816f,		/* position */
	0.487123f,								/* size     */
	0.0463851f,								/* density  */
	2.49168f,	1.99904f,	3.29079f,		/* position */
	0.925445f,								/* size     */
	0.0616028f,								/* density  */
	2.41269f,	0.0251091f,	-1.74337f,		/* position */
	0.470567f,								/* size     */
	0.073195f,								/* density  */
	2.51241f,	0.0426296f,	4.25876f,		/* position */
	0.924682f,								/* size     */
	0.0438435f,								/* density  */
	2.5682f,	0.241497f,	-0.113314f,		/* position */
	0.51417f,								/* size     */
	0.0902463f,								/* density  */
	2.12904f,	0.280755f,	-0.742739f,		/* position */
	0.860841f,								/* size     */
	0.0677871f,								/* density  */
	2.43936f,	1.20649f,	4.81843f,		/* position */
	0.583504f,								/* size     */
	0.0512265f,								/* density  */
	2.21524f,	1.47135f,	-4.57751f,		/* position */
	0.441631f,								/* size     */
	0.0302078f,								/* density  */
	2.53662f,	1.64695f,	3.35435f,		/* position */
	0.421756f,								/* size     */
	0.0862032f,								/* density  */
	2.53959f,	1.72693f,	3.05594f,		/* position */
	0.355245f,								/* size     */
	0.0521397f,								/* density  */
	2.34353f,	1.8565f,	-3.0936f,		/* position */
	0.53313f,								/* size     */
	0.0809394f,								/* density  */
	2.5475f,	0.0326024f,	1.19328f,		/* position */
	0.483041f,								/* size     */
	0.0602112f,								/* density  */
	2.2218f,	0.185321f,	0.40664f,		/* position */
	0.427116f,								/* size     */
	0.0842915f,								/* density  */
	2.65747f,	0.346758f,	-0.0787997f,	/* position */
	0.770869f,								/* size     */
	0.076386f,								/* density  */
	2.68339f,	0.555789f,	-0.790954f,		/* position */
	0.604257f,								/* size     */
	0.097373f,								/* density  */
	2.35138f,	0.914444f,	-4.65304f,		/* position */
	0.439667f,								/* size     */
	0.056776f,								/* density  */
	2.75493f,	1.2963f,	-4.71354f,		/* position */
	0.570153f,								/* size     */
	0.0971899f,								/* density  */
	2.49177f,	1.58967f,	2.589f,			/* position */
	0.472035f,								/* size     */
	0.0631458f,								/* density  */
	2.27707f,	1.67953f,	-4.77442f,		/* position */
	0.565422f,								/* size     */
	0.0708585f,								/* density  */
	2.73292f,	1.82766f,	-3.8467f,		/* position */
	0.535667f,								/* size     */
	0.0592199f,								/* density  */
	2.66147f,	1.83509f,	4.29991f,		/* position */
	0.641108f,								/* size     */
	0.0545567f,								/* density  */
	2.50455f,	1.9068f,	5.0358f,		/* position */
	0.448975f,								/* size     */
	0.0934812f,								/* density  */
	2.49264f,	0.0504967f,	-2.37119f,		/* position */
	0.535171f,								/* size     */
	0.08978f,								/* density  */
	2.84452f,	0.143498f,	1.34254f,		/* position */
	0.836827f,								/* size     */
	0.0805731f,								/* density  */
	2.52535f,	0.541381f,	0.246389f,		/* position */
	0.605401f,								/* size     */
	0.0599963f,								/* density  */
	2.43082f,	0.647923f,	4.66992f,		/* position */
	0.524985f,								/* size     */
	0.0238575f,								/* density  */
	2.80918f,	1.10498f,	-5.26806f,		/* position */
	0.393336f,								/* size     */
	0.0432893f,								/* density  */
	2.77673f,	1.3627f,	4.39498f,		/* position */
	0.445961f,								/* size     */
	0.0937083f,								/* density  */
	2.40442f,	1.61503f,	4.52995f,		/* position */
	0.53231f,								/* size     */
	0.0476449f,								/* density  */
	2.78316f,	1.76664f,	-4.73789f,		/* position */
	0.749926f,								/* size     */
	0.0467757f,								/* density  */
	2.75501f,	1.75717f,	-4.80841f,		/* position */
	0.922813f,								/* size     */
	0.0548839f,								/* density  */
	2.70341f,	1.93331f,	3.12117f,		/* position */
	0.608682f,								/* size     */
	0.0485141f,								/* density  */
	2.64109f,	0.123015f,	-0.774231f,		/* position */
	0.801597f,								/* size     */
	0.0306229f,								/* density  */
	2.9248f,	0.464972f,	-0.741476f,		/* position */
	0.432361f,								/* size     */
	0.0737126f,								/* density  */
	2.93085f,	0.595017f,	4.45779f,		/* position */
	0.91978f,								/* size     */
	0.0563585f,								/* density  */
	2.9701f,	0.994784f,	-0.661861f,		/* position */
	0.874861f,								/* size     */
	0.0736857f,								/* density  */
	2.93737f,	1.28809f,	1.64197f,		/* position */
	0.802932f,								/* size     */
	0.0862105f,								/* density  */
	2.93186f,	1.46955f,	1.51836f,		/* position */
	0.535533f,								/* size     */
	0.0258205f,								/* density  */
	2.91745f,	1.76668f,	1.58055f,		/* position */
	0.721105f,								/* size     */
	0.0827363f,								/* density  */
	2.95419f,	1.8104f,	-3.94005f,		/* position */
	0.700371f,								/* size     */
	0.0304007f,								/* density  */
	2.83822f,	1.88184f,	-3.22224f,		/* position */
	0.695374f,								/* size     */
	0.0208667f,								/* density  */
	2.8756f,	0.3908f,	5.11568f,		/* position */
	0.466351f,								/* size     */
	0.0340092f,								/* density  */
	3.02758f,	0.615754f,	-0.563629f,		/* position */
	0.701535f,								/* size     */
	0.0835347f,								/* density  */
	3.23658f,	1.24284f,	4.63657f,		/* position */
	0.476156f,								/* size     */
	0.0553697f,								/* density  */
	3.15265f,	1.46111f,	3.81071f,		/* position */
	0.394003f,								/* size     */
	0.0322147f,								/* density  */
	3.20192f,	1.51255f,	1.32325f,		/* position */
	0.757517f,								/* size     */
	0.0813422f,								/* density  */
	3.20083f,	1.71789f,	-4.89389f,		/* position */
	0.895652f,								/* size     */
	0.0204028f,								/* density  */
	2.86763f,	1.93147f,	1.60173f,		/* position */
	0.566013f,								/* size     */
	0.0805975f,								/* density  */
	3.00719f,	0.320485f,	4.24622f,		/* position */
	0.480295f,								/* size     */
	0.0577136f,								/* density  */
	3.22711f,	1.40252f,	1.49211f,		/* position */
	0.599031f,								/* size     */
	0.0416633f,								/* density  */
	3.20731f,	1.70616f,	4.22422f,		/* position */
	0.396655f,								/* size     */
	0.0857051f,								/* density  */
	3.24554f,	1.92106f,	1.37848f,		/* position */
	0.651866f,								/* size     */
	0.0329887f,								/* density  */
	3.05674f,	0.32698f,	2.07757f,		/* position */
	0.909213f,								/* size     */
	0.0463338f,								/* density  */
	3.41375f,	0.575382f,	4.33881f,		/* position */
	0.666095f,								/* size     */
	0.0392438f,								/* density  */
	3.28259f,	1.442f,	1.27408f,			/* position */
	0.420898f,								/* size     */
	0.0581921f,								/* density  */
	3.16107f,	2.00377f,	1.83428f,		/* position */
	0.32135f,								/* size     */
	0.0894577f,								/* density  */
	3.54911f,	0.257998f,	2.61707f,		/* position */
	0.353757f,								/* size     */
	0.0937278f,								/* density  */
	3.1502f,	0.460279f,	4.23563f,		/* position */
	0.49872f,								/* size     */
	0.0775384f,								/* density  */
	3.15174f,	1.14226f,	-2.03255f,		/* position */
	0.58381f,								/* size     */
	0.0776702f,								/* density  */
	3.67851f,	-0.0370933f,	1.72298f,	/* position */
	0.368692f,								/* size     */
	0.0855855f,								/* density  */
	3.68224f,	0.263697f,	2.24415f,		/* position */
	0.595426f,								/* size     */
	0.0255617f,								/* density  */
	3.36527f,	1.19306f,	-1.96577f,		/* position */
	0.798221f,								/* size     */
	0.0622083f,								/* density  */
	3.62298f,	0.0452933f,	2.19093f,		/* position */
	0.752806f,								/* size     */
	0.0422687f,								/* density  */
	3.58439f,	0.222647f,	4.4842f,		/* position */
	0.493933f,								/* size     */
	0.0902805f,								/* density  */
	3.82632f,	0.883068f,	-2.47013f,		/* position */
	0.362436f,								/* size     */
	0.0437776f,								/* density  */
	3.64194f,	1.68658f,	2.24015f,		/* position */
	0.568379f,								/* size     */
	0.0231813f,								/* density  */
	4.09547f,	0.284534f,	-4.88726f,		/* position */
	0.652648f,								/* size     */
	0.0658388f,								/* density  */
	3.94641f,	0.827709f,	-0.299177f,		/* position */
	0.524165f,								/* size     */
	0.071359f,								/* density  */
	3.66556f,	1.2061f,	-2.60306f,		/* position */
	0.571221f,								/* size     */
	0.0807831f,								/* density  */
	3.81507f,	1.73852f,	3.47637f,		/* position */
	0.724214f,								/* size     */
	0.0337211f,								/* density  */
	4.21529f,	-0.0232847f,	4.20107f,	/* position */
	0.927372f,								/* size     */
	0.0791156f,								/* density  */
	3.89639f,	0.346159f,	0.938263f,		/* position */
	0.590142f,								/* size     */
	0.0399054f,								/* density  */
	4.27158f,	0.50957f,	1.18236f,		/* position */
	0.890769f,								/* size     */
	0.0662783f,								/* density  */
	3.77417f,	0.667215f,	-0.271267f,		/* position */
	0.808559f,								/* size     */
	0.0605969f,								/* density  */
	4.22992f,	1.24759f,	-2.38339f,		/* position */
	0.72389f,								/* size     */
	0.0286673f,								/* density  */
	4.19998f,	1.72216f,	3.06122f,		/* position */
	0.652591f,								/* size     */
	0.093762f,								/* density  */
	4.03212f,	0.118821f,	4.29788f,		/* position */
	0.661079f,								/* size     */
	0.0757537f,								/* density  */
	4.3345f,	0.411857f,	-5.04516f,		/* position */
	0.461716f,								/* size     */
	0.091279f,								/* density  */
	3.97934f,	0.64675f,	-4.51989f,		/* position */
	0.800586f,								/* size     */
	0.0266408f,								/* density  */
	4.08606f,	0.806452f,	4.35707f,		/* position */
	0.841424f,								/* size     */
	0.0611707f,								/* density  */
	4.31943f,	1.32128f,	-2.35016f,		/* position */
	0.560806f,								/* size     */
	0.0884542f,								/* density  */
	4.24613f,	1.68508f,	-2.50567f,		/* position */
	0.607423f,								/* size     */
	0.0257057f,								/* density  */
	4.09886f,	0.122319f,	-1.52588f,		/* position */
	0.800605f,								/* size     */
	0.0415094f,								/* density  */
	4.54294f,	0.397444f,	3.72963f,		/* position */
	0.931911f,								/* size     */
	0.0529795f,								/* density  */
	4.5016f,	0.713195f,	-4.68239f,		/* position */
	0.598725f,								/* size     */
	0.0326518f,								/* density  */
	4.49827f,	1.14828f,	-4.44102f,		/* position */
	0.560158f,								/* size     */
	0.0645253f,								/* density  */
	4.31018f,	1.47991f,	-3.08395f,		/* position */
	0.530326f,								/* size     */
	0.0782952f,								/* density  */
	4.10887f,	1.90241f,	-2.60846f,		/* position */
	0.742353f,								/* size     */
	0.0300223f,								/* density  */
	4.66543f,	0.116523f,	4.23497f,		/* position */
	0.844419f,								/* size     */
	0.0216651f,								/* density  */
	4.8362f,	0.352918f,	4.7405f,		/* position */
	0.552108f,								/* size     */
	0.0264016f,								/* density  */
	4.22314f,	0.610307f,	-4.92478f,		/* position */
	0.437759f,								/* size     */
	0.0936351f,								/* density  */
	4.33419f,	0.855914f,	-4.45203f,		/* position */
	0.653087f,								/* size     */
	0.087712f,								/* density  */
	4.59535f,	1.40256f,	-4.1403f,		/* position */
	0.749983f,								/* size     */
	0.052794f,								/* density  */
	4.37409f,	1.91034f,	-1.33234f,		/* position */
	0.869253f,								/* size     */
	0.0564879f,								/* density  */
	4.44189f,	0.22021f,	4.75874f,		/* position */
	0.35555f,								/* size     */
	0.0429914f,								/* density  */
	4.81321f,	0.405155f,	1.95111f,		/* position */
	0.318966f,								/* size     */
	0.0324662f,								/* density  */
	4.68696f,	0.545463f,	2.06792f,		/* position */
	0.922794f,								/* size     */
	0.0287112f,								/* density  */
	4.81632f,	0.65729f,	0.424193f,		/* position */
	0.720513f,								/* size     */
	0.0700528f,								/* density  */
	4.46961f,	0.953193f,	0.610909f,		/* position */
	0.328637f,								/* size     */
	0.0429133f,								/* density  */
	4.77762f,	1.20055f,	-4.42618f,		/* position */
	0.671798f,								/* size     */
	0.0414216f,								/* density  */
	4.37559f,	1.62985f,	0.596737f,		/* position */
	0.395873f,								/* size     */
	0.0817988f,								/* density  */
	5.07942f,	0.0348292f,	-1.58961f,		/* position */
	0.460591f,								/* size     */
	0.0652821f,								/* density  */
	5.06296f,	0.308296f,	-1.97521f,		/* position */
	0.894774f,								/* size     */
	0.0521934f,								/* density  */
	4.80914f,	0.378085f,	-3.0895f,		/* position */
	0.386183f,								/* size     */
	0.0231715f,								/* density  */
	4.76222f,	0.439118f,	0.550625f,		/* position */
	0.339776f,								/* size     */
	0.0816254f,								/* density  */
	5.0716f,	0.575139f,	-4.55175f,		/* position */
	0.326157f,								/* size     */
	0.0806439f,								/* density  */
	4.78921f,	0.611226f,	0.777035f,		/* position */
	0.588559f,								/* size     */
	0.0385479f,								/* density  */
	5.0144f,	0.723274f,	0.618105f,		/* position */
	0.656043f,								/* size     */
	0.0338115f,								/* density  */
	5.13735f,	0.920027f,	2.5865f,		/* position */
	0.716317f,								/* size     */
	0.0618787f,								/* density  */
	5.01876f,	1.2181f,	-4.71839f,		/* position */
	0.515734f,								/* size     */
	0.0878488f,								/* density  */
	5.05024f,	1.45711f,	0.617075f,		/* position */
	0.474248f,								/* size     */
	0.0261769f,								/* density  */
	4.64844f,	1.59369f,	-4.27762f,		/* position */
	0.374319f,								/* size     */
	0.0973193f,								/* density  */
};

}
}
