/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif
#define _USE_MATH_DEFINES 1
#include <math.h>
#include "Vecalg.h"

namespace gputest{
namespace common{

vec3_t::vec3_t ( const vec4_t& _v ) :  x(_v.x), y(_v.y), z(_v.z) {}

void vec3_t::operator= ( const vec4_t& _v )
{
	x = _v.x ; y = _v.y ; z = _v.z ;
}

vec3_t operator* ( GLfloat _arg0, const vec3_t& _arg1 )
{
	return _arg1*_arg0 ;
}

vec4_t operator* ( GLfloat _arg0, const vec4_t& _arg1 )
{
	return _arg1*_arg0 ;
}

GLfloat mat4_t::minor ( int _i, int _j ) const
{
	mat3_t t ;
	int i, j, x, y ;
	for ( i = 0, x = 0 ; i < 4 ; i++ )
	{
		if ( i == _i ) continue ;
		for ( j = 0, y = 0 ; j < 4 ; j++ )
		{
			if ( j == _j ) continue ;

			t[x][y] = m[i][j] ;
			y++ ;
		}
		x++ ;
	}

	GLfloat res = t.det () ;

	return ( (_i+_j)&1 )? -res : res ;
}

mat4_t mat4_t::rotate ( GLfloat _th, GLfloat _x, GLfloat _y, GLfloat _z )
{
	mat4_t res ;
	GLfloat c = cosf(_th*(GLfloat)M_PI/180.f) ;
	GLfloat s = sinf(_th*(GLfloat)M_PI/180.f) ;

	vec3_t u( _x, _y, _z ) ;
	u /= u.norm () ;

	res[0][0] = (u[0]*u[0])*(1.f - c) + c;
	res[0][1] = (u[0]*u[1])*(1.f - c) - s*u[2]; 
	res[0][2] = (u[0]*u[2])*(1.f - c) + s*u[1];

	res[1][0] = (u[1]*u[0])*(1.f - c) + s*u[2];
	res[1][1] = (u[1]*u[1])*(1.f - c) + c;
	res[1][2] = (u[1]*u[2])*(1.f - c) - s*u[0];

	res[2][0] = (u[2]*u[0])*(1.f - c) - s*u[1];
	res[2][1] = (u[2]*u[1])*(1.f - c) + s*u[0];
	res[2][2] = (u[2]*u[2])*(1.f - c) + c;

	return res ;
}

mat4_t mat4_t::lookAt(GLfloat eyex, GLfloat eyey, GLfloat eyez, GLfloat centerx,
	GLfloat centery, GLfloat centerz, GLfloat upx, GLfloat upy, GLfloat upz)
{
    vec3_t forward, side, up;
    mat4_t m ;

    forward.x = centerx - eyex;
    forward.y = centery - eyey;
    forward.z = centerz - eyez;

	forward /= forward.norm () ;

    up.x = upx;
    up.y = upy;
    up.z = upz;

	side = forward ^ up ;

	side /= side.norm () ;

	up = side ^ forward ;

    m[0][0] = side[0];
    m[1][0] = side[1];
    m[2][0] = side[2];

    m[0][1] = up[0];
    m[1][1] = up[1];
    m[2][1] = up[2];

    m[0][2] = -forward[0];
    m[1][2] = -forward[1];
    m[2][2] = -forward[2];

	m = m.transpose () ;
	m = m * mat4_t::translate ( -eyex, -eyey, -eyez ) ;

	return m ;
}

mat4_t mat4_t::perspective (GLfloat fovy, GLfloat aspect, GLfloat znear, GLfloat zfar)
{
	GLfloat fov = fovy * (GLfloat)(3.14159265f/180.0f);
	GLfloat f = 1.0f/tan(fov/2.0f);

	mat4_t m ;
	
	m[0][0] = f/aspect;
	m[0][1] = 0.0f;
	m[0][2] = 0.0f;
	m[0][3] = 0.0f;

	m[1][0] = 0.0f;
	m[1][1] = f;
	m[1][2] = 0.0f;
	m[1][3] = 0.0f;

	m[2][0] = 0.0f;
	m[2][1] = 0.0f;
	m[2][2] = (zfar+znear)/(znear-zfar);
	m[2][3] = (2.0f*zfar*znear)/(znear-zfar);

	m[3][0] = 0.0f;
	m[3][1] = 0.0f;
	m[3][2] = -1.0f;
	m[3][3] = 0.0f;

	return m;
}

GLfloat vec3_t::norm() const
{
	return sqrtf ( (*this) * (*this) ) ;
}

}
}
