/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */
/* re-formed by Nintendo */
 
#ifndef DMP_UTIL_H_
#define DMP_UTIL_H_

namespace gputest{
namespace common{

// Load texture from file
void loadTexture(const char * _name, unsigned _target, int _level, bool& _useAlpha, bool _is2D = true, int *_width=0, unsigned _forceformat=0);

// Lighting lookup table utility
float z_schlick(float r, float t, bool normalize);
float a_schlick(float p, float w, bool normalize);
float gaussian(float _c, float m);
float beckmann(float _c, float m);
float beckmann2(float _c, float m);
float r_fresnel(float _c, float _m = 5.f, float _r0 = 1.f, float _r1 = 0.04f);
float nk_fresnel(float _c, float _n, float _k);

}
}

#endif
