/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */
/* re-formed by Nintendo */

#ifndef DMP_TGA_H
#define DMP_TGA_H
#include <nn/fs.h>

#ifdef WIN32
#   ifdef DMPIMG_EXPORTS
#   define IMAGE_API __declspec(dllexport)
#   else
#   define IMAGE_API __declspec(dllimport)
#   endif
#else
#   define IMAGE_API
#endif

namespace gputest{
namespace common{

/*
 *
 */
enum {
    IMAGE_TRUE  = 0,
    IMAGE_FALSE = 1
};

/*
 *
 */
enum {
    IMAGE_NONE = 0
};

/*
 * image format
 */

#define IMAGE_RGB                   0x1907
#define IMAGE_RGBA                  0x1908

#define IMAGE_BGR                   0x80E0
#define IMAGE_BGRA                  0x80E1

/*
#define IMAGE_RGB8                  0x8051
#define IMAGE_RGBA8                 0x8058
*/

/*
 * Data types
 */
#define IMAGE_BYTE                  0x1400
#define IMAGE_UNSIGNED_BYTE         0x1401
#define IMAGE_SHORT                 0x1402
#define IMAGE_UNSIGNED_SHORT        0x1403
#define IMAGE_INT                   0x1404
#define IMAGE_UNSIGNED_INT          0x1405
#define IMAGE_FLOAT                 0x1406

/*
 * Orientation
 */
#define IMAGE_LOWER_LEFT            0x8CA1
#define IMAGE_UPPER_LEFT            0x8CA2

/*
 * image file format
 */
enum {
    IMAGE_UNKNOWN                   = 0x0000,

    IMAGE_RAW32                     = 0xec01,
    IMAGE_RAW24,

    IMAGE_BMP                       = 0xec11,

    IMAGE_JPG                       = 0xec21,

    IMAGE_GIF                       = 0xec31,

    IMAGE_PNG                       = 0xec41,

    IMAGE_TGA32                     = 0xec51,
    IMAGE_TGA24,
    IMAGE_TGA32RLE                  = 0xec61,
    IMAGE_TGA24RLE
};

void *dmpLoadTGA(
    const char *filename,
    unsigned int *width,
    unsigned int *height,
    unsigned int *format,
    unsigned int *type,
    unsigned int *orientation);

unsigned int dmpSaveTGA(
    unsigned int fileformat,
    const char *filename,
    unsigned int width,
    unsigned int height,
    unsigned int format,
    unsigned int type,
    unsigned int orientation,
    const void *pixels);

}
}

#endif /* DMP_TGA_H */
