/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */
 
#ifndef DMP_LOADER_H_
#define DMP_LOADER_H_

namespace gputest{
namespace common{

typedef struct tga_dat_header_t
{
    unsigned        obj_num;
    unsigned        patch_num;
    unsigned        vtx_size;       // total byte size
    unsigned        nrm_size;
    unsigned        tex_size;
    unsigned        tgt_size;
    unsigned        wgt_size;
    unsigned        idx_size;
    unsigned        elm_size;
} dat_header_t;

typedef struct tag_dat_obj_t
{
    unsigned        vtx_offset;
    unsigned        vtx_size;       // byte size
    unsigned        nrm_offset;
    unsigned        nrm_size;
    unsigned        tex_offset;
    unsigned        tex_size;
    unsigned        tgt_offset;
    unsigned        tgt_size;
    unsigned        wgt_offset;
    unsigned        wgt_size;
    unsigned        idx_offset;
    unsigned        idx_size;
    unsigned        elm_offset;
    unsigned        elm_size;
    unsigned        patch_offset;
    unsigned        patch_size;
} dat_obj_t;

typedef struct tag_dat_patch_t
{
    unsigned        elm_offset;
    unsigned        elm_size;
    GLfloat         ambient[3];
    GLfloat         specular[3];
    GLfloat         diffuse[3];
    GLfloat         shininess;
} dat_patch_t;

typedef struct tag_dat_t
{
    GLuint          posVB;
    GLuint          normVB;
    GLuint          texVB;
    GLuint          tangVB;
    GLuint          wghtVB;
    GLuint          midxVB;
    GLuint          idxVB;
    dat_obj_t*      obj;
    dat_patch_t*    patch;
    int             obj_num;
} dat_t;

// Load texture from file
void loadDAT(const char* name, dat_t* dat);
void unloadDAT(dat_t* dat);

}
}

#endif  /* _LOADER_H_ */
