/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     Loader.cpp

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 7298 $
 *---------------------------------------------------------------------------*/

/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */

#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>
#include <nn/fs.h>

#include <string.h>
#include <cstdlib>

#include "Loader.h"
#include "Memory.h"

#include <nn/dbg.h>

namespace gputest{
namespace common{

void loadDAT(const char* _name, dat_t* _dat)
{
    if (!_name || !_dat)
        return;
    
    char* fname = 0;
    wchar_t* wfname = 0;
    unsigned char* dat = 0;
    long long int filesize;
    nn::fs::FileReader file;
    do
    {
        fname = (char*)malloc(strlen(_name) + 1);
        if (!fname)
            break;
        
        int dotpos = 0;
        strcpy(fname, _name);
        for (int i = (int)strlen(fname) - 1; i >= 0; i--)
        {
            if (fname[i] == '.')
            {
                dotpos = i;
                break;
            }
        }
        if (strncmp(&fname[dotpos + 1], "dat", 3) != 0)
            break;
        
        wfname = static_cast<wchar_t*>(malloc( (strlen(fname)+1)*2 ));
        if (!wfname)
            break;
        (void)std::mbstowcs( wfname, fname, strlen(fname)+1 );
        file.Initialize(wfname);
        filesize = file.GetSize();
        dat = static_cast<unsigned char*>(malloc(filesize));
        if (!dat)
            break;
        filesize = file.Read(dat, filesize);
        
        dat_header_t* header = (dat_header_t*)dat;
        dat_obj_t* obj = (dat_obj_t*)&dat[sizeof(dat_header_t)];
        dat_patch_t* patch = (dat_patch_t*)&dat[sizeof(dat_header_t) + sizeof(dat_obj_t) * header->obj_num];
        
        nn::fs::FileReader attribfile;
        unsigned char* attribdata = 0;
        memset(_dat, 0, sizeof(dat_t));
        
        if (header->vtx_size)
        {
            memcpy(&fname[dotpos + 1], "vtx", 3);
            (void)std::mbstowcs( wfname, fname, strlen(fname)+1 );
            attribfile.Initialize(wfname);
            filesize = attribfile.GetSize();
            attribdata = static_cast<unsigned char*>(malloc(filesize));
            if (!attribdata)
                break;
            (void)attribfile.Read(attribdata, filesize);
            glGenBuffers(1, &_dat->posVB);
            glBindBuffer(GL_ARRAY_BUFFER, _dat->posVB);
            glBufferData(GL_ARRAY_BUFFER, header->vtx_size, attribdata, GL_STATIC_DRAW);
            free(attribdata);
            attribfile.Finalize();
        }
        if (header->nrm_size)
        {
            memcpy(&fname[dotpos + 1], "nrm", 3);
            (void)std::mbstowcs( wfname, fname, strlen(fname)+1 );
            attribfile.Initialize(wfname);
            filesize = attribfile.GetSize();
            attribdata = static_cast<unsigned char*>(malloc(filesize));
            if (!attribdata)
                break;
            (void)attribfile.Read(attribdata, filesize);
            glGenBuffers(1, &_dat->normVB);
            glBindBuffer(GL_ARRAY_BUFFER, _dat->normVB);
            glBufferData(GL_ARRAY_BUFFER, header->nrm_size, attribdata, GL_STATIC_DRAW);
            free(attribdata);
            attribfile.Finalize();
        }
        if (header->tex_size)
        {
            memcpy(&fname[dotpos + 1], "tex", 3);
            (void)std::mbstowcs( wfname, fname, strlen(fname)+1 );
            attribfile.Initialize(wfname);
            filesize = attribfile.GetSize();
            attribdata = static_cast<unsigned char*>(malloc(filesize));
            if (!attribdata)
                break;
            (void)attribfile.Read(attribdata, filesize);
            glGenBuffers(1, &_dat->texVB);
            glBindBuffer(GL_ARRAY_BUFFER, _dat->texVB);
            glBufferData(GL_ARRAY_BUFFER, header->tex_size, attribdata, GL_STATIC_DRAW);
            free(attribdata);
            attribfile.Finalize();
        }
        if (header->tgt_size)
        {
            memcpy(&fname[dotpos + 1], "tgt", 3);
            (void)std::mbstowcs( wfname, fname, strlen(fname)+1 );
            attribfile.Initialize(wfname);
            filesize = attribfile.GetSize();
            attribdata = static_cast<unsigned char*>(malloc(filesize));
            if (!attribdata)
                break;
            (void)attribfile.Read(attribdata, filesize);
            glGenBuffers(1, &_dat->tangVB);
            glBindBuffer(GL_ARRAY_BUFFER, _dat->tangVB);
            glBufferData(GL_ARRAY_BUFFER, header->tgt_size, attribdata, GL_STATIC_DRAW);
            free(attribdata);
            attribfile.Finalize();
        }
        if (header->wgt_size)
        {
            memcpy(&fname[dotpos + 1], "wgt", 3);
            (void)std::mbstowcs( wfname, fname, strlen(fname)+1 );
            attribfile.Initialize(wfname);
            filesize = attribfile.GetSize();
            attribdata = static_cast<unsigned char*>(malloc(filesize));
            if (!attribdata)
                break;
            (void)attribfile.Read(attribdata, filesize);
            glGenBuffers(1, &_dat->wghtVB);
            glBindBuffer(GL_ARRAY_BUFFER, _dat->wghtVB);
            glBufferData(GL_ARRAY_BUFFER, header->wgt_size, attribdata, GL_STATIC_DRAW);
            free(attribdata);
            attribfile.Finalize();
        }
        if (header->idx_size)
        {
            memcpy(&fname[dotpos + 1], "idx", 3);
            (void)std::mbstowcs( wfname, fname, strlen(fname)+1 );
            attribfile.Initialize(wfname);
            filesize = attribfile.GetSize();
            attribdata = static_cast<unsigned char*>(malloc(filesize));
            if (!attribdata)
                break;
            (void)attribfile.Read(attribdata, filesize);
            glGenBuffers(1, &_dat->midxVB);
            glBindBuffer(GL_ARRAY_BUFFER, _dat->midxVB);
            glBufferData(GL_ARRAY_BUFFER, header->idx_size, attribdata, GL_STATIC_DRAW);
            free(attribdata);
            attribfile.Finalize();
        }
        if (header->elm_size)
        {
            memcpy(&fname[dotpos + 1], "elm", 3);
            (void)std::mbstowcs( wfname, fname, strlen(fname)+1 );
            attribfile.Initialize(wfname);
            filesize = attribfile.GetSize();
            attribdata = static_cast<unsigned char*>(malloc(filesize));
            if (!attribdata)
                break;
            (void)attribfile.Read(attribdata, filesize);
            glGenBuffers(1, &_dat->idxVB);
            glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, _dat->idxVB);
            glBufferData(GL_ELEMENT_ARRAY_BUFFER, header->elm_size, attribdata, GL_STATIC_DRAW);
            free(attribdata);
            attribfile.Finalize();
        }
        
        _dat->obj = (dat_obj_t*)malloc(sizeof(dat_obj_t) * header->obj_num);
        _dat->patch = (dat_patch_t*)malloc(sizeof(dat_patch_t) * header->patch_num);
        if (!_dat->obj || !_dat->patch)
        {
            if (_dat->obj)
                free(_dat->obj);
            if (_dat->patch)
                free(_dat->patch);
            break;
        }
        memcpy(_dat->obj, obj, sizeof(dat_obj_t) * header->obj_num);
        memcpy(_dat->patch, patch, sizeof(dat_patch_t) * header->patch_num);
        _dat->obj_num = header->obj_num;
    } while (0);
    
    if (fname)
        free(fname);
    if (wfname)
        free(wfname);
    if (dat)
        free(dat);
    file.Finalize();
    
    return;
}

void unloadDAT(dat_t* dat)
{
    if (dat)
    {
        if (dat->posVB)
            glDeleteBuffers(1, &dat->posVB);
        if (dat->normVB)
            glDeleteBuffers(1, &dat->normVB);
        if (dat->texVB)
            glDeleteBuffers(1, &dat->texVB);
        if (dat->tangVB)
            glDeleteBuffers(1, &dat->tangVB);
        if (dat->wghtVB)
            glDeleteBuffers(1, &dat->wghtVB);
        if (dat->midxVB)
            glDeleteBuffers(1, &dat->midxVB);
        if (dat->idxVB)
            glDeleteBuffers(1, &dat->idxVB);
        if (dat->obj)
            free(dat->obj);
        if (dat->patch)
            free(dat->patch);
    }
    
    return;
}

}
}
