/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */

#include <nn/gx.h>
#include <nn/math.h>
#include <nn/fs.h>
#include <nn/os.h>
#include <nn/init.h>
#include <nn/fnd/fnd_ExpHeap.h>
#include "File.h"

#include <string.h>
#include <cstdlib>

#include "Memory.h"

namespace gputest{
namespace common{

unsigned char* ReadFile(const char* filePath, int* readSize)
{
    nn::fs::FileReader file;
    wchar_t* wfname = 0;
    long long int filesize;
    unsigned char* fdat;
    
    wfname = static_cast<wchar_t*>(malloc( (strlen(filePath)+1)*2 ));
    (void)std::mbstowcs( wfname, filePath, strlen(filePath)+1 );
    
    file.Initialize(wfname);
    filesize = file.GetSize();
    fdat = static_cast<unsigned char*>(malloc(filesize));
    filesize = file.Read(fdat, filesize);
    
    *readSize = static_cast<int>(filesize);
    free(wfname);
    file.Finalize();
    
    return fdat;
}

int WriteFile(const char* filePath, unsigned char* fileData, int writeSize)
{
    (void)filePath;
    (void)fileData;
    (void)writeSize;
    return 0;
}

}
}
