/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */

#include <nn/gx.h>
#include <nn/math.h>
#include <nn/fs.h>
#include <nn/os.h>
#include <nn/init.h>
#include <nn/fnd/fnd_ExpHeap.h>
#include <nn/gxlow/CTR/gxlow_CTR.h>
#include "sys.h"

#include "Allocator.h"
#include "Memory.h"

//#define MAKE_REF_VALUE
#define COMPARE_RESULT

#include "gputestref.h"

// SDK3.2.4Ή kubokǉR[h
#include "../../../eva/sound/NWSound.h"
using namespace uji::eva::agingsnd;


namespace gputest{
namespace common{

demo::RenderSystemUji* s_RenderSystem;
s64 startTick_;

using namespace nn::math;

static int (*draw_func)(void) = 0;
static unsigned int width_, height_;
static int loop_count_ = 0;
static int test_id_ = 0;
static int frame_ = 0;
static int error_ = -1;
static GLuint fontvbcoll_ = 0;
static int toalframe_ = 0;

/* display initialization */
void init_display(const unsigned int width, const unsigned int height, const char *name, int (*drawfunc)(void))
{
	draw_func = drawfunc;

	width_ = width;
	height_ = height;
	(void)name;
	s_RenderSystem->SetRenderTarget(NN_GX_DISPLAY0);

	// initialize error flag. frame number occuring error is kept in this symbol.
	error_ = -1;
	
	#ifdef MAKE_REF_VALUE
	NN_LOG("{");
	#endif

	return;
}

/* display shutdown */
void shutdown_display(void)
{
	#ifdef MAKE_REF_VALUE
	NN_LOG("\n},\n");
	#endif
}

void swap_buffer(void)
{
	s_RenderSystem->SwapBuffers();
	// check rendering result
	#if defined(MAKE_REF_VALUE) || defined(COMPARE_RESULT)
	{
	    GLint param;
		nngxGetDisplaybufferParameteri(NN_GX_DISPLAYBUFFER_ADDRESS, &param);
		unsigned char* pixels = reinterpret_cast<unsigned char*>(param);
		
		nngxlowInvalidateDataCache(pixels, width_ * height_ * 3);
		unsigned sum = 0;
		for (int i = 0; i < width_ * height_; i++)
		{
			sum += (pixels[i * 3 + 0]) | (pixels[i * 3 + 1] << 8) | (pixels[i * 3 + 2] << 16);
		}
		#ifdef MAKE_REF_VALUE
		if ((frame_ % 10) == 0)
			NN_LOG("\n");
		NN_LOG("0x%08x", sum);
		if (frame_ != loop_count_ - 1)
			NN_LOG(",");
		ref_value[test_id_-1][frame_] = sum;
		#elif defined(COMPARE_RESULT)
		if (ref_value[test_id_-1][frame_] != sum)
		{
//            NN_LOG("fail in test%d!! ref:%08x val:%08x\n", test_id_, ref_value[test_id_-1][frame_], sum);
			error_ = frame_;
		}
		#endif
	}
	#endif
	s_RenderSystem->SetRenderTarget(NN_GX_DISPLAY1);
	
	// draw current time in lower display.
	{
		// save current gl state
		GLuint program;
		glGetIntegerv(GL_CURRENT_PROGRAM, (GLint*)&program);
		GLuint activetex;
		glGetIntegerv(GL_ACTIVE_TEXTURE, (GLint*)&activetex);
		GLuint tex2d0, texcube0;
		glActiveTexture(GL_TEXTURE0);
		glGetIntegerv(GL_TEXTURE_BINDING_2D, (GLint*)&tex2d0);
		glGetIntegerv(GL_TEXTURE_BINDING_CUBE_MAP, (GLint*)&texcube0);
		GLboolean blendEnabled = glIsEnabled(GL_BLEND);
		GLenum srcRGB, dstRGB, srcAlpha, dstAlpha;
		glGetIntegerv(GL_BLEND_SRC_RGB, (GLint*)&srcRGB);
		glGetIntegerv(GL_BLEND_DST_RGB, (GLint*)&dstRGB);
		glGetIntegerv(GL_BLEND_SRC_ALPHA, (GLint*)&srcAlpha);
		glGetIntegerv(GL_BLEND_DST_ALPHA, (GLint*)&dstAlpha);
		GLenum modeRGB, modeAlpha;
		glGetIntegerv(GL_BLEND_EQUATION_RGB, (GLint*)&modeRGB);
		glGetIntegerv(GL_BLEND_EQUATION_ALPHA, (GLint*)&modeAlpha);
		GLuint vbcoll;
		glGetIntegerv(GL_VERTEX_STATE_COLLECTION_BINDING_DMP, (GLint*)&vbcoll);
		glBindBuffer(GL_VERTEX_STATE_COLLECTION_DMP, fontvbcoll_);
		GLboolean depthEnabled = glIsEnabled(GL_DEPTH_TEST);
		GLboolean cullEnabled = glIsEnabled(GL_CULL_FACE);
		glDisable(GL_DEPTH_TEST);
		GLboolean stencilEnabled = glIsEnabled(GL_STENCIL_TEST);
		glDisable(GL_STENCIL_TEST);
		
		// draw font
		s64 currentTick = nn::os::Tick::GetSystemCurrent();
		int pastmillisec = (int)nnosTickConvertToMilliSeconds(currentTick - startTick_);
        int pastminute = pastmillisec / 60000;
		float pastsec = (float)(pastmillisec / 1000.f) - (float)(pastminute * 60.0f);
		s_RenderSystem->DrawText(0, 0, "Frame: %d, Time %dmin %1.3fsec\n", toalframe_++, pastminute, pastsec);
		s_RenderSystem->SwapBuffers();
		
		// restore state
		s_RenderSystem->SetRenderTarget(NN_GX_DISPLAY0);
		glUseProgram(program);
		glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D, tex2d0);
		glBindTexture(GL_TEXTURE_CUBE_MAP, texcube0);
		glActiveTexture(activetex);
		if (blendEnabled)
			glEnable(GL_BLEND);
		else
			glDisable(GL_BLEND);
		glBlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
		glBlendEquationSeparate(modeRGB, modeAlpha);
		glBindBuffer(GL_VERTEX_STATE_COLLECTION_DMP, vbcoll);
		if (depthEnabled)
			glEnable(GL_DEPTH_TEST);
		else
			glDisable(GL_DEPTH_TEST);
		if (cullEnabled)
			glEnable(GL_CULL_FACE);
		else
			glDisable(GL_CULL_FACE);
		if (stencilEnabled)
			glEnable(GL_STENCIL_TEST);
		else
			glDisable(GL_STENCIL_TEST);
	}
	s_RenderSystem->WaitVsync(NN_GX_DISPLAY_BOTH);

	return;
}

void draw_loop(void)
{
	for (frame_ = 0; frame_ < loop_count_; frame_++)
	{
        // SDK3.2.4Ή kubokǉR[h
        UpdatePlayer();
        
		if (draw_func)
		{
			if (draw_func() == 0)
				break;
		}
	}

	return;
}

void cmn_InitializeFramework(demo::RenderSystemUji* pRenderSystem, int loopCount, s64 startTick)
{
	startTick_ = startTick;
	
	s_RenderSystem = pRenderSystem;
	s_RenderSystem->SetColor(1.f, 1.f, 1.f, 1.f);
	
	loop_count_ = loopCount;
	#ifdef MAKE_REF_VALUE
	NN_LOG("unsigned ref_value[][%d] = {\n", loopCount);
	#endif

	// create vertex state collection for font draw.
	glGenBuffers(1, &fontvbcoll_);
	glBindBuffer(GL_VERTEX_STATE_COLLECTION_DMP, fontvbcoll_);
	glBindBuffer(GL_VERTEX_STATE_COLLECTION_DMP, 0);
	
	toalframe_ = 0;
}

void cmn_FinalizeFramework(void)
{
	glDeleteBuffers(1, &fontvbcoll_);
}

void cmn_setTestID(int id)
{
	test_id_ = id;
}

int cmn_getTestError()
{
	return error_;
}

void cmn_setRenderTarget(int display)
{
	s_RenderSystem->SetRenderTarget(display == 0 ? NN_GX_DISPLAY0 : NN_GX_DISPLAY1);
}

GLuint cmn_getRenderbufferObjectID(int display, int attachment)
{
	return s_RenderSystem->GetRenderBufferObjectId(display == 0 ? NN_GX_DISPLAY0 : NN_GX_DISPLAY1, attachment);
}

}
}
