/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */
#ifndef __S_DISPLAY_H__
#define __S_DISPLAY_H__

#include "sys.h"

namespace gputest{
namespace common{

void init_display(const unsigned int width, const unsigned int height, const char *name, int (*drawfunc)(void));
void shutdown_display(void);
void swap_buffer(void);
void draw_loop(void);
void cmn_InitializeFramework(demo::RenderSystemUji* pRenderSystem, int loopCount, s64 startTick);
void cmn_FinalizeFramework(void);
void cmn_setTestID(int id);
int cmn_getTestError();
void cmn_setRenderTarget(int display);
GLuint cmn_getRenderbufferObjectID(int display, int attachment);

}
}

#endif	/* __S_DISPLAY_H__ */
