//
//------------------------------------------------------------
// Copyright(c) 2009-2010 by Digital Media Professionals Inc.
// All rights reserved.
//------------------------------------------------------------
// This source code is the confidential and proprietary
// of Digital Media Professionals Inc.
//------------------------------------------------------------
//

#include "Commonasm.h"

defb	b0,	true

l_position:
	m4x4	TEMP_VIEW,			dmp_position,		dmp_local_to_view_matrix
	mov		TEMP_POS,			dmp_projection_matrix[2]
	add		TEMP_POS,			TEMP_POS,			dmp_projection_matrix[3]
	mul		TEMP_POS,			TEMP_POS,			-CONST_HALF
	dp4		gl_Position.x,		TEMP_VIEW,			dmp_projection_matrix[0]
	dp4		gl_Position.y,		TEMP_VIEW,			dmp_projection_matrix[1]
	dp4		gl_Position.z,		TEMP_VIEW,			TEMP_POS
	dp4		gl_Position.w,		TEMP_VIEW,			dmp_projection_matrix[3]
	ret
	nop
	
l_position_view_quaternion:
	m4x4	TEMP_VIEW,			dmp_position,		dmp_local_to_view_matrix
	dp3		TEMP_NORM.z,		dmp_normal,			dmp_local_to_view_matrix[2]
	dp3		TEMP_NORM.x,		dmp_normal,			dmp_local_to_view_matrix[0]
	dp3		TEMP_NORM.y,		dmp_normal,			dmp_local_to_view_matrix[1]
	mov		TEMP_POS,			dmp_projection_matrix[2]
	add		TEMP_POS,			TEMP_POS,			dmp_projection_matrix[3]
	mov		dmp_lrView,			-TEMP_VIEW
	mul		TEMP_POS,			TEMP_POS,			-CONST_HALF
	dp4		gl_Position.x,		TEMP_VIEW,			dmp_projection_matrix[0]
	dp4		gl_Position.y,		TEMP_VIEW,			dmp_projection_matrix[1]
	cmp		EQ, EQ,				TEMP_NORM.z,		-CONST_1				// compare z component of norm with -1.0
	add		r4,					TEMP_NORM.z,		CONST_1					// n.z + 1.0 is in r4
	dp4		gl_Position.z,		TEMP_VIEW,			TEMP_POS
	dp4		gl_Position.w,		TEMP_VIEW,			dmp_projection_matrix[3]
	mul		r4,					r4,					CONST_HALF				// 0.5*(n.z + 1.0) is in r4
	mov		dmp_lrQuat.w,		CONST_0										// zero out quat.w component
	rsq		r4,					r4.x										// 1/sqrt(0.5*(n.z + 1.0)) is in r4
	mul		r5,					TEMP_NORM,			CONST_HALF				// 0.5*n is in r5
	ifc 0, 1, COND_MODE_STA0
		rcp		dmp_lrQuat.z,	r4.x										// sqrt(0.5*(n.z + 1.0)) is in quat.z component
		mul		dmp_lrQuat.xy,	r5,					r4						// 0.5*n*quat.z is in quat.xy
    else
    	mov		dmp_lrQuat,		CONST_1_0									// zero out quat.w component
	endif
	nop
	ret
	nop

l_position_view_quaternion_reflection:
	m4x4	TEMP_VIEW,			dmp_position,		dmp_local_to_view_matrix
	
	dp3		TEMP_NORM.x,		dmp_normal,			dmp_local_to_view_matrix[0]
	dp3		TEMP_NORM.y,		dmp_normal,			dmp_local_to_view_matrix[1]
	dp3		TEMP_NORM.z,		dmp_normal,			dmp_local_to_view_matrix[2]

	mov		TEMP_POS,			dmp_projection_matrix[2]

	add		TEMP_POS,			TEMP_POS,			dmp_projection_matrix[3]
	mov		dmp_lrView,			-TEMP_VIEW
		
	mul		TEMP_POS,			TEMP_POS,			-CONST_HALF
	
	dp3		TEMP0,				-TEMP_VIEW,			TEMP_NORM
	dp4		gl_Position.x,		TEMP_VIEW,			dmp_projection_matrix[0]
	dp4		gl_Position.y,		TEMP_VIEW,			dmp_projection_matrix[1]
	cmp		EQ, EQ,				TEMP_NORM.z,		-CONST_1					// compare z component of norm with -1.0
	add		r4,					TEMP_NORM.z,		CONST_1						// n.z + 1.0 is in r4
	dp4		gl_Position.z,		TEMP_VIEW,			TEMP_POS
	
	add		TEMP0,				TEMP0,				TEMP0
	
	dp4		gl_Position.w,		TEMP_VIEW,			dmp_projection_matrix[3]
	mul		r4,					r4,					CONST_HALF					// 0.5*(n.z + 1.0) is in r4

	mad		TEMP0,				TEMP0,				TEMP_NORM,			TEMP_VIEW

	mov		dmp_lrQuat.w,		CONST_0											// zero out quat.w component
	
	rsq		r4,					r4.x											// 1/sqrt(0.5*(n.z + 1.0)) is in r4
	mul		r5,					TEMP_NORM,			CONST_HALF					// 0.5*n is in r5
	ifc 0, 1, COND_MODE_STA0
		rcp		dmp_lrQuat.z,	r4.x											// sqrt(0.5*(n.z + 1.0)) is in quat.z component
		mul		dmp_lrQuat.xy,	r5,					r4							// 0.5*n*quat.z is in quat.xy
    else
    	mov		dmp_lrQuat,		CONST_1_0										// zero out quat.w component
	endif
	
	dp3		gl_TexCoord0.x,		TEMP0,				dmp_local_to_world_matrix[0]
	dp3		gl_TexCoord0.y,		TEMP0,				dmp_local_to_world_matrix[1]
	dp3		gl_TexCoord0.z,		TEMP0,				dmp_local_to_world_matrix[2]
	mov		gl_TexCoord0.w,		CONST_0
	ret
	nop
	
l_position_view_full_quaternion:
	m4x4	TEMP_VIEW,			dmp_position,		dmp_local_to_view_matrix
	dp3		TEMP_NORM.x,		dmp_normal,			dmp_local_to_view_matrix[0]
	dp3		TEMP_NORM.y,		dmp_normal,			dmp_local_to_view_matrix[1]
	dp3		TEMP_NORM.z,		dmp_normal,			dmp_local_to_view_matrix[2]
	dp3		TEMP_TANG.x,		dmp_tangent,		dmp_local_to_view_matrix[0]
	dp3		TEMP_TANG.y,		dmp_tangent,		dmp_local_to_view_matrix[1]
	dp3		TEMP_TANG.z,		dmp_tangent,		dmp_local_to_view_matrix[2]
	mov		TEMP_POS,			dmp_projection_matrix[2]
	add		TEMP_POS,			TEMP_POS,			dmp_projection_matrix[3]
	mov		dmp_lrView,			-TEMP_VIEW
	mul		TEMP_POS,			TEMP_POS,			-CONST_HALF
	dp4		gl_Position.x,		TEMP_VIEW,			dmp_projection_matrix[0]
	dp4		gl_Position.y,		TEMP_VIEW,			dmp_projection_matrix[1]
	dp4		gl_Position.z,		TEMP_VIEW,			TEMP_POS
	dp4		gl_Position.w,		TEMP_VIEW,			dmp_projection_matrix[3]

	mul		r5,					TEMP_NORM.yzx,	TEMP_TANG.zxy
	mad		r5,					-TEMP_TANG.yzx,	TEMP_NORM.zxy,	r5	// b*|n|^2 is in r5
	dp3		r5.w,				r5,				r5
	rsq		r5.w,				r5.w
	mul		r5,					r5,				r5.w
	add		r6.w,				TEMP_NORM.z,	r5.y
	mul		TEMP_TANG,			r5.yzx,			TEMP_NORM.zxy
	mad		TEMP_TANG,			-TEMP_NORM.yzx,	r5.zxy,			TEMP_TANG
	add		r6.w,				TEMP_TANG.x,	r6
	mov		TEMP_TANG.w,		r5.z
	mov		r5.z,				TEMP_TANG.x
	add		r6.w,				CONST_1,		r6
	mov		TEMP_NORM.w,		r5.x
	mov		r5.x,				TEMP_NORM.z
	cmp		CMP_MODE_GT,		CMP_MODE_GT,	r6.w,			CONST_1__256
	mov		r6.x,				CONST_1	
	mov		r6.y,				-CONST_1
	jpc		0, 0,				COND_MODE_STA0,	l_full_quaternion_calc_fallback
	add		r7.xz,				TEMP_TANG.wwyy,	-TEMP_NORM.yyww
	add		r7.y,				TEMP_NORM.x,	-TEMP_TANG.z
	mov		r7.w,				r6
	dp4		r6,					r7,				r7
	rsq		r6,					r6.x
	mul		dmp_lrQuat,		    r7,				r6
	jpb		b0,	true, l_full_quaternion_calc_end
l_full_quaternion_calc_fallback:	
	cmp CMP_MODE_GT, CMP_MODE_GT,	r5.zy,			r5.yx
	ifc 1, 1, COND_MODE_STA0
		ifc 1, 1, COND_MODE_STA1
			mul			r8,				TEMP_TANG.yyzw,		r6.xxxy
			add			r8.x,			CONST_1,			-r5.y
			add			r9,				r5.z,				-r5.x
			add			r8.yzw,			r8,					TEMP_NORM.wwxy
			add			r8.x,			r9,					r8
		else
			cmp CMP_MODE_GT, CMP_MODE_GT,	r5.z, r5.x
			mul			r8,				TEMP_TANG.yyzw,		r6.xxxy
			add			r8.x,			CONST_1,			-r5.y
			ifc 1, 1, COND_MODE_STA0
				add			r9,				r5.z,				-r5.x
				add			r8.yzw,			r8,					TEMP_NORM.wwxy
				add			r8.x,			r9,					r8
			else
				mul			r8,				TEMP_TANG.zwwy,		r6.xxxy
				add			r8.z,			CONST_1,			-r5.z
				add			r9,				r5.x,				-r5.y
				add			r8.xyw,			r8,					TEMP_NORM.xyyw
				add			r8.z,			r9,					r8
			endif
			nop
		endif
		dp4			r6,		r8,				r8
	else
		ifc 1, 1, COND_MODE_STA1
			mul		r8,				TEMP_TANG.yywz,		r6.xxxy
			add		r8.y,			CONST_1,			-r5.z
			add		r9,				r5.y,				-r5.x
			add		r8.xzw,			r8,					TEMP_NORM.wwyx
			add		r8.y,			r9,					r8
		else
			mul		r8,				TEMP_TANG.zwwy,		r6.xxxy
			add		r8.z,			CONST_1,			-r5.z
			add		r9,				r5.x,				-r5.y
			add		r8.xyw,			r8,					TEMP_NORM.xyyw
			add		r8.z,			r9,					r8
		endif
		dp4			r6,		r8,				r8
	endif
	rsq			r6,			r6.x
	mul			dmp_lrQuat,			r8,					r6
l_full_quaternion_calc_end:
	nop
	ret

l_position_view_full_quaternion_reflection:
	m4x4	TEMP_VIEW,			dmp_position,		dmp_local_to_view_matrix
	dp3		TEMP_NORM.x,		dmp_normal,			dmp_local_to_view_matrix[0]
	dp3		TEMP_NORM.y,		dmp_normal,			dmp_local_to_view_matrix[1]
	dp3		TEMP_NORM.z,		dmp_normal,			dmp_local_to_view_matrix[2]
	dp3		TEMP_TANG.x,		dmp_tangent,		dmp_local_to_view_matrix[0]
	dp3		TEMP_TANG.y,		dmp_tangent,		dmp_local_to_view_matrix[1]
	dp3		TEMP_TANG.z,		dmp_tangent,		dmp_local_to_view_matrix[2]
	mov		TEMP_POS,			dmp_projection_matrix[2]
	add		TEMP_POS,			TEMP_POS,			dmp_projection_matrix[3]
	mov		dmp_lrView,			-TEMP_VIEW
	mul		TEMP_POS,			TEMP_POS,			-CONST_HALF
	dp4		gl_Position.x,		TEMP_VIEW,			dmp_projection_matrix[0]
	dp4		gl_Position.y,		TEMP_VIEW,			dmp_projection_matrix[1]
	dp4		gl_Position.z,		TEMP_VIEW,			TEMP_POS
	dp4		gl_Position.w,		TEMP_VIEW,			dmp_projection_matrix[3]

	mul		r5,					TEMP_NORM.yzx,	TEMP_TANG.zxy
	mad		r5,					-TEMP_TANG.yzx,	TEMP_NORM.zxy,	r5	// b*|n|^2 is in r5
	dp3		r5.w,				r5,				r5
	rsq		r5.w,				r5.w
	mul		r5,					r5,				r5.w
	add		r6.w,				TEMP_NORM.z,	r5.y
	mul		TEMP_TANG,			r5.yzx,			TEMP_NORM.zxy
	mad		TEMP_TANG,			-TEMP_NORM.yzx,	r5.zxy,			TEMP_TANG
	add		r6.w,				TEMP_TANG.x,	r6
	mov		TEMP_TANG.w,		r5.z
	mov		r5.z,				TEMP_TANG.x
	add		r6.w,				CONST_1,		r6
	mov		TEMP_NORM.w,		r5.x
	mov		r5.x,				TEMP_NORM.z
	cmp		CMP_MODE_GT,		CMP_MODE_GT,	r6.w,			CONST_1__256
	mov		r6.x,				CONST_1	
	mov		r6.y,				-CONST_1
	jpc		0, 0,				COND_MODE_STA0,	l_full_quaternion_calc_fallback_reflection
	add		r7.xz,				TEMP_TANG.wwyy,	-TEMP_NORM.yyww
	add		r7.y,				TEMP_NORM.x,	-TEMP_TANG.z
	mov		r7.w,				r6
	dp4		r6,					r7,				r7
	rsq		r6,					r6.x
	mul		dmp_lrQuat,		r7,				r6
	jpb		b0,	true, l_full_quaternion_reflection_calc_end
l_full_quaternion_calc_fallback_reflection:	
	cmp CMP_MODE_GT, CMP_MODE_GT,	r5.zy,			r5.yx
	ifc 1, 1, COND_MODE_STA0
		ifc 1, 1, COND_MODE_STA1
			mul			r8,				TEMP_TANG.yyzw,		r6.xxxy
			add			r8.x,			CONST_1,			-r5.y
			add			r9,				r5.z,				-r5.x
			add			r8.yzw,			r8,					TEMP_NORM.wwxy
			add			r8.x,			r9,					r8
		else
			cmp CMP_MODE_GT, CMP_MODE_GT,	r5.z, r5.x
			mul			r8,				TEMP_TANG.yyzw,		r6.xxxy
			add			r8.x,			CONST_1,			-r5.y
			ifc 1, 1, COND_MODE_STA0
				add			r9,				r5.z,				-r5.x
				add			r8.yzw,			r8,					TEMP_NORM.wwxy
				add			r8.x,			r9,					r8
			else
				mul			r8,				TEMP_TANG.zwwy,		r6.xxxy
				add			r8.z,			CONST_1,			-r5.z
				add			r9,				r5.x,				-r5.y
				add			r8.xyw,			r8,					TEMP_NORM.xyyw
				add			r8.z,			r9,					r8
			endif
			nop
		endif
		dp4			r6,		r8,				r8
	else
		ifc 1, 1, COND_MODE_STA1
			mul		r8,				TEMP_TANG.yywz,		r6.xxxy
			add		r8.y,			CONST_1,			-r5.z
			add		r9,				r5.y,				-r5.x
			add		r8.xzw,			r8,					TEMP_NORM.wwyx
			add		r8.y,			r9,					r8
		else
			mul		r8,				TEMP_TANG.zwwy,		r6.xxxy
			add		r8.z,			CONST_1,			-r5.z
			add		r9,				r5.x,				-r5.y
			add		r8.xyw,			r8,					TEMP_NORM.xyyw
			add		r8.z,			r9,					r8
		endif
		dp4			r6,		r8,				r8
	endif
	rsq			r6,			r6.x
	mul			dmp_lrQuat,			r8,					r6
l_full_quaternion_reflection_calc_end:
	dp3		TEMP0,				-TEMP_VIEW,			TEMP_NORM
	add		TEMP0,				TEMP0,				TEMP0
	mad		TEMP0,				TEMP0,				TEMP_NORM,			TEMP_VIEW
	dp3		gl_TexCoord0.x,		TEMP0,				dmp_local_to_world_matrix[0]
	dp3		gl_TexCoord0.y,		TEMP0,				dmp_local_to_world_matrix[1]
	dp3		gl_TexCoord0.z,		TEMP0,				dmp_local_to_world_matrix[2]
	mov		gl_TexCoord0.w,		CONST_0
	ret
	nop
