/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     Allocator.cpp

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 7298 $
 *---------------------------------------------------------------------------*/

/*
 *------------------------------------------------------------
 * Copyright(c) 2009-2010 by Digital Media Professionals Inc.
 * All rights reserved.
 *------------------------------------------------------------
 * This source code is the confidential and proprietary
 * of Digital Media Professionals Inc.
 *------------------------------------------------------------
 */

#include <nn/os.h>
#include "sys.h"

#include "Allocator.h"

namespace gputest{
namespace common{

static uji::sys::DemoAllocator* pAlloc_ = 0;

void cmn_SetAllocator(uji::sys::DemoAllocator* pAllocator)
{
	pAlloc_ = pAllocator;
}

void* stdAlloc(int size)
{
    return pAlloc_->Alloc(size);
}

void stdFree(void* ptr)
{
    pAlloc_->Free(ptr);
    
    return;
}

}
}
