/*--------------------------------------------------------------------------*
 Project:
 File: demo_window.cpp
 
 EChEgp@̃f

 ǂǂҏWĂB

*--------------------------------------------------------------------------*/

#include "demo_window.h"
#include "sys_App.h"

#include <nn.h>
#include <nn/fnd.h>
#include <nn/gx.h>
#include <stdlib.h>
#include <nw/types.h>


namespace uji {
namespace eva {


//============================================================================
//============================================================================
//                         SimpleWindow
//============================================================================
//============================================================================

// `揈
void SimpleWindow::OnDraw(sys::GraphicsDrawing* gfx)
{
    sys::Point pos = this->GetClientPosition();
    
    // tHg̐ݒ
    gfx->SetFixedWidthFont(14);
    
    // \JnXN[Ww
    gfx->m_TextWriter.SetCursor(pos.x+3, pos.y+3);
    
    // Fݒ
    gfx->m_TextWriter.SetTextColor(nn::util::Color8::YELLOW);
    
    // `̑O
    gfx->BeginDrawingString();        
        /* 
            A{^Ə㉺L[́AOnUpdatePadŃI[o[ChłB
            L/ŔAEChE}l[W̏łB
        */
        (void)gfx->m_TextWriter.Printf("DEMO(%d)\n", m_FrameCount);
        (void)gfx->m_TextWriter.Printf("A  :Output Message(%d)\n", m_MesgCount);
        (void)gfx->m_TextWriter.Printf("R  :Change Active Window\n");
        (void)gfx->m_TextWriter.Printf("L  :Change Visible Window\n");    
        (void)gfx->m_TextWriter.Printf("U/D:Change Alpha\n\n");
    
        gfx->m_TextWriter.SetTextColor(nn::util::Color8::WHITE);    
        (void)gfx->m_TextWriter.Printf("AppMemSize  = %d KByte\n", nn::os::GetAppMemorySize()/1024);
        (void)gfx->m_TextWriter.Printf("UsingMemSize= %d KByte\n", nn::os::GetUsingMemorySize()/1024);
    gfx->EndDrawingString();
}

// ͏
void SimpleWindow::OnUpdatePad(const sys::Pad& pad)
{
    if (pad.IsButtonRepeatFast(sys::Pad::BUTTON_A))
    {        
        sys::Point cursorPos;
        
        if (m_MessageLogWindow)
        {
            // bZ[WOEChEɏo
            m_MessageLogWindow->Printf("%03d: Thanks!\n", ++m_MesgCount);
        }
        
        if (m_TextWindow)
        {
            // eLXgEChEɏo                
            m_TextWindow->SetTextColor(sys::ATTR_COLOR_WHITE);        
            m_TextWindow->Printf("\n> ");
            cursorPos = m_TextWindow->Getxy();        
            m_TextWindow->SetTextColor(static_cast<sys::ATTR_TEXT_COLOR>(m_MesgCount%sys::ATTR_COLOR_MAX));                    
            m_TextWindow->Printf("[%d:%d]%03d: Color(%d)", 
                cursorPos.x, cursorPos.y, m_MesgCount, m_MesgCount%sys::ATTR_COLOR_MAX);        
        }
    }
    
    // ߗύX
    if (pad.IsButtonRepeat(sys::Pad::BUTTON_UP))
    {
        m_WindowManager.ChangeMasterAlpha(16);
    }
    if (pad.IsButtonRepeat(sys::Pad::BUTTON_DOWN))
    {
        m_WindowManager.ChangeMasterAlpha(-16);
    }    
}

// t[XV
void SimpleWindow::OnUpdate()
{
    m_FrameCount++;   
}


//============================================================================
//============================================================================
//                         DemoWindow
//============================================================================
//============================================================================

/*---------------------------------------------------------------------------
 Desc:  EChEfs
---------------------------------------------------------------------------*/
void DemoWindow::Run()
{    
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // EChE
    (void)m_WindowManager.CreateWindow(&m_TextWindow,         NN_GX_DISPLAY0, 190, 80);        
    (void)m_WindowManager.CreateWindow(&m_MessageLogWindow,   NN_GX_DISPLAY1, 10, 10);    
    (void)m_WindowManager.CreateWindow(&m_SimpleWindow,       NN_GX_DISPLAY0, 10, 30);
    
    // VvEChEł̏o͐EChE֘At
    m_SimpleWindow.SetTextWindow(m_TextWindow);
    m_SimpleWindow.SetMessageLogWindow(m_MessageLogWindow);

	// ^CgwiF̕ύX(TextWindow)
	m_TextWindow.SetTitleBackColor(uji::sys::RECT_RT, nw::ut::Color8(255, 255, 255, 255));
	m_TextWindow.SetTitleBackColor(uji::sys::RECT_LT, nw::ut::Color8(0, 0, 0, 255));
	m_TextWindow.SetTitleBackColor(uji::sys::RECT_LB, nw::ut::Color8(0, 0, 0, 255));
	m_TextWindow.SetTitleBackColor(uji::sys::RECT_RB, nw::ut::Color8(255, 255, 255, 255));
	
	// ^CgwiF̕ύX(MessageLogWindow)
	m_MessageLogWindow.SetTitleBackColor(uji::sys::RECT_LT, nw::ut::Color8(255, 0, 0, 255));
	
	// ^CgwiF̕ύX(SimpleWindow)
	m_SimpleWindow.SetTitleBackColor(uji::sys::RECT_RB, nw::ut::Color8(0, 0, 0, 255));

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(240);
    
    uji::sys::Point cursorPos;
    
    // eLXgEChEɕo
    for (int i = 0; i < sys::ATTR_COLOR_MAX; i++)
    {
        // eLXg\ʒusEԍŎw
        m_TextWindow.Gotoxy(i, i);
        // ݂̕\ʒu擾
        cursorPos = m_TextWindow.Getxy();
        m_TextWindow.SetTextColor(static_cast<sys::ATTR_TEXT_COLOR>(sys::ATTR_COLOR_BLACK+i));
        m_TextWindow.Printf("[%d:%d]Color_id(%d)", cursorPos.x, cursorPos.y, i);
    }
        
    do 
    {        
        // pbh͍XV
        sys::Pad().UpdatePad();
        
        /*
            EChE
        */
        m_WindowManager.UpdatePad(sys::Pad());  // pbh
        m_WindowManager.Update();               // XV        
        
        /* ------------------------------------------------------------------------
                ʕ`
        ------------------------------------------------------------------------ */
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();
        m_WindowManager.DrawDisplay0();
        
        /*
            ` 
        */    
        gfx->SetFixedWidthFont(20);
        gfx->m_TextWriter.SetCursor(0, 0, 0);        
        gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_V);
        gfx->m_TextWriter.SetTextColor(nn::util::Color8::YELLOW, nn::util::Color8::RED);
        gfx->BeginDrawingString(); 
            (void)gfx->m_TextWriter.Printf("DEMO WINDOW(%d)\n", m_frameCount++);            
        gfx->EndDrawingString();
        gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_NONE);
#if 0
        // R}hobt@̏ʂfobOo
        gfx->NN_LOG_CmdBufUsedSize();
#endif                
        gfx->m_DrawFramework->SwapBuffers();
        
        /* ------------------------------------------------------------------------
                ʕ`
        ------------------------------------------------------------------------ */
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        m_WindowManager.DrawDisplay1();
        
        /*
            DrawFrameworkExiRenderSystemj }``
        */
        gfx->m_DrawFramework->SetColor(1.0f, 0.0f, 0.0f, 1.0f);
        for (u32 i = 0; i < 5; i++)
        {
            f32 value = static_cast<f32>(i);        
            gfx->m_DrawFramework->SetPointSize( 2.0f * ( value + 1.0f ) );
            gfx->m_DrawFramework->DrawPoint(200.0f + 10.0f * value, 100.0f + 10.0f * value);        
        }
#if 0
        // R}hobt@̏ʂfobOo
        gfx->NN_LOG_CmdBufUsedSize();
#endif        
        gfx->m_DrawFramework->SwapBuffers();        
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    } 
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));
    
    // EChEj
    m_WindowManager.DestroyWindow(&m_TextWindow);
    m_WindowManager.DestroyWindow(&m_SimpleWindow);
    m_WindowManager.DestroyWindow(&m_MessageLogWindow);
}

}   // usingnamespace eva
}   // usingnamespace uji


