/*************************************************************************

  o׌̃OW\tg

 ************************************************************************/
#ifndef Collect_LOG_DATA_H_INCLUDED
#define Collect_LOG_DATA_H_INCLUDED

#include <nn.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBase.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>  // EVA_SDK_0_14_1    
#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>
#include "sys.h"
#include "../eva/wireless/CommandUtil.h"
#include "../seq/CommCamera.h" 

namespace uji{
namespace eva{
    
class CollectLogData
{
    public:
    // ֐Xg\\
    struct FuncMapping
    {
        u16  opcode;                  // IyR[hiR}hID̓X|XIDj
        char funcname[40];           // ֐
        const char* ( CollectLogData::*func )( const char * );  // ֐|C^
        char PADDING[3];
    };
    
    struct ProductLogElement
    {
        u8   testMode;
        char testerID[ 24 ];
        char testDate[ 11 ];
        char testTime[ 6 ];
    };
    
    CollectLogData() : gfx( uji::sys::GraphicsDrawing::GetInstance()),
                    m_CommWindow( 400/(FONT_SIZE/2), 160/FONT_SIZE, FONT_SIZE ),
                    m_StatWindow( 300/(FONT_SIZE/2), 220/FONT_SIZE, FONT_SIZE ),
                    m_InfoWindow( 400/(FONT_SIZE/2),  80/FONT_SIZE, FONT_SIZE ),
                    m_isBreak( false ), m_SendCommCount(0), m_RecvCommCount(0)
    {
        m_RecvCommandBuf     = new char[ MAX_COMMAND_SIZE ];
        m_SendCommandBuf = new char[ MAX_COMMAND_SIZE ];
        
        std::memset( m_RecvCommandBuf, 0x00, MAX_COMMAND_SIZE );
        std::memset( m_SendCommandBuf, 0x00, MAX_COMMAND_SIZE );
        
        m_CommSpi.Initialize( uji::seq::CommCamera::SpiType_1Mx1 );

    }
    
    ~CollectLogData()
    {
        delete[] m_RecvCommandBuf;
        delete[] m_SendCommandBuf;
        
        
    };
    
    static void ExecuteCollectLogData()
    {
        CollectLogData cd;
        cd.ExecuteCommon();
    }
    
    static const u8 FONT_SIZE        = 12;
    
    
    const char* TESTER_GetVersion( const char* arg );
    const char* TESTER_GetBuildDate( const char* arg );
    const char* TESTER_SetTime( const char* arg );
    const char* TESTER_SetTestMode( const char* arg );
    
    const char* LOG_WriteStartLog( const char* arg );
    const char* LOG_WriteOKLog( const char* arg );
    const char* LOG_WriteNGLog( const char* arg );
    const char* LOG_CheckTestProcess( const char* arg );
    const char* LOG_GetProductLogSize( const char* arg );
    const char* LOG_GetProductLogData( const char* arg );
    const char* LOG_GetInspectLogSize( const char* arg );
    const char* LOG_GetInspectLogData( const char* arg );
    
    private:
    void ExecuteCommon();
    
    void ExecuteCommandThread();
    
    static void WrappingExecuteCommandThread( void* param );
    static int GetGroupIDFromCommandID( const u16 &commID );
    bool ReceiveCommand();
    void SendCommand( const char* str );
    
    void PrintRecvCommand( const CommPack &commPack );
    void PrintSendCommand( const char* str );
    
    const char* ExecuteCommandFunction( const CommPack &commPack );
    const char* GetCommandName( const CommPack &commPack );
    
    const char* GetTwlnLogData( const wchar_t* path );
    const char* GetTwlnLogSize( const wchar_t* path );
    
    static const u8 MAX_COMMAND_SIZE = 128;
    static const u8 START_DATE_SIZE  = 11;
    static const u8 START_TIME_SIZE  = 6;
    static const u8 TESTER_ID_SIZE   = 24;
    
    
    uji::sys::GraphicsDrawing* gfx;
    
    uji::sys::TextWindow m_CommWindow;
    uji::sys::TextWindow m_StatWindow;
    uji::sys::TextWindow m_InfoWindow;
    
    uji::eva::TimeCounter m_TimeCounter;
    
    uji::seq::CommCamera  m_CommSpi;
    
    bool m_isBreak;
    
    int  m_SendCommCount;
    int  m_RecvCommCount;

    char* m_RecvCommandBuf;
    char* m_SendCommandBuf;
    //char* m_WorkBuf;
    
    ProductLogElement m_log;
};

} // namespace eva
} // namespace uji

#endif
