#include "CollectLogData.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../eva/procchk/ProcessCheck.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji::sys;

namespace uji{
namespace eva{

namespace
{
    const CollectLogData::FuncMapping FuncMap[] =
    {
        { 0x0501,   "LOG_CheckTestProcess"      ,&CollectLogData::LOG_CheckTestProcess      },
        { 0x0502,   "LOG_GetProductLogSize"     ,&CollectLogData::LOG_GetProductLogSize     },
        { 0x0503,   "LOG_GetProductLogData"     ,&CollectLogData::LOG_GetProductLogData     },
        { 0x0504,   "LOG_WriteStartLog"         ,&CollectLogData::LOG_WriteStartLog         },
        { 0x0505,   "LOG_WriteOKLog"            ,&CollectLogData::LOG_WriteOKLog            },
        { 0x0506,   "LOG_WriteNGLog"            ,&CollectLogData::LOG_WriteNGLog            },
        { 0x0507,   "LOG_GetInspectLogSize"     ,&CollectLogData::LOG_GetInspectLogSize     },
        { 0x0508,   "LOG_GetInspectLogData"     ,&CollectLogData::LOG_GetInspectLogData     },
        { 0x0901,   "TESTER_GetVersion"         ,&CollectLogData::TESTER_GetVersion         },
        { 0x0902,   "TESTER_GetBuildDate"       ,&CollectLogData::TESTER_GetBuildDate       },
        { 0x0903,   "TESTER_SetTime"            ,&CollectLogData::TESTER_SetTime            },
        { 0x0904,   "TESTER_SetTestMode"        ,&CollectLogData::TESTER_SetTestMode        },
    };

}

void CollectLogData::ExecuteCommon()
{
    nn::os::Thread execCommThread;
    execCommThread.StartUsingAutoStack( WrappingExecuteCommandThread, this, 4096, nn::os::DEFAULT_THREAD_PRIORITY - 1 );


    uji::sys::WindowManager windowManager;

    m_CommWindow.SetTitle("Command  ( Press L+R : Clear )");
    m_StatWindow.SetTitle("CollectLog Status");
    m_InfoWindow.SetTitle("CollectLog Info");


    windowManager.CreateWindow( &m_CommWindow, NN_GX_DISPLAY0, 0, 0 );
    windowManager.CreateWindow( &m_StatWindow, NN_GX_DISPLAY1, 0, 0 );
    windowManager.CreateWindow( &m_InfoWindow, NN_GX_DISPLAY0, 0, 160 );

    m_TimeCounter.InitTime();
    while( true )
    {
        Pad().UpdatePad();
        if( Pad().IsButtonPress( Pad::BUTTON_L ) && Pad().IsButtonPress( Pad::BUTTON_R ) && Pad().IsButtonPress( Pad::BUTTON_START ))
        {
            m_isBreak = true;
            break;
        }

        if( Pad().IsButtonPress( Pad::BUTTON_DOWN ) && Pad().IsButtonPress( Pad::BUTTON_A ))
        {

        }

        if( Pad().IsButtonPress( Pad::BUTTON_DOWN ) && Pad().IsButtonPress( Pad::BUTTON_B ))
        {

        }
        if( Pad().IsButtonPress( Pad::BUTTON_L ) && Pad().IsButtonPress( Pad::BUTTON_R ) )
        {
            m_CommWindow.Printf("\f");
            m_StatWindow.Printf("\f");

        }
        m_InfoWindow.Printf("\f");
        m_InfoWindow.Printf("CTR_CollectLogData Ver:%s     ( %s )\n", VERSION_STRING, VERSION_DATE );
        m_InfoWindow.Printf("TimeCount  = %s         ",
                   CommandUtil::ConvertStringFromTimeSpan( m_TimeCounter.GetTimeSpan()));

        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        windowManager.Update();
        windowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        gfx->m_DrawFramework->Clear();
        windowManager.Update();
        windowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    }
    execCommThread.Join();
    execCommThread.Finalize();
}

//------------------------------------------------------------------------------
// o֐XbhƂċN邽߂̃bp[
//------------------------------------------------------------------------------
void CollectLogData::WrappingExecuteCommandThread( void* param )
{
    CollectLogData* pCLD = reinterpret_cast< CollectLogData* >( param );
    pCLD->ExecuteCommandThread();
}


//------------------------------------------------------------------------------
// R}h猟NXbhB
//------------------------------------------------------------------------------
void CollectLogData::ExecuteCommandThread()
{

    CommPack commPack;
    NN_LOG("ExecuteCommandThread\n");

    const char CHECKSUM_ERROR_COMMAND[] = "0000000000";

    while( !m_isBreak )
    {
        if( ReceiveCommand() ) // R}hMmF
        {
            if( !CommandUtil::isCorrectCheckSum( m_RecvCommandBuf, std::strlen( m_RecvCommandBuf )))
            {
                NN_LOG("CheckSum Error!\n");
                m_StatWindow.Printf("%02x: Command CheckSum Error!\n", m_RecvCommCount - 1 );

                commPack = CommandUtil::AnalysisCommand( CHECKSUM_ERROR_COMMAND );

                const char* RSCStr = CommandUtil::CreateResponseString( commPack,
                                                  CommandUtil::CreateRSCAndResponseArgString( CommandUtil::CHECKSUM ));
                SendCommand( RSCStr );
                continue;
            }

            commPack = CommandUtil::AnalysisCommand( m_RecvCommandBuf );
            PrintRecvCommand( commPack );
            const char* RSCStr = CommandUtil::CreateResponseString( commPack, ExecuteCommandFunction( commPack ));
            SendCommand( RSCStr );
            PrintSendCommand( RSCStr );
        }else
        {
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMicroSeconds(1000));
        }
    }
}

//------------------------------------------------------------------------------
// R}h̑M֐
//------------------------------------------------------------------------------
void CollectLogData::SendCommand( const char* str )
{
    u32 w_Count;

    COMMAND_SEND_RETRY :  // obt@ɋ󂫂Ȃꍇ͂烊gC
    w_Count = m_CommSpi.GetWriteFifoCount();

    // FIFŐ󂫂0x0FFF-0x0F38=200Byteȏ㖳ꍇ͋󂭂܂ő҂B
    if( w_Count >= 0x0F38 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));
        goto COMMAND_SEND_RETRY;
    }

    m_CommSpi.WriteFifo( reinterpret_cast< const u8* >( str ), std::strlen( str ));
    m_CommWindow.SetTextColor( ATTR_COLOR_YELLOW );
    m_CommWindow.Printf("->%02x: ", m_SendCommCount );
    m_SendCommCount++;
}



//------------------------------------------------------------------------------
// f[^MBf[^FIFOɂȂꍇfalseԂ
//------------------------------------------------------------------------------
bool CollectLogData::ReceiveCommand()
{
    u32 r_Count = 0;

    r_Count = m_CommSpi.GetReadFifoCount();
    // R}h10(ŏR}h)Zꍇ͒Ȃ܂ő҂
    if( r_Count < 10 )
    {
        return false;
    }
    
    // FIFOɃR}h܂Ăꍇ́AÖׂxԂuĂǂ݂Ȃ
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));
    r_Count = m_CommSpi.GetReadFifoCount();

    // ۂFifoǂݏoAeʂɕ\
    std::memset( m_RecvCommandBuf, 0x00, MAX_COMMAND_SIZE );
    m_CommSpi.ReadFifo( reinterpret_cast< u8* >( m_RecvCommandBuf ), r_Count );

    m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
    m_CommWindow.Printf("  %02x: ", m_RecvCommCount );

    // R}hǂݍ݃tOZbgAR}hJEg𑝂₷
    m_RecvCommCount++;
    return true;

}




//------------------------------------------------------------------------------
// R}hpPbg猟֐sAԂlԂ
//------------------------------------------------------------------------------
const char* CollectLogData::ExecuteCommandFunction( const CommPack &commPack )
{
    int gID = GetGroupIDFromCommandID( commPack.CommID );
    if( gID < 0 )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    else
    {
        return ( this->*( FuncMap[ gID ].func ))( commPack.Arg );
    }
}

//------------------------------------------------------------------------------
// R}hpPbg猟֐Ԃ
//------------------------------------------------------------------------------
const char* CollectLogData::GetCommandName( const CommPack &commPack )
{
    int gID = GetGroupIDFromCommandID( commPack.CommID );
    if( gID < 0 )
    {
        return "No Command";
    }
    else
    {
        return FuncMap[ gID ].funcname;
    }
}

//------------------------------------------------------------------------------
// R}hpPbgCommIĎ̔ԍԂ
//------------------------------------------------------------------------------
int CollectLogData::GetGroupIDFromCommandID( const u16 &commID )
{
    int groupID;
    u32 max_GroupID = ( sizeof( FuncMap ) / sizeof( FuncMap[0] ));

    for( groupID = 0; groupID <= max_GroupID; groupID++ )
    {
        if( commID == FuncMap[ groupID ].opcode )
        {
            return groupID;
        }
    }
    NN_LOG("Bad Return! %d\n", __LINE__);
    const int ERROR_NUMBER = -1;
    return ERROR_NUMBER;
}

void CollectLogData::PrintRecvCommand( const CommPack &commPack )
{
    m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
    m_CommWindow.Printf( "%s Arg = %s\n", GetCommandName( commPack ), commPack.Arg );
    m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
}


void CollectLogData::PrintSendCommand( const char* str )
{
    const int MAX_PRINT_BUF = 100;
    char PrintBuf[ MAX_PRINT_BUF ] = "";

    std::memcpy( PrintBuf, &str[0], 4 );
    m_CommWindow.SetTextColor( ATTR_COLOR_GREEN );
    m_CommWindow.Printf( PrintBuf );
    std::memset( PrintBuf, 0x00, 4 );

    std::memcpy( PrintBuf, &str[4], 4 );
    m_CommWindow.SetTextColor( ATTR_COLOR_YELLOW );
    m_CommWindow.Printf( PrintBuf );
    std::memset( PrintBuf, 0x00, 4 );

    std::memcpy( PrintBuf, &str[8], 2 );
    m_CommWindow.SetTextColor( ATTR_COLOR_GREEN );
    m_CommWindow.Printf( PrintBuf );
    std::memset( PrintBuf, 0x00, 2 );

    if( str[10] == '0' && str[11] == '0' )
    {
        m_CommWindow.SetTextColor( ATTR_COLOR_BLUE );
    }else
    {
        m_CommWindow.SetTextColor( ATTR_COLOR_RED );
    }
    std::memcpy( PrintBuf, &str[10], 2 );
    m_CommWindow.Printf( PrintBuf );
    m_CommWindow.SetTextColor( ATTR_COLOR_YELLOW );
    m_CommWindow.Printf( "%s\n", &str[12]);
}

//------------------------------------------------------------------------------
// Desc   FiOpjJnԐݒ
// Arg    FJn
// Return FȂ
//------------------------------------------------------------------------------
const char* CollectLogData::TESTER_SetTime( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    const u8 DATA_AND_TIME_LEN = 16;

    if( std::strlen( arg ) != DATA_AND_TIME_LEN )  // ̒̂e
    {
        m_StatWindow.Printf("Argument Length Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    const u8 SEPARATOR_POSITION = 10;

    if( arg[ SEPARATOR_POSITION ] != '#' )  // ̔ẑe
    {
        m_StatWindow.Printf("Argument Format Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    const u8 DATE_NUM   = 10;
    const u8 TIME_START = 11;
    const u8 TIME_NUM   = 5;

    std::memset( m_log.testDate, 0x00, sizeof( m_log.testDate ));
    std::memset( m_log.testTime, 0x00 ,sizeof( m_log.testTime ));

    std::memcpy( m_log.testDate, &arg[0], DATE_NUM );
    std::memcpy( m_log.testTime, &arg[ TIME_START ], TIME_NUM );

    NN_LOG("TestDate = %s\n", m_log.testDate );
    NN_LOG("TestTime = %s\n", m_log.testTime );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FiOpj[hݒ
// Arg    F[h
// Return FȂ
//------------------------------------------------------------------------------
const char* CollectLogData::TESTER_SetTestMode( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    const u8 SEPARATOR_POSITION = 1;
    if( '#' != arg[ SEPARATOR_POSITION ])
    {
        m_StatWindow.Printf("Argument Format Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    m_log.testMode = CommandUtil::ConvertNumFromString( arg, 1 );

    const u8 TESTER_ID_START  = 2;
    const u8 TESTER_ID_LENGTH = 6;

    std::memset( m_log.testerID, 0x00, sizeof( m_log.testerID ));

    std::memcpy( m_log.testerID, &arg[ TESTER_ID_START ], TESTER_ID_LENGTH );

    NN_LOG("TestMode = %d TesterID = %s\n", m_log.testMode, m_log.testerID );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FiOpjJnO
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* CollectLogData::LOG_WriteStartLog( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    // O

    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog;
    pdl->Initialize();
    if( 0 <= pdl->Add_1Line( m_log.testMode, "Collect", "START", VERSION_STRING, m_log.testDate, m_log.testTime, m_log.testerID, arg ))
    {
        pdl->Finalize();
        delete pdl;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        pdl->Finalize();
        delete pdl;
        m_StatWindow.Printf("Write Log Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }


}
//------------------------------------------------------------------------------
// Desc   FiOpjOKO
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* CollectLogData::LOG_WriteOKLog( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );



    const u8 LOG_MESSAGE_MAX = 80;
    char logMessage[ LOG_MESSAGE_MAX ] = "";


    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog;
    pdl->Initialize();
    if( 0 <= pdl->Add_1Line( m_log.testMode, "Collect", "OK", VERSION_STRING, m_log.testDate, m_log.testTime, m_log.testerID, logMessage ))
    {
        pdl->Finalize();
        delete pdl;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        pdl->Finalize();
        delete pdl;
        m_StatWindow.Printf("Write Log Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

}
//------------------------------------------------------------------------------
// Desc   FiOpjNGR[h
// Arg    FNGR[h
// Return FȂ
//------------------------------------------------------------------------------
const char* CollectLogData::LOG_WriteNGLog( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog;
    pdl->Initialize();
    if( 0<= pdl->Add_1Line( m_log.testMode, "Collect", "NG", VERSION_STRING, m_log.testDate, m_log.testTime, m_log.testerID, arg ))
    {
        pdl->Finalize();
        delete pdl;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        pdl->Finalize();
        delete pdl;
        m_StatWindow.Printf("WriteLog Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }




}

//------------------------------------------------------------------------------
// Desc   FvÕo[W擾
// Arg    FȂ
// Return FvOo[W
//------------------------------------------------------------------------------
const char* CollectLogData::TESTER_GetVersion( const char* arg )
{
    NN_UNUSED_VAR( arg )

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, VERSION_STRING );
}
//------------------------------------------------------------------------------
// Desc   FvÕrh擾
// Arg    FȂ
// Return FvÕrh
//------------------------------------------------------------------------------
const char* CollectLogData::TESTER_GetBuildDate( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, VERSION_DATE );
}

//------------------------------------------------------------------------------
// Desc   FLOG_GetProductLogSize
// Arg    FȂ
// Return Fproduct.log̃TCY
//------------------------------------------------------------------------------
const char* CollectLogData::LOG_GetProductLogSize( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    const wchar_t PRODUCT_LOG_PATH[] = L"twln:/sys/log/product.log";
    return GetTwlnLogSize( PRODUCT_LOG_PATH );
}

//------------------------------------------------------------------------------
// Desc   FLOG_GetProductLogData
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* CollectLogData::LOG_GetProductLogData( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    const wchar_t PRODUCT_LOG_PATH[] = L"twln:/sys/log/product.log";
    return GetTwlnLogData( PRODUCT_LOG_PATH );
}

//------------------------------------------------------------------------------
// Desc   FLOG_GetInspectLogSize
// Arg    FȂ
// Return Finspect.log̃TCY
//------------------------------------------------------------------------------
const char* CollectLogData::LOG_GetInspectLogSize( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    const wchar_t PRODUCT_LOG_PATH[] = L"twln:/sys/log/inspect.log";
    return GetTwlnLogSize( PRODUCT_LOG_PATH );
}

//------------------------------------------------------------------------------
// Desc   FLOG_GetInspectLogData
// Arg    FȂ
// Return Finspect.log̃TCY
//------------------------------------------------------------------------------
const char* CollectLogData::LOG_GetInspectLogData( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    const wchar_t PRODUCT_LOG_PATH[] = L"twln:/sys/log/inspect.log";
    return GetTwlnLogData( PRODUCT_LOG_PATH );
}

//------------------------------------------------------------------------------
// Desc   FLOG_CheckTestProcess
// Arg    FȂ
// Return F`FbN̐
//------------------------------------------------------------------------------

const char* CollectLogData::LOG_CheckTestProcess( const char* arg )
{
    NN_UNUSED_VAR( arg );

    uji::seq::TestResult result;

    uji::eva::procchk::ProcessCheck pc;
    pc.LogCheck_LastProcessIsProcCheck( result );

    if( result.m_Result )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
}

//------------------------------------------------------------------------------
// TWLA[JCü̃pX̃t@C̃TCYԂB
//------------------------------------------------------------------------------
const char* CollectLogData::GetTwlnLogSize( const wchar_t* path )
{
    nn::fs::MountSpecialArchive("twln:", nn::fs::CTR::ARCHIVE_TYPE_TWL_NAND );
    nn::fs::FileInputStream fs;

    nn::Result result;

    result = fs.TryInitialize( path );

    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("FS Initialize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    s64 fileSize;

    result = fs.TryGetSize( &fileSize );
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("FS GetSize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    fs.Finalize();
    nn::fs::Unmount( "twln:" );

    static char ReturnSizeStr[10];

    std::sprintf( ReturnSizeStr, "%llX", fileSize );


    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, ReturnSizeStr );
}

//------------------------------------------------------------------------------
// TWLA[JCü̃pX̃t@CFIFO_DɑB
//------------------------------------------------------------------------------
const char* CollectLogData::GetTwlnLogData( const wchar_t* path )
{
    nn::fs::MountSpecialArchive("twln:", nn::fs::CTR::ARCHIVE_TYPE_TWL_NAND );
    nn::fs::FileInputStream fs;

    nn::Result result;

    result = fs.TryInitialize( path );

    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("FS Initialize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    s64 fileSize;
    s32 readSize;

    result = fs.TryGetSize( &fileSize );
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("FS GetSize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    u8* logOpenBuf = new u8[ 16*1024 + 1 ];
    if( logOpenBuf == NULL )
    {
        m_StatWindow.Printf("Memory Allocate Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    result = fs.TryRead( &readSize, logOpenBuf, fileSize );
    if( result.IsFailure())
    {
        NN_LOG("Read Failed\n");
        m_StatWindow.Printf("File Read Error\n");
        nn::dbg::PrintResult( result );

    }

    if( readSize != fileSize )
    {
        m_StatWindow.Printf("ReadSize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    fs.Finalize();
    nn::fs::Unmount( "twln:" );

    u8* sendPointer = logOpenBuf;
    u32 transSize;
    u32 fifoCount;

    u32 residualQuantity = readSize;

    fifoCount = m_CommSpi.GetDataFifoCount();
    transSize = uji::seq::CommCamera::FIFO_SIZE - fifoCount;


    while( residualQuantity != 0 )
    {
        //̓]ʌ
        fifoCount = m_CommSpi.GetDataFifoCount();
        transSize = uji::seq::CommCamera::FIFO_SIZE - fifoCount;

        //]Pʂ16oCgPʂɂ
        transSize = transSize & 0xfff0;
        if( transSize > residualQuantity )
        {
            transSize = residualQuantity; //Ō̓]ʍ킹
        }
        //]
        if( transSize != 0 )
        {
            m_CommSpi.WriteDataFifo( sendPointer, transSize );
            sendPointer += transSize;
            residualQuantity -= transSize;
        }
    }
    
    delete[] logOpenBuf;
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

} // namespace eva
} // namespace uji
