
#ifndef _UJI_TESTCODEC_H_
#define _UJI_TESTCODEC_H_


#include <nn.h>
#include <string>
#include <nn/codec.h>
#include <nn/codec/CTR/codec_HardwareCheck.h>
#include <nn/hid/CTR/hid_AnalogStickCalibrator.h>
#include <nn/hid/CTR/hid_TouchPanelCalibrator.h>
#include "sys.h"
#include "../seq/TestResult.h" 

using namespace std;

namespace uji {
namespace eva {
namespace codec {

    extern bool TestGetCodecVer(uji::seq::TestResult &result);
    extern bool TestAnalogKey(uji::seq::TestResult &result);
    extern bool TestTouchPanel(uji::seq::TestResult &result);

    enum CodecClassGroup
    {
        HID     = 0,
        Mic     = 1,
        Csnd    = 2,
        Dsp     = 3,
        Lgy     = 4,
        Check   = 5
    };

// codec APIeXgpNX
class TestCodec
{
public:
    TestCodec(){}
    virtual ~TestCodec(){}
    
    nn::Result InitializeCodecGroup(nn::Handle* pSession, u8 group);
    nn::Result FinalizeCodecGroup(nn::Handle* pSession, u8 group);
    void TestInitializeCommon();
    void TestReadMultiEx_SPI1_VendorId();
    void TestReadMultiEx_SPI2_VendorId();
    void TestReadMultiEx_SPI1_RevisionId();
    void TestReadMultiEx_SPI2_RevisionId();
    void TestReadMultiEx_SPI2_MicPgaGainCalibration();
    void TestWriteMultiEx_SPI2_MicPgaGainCalibration(u8* setMicPgaGainCalibration);
    void TestSetVolumeSetting(u8* setVolumeSetting);
    void TestSetLeftVolume(u8* setLeftVolume);
    void TestSetRightVolume(u8* setRightVolume);
    f32 ConvCalibGainHexToF32(u8 hex_gain);
    u8  ConvCalibGainF32ToHex(f32 f32_gain);
    
    u8 m_VendorId;
    u8 m_RevisionId;
    
    u8 m_VendorId_SPI1;
    u8 m_VendorId_SPI2;
    u8 m_RevisionId_SPI1;
    u8 m_RevisionId_SPI2;
    u8 m_MicPgaGainCalibration_SPI2;
    
private:
};


}   // namespace codec
}   // namespace eva
}   // namespace uji

/* _UJI_TESTCODEC_H_ */
#endif

