

#include "sys_GraphicsDrawing.h"
#include "TestCodec.h"

using namespace uji::sys;

namespace uji {
namespace eva {

static sys::WindowManager s_WindowManager;

/*---------------------------------------------------------------------------
  Desc: CODEC ̃WX^̓ǂݍ݊mFiHardwareCheckNXmFj
---------------------------------------------------------------------------*/
void EvaReadMultiEx_SPI2()
{
    nn::Result result;
    string strLog = "";
    string strError = "";
    uji::sys::Pad pad;
    nn::Handle session;
    
    codec::TestCodec* pTc = new codec::TestCodec;
    
    // 
    pTc->TestInitializeCommon();
    nn::codec::CTR::HardwareCheck hc(session);
    
    const u8 SIZE = 50;
    const u8 len  = 4;
    u8 buf[SIZE] = "";
    
    /*-----------------------------------------------
       read
     -----------------------------------------------*/
    // read (36`39)
    result = hc.ReadMultiEx_SPI2( 1, 36, buf, len );
    if (result.IsFailure())
    {
        strError += "Fail to read buf!";
    }
    else
    {
        strError += "Success.";
        for(int i=0; i<len; ++i)
        {
            char bufAscii[9];
            sprintf(bufAscii, "[3%d]%2X ", i+6, buf[i]);
            strLog += static_cast<string>(bufAscii);
        }
    }
    
    NN_LOG("------------------------------------------------\n");
    NN_LOG("Resistor Read by SPI2(Page1.36-39)\n");
    NN_LOG("%s\n", strError.c_str());
    NN_LOG("%s\n", strLog.c_str());
    NN_LOG("------------------------------------------------\n");
    
    do
    {
        pad.UpdatePad();
        
        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     Read by SPI2(Page1.36-39)\n");
        Menu::m_SubWindow->Printf("     %s\n", strError.c_str());
        Menu::m_SubWindow->Printf("     %s\n", strLog.c_str());
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        
        sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
    
    
    // I
    result = pTc->FinalizeCodecGroup(&session, codec::Check);
    delete pTc;
}

/*---------------------------------------------------------------------------
  Desc: CODEC ̃WX^̏݊mFiHardwareCheckNXmFj
---------------------------------------------------------------------------*/
void EvaWriteMultiEx_SPI2()
{
    nn::Result result;
    string strError = "";
    uji::sys::Pad pad;
    nn::Handle session;
    
    codec::TestCodec* pTc = new codec::TestCodec;
    
    // 
    pTc->TestInitializeCommon();
    //result = pTc->InitializeCodecGroup(&session, codec::Check);
    nn::codec::CTR::HardwareCheck hc(session);
    
    const u8 SIZE = 50;
    const u8 len  = 4;
    u8 buf[SIZE] = "TEST";
    
    /*-----------------------------------------------
       write (36`39)
     -----------------------------------------------*/
    result = hc.WriteMultiEx_SPI2( 1, 36, buf, len );
    if (result.IsFailure())
    {
        strError += "Fail to write buf!";
    }
    else
    {
        strError += "Success(Write'TEST').";
    }
    
    NN_LOG("------------------------------------------------\n");
    NN_LOG("Resistor Write by SPI2(Page1.36-39)\n");
    NN_LOG("%s\n", strError.c_str());
    NN_LOG("------------------------------------------------\n");
    
    do
    {
        pad.UpdatePad();
        
        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     Write by SPI2(Page1.36-39)\n");
        Menu::m_SubWindow->Printf("     %s\n", strError.c_str());
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        
        sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
    
    
    // I
    result = pTc->FinalizeCodecGroup(&session, codec::Check);
    delete pTc;
}

/*---------------------------------------------------------------------------
  Desc: codeco[Wix_[ID, rWIDj̓Ǎ݃eXg
---------------------------------------------------------------------------*/
void EvaReadMultiEx_SPI1SPI2_CodecID()
{
    codec::TestCodec* pTc = new codec::TestCodec;
    uji::sys::Pad pad;
    
    const int NUM = 4;
    u8 codecVer[NUM];
    
    pTc->TestReadMultiEx_SPI1_VendorId();
    pTc->TestReadMultiEx_SPI2_VendorId();
    pTc->TestReadMultiEx_SPI1_RevisionId();
    pTc->TestReadMultiEx_SPI2_RevisionId();
    
    codecVer[0] = pTc->m_VendorId_SPI1;
    codecVer[1] = pTc->m_VendorId_SPI2;
    codecVer[2] = pTc->m_RevisionId_SPI1;
    codecVer[3] = pTc->m_RevisionId_SPI2;
    
    for(int i=0; i<NUM; ++i)
    {
    	NN_LOG("%d: %3x, %3d\n", i, codecVer[i], codecVer[i]);
    }
    do
    {
        pad.UpdatePad();
        
        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("                 SPI1  SPI2\n");
        Menu::m_SubWindow->Printf("     VendorID  :  %02X    %02X\n", codecVer[1], codecVer[0]);
        Menu::m_SubWindow->Printf("     RevisionID:  %02X    %02X\n", codecVer[3], codecVer[2]);
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        
        sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
    
    
    delete pTc;
}

/*---------------------------------------------------------------------------
  Desc: j[
---------------------------------------------------------------------------*/
void OpenCodecMenu()
{
    sys::ClassMenu *m = new sys::ClassMenu( "Codec Test Menu" );
    
    m->Add( " RegRead  by SPI2(Page1.36-39) ", EvaReadMultiEx_SPI2);
    m->Add( " RegWrite by SPI2(Page1.36-39)", EvaWriteMultiEx_SPI2);
    m->Add( " RegRead  by SPI1/2(VID/RID)   ", EvaReadMultiEx_SPI1SPI2_CodecID);
    m->Open();
    
    delete m;
    
    /*  L̕@Ńj[쐬\(2010.07.14)
    
    TestCodec * tc = new TestCodec;
    
    m->Add<TestCodec>( " AnalogStick Test ", tc, &TestCodec::TestAnalogInterfaceData, NULL );
    m->Add<TestCodec>( " RegR/W SPI2(LOG) ", tc, &TestCodec::TestRWMultiEx_SPI2, NULL );
    
    delete tc;
    
    */
}

} // namespace eva
} // namespace uji

