/*---------------------------------------------------------------------------*
  Project:  CTR_UJI
  File:     EvaCardSpi.h

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#ifndef EVA_CARDSPI_H_
#define EVA_CARDSPI_H_

#include "sys.h"

using namespace std;

namespace uji{
namespace eva{

class EvaCARDSPI
{
public:
	EvaCARDSPI(){}

	void OpenMenu();
	
	void TestRead(wchar_t* path);
	void TestWrite(wchar_t* path);

	// Read 1bit[h
	void Read_512k_1bit(void);
	void Read_1M_1bit(void);
	void Read_2M_1bit(void);
	void Read_4M_1bit(void);		
	void Read_8M_1bit(void);
	void Read_16M_1bit(void);	

	// Read 4bit[h
	void Read_512k_4bit(void);
	void Read_1M_4bit(void);
	void Read_2M_4bit(void);
	void Read_4M_4bit(void);	
	void Read_8M_4bit(void);
	void Read_16M_4bit(void);
	
	// Write 1bit[h
	void Write_512k_1bit(void);
	void Write_1M_1bit(void);
	void Write_2M_1bit(void);
	void Write_4M_1bit(void);		
	void Write_8M_1bit(void);
	void Write_16M_1bit(void);
	
	// _~[
	void Test();	
};

} // namespace eva
} // namespace uji
#endif
