/*---------------------------------------------------------------------------*
  Project:  CTR_UJI
  File:     EvaCardSpi.cpp

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#include "EvaCardSpi.h"

using namespace uji::sys;

namespace uji{
namespace eva{

#define BUF_SIZE (512)
u8 gBuffer[BUF_SIZE];

//------------------------------------------------
// cardspi̕]j[
//------------------------------------------------
void EvaCARDSPI::OpenMenu()
{
    ClassMenu *m = new ClassMenu( "CARDSPI Menu" );

    m->SetColumn(2);
       
//    m->Add<EvaCARDSPI>("Dummy         "        ,this, &EvaCARDSPI::Test);      
    m->Add<EvaCARDSPI>("Read 512KHz 1bit"      ,this, &EvaCARDSPI::Read_512k_1bit);    
    m->Add<EvaCARDSPI>("Read 1MHz 1bit"        ,this, &EvaCARDSPI::Read_1M_1bit);
    m->Add<EvaCARDSPI>("Read 2MHz 1bit"        ,this, &EvaCARDSPI::Read_2M_1bit);    
    m->Add<EvaCARDSPI>("Read 4MHz 1bit"        ,this, &EvaCARDSPI::Read_4M_1bit);    
    m->Add<EvaCARDSPI>("Read 8MHz 1bit"        ,this, &EvaCARDSPI::Read_8M_1bit);    
    m->Add<EvaCARDSPI>("Read 16MHz 1bit"       ,this, &EvaCARDSPI::Read_16M_1bit);
    m->Add<EvaCARDSPI>("Read 512KHz 4bit"      ,this, &EvaCARDSPI::Read_512k_4bit);    
    m->Add<EvaCARDSPI>("Read 1MHz 4bit"        ,this, &EvaCARDSPI::Read_1M_4bit);
    m->Add<EvaCARDSPI>("Read 2MHz 4bit"        ,this, &EvaCARDSPI::Read_2M_4bit);    
    m->Add<EvaCARDSPI>("Read 4MHz 4bit"        ,this, &EvaCARDSPI::Read_4M_4bit);    
    m->Add<EvaCARDSPI>("Read 8MHz 4bit"        ,this, &EvaCARDSPI::Read_8M_4bit);    
    m->Add<EvaCARDSPI>("Read 16MHz 4bit"       ,this, &EvaCARDSPI::Read_16M_4bit);       
    m->Add<EvaCARDSPI>("Write 512KHz 1bit"     ,this, &EvaCARDSPI::Write_512k_1bit);    
    m->Add<EvaCARDSPI>("Write 1MHz 1bit"       ,this, &EvaCARDSPI::Write_1M_1bit);
    m->Add<EvaCARDSPI>("Write 2MHz 1bit"       ,this, &EvaCARDSPI::Write_2M_1bit);    
    m->Add<EvaCARDSPI>("Write 4MHz 1bit"       ,this, &EvaCARDSPI::Write_4M_1bit);    
    m->Add<EvaCARDSPI>("Write 8MHz 1bit"       ,this, &EvaCARDSPI::Write_8M_1bit);    
    m->Add<EvaCARDSPI>("Write 16MHz 1bit"      ,this, &EvaCARDSPI::Write_16M_1bit);    
    m->Open();
    
    delete m;
}

//------------------------------------------------------------------
// RA֐
//------------------------------------------------------------------
void EvaCARDSPI::TestRead(wchar_t* path)
{
    nn::fs::FileStream in;
    s32 readByte;
    
    in.Initialize(path, NULL);
    in.SetPosition(0x1234);
    readByte = in.Read(gBuffer, BUF_SIZE);
    NN_LOG("readByte : %d bytes\n", readByte);
    for(int i = 0; i < BUF_SIZE; i++)
    {
        NN_LOG(" %02X", gBuffer[i]);
        if(i % 32 == 31) NN_LOG("\n");
    }
    in.Finalize();
}

void EvaCARDSPI::TestWrite(wchar_t* path)
{
    nn::fs::FileStream out;
    s32 writtenByte;
    
    out.Initialize(path, NULL);
    out.SetPosition(0x5678);
    
    // f[^̍쐬
    memset(gBuffer, 0x5A, BUF_SIZE);
    
    
    writtenByte = out.Write(gBuffer, BUF_SIZE);
    NN_LOG("writtenByte : %d\n", writtenByte);
}

//------------------------------------------------
// Read 1bit
//------------------------------------------------
void EvaCARDSPI::Read_512k_1bit(void)
{
	TestRead( L"cardspi:/512KHz_1xIO.bin");
}
void EvaCARDSPI::Read_1M_1bit(void)
{
	TestRead( L"cardspi:/1MHz_1xIO.bin");
}
void EvaCARDSPI::Read_2M_1bit(void)
{
	TestRead( L"cardspi:/2MHz_1xIO.bin");
}
void EvaCARDSPI::Read_4M_1bit(void)
{
	TestRead( L"cardspi:/4MHz_1xIO.bin");
}
void EvaCARDSPI::Read_8M_1bit(void)
{
	TestRead( L"cardspi:/8MHz_1xIO.bin");
}
void EvaCARDSPI::Read_16M_1bit(void)
{
	TestRead( L"cardspi:/16MHz_1xIO.bin");
}

//------------------------------------------------
// Read 4bit
//------------------------------------------------
void EvaCARDSPI::Read_512k_4bit(void)
{
	TestRead( L"cardspi:/512KHz_4xIO.bin");
}
void EvaCARDSPI::Read_1M_4bit(void)
{
	TestRead( L"cardspi:/1MHz_4xIO.bin");
}
void EvaCARDSPI::Read_2M_4bit(void)
{
	TestRead( L"cardspi:/2MHz_4xIO.bin");
}
void EvaCARDSPI::Read_4M_4bit(void)
{
	TestRead( L"cardspi:/4MHz_4xIO.bin");
}
void EvaCARDSPI::Read_8M_4bit(void)
{
	TestRead( L"cardspi:/8MHz_4xIO.bin");
}
void EvaCARDSPI::Read_16M_4bit(void)
{
	TestRead( L"cardspi:/16MHz_4xIO.bin");
}

//------------------------------------------------
// Write 1bit
//------------------------------------------------
void EvaCARDSPI::Write_512k_1bit(void)
{
	TestWrite( L"cardspi:/512KHz_1xIO.bin");
}
void EvaCARDSPI::Write_1M_1bit(void)
{
	TestWrite( L"cardspi:/1MHz_1xIO.bin");
}
void EvaCARDSPI::Write_2M_1bit(void)
{
	TestWrite( L"cardspi:/2MHz_1xIO.bin");
}
void EvaCARDSPI::Write_4M_1bit(void)
{
	TestWrite( L"cardspi:/4MHz_1xIO.bin");
}
void EvaCARDSPI::Write_8M_1bit(void)
{
	TestWrite( L"cardspi:/8MHz_1xIO.bin");
}
void EvaCARDSPI::Write_16M_1bit(void)
{
	TestWrite( L"cardspi:/16MHz_1xIO.bin");
}

//------------------------------------------------
// _~[
//------------------------------------------------
void EvaCARDSPI::Test()
{
	NN_LOG("test\n");	
}

} // namespace eva
} // namespace uji
