

/*--------------------------------------------------------------------------*
 Project:
 File: CardTestList.cpp
 
*--------------------------------------------------------------------------*/

#include "CardTest.h"
#include "CardTestList.h"
#include "../seq/TestResult.h"
#include "../rom/rom_ReadTest.h"
#include "../spiflash/SPIFlash.h"
#include "../card/CardTestDefine.h"
#include <stdlib.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#ifndef CARD_SDK_13_2
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>  // EVA_SDK_0_14_1
#include <nn/ctst/ctst_Api.h>
#include <nn/pl/pl_Result.h>
#include <nn\pl\CTR\pl_Version.h>
#include <nn\pl\CTR\pl_SharedDataTitleId.h>
#endif

#define DATA_1M_BIT      128*1024		// 128K Byte
#define DATA_4M_BIT      512*1024		// 512K Byte
#define TMP_SIZE  256


using namespace nn::dbg::detail;		// Printfp
using namespace uji::eva::spi;



namespace uji {
namespace eva {
namespace card {

static s32 IniStrCompareStr(char *str, char list[][TMP_SIZE], u32 * list_num);
static s32 PrepareToTest1( void );
static s32 PrepareToTest2( void );
static s32 PrepareToTest3( void );
static s32 FinishToTest1( void );
static s32 FinishToTest2( void );
static s32 FinishToTest3( void );





//=================================================================================================================================================
//  R}hIDɏ]Aes֐
//=================================================================================================================================================
s32 CardTestList( SpiCommand* seq_command, SpiResponse* response )
{
	
	char str_response[TMP_SIZE];
	s32 result;
	int field;
	int rom_size;
	char str_uniqueID[65];
	int deviceID;
	char initialcode[8];
	u32  checksum;
	char version[32];
	u32 speed;
	char tmp_str[TMP_SIZE];
	char  str_arg[5][TMP_SIZE];	// 
	u32   arg_num = 0;
	u32 device_status = 0;
	char str_err[128];
	
	memset(str_response, 0x00, TMP_SIZE);
	memset(str_uniqueID, 0x00, sizeof(str_uniqueID));
	memset(tmp_str, 0x00, sizeof(tmp_str));
	memset(str_err, 0x00, sizeof(str_err));
	
	
	switch( seq_command->id )
	{

		case 0x0001:
			result = PrepareToTest1();
			break;

		case 0x0002:
			result = PrepareToTest2();
			break;

		case 0x0003:
			result = PrepareToTest3();
			break;
		
		// ROM`FbNTZ
		// :̈(0`127)
		// X|X1:  X|X2:j[NID
		case 0x0101:
		// `FbNTZ					 NANDJ[h
		case  0x0301:
		
			strcpy(tmp_str, seq_command->str_arg);

			// ***=****,****,****,****,****,****,**** ̌`ŏĂ镶񂩂A
			//u=v̌̕****P̂܂܈listɊi[
			IniStrCompareStr(tmp_str, str_arg, &arg_num);
			
			// 16iɕϊ
			field = strtol(str_arg[0], NULL, 16);
//			field = atoi(str_arg[0]);
			if( field < 0 || 127 < field )
			{
				result = 1;
				sprintf(str_response, "F:%s[%s]", str_arg[0], seq_command->str_arg);
				break;
			}

			rom_size = strtol(str_arg[1], NULL, 16);
			if( rom_size <= 0 )
			{
				result = 2;
//				sprintf(str_response, "S:[%s][%s][%s][%s][%s][%s]", str_arg[0], str_arg[1], seq_command->str_check_sum, seq_command->str_id, seq_command->str_arg_num, seq_command->str_arg );
				sprintf(str_response, "S:%s[%s]", str_arg[0], str_arg[1]);
				Printf( "\n 0x0101 arg:%d(%s) size:%d(%s)\n", field, str_arg[0], rom_size, str_arg[1]);
				break;
			}

			Printf( "\n 0x0101 arg:%d(%s) size:%d(%s)\n", field, str_arg[0], rom_size, str_arg[1]);
			
			result = uji::eva::rom::GetRomCheckSum(field, rom_size, &checksum);
			// X|X2
			sprintf(str_response, "%X", checksum);
			if(result == CARD_POWER_STATUS_ERROR) strcat(str_response, "NO_CARD");
			break;

		// j[NIDǂݏo  
		// :Ȃ 
		// X|X1:  X|X2:j[NID
		case 0x0102:
			Printf( "\n 0x0102 \n");
			result = uji::eva::rom::GetUniqueID(str_uniqueID);
			str_uniqueID[64] = 0;
			// X|X2
			sprintf(str_response, "%s", str_uniqueID);
			break;

		// obNAbv &xt@C(INCREMENT)
		// :Ȃ 
		// X|X1:  X|X2:Ȃ
		case 0x0201:
			Printf( "\n 0x0201 \n");
			field = strtol(seq_command->str_arg, NULL, 16);
			if( field < 0 || 127 < field )
			{
				result = 1;
				sprintf(str_response, "FIELD:%s[%s]", str_arg[0], seq_command->str_arg);
				break;
			}
			result = VerifyIncrement(field, &device_status, str_err);
			if(result == SPI_FLASH_SIZE_ERROR)sprintf(str_response, "CODE:%X", result+device_status);
			else if(result != 0)sprintf(str_response, "CODE:%X %s", result, str_err);
			break;

		// C[X&xt@CiFFj obNAbv
		case 0x0202:
			Printf( "\n 0x0202 \n");
			field = strtol(seq_command->str_arg, NULL, 16);
			if( field < 0 || 127 < field )
			{
				result = 1;
				sprintf(str_response, "ARG:%s", seq_command->str_arg);
				break;
			}
//			result = VerifyFF(field, &device_status, str_err);
			result = VerifyFF();
			if(result == SPI_FLASH_SIZE_ERROR)sprintf(str_response, "CODE:%X", result+device_status);
			else if(result != 0)sprintf(str_response, "NG CODE:%X %s", result, str_err);
			break;

		// obNAbṽfoCXID`FbN   
		// X|X1:  X|X2:foCXID
		case 0x0203:
			Printf( "\n 0x0203 \n");
			result = GetDeviceID(&deviceID);
			// X|X2
			sprintf(str_response, "%06X", deviceID);
			break;

		// &xt@C1iINCREMENTjNANDJ[h
		case  0x0302:
			Printf( "\n 0x0302 \n");
			result = VerifyIncrement(field, &device_status, str_err);
			if(result == SPI_FLASH_SIZE_ERROR)sprintf(str_response, "SFS:%X", result+device_status);
			else if(result != 0)sprintf(str_response, "CODE:%X %s", result, str_err);
			break;

		// &xt@C2iFFj	   NANDJ[h
		case  0x0303:
			Printf( "\n 0x0303 \n");
//			result = VerifyFF(field, &device_status, str_err);
			result = VerifyFF();
			if(result == SPI_FLASH_SIZE_ERROR)sprintf(str_response, "SFS:%X", result+device_status);
			else if(result != 0)sprintf(str_response, "CODE:%X %s", result, str_err);
			break;

		// foCXID`FbN				 NANDJ[h
		case  0x0304:
			Printf( "\n 0x0304 \n");
			result = GetDeviceID(&deviceID);
			// X|X2
			sprintf(str_response, "%06X", deviceID);
			break;

		// CjVR[hǂݏo
		case 0x9001:
			Printf( "\n 0x9001 \n");
			result = GetInitialCode(initialcode);
			// X|X2
			sprintf(str_response, "%s", initialcode);
			break;

		//	Zt`FbN
		// :ʐMmFpF0x1234 
		// X|X1:  X|X2:ʐMmFpX|XF1234
		case 0x9101:
			Printf( "\n 0x9101 \n");
			result = Selftest(str_response, seq_command->str_arg);
			break;
			
		// J[h\CTRԒʐMxݒ
		case 0x9201:
			Printf( "\n 0x9201 \n");
			result = SetConnectionSpeed(speed);
			break;

		// CTRɏ܂ꂽvÕo[W擾
		case 0x9301:
			Printf( "\n 0x9301 \n");
			result = GetProgramVersion(version);
			// X|X2
			if(result == 0) sprintf(str_response, "%s", version);
			else            sprintf(str_response, "%X", result);
			break;

		case 0xFF01:
			result = FinishToTest1();
			break;

		case 0xFF02:
			result = FinishToTest2();
			break;

		case 0xFF03:
			result = FinishToTest3();
			break;

		default:
			Printf( "\n default \n");
			sprintf(str_response, "COMMAND ID ERROR:%04X", seq_command->id);
			result = 1;
			
	}
	if( result == 0 ) sprintf( response->str_arg, "OK#%s",  str_response );
	else              sprintf( response->str_arg, "NG#%s",  str_response );
	
	return result;

}



//=================================================================================================================================================
// 0001
//=================================================================================================================================================
s32 PrepareToTest1( void )
{
	size_t size = 0;
	u8* dummyMemory;
	u8   power_on_off = 0;

	NN_LOG( "PrepareToTest1\n" );
	NN_UTIL_PANIC_IF_FAILED(nn::fs::CardSlotPowerOn(&power_on_off));
	NN_LOG( "PrepareToTest1-2\n" );
	nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
	NN_LOG( "PrepareToTest1-3\n" );

#ifdef CARD_SDK_13_2
//	nn::fs::ActivateCardDevice();  // SDK0_13_2
#else
//	nn::ctst::CTR::DetailInfo  detailInfo;
//	NN_LOG( "PrepareToTest1-4\n" );
//	nn::ctst::CTR::FunctionTestStart(dummyMemory, size, nn::ctst::CTR::TID_FUNC_INITIALIZE, &detailInfo);  // EVA_SDK_0_14_1
#endif
	NN_LOG( "PrepareToTest1-5\n" );
	
	return 0;
}


//=================================================================================================================================================
// 0002
//=================================================================================================================================================
s32 PrepareToTest2( void )
{
	NN_LOG( "PrepareToTest2\n" );
	
	return 0;
}


//=================================================================================================================================================
// 0003
//=================================================================================================================================================
s32 PrepareToTest3( void )
{
	NN_LOG( "PrepareToTest3\n" );
	
	return 0;
}


//=================================================================================================================================================
// 0101
//=================================================================================================================================================

//=================================================================================================================================================
// 0102
//=================================================================================================================================================

//=================================================================================================================================================
// 0201
//=================================================================================================================================================
s32 VerifyIncrement( int block, u32* device_status, char* str_err )
{
	s32 i;
	s32 ng_code = 0;
	u32 device_size = 0;
	u32* read_data;
	u32* write_data;
	nn::os::Tick start_tick;
//	s64 test_time = 0;
	u32 increment_loop = 0;
	char str_tmp[128];
	

	memset(str_tmp, 0x00, sizeof(str_tmp));

	// ԌvJn
	start_tick = nn::os::Tick::GetSystemCurrent();

	// ʐMxݒƃfoCXTCY̎擾
	device_size = uji::eva::PrepareSPIFlash(device_status);
//	NN_LOG("\n device_size:%u (%X) \n", device_size, device_size);
	
	if(device_size == SPI_FLASH_SIZE_ERROR)
	{
		sprintf( str_err, "dev_id:%u", (*device_status) );
		NN_LOG("\nERROR device_size:%u (%X) \n", device_size + (*device_status), device_size + (*device_status));
		return SPI_FLASH_SIZE_ERROR;
	}
	
	if(device_size%(DATA_512K_BIT) != 0) return SPI_FLASH_SIZE_ERROR+1;
	
	increment_loop = device_size/(DATA_512K_BIT);
//	NN_LOG("device_size:%u DATA_512K_BIT:%u (%u)%u\n", device_size, DATA_512K_BIT, device_size/65536, device_size/(DATA_512K_BIT));
//	NN_LOG("increment_loop:%u\n", increment_loop);

	// Readf[^ꎞIɏޗ̈̊m
	read_data = reinterpret_cast<u32*>(uji::sys::AllocDeviceMemory(DATA_512K_BIT, 32));
	if (read_data == NULL)
	{
		NN_LOG("Failed to allocate continuous memory\n");
		return SPI_FLASH_READ_ALLOC_ERROR;
	}

	// Writef[^ꎞIɏޗ̈̊m
	write_data = reinterpret_cast<u32*>(uji::sys::AllocDeviceMemory(DATA_512K_BIT, 32));
	if (write_data == NULL)
	{
		NN_LOG("Failed to allocate continuous memory\n");
		uji::sys::Free(read_data);
		return SPI_FLASH_WRITE_ALLOC_ERROR;
	}

	
	memset(read_data, 0x00, sizeof(DATA_512K_BIT));
	memset(write_data, 0x00, sizeof(DATA_512K_BIT));
	
	Printf("\n block:%d \n", block);

	// f[^i[
	for(i=0;i<DATA_512K_BIT/sizeof(u32);i++)
	{
		read_data[i]  = 0x99999999;
		write_data[i] = i;
	}

	
	// C[X(ECflagERASE_CHECK_ON̏ꍇFFɂȂĂ邱Ƃ̊mFs)
	ng_code = uji::eva::CheckErase(DATA_512K_BIT, DATA_512K_BIT * block, read_data, start_tick, ERASE_CHECK_OFF, str_err);
	
	if(ng_code != 0)
	{
		sprintf(str_tmp, " b:%d", block);
		strcat(str_err, str_tmp);
		uji::sys::Free(read_data);
		uji::sys::Free(write_data);
		return ng_code + DATA_512K_BIT*block;
	}

//		NN_LOG("\n WRITE \n");
//		NN_LOG("\n write_data:%X  write_data+:%X \n sizeof(write_data):%d :%X \n",write_data, write_data+((DATA_512K_BIT * block)/2/sizeof(u32)), sizeof(u32), device_size/2/sizeof(u32) );
//		NN_LOG("\n write_data:%X :%X :%X :%X :%X \n",write_data, write_data+0x4000, write_data+0x8000, write_data+0xC000, write_data+0x10000 );
//		NN_LOG("\n read_data:%X  read_data+:%X \n sizeof(read_data):%d  :%X \n",read_data, read_data+(DATA_512K_BIT/2/sizeof(read_data)), sizeof(u32), (DATA_512K_BIT/2/sizeof(read_data)) );
//		NN_LOG(" test_size:%u start_address:%X(%u)\n", DATA_512K_BIT/2, DATA_512K_BIT * block, DATA_512K_BIT * block);
	
	// eXgp^[݂̏ƃxt@C(1bitǂݏo)
#ifdef CARD_SDK_13_2
	ng_code = uji::eva::VerifyIncrement(DATA_512K_BIT/2, DATA_512K_BIT * block, write_data, read_data, start_tick, READ_WAY_4XIO, str_err);
#else
	ng_code = uji::eva::VerifyIncrement(DATA_512K_BIT/2, DATA_512K_BIT * block, write_data, read_data, start_tick, READ_WAY_1XIO, str_err);
#endif
	if(ng_code != 0)
	{
		sprintf(str_tmp, " b:%d", block);
		strcat(str_err, str_tmp);
		uji::sys::Free(read_data);
		uji::sys::Free(write_data);
		return ng_code + (DATA_512K_BIT*block);
	}


//		NN_LOG(" test_size:%u start_address:%X(%u)\n", DATA_512K_BIT/2, DATA_512K_BIT/2 + DATA_512K_BIT * block, DATA_512K_BIT/2 + DATA_512K_BIT * block);

	// eXgp^[݂̏ƃxt@C(4bitǂݏo)
	ng_code = uji::eva::VerifyIncrement(DATA_512K_BIT/2, DATA_512K_BIT/2 + DATA_512K_BIT * block, write_data+(DATA_512K_BIT/2/sizeof(write_data)), read_data+(DATA_512K_BIT/2/sizeof(read_data)), start_tick, READ_WAY_4XIO, str_err);
	if(ng_code != 0)
	{
		uji::sys::Free(read_data);
		uji::sys::Free(write_data);
		sprintf(str_tmp, " b:%d", block);
		strcat(str_err, str_tmp);
		return ng_code + DATA_512K_BIT/2 + (DATA_512K_BIT*block);
	}

//#if 0
//		test_time = GetMicroSecond(start_tick);
//		NN_LOG("Before CheckErase Time:%lld mS \n", test_time);

	// C[X(ECflagERASE_CHECK_ON̏ꍇFFɂȂĂ邱Ƃ̊mFs)
	ng_code = uji::eva::CheckErase(DATA_512K_BIT, DATA_512K_BIT*block, read_data, start_tick, ERASE_CHECK_ON, str_err);
	if(ng_code != 0)
	{
		sprintf(str_tmp, " b:%d", block);
		strcat(str_err, str_tmp);
		uji::sys::Free(read_data);
		uji::sys::Free(write_data);
		return ng_code + (DATA_512K_BIT*block);
	}
//#endif

//		test_time = GetMicroSecond(start_tick);
//		NN_LOG("After CheckErase Time:%lld mS \n", test_time);
	
	

	uji::sys::Free(read_data);
	uji::sys::Free(write_data);

	return ng_code;
}


// blockɊ֌WȂS̈挟sꍇ
#if 0
	// C[X(ECflagERASE_CHECK_ON̏ꍇFFɂȂĂ邱Ƃ̊mFs)
	ng_code = uji::eva::CheckErase(device_size, 0, read_data, start_tick, ERASE_CHECK_OFF);
	// eXgp^[݂̏ƃxt@C(1bitǂݏo)
	ng_code = uji::eva::VerifyIncrement(device_size/2, 0, write_data, read_data, start_tick, READ_WAY_1XIO);
	// eXgp^[݂̏ƃxt@C(4bitǂݏo)
	ng_code = uji::eva::VerifyIncrement(device_size/2, device_size/2, write_data+(device_size/2/sizeof(write_data)), read_data+(device_size/2/sizeof(read_data)), start_tick, READ_WAY_4XIO);


	// 1MtbV̏ꍇ
	if(device_size == DATA_1M_BIT)
	{
//		// block0,1ȊȌꍇNG
//		if( block < 0 || 1 < block ) return SPI_FLASH_CHECK_BLOCK_ERROR;
	}

	// 4MtbV̏ꍇ
	if(device_size == DATA_4M_BIT)
	{
		// block0`7ȊȌꍇNG
//		if( block < 0 || 7 < block ) return SPI_FLASH_CHECK_BLOCK_ERROR;
	}



#endif

//	test_time = GetMicroSecond(start_tick);
//	NN_LOG("Before CheckErase Time:%lld mS \n", test_time);


//=================================================================================================================================================
// 0202
//=================================================================================================================================================
s32 VerifyFF( void )
{
	s32 ng_code = 0;
#if 0

	s32 i;
	u32 device_size = 0;
	u32* read_data;
	u32* write_data;
	nn::os::Tick start_tick;
	s64 test_time = 0;
	u32 ff_loop = 0;

	Printf( "\n %d \n", block);

	// ԌvJn
	start_tick = nn::os::Tick::GetSystemCurrent();

	// ʐMxݒƃfoCXTCY̎擾
	device_size = PrepareSPIFlash(device_status);
	if(device_size == SPI_FLASH_SIZE_ERROR)
	{
		NN_LOG("\nERROR\n");
		return device_size;
	}

	ff_loop = device_size/(DATA_512K_BIT);

	read_data = reinterpret_cast<u32*>(uji::sys::AllocDeviceMemory(DATA_512K_BIT, 32));
	if (read_data == NULL)
	{
		NN_LOG("Failed to allocate continuous memory\n");
		return 2;
	}

	// ł͑S̈挟s V[PTłĂȂ̂ŁAvOőSubNw肷
	for(block=0;block<ff_loop;block++)
	{
		memset(read_data, 0x00, sizeof(DATA_512K_BIT));
	
		Printf( "\n device_size:%u  block:%d address:%u(%X) \n", device_size, block, DATA_512K_BIT*block, DATA_512K_BIT*block );
	
		test_time = GetMicroSecond(start_tick);
		NN_LOG("Before CheckErase Time:%lld mS \n", test_time);
	
		// C[X(ECflagERASE_CHECK_ON̏ꍇFFɂȂĂ邱Ƃ̊mFs)
		ng_code = uji::eva::CheckErase(DATA_512K_BIT, DATA_512K_BIT*block, read_data, start_tick, ERASE_CHECK_ON, str_err);
	
		test_time = GetMicroSecond(start_tick);
		NN_LOG("After CheckErase Time:%lld mS \n", test_time);
	}
		
	uji::sys::Free(read_data);
#endif

	return ng_code;
}


//=================================================================================================================================================
// 0203
//=================================================================================================================================================
s32 GetDeviceID( int *ID )
{
	u32 status = 0;
	nn::Result result;

	// foCXID擾
	result = nn::fs::Read(0x9F, &status, 3);  // RDID
	if ( result.IsFailure() )
	{
		return GET_DEVICE_ID_ERROR;
	}

	NN_LOG("\n status:%X  \n", status);
	*ID = status;

	return 0;
}


//=================================================================================================================================================
// 9001
//=================================================================================================================================================
s32 GetInitialCode( char *code )
{
#define INITIAL_PAGE		32		// 
#define INITIAL_ADDRESS		0x156	// (ۂ0x4156)
#define CARD_VERTION_PAGE	2		// 
#define CARD_VERTION_ADDRESS		0x0110	// (ۂ0x0310)

	u8 read_buffer[4096];
	int i;
	
	uji::eva::rom::ReadRom( INITIAL_PAGE, 512, (u32*)read_buffer );

	NN_LOG("\n[");
	for(i=0;i<16;i++)
	{
		NN_LOG("%c", read_buffer[0x150+i]);
	}
	NN_LOG("]\n");
	
	NN_LOG("\n[");
	for(i=0;i<4;i++)
	{
		NN_LOG("%X", read_buffer[INITIAL_ADDRESS+i]);
	}
	NN_LOG("]\n");


	NN_LOG("\n[");
	for(i=0;i<4;i++)
	{
		NN_LOG("%c", read_buffer[INITIAL_ADDRESS+i]);
	}
	NN_LOG("]\n");

	*code     = read_buffer[INITIAL_ADDRESS];
	*(code+1) = read_buffer[INITIAL_ADDRESS+1];
	*(code+2) = read_buffer[INITIAL_ADDRESS+2];
	*(code+3) = read_buffer[INITIAL_ADDRESS+3];

	// o[W񂪂y[W[h
	uji::eva::rom::ReadRom( CARD_VERTION_PAGE, 512, (u32*)read_buffer );

	NN_LOG("\n[");
	for(i=0;i<4;i++)
	{
		NN_LOG("%X", read_buffer[CARD_VERTION_ADDRESS+i]);
	}
	NN_LOG("]\n");

	// }X^o[W(0x311 ̏6bit <7-2>)
	NN_LOG( "0:%u 1:%u\n", read_buffer[CARD_VERTION_ADDRESS], read_buffer[CARD_VERTION_ADDRESS+1] );
	NN_LOG( "2:%u 3:%u\n", read_buffer[CARD_VERTION_ADDRESS+2], read_buffer[CARD_VERTION_ADDRESS+3] );
	NN_LOG( "<<:%x >>:%x \n", 4 << 2, 4 >> 2 );
	NN_LOG( "remaster:%x \n", read_buffer[CARD_VERTION_ADDRESS+1] >> 2 );


	*(code+4) = (read_buffer[CARD_VERTION_ADDRESS+1] >> 2) + 0x30;
	
	// v_NVo[W
	*(code+5) = read_buffer[CARD_VERTION_ADDRESS+3] + 0x30;
	*(code+6) = read_buffer[CARD_VERTION_ADDRESS+2] + 0x30;

	
	//code = "IRAJ";
//	std::sprintf( code, "IRAJ000");

	return 0;
}

//=================================================================================================================================================
// 9101
//	Zt`FbN
// :ʐMmFpF0x1234 
// X|X1:  X|X2:ʐMmFpX|XF1234
//=================================================================================================================================================
s32 Selftest( char *response_arg_str, char *command_arg_str )
{
	char test[5];

	strcpy(test,"1234");
	// G[
	if( strcmp("1234", command_arg_str) != 0 )
	{
		sprintf(response_arg_str, "[%s] %d:%d:%d:%d:%d", command_arg_str, command_arg_str[0], command_arg_str[1], command_arg_str[2], command_arg_str[3], command_arg_str[4]);
		return 1;
	}
	else
	{
		sprintf(response_arg_str, "%s", command_arg_str);
		return 0;
	}

}


//=================================================================================================================================================
// 9201
// speed  0x00 - 0xFF
//=================================================================================================================================================
s32 SetConnectionSpeed( u32 speed )
{
	Printf( "\n speed:%d \n", speed );

	return 0;
}


#if 0
	bool x = 0;
	u8 power_on_off = 0;

	//j[p̃EChE}l[W
	static uji::sys::WindowManager m_WindowManager;
	uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();

	//	EChE
	m_WindowManager.Update();        
	m_WindowManager.DrawDisplay0();

	//	`
	gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

	// `̑O
	gfx->BeginDrawingString(); 
	gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
	gfx->SetFixedWidthFont(16);           
	gfx->m_TextWriter.SetCursor(10, 20);


	gfx->m_DrawFramework->Clear();

	x = nn::fs::IsCardInserted();
	nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
	(void)gfx->m_TextWriter.Printf( "\n x:%d, power_on_off:%d \n", x, power_on_off );
	nn::fs::CardSlotPowerOn(&power_on_off);
	nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
	(void)gfx->m_TextWriter.Printf( "\n ON x:%d, power_on_off:%d \n", x, power_on_off );
	glFlush();
	gfx->m_DrawFramework->SwapBuffers();

#endif

//=================================================================================================================================================
// 9301
//=================================================================================================================================================
s32 GetProgramVersion( char *version )
{

    static const char PROGRAM_VERSION_DATE[] = __DATE__ " " __TIME__ ;
    int day, year, time1, time2, time3;
    char month[5];
    
    sscanf( PROGRAM_VERSION_DATE, "%s %d %d %d:%d:%d", month, &day, &year, &time1, &time2, &time3 );
	NN_LOG("month:%s %d %d %d:%d:%d", month, day, year, time1, time2, time3);

#ifdef CARD_SDK_13_2
	sprintf( version, "%d.%d.%d", 0, 0, 0 );
#else
    nn::Result result;
    const char ARCHIVE_NAME[] = "test:";
	const wchar_t SAMPLE_FILENAME[] = L"test:/version.bin";
	nn::fs::FileInputStream infile;
	s64 size;
	nn::pl::CTR::CardUpdateVersion versionInfo;
	static bool first_flag = 0;
    
    const nn::fs::TitleId MOUNT_SHAREDDATA_TITLEID        = nn::pl::CTR::SHAREDDATA_TITLEID_COUNTRY_REGION;

    // }Egpobt@
    static u8 s_MountBuffer[1024];
    
    NN_LOG("version data mount sample");

    s32 requiredsize = nn::fs::GetContentRequiredMemorySize(nn::fs::MEDIA_TYPE_NAND, MOUNT_SHAREDDATA_TITLEID, 0, 5, 5);
    NN_LOG("required size: %d\n", requiredsize);
    NN_PANIC_IF_FALSE(requiredsize <= sizeof(s_MountBuffer));

	if(first_flag == 0)
	{
		first_flag = 1;
	    // CUP o[W\    
	    result = nn::fs::MountContent(ARCHIVE_NAME,  nn::fs::MEDIA_TYPE_NAND, nn::pl::CTR::SHAREDDATA_TITLEID_CUP_VERSION_JP, 0, 5, 5, s_MountBuffer, sizeof(s_MountBuffer));
	    if ( result.IsFailure() )
	    {
	        NN_LOG("failed to mount version info content\n");
	        return GETPROGRAMVERSION_MOUNTCONTENT_ERROR;
	    }
	}
        
        NN_LOG("open file: '%ls'\n", SAMPLE_FILENAME);
        infile.Initialize(SAMPLE_FILENAME);

        size = infile.GetSize();
        NN_LOG("size: %lld\n",size);

        s32 readsize = infile.Read(&versionInfo, sizeof(versionInfo));
        NN_LOG("readsize: %d\n", readsize);
        NN_LOG("major:  %d\n", static_cast<u32>(versionInfo.majorVersion));
        NN_LOG("minor:  %d\n", static_cast<u32>(versionInfo.minorVersion));
        NN_LOG("micro:  %d\n", static_cast<u32>(versionInfo.microVersion));
        NN_LOG("region: %c\n", versionInfo.region);

//    nn::fs::Unmount(ARCHIVE_NAME);

//	sprintf( version, "%u.%u%u%c %s %d %d", static_cast<u32>(versionInfo.majorVersion), static_cast<u32>(versionInfo.minorVersion), static_cast<u32>(versionInfo.microVersion), versionInfo.region, month, day, year );
	sprintf( version, "F:%u.%u%u%c\nP:%s", static_cast<u32>(versionInfo.majorVersion), static_cast<u32>(versionInfo.minorVersion), static_cast<u32>(versionInfo.microVersion), versionInfo.region, CARD_TEST_VERSION );

#endif

	return 0;
}


#ifndef CARD_SDK_13_2
void SampleMountVersion()
{
    nn::Result result;
    const char ARCHIVE_NAME[] = "test:";
    
    // manualapp.cia ̃^CgID
    const nn::fs::TitleId MANUAL_TITLE_ID = 0x0004001000020300;

    const nn::fs::TitleId MOUNT_SHAREDDATA_TITLEID        = nn::pl::CTR::SHAREDDATA_TITLEID_COUNTRY_REGION;

    // }Egpobt@
    static u8 s_MountBuffer[1024];
    
    NN_LOG("version data mount sample");

    s32 requiredsize = nn::fs::GetContentRequiredMemorySize(nn::fs::MEDIA_TYPE_NAND, MOUNT_SHAREDDATA_TITLEID, 0, 5, 5);
    NN_LOG("required size: %d\n", requiredsize);
    NN_PANIC_IF_FALSE(requiredsize <= sizeof(s_MountBuffer));

    // CUP o[W\    
    result = nn::fs::MountContent(ARCHIVE_NAME,  nn::fs::MEDIA_TYPE_NAND, nn::pl::CTR::SHAREDDATA_TITLEID_CUP_VERSION_JP, 0, 5, 5, s_MountBuffer, sizeof(s_MountBuffer));
    if ( result.IsFailure() )
    {
        NN_LOG("failed to mount version info content\n");
        return;
    }

    {
        const wchar_t SAMPLE_FILENAME[] = L"test:/version.bin";
        
        NN_LOG("open file: '%ls'\n", SAMPLE_FILENAME);
        nn::fs::FileInputStream infile;
        infile.Initialize(SAMPLE_FILENAME);

        s64 size;
        size = infile.GetSize();
        NN_LOG("size: %lld\n",size);

        nn::pl::CTR::CardUpdateVersion versionInfo;
        s32 readsize = infile.Read(&versionInfo, sizeof(versionInfo));
        NN_LOG("readsize: %d\n", readsize);
        NN_LOG("major:  %d\n", static_cast<u32>(versionInfo.majorVersion));
        NN_LOG("minor:  %d\n", static_cast<u32>(versionInfo.minorVersion));
        NN_LOG("micro:  %d\n", static_cast<u32>(versionInfo.microVersion));
        NN_LOG("region: %c\n", versionInfo.region);
    }

//    nn::fs::Unmount(ARCHIVE_NAME);
}
#endif



//=================================================================================================================================================
// response_arg_str X|Xpstr񂪂ɏ
// check_sum_flag   R}h̃`FbNTOK̏ꍇ0ANG̏ꍇ1ɂȂB ̃tO1̏ꍇ͌s킸response_arg_strNG
// commang_arg_str  R}hɊi[
// calc_command_sum R}h񂩂vZďo`FbNT
// arg_command_sum  R}hɂĂ`FbNT
//=================================================================================================================================================
void test_test( char *response_arg_str, char *command_arg_str )
{
	
	sprintf(response_arg_str, "OK#%s", command_arg_str);

	return;
}




//=================================================================================================================================================
// FF01
//=================================================================================================================================================
s32 FinishToTest1( void )
{
	NN_LOG( "FinishToTest1\n" );
#ifndef TS_Board
	u8 power_on_off = 0;
	// J[hdOFF
	nn::fs::CardSlotPowerOff(&power_on_off);
#endif
	
	return 0;
}

//=================================================================================================================================================
// FF02
//=================================================================================================================================================
s32 FinishToTest2( void )
{
	NN_LOG( "FinishToTest2\n" );
	
	return 0;
}

//=================================================================================================================================================
// FF03
//=================================================================================================================================================
s32 FinishToTest3( void )
{
	NN_LOG( "FinishToTest3\n" );
	
	return 0;
}






//---------------------------------------------------------------------------------------------------
//Tv                  F***=****,****,****,****,****,****,****
//                        ̌`ŏĂ镶񂩂A
//                        u=v̌̕****P̂܂܈listɊi[
//                        
//  str             F
//  list            Fʕ̊i[
//  list_num        Fi[ꂽlisť
//
//߂l                Fݐ́AK_FUNC_OK (= 0)
//                        ݎśAG[R[h
//---------------------------------------------------------------------------------------------------
static s32 IniStrCompareStr(char *str, char list[][TMP_SIZE], u32 * list_num)
{
	#define		COMPARE_STR_SIZE  256
    char    behind_str[COMPARE_STR_SIZE];   // '#'̌̕i[
    char    tmp_behind_str[COMPARE_STR_SIZE];   // behind_strĂԁAa
    char    list_str[COMPARE_STR_SIZE];     // listڕi[
    char*   comma_pos;          // ','ʒu|C^
    *list_num = 0;

    // ̏
    memset(behind_str, 0x00, sizeof(behind_str));

    // strbehind_strɊi[
    strcpy(behind_str, str);

    while (1)
    {

        // "#"̏ꏊ
        comma_pos = strchr(behind_str, '#');

        // '#'Ȃꍇ
        if (comma_pos == NULL)
        {
            break;
        }

        // ̏
        memset(list_str, 0x00, sizeof(list_str));

        // "#"̑Oɂ镶list_strɊi[
        strncpy(list[(*list_num)], behind_str, (comma_pos - behind_str));

        // "#"̌ɂ镶tmp_behind_strɊi[i@ABCj
        // @̏
        memset(tmp_behind_str, 0x00, sizeof(tmp_behind_str));

        // A"#"ȍ~tmp_behind_strɊi[
        strcpy(tmp_behind_str, comma_pos + 1);

        // B̏
        memset(behind_str, 0x00, sizeof(behind_str));

        // Ctmp_behind_strbehind_strɃRs[
        strcpy(behind_str, tmp_behind_str);

        // list̐{Plist_numɊi[
        (*list_num)++;

    }

    // "\0"̏ꏊ
    comma_pos = strchr(behind_str, '\0');

    // '\0'̑O̕list_strɊi[
    strncpy(list[(*list_num)], behind_str, (comma_pos - behind_str));

    // list̐{Plist_numɊi[
    (*list_num)++;

    return 0;

}










}	// usingnamespace card
}   // usingnamespace eva
}   // usingnamespace uji

