/*--------------------------------------------------------------------------*
 Project:
 File: CardTest.cpp
 
*--------------------------------------------------------------------------*/

#include "CardTest.h"
#include "CardTestList.h"
#include "../seq/TestResult.h"    
#include "CardTestDefine.h"    
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>


using namespace nn::dbg::detail;		// Printfp
using namespace uji::eva::spi;


namespace uji {
namespace eva {
namespace card {

u32 deviser_5M[14] = {	16667,	// 300
					4167,	// 1200
					2083,	// 2400
					1042,	// 4800
					521,	// 9600
					260,	// 19200
					130,	// 38400
					87,		// 57600
					43,		// 115200
					21,		// 230400
					10,		// 500000
					5,		// 1000000
					2,		// 2500000
					1 		// 5000000
};

char str_deviser_5M[14][10] = 
					{	"300",
						"1200",
						"2400",
						"4800",
						"9600",
						"19200",
						"38400",
						"57600",
						"115200",
						"230400",
						"500000",
						"1000000",
						"2500000",
						"5000000"
};


//=================================================================================================================================================
// GR[obN֐(V[PXL[{[hœ͂CTRɑꂽÂ܂܃V[PXɕԂĂ)
// ݃ASɓnĂvO
//=================================================================================================================================================
void CardTest::CommandResponse()
{
	int i;
	u8 command_buffer[2048];				// R}hpobt@
	static u8 old_command_buffer[2048]="";	// R}hpobt@
	u8 response_buffer[2048];				// X|Xpobt@
	SpiCommand  seq_command;				// R}hp\
	SpiResponse response;					// X|Xp\
	static u8 flag_spi_init = 0;			// SPIʐMp̏sǂtO
	s32 devisor = 8;						// SPIʐMx肷鐔
	u32 command_sum = 0;					// R}h̃`FbNTvZʂϐ
	u32 seq_command_sum = 0;				// R}h̃`FbNTvZʂϐ
    nn::hid::CTR::PadReader padReader;		// {^͊mp
    nn::hid::CTR::PadStatus padStatus;		// {^͊mp
    uji::sys::Pad pad;						// {^͊mp
    static uji::sys::WindowManager m_WindowManager;		// j[p̃EChE}l[W
	nn::os::Tick start_tick;				// Ԍvp
	s64 test_time = 0;
	s32 comand_loop = 0;
	s32 result = 0;
	char str_error[2048];
	u8   power_on_off = 0;



	uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX
    m_WindowManager.SetAlpha(196);
    
	//	EChE
	m_WindowManager.UpdatePad(pad);  // pbh
	m_WindowManager.Update();        // XV
	m_WindowManager.DrawDisplay0();

	//	`
	gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
	gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

	// `̑O
	gfx->BeginDrawingString(); 
	gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);

	gfx->m_DrawFramework->Clear();
	(void)gfx->m_TextWriter.Printf( " 1\n" );

	glFlush();
	gfx->m_DrawFramework->SwapBuffers();

    Printf("--spi_test start--\n");
	if(flag_spi_init == 0)
	{
		//SPI ʐM
		uji::eva::spi::WriteSpi::WriteSpiInit();
		flag_spi_init = 1;
	}

	// SPI Channel A ݒ
	SetChannelA();
	// SPI Channel B ݒ
//	SetChannelB();

	nn::fs::CardSlotPowerOff(&power_on_off);

	// V[PTƂ̃R}hƃX|X̑M
	do
	{
		
		gfx->m_DrawFramework->Clear();

		// V[PT瑗ꂽR}hǂݎ֐(R}hMJn3boĂR}hׂĎ󂯎ĂȂꍇ̓^CAEgƂ݂Ȃăf[^NA)
//		ReceiveCommandFromSeq(gfx, &seq_command, command_buffer, test_time, response_buffer);


		
		// R}hOƓꍇ
		do
		{
			comand_loop++;
			
			// command_buffer response_buffer tmp_buffer̗eʂ 2048*2ɂGetResponseDataŃt[Y
			memset(command_buffer, 0x00, sizeof(command_buffer));

			// V[PT瑗ꂽR}hǂݎ֐(R}hMJn3boĂR}hׂĎ󂯎ĂȂꍇ̓^CAEgƂ݂Ȃăf[^NA)
			ReceiveCommandFromSeq(gfx, &seq_command, command_buffer, test_time, response_buffer);
			Printf("send:[%s]\n old:[%s]\n", command_buffer, old_command_buffer);
		
		}while( (strcmp((char*)command_buffer, (char*)old_command_buffer) == 0) && (comand_loop < 2) );
		comand_loop = 0;

		memset(old_command_buffer, 0x00, sizeof(old_command_buffer));
		
		for(i=0;i<seq_command.arg_num+10;i++)
		{
			old_command_buffer[i] = command_buffer[i];
		}
			Printf("2 send:[%s]\n   old:[%s]\n", command_buffer, old_command_buffer);


		// V[PT󂯂R}huR}h{\r\nvCTRV[PTɑ
//		SendResponseToSeq( seq_command.arg_num, command_buffer );
//		Printf("send:[%s]\n", command_buffer);
	
		// R}h̃`FbNTvZ
		command_sum = 0;
		
		for(i=4;i<(seq_command.arg_num+10);i++)
		{
//			Printf("\n [%d]:%X ", i, command_buffer[i]);
			command_sum += command_buffer[i];
		}
		
		// seq_command̃`FbNTvZ
		seq_command_sum = 0;

		for(i=0;i<4;i++)
		{
			seq_command_sum += seq_command.str_id[i];
		}

		for(i=0;i<2;i++)
		{
			seq_command_sum += seq_command.str_arg_num[i];
		}

		for(i=0;i<seq_command.arg_num;i++)
		{
//			Printf("\n [%d]str_arg:%X ", i, seq_command.str_arg[i]);
			seq_command_sum += seq_command.str_arg[i];
		}
		
		// X|Xi[̈
		InitializeResponseData( &response );

		// ԌvJn
		start_tick = nn::os::Tick::GetSystemCurrent();

		// R}h̃`FbNT̊mF(mFʂCardTestList֐̈ƂĎg)
		Printf("\n command_sum:%X seq_command_sum:%X seq_command.sum:%X \n", command_sum, seq_command_sum, seq_command.sum);
		// R}h̃`FbNTG[ꍇ
		if( command_sum != seq_command.sum ) sprintf( response.str_arg, "COM_ERROR#c:%04X a:%s[%s]", command_sum, seq_command.str_check_sum, command_buffer );
		// V[PXR}h̃`FbNTG[ꍇ
		else if( seq_command_sum != seq_command.sum )
		{
			sprintf( response.str_arg, "COM_ERROR#s:%04X a:%s[%s][%s]", seq_command_sum, seq_command.str_check_sum, command_buffer, seq_command.str_arg );
		}
		// G[ꍇ R}hIDɂAڐU蕪(R}h`FbNTقȂꍇ͌sONGƔ肳)
		else
		{
			result = CardTestList(&seq_command, &response);
			if(result!=0)
			{
				memset(str_error, 0x00, sizeof(str_error));
				sprintf(str_error, ":[%s][%s][%s][%s][%s]", seq_command.str_check_sum, seq_command.str_id, seq_command.str_arg_num, seq_command.str_arg, command_buffer);
				strcat(response.str_arg, str_error);
			}
			Printf("\n response.str_arg:%s [%s][%s][%s][%s][%s]\n", str_error, command_buffer, seq_command.str_check_sum, seq_command.str_id, seq_command.str_arg_num, seq_command.str_arg);
		}
		

		gfx->m_DrawFramework->Clear();

		(void)gfx->m_TextWriter.Printf("[12]\n");
		glFlush();
		gfx->m_DrawFramework->SwapBuffers();
		test_time = GetMicroSecond(start_tick);
		NN_LOG("list test_time:%lld mS\n", test_time);

		memset(response_buffer, 0x00, sizeof(response_buffer));

		// V[PTɑ郌X|X擾
		GetResponseData( &seq_command, &response, response_buffer );
		Printf("\n response.arg_num:%X   \n", response.arg_num);
		(void)gfx->m_TextWriter.Printf("GetResponseData response:\n%s", response_buffer);
		glFlush();
		gfx->m_DrawFramework->SwapBuffers();
		
		// CTRV[PTɃX|X𑗂
		SendResponseToSeq( response.arg_num, response_buffer );
		Printf("send:[%s]\n", response_buffer);
		(void)gfx->m_TextWriter.Printf("send:%s", response_buffer);
		glFlush();
		gfx->m_DrawFramework->SwapBuffers();
		

		// L[͂̊mF
		padReader.ReadLatest(&padStatus);
		pad.UpdatePad(padStatus);

		
	// R{^B{^𓯎ꂽꍇ͌rłj[ɖ߂
	}while( !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_A)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) );

}




}	// usingnamespace card
}   // usingnamespace eva
}   // usingnamespace uji



	//  SPIʐMx̐ݒ
#ifdef TS_Board
	// fobN115200bps
//	SpiChAChangeBaudRate(8);
	// fobN921600bps
//	SpiChAChangeBaudRate(1);
#else
	// @ł5Mbps
//	ChangeBaudRateA(deviser_5M[13]);
#endif
