
/********************************************************************
  JBHpvO
  BF
    `[g摜
    AWB ON
    ׂ摜
    AWB OFF, WB ݒl 7000K
********************************************************************/

#include <string.h>
#include <nn.h>
#include <nn/gx.h>
#include <nn/camera.h>
#include <nn/y2r.h>
#include <string.h>
#include "sys.h"
#include "../sys/sys_SoundPlayer.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../seq/TestList.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "../seq/TestListManager.h"

#include "TestCamera.h"
#include "TestCameraCapture.h"

#ifdef EVA_COMPOSITE
#include "../seq/TestSequencer.h"
static void ShowPicture( wchar_t *file );
#endif

static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji;
using namespace uji::sys;
using namespace uji::eva;
using namespace uji::seq;

// G[}CNR[hp
enum enumErrorMicro
{
    PASS = 0,
    BLOWN_OUT_HIGHLIGHTS_ICAM   = 1,
    BLOWN_OUT_HIGHLIGHTS_OCAM_L = 2,
    BLOWN_OUT_HIGHLIGHTS_OCAM_R = 3,
    MICRO_ERROR_NUM      = 4
};

// zCgoXݒp
static char *WHITEBALANCE_STR[]=
{
    "AUTO" ,
    "3200K",
    "4150K",
    "5200K",
    "6000K",
    "7000K",
    NULL
};
u32 u32_WhiteBalance = 1;   // zCgoX AUTO͎gȂ̂ŏl1

bool chart_captured = false;// SDJ[hgݍݎwo̔fp

// Heapۑ̌ʕێp
uji::seq::TestResult heap_result;

/************************************************************************
bZ[W\
  ************************************************************************/
static void ShowMessage( uji::sys::GraphicsDrawing* gfx, char *str1, char *str2 )
{
    gfx->BeginDrawingString();
    gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_V);
    gfx->m_TextWriter.SetTextColor(nn::util::Color8::YELLOW, nn::util::Color8::RED);
    gfx->m_TextWriter.SetCursor(20, 100);
    gfx->m_TextWriter.Print( str1 );
    gfx->m_TextWriter.SetCursor(20, 150);
    gfx->m_TextWriter.Print( str2 );
    gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_NONE);
    gfx->EndDrawingString();
}

/************************************************************************
ʂɊG\
************************************************************************/
static void ShowPicture( wchar_t *file )
{
    GLuint s_TextureId;

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    JpegTexture jt;

    jt.Open( file );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            GL_RGB_NATIVE_DMP,
                                            jt.GetWidth(),
                                            jt.GetHeight(),
                                            GL_RGB_NATIVE_DMP,
                                            GL_UNSIGNED_SHORT_5_6_5,
                                            jt.GetTextureDataPointer(),
                                            s_TextureId );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->m_DrawFramework->FillTexturedRectangle(s_TextureId,
                                                0.0f, 0.0f,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                jt.GetWidth(), jt.GetHeight() );
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->DeleteTexture(s_TextureId);
    jt.Close();

}

/************************************************************************
  `[gBH
  ************************************************************************/
bool uji::eva::camera::Capture3PicturesChart(TestResult &result)
{
    s64 WAIT_TIME = 2000;   // ҂(mS)
    s8 sharpness = 0;       // V[vlX -4`5
    s8 s8_Exposure = -3;    // Il   -5`5
    nn::Result nn_result;   // ̌ʕێp

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();// TODO:H

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;

    // ܂SDJ[hgݍݎw
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    jpegDrawer->OpenPicture(L"rom:/jpeg/setSD.jpg");
    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->SwapBuffers();
    
    // SDJ[h܂Ń[v
    do
    {
        // C҂Ԃ
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }while( !nn::fs::IsSdmcInserted() );
    chart_captured = true;
    // 摜
    jpegDrawer->ClosePicture();
    delete jpegDrawer;

// SDJ[hmF
    // LOCKĂȂmF
    if( !nn::fs::IsSdmcWritable() )
    {
        NN_LOG( "SD Card is Locked(Not Writable)\n" );
    }
    nn::fs::MountSdmc();
    // ujifBNgȂ쐬
    nn::fs::Directory dir;
    nn_result = dir.TryInitialize( L"sdmc:/uji" );
    if(nn_result.IsFailure())
    {
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Can't Initialize!", "Create Directory..." );
        NN_LOG( "Can't Initialize! Create Directory...\n" );
        gfx->m_DrawFramework->SwapBuffers();

        nn_result = nn::fs::TryCreateDirectory( L"sdmc:/uji" );
        if(nn_result.IsFailure())
        {
            gfx->m_DrawFramework->Clear();
            ::ShowMessage ( gfx, "Warning", "Fail to Create Directory!" );
            NN_LOG( "Can't Create Directory!\n" );
            gfx->m_DrawFramework->SwapBuffers();
        }
        else
        {
            NN_LOG( "Create Directory Success!\n" );
        }
    }
    else
    {
        dir.Finalize();
        NN_LOG( "Directory is Already Exist\n" );
    }

    // ɓt@Cꍇ͍폜
    nn_result = nn::fs::TryDeleteFile( L"sdmc:/uji/icam.png" );
    if( nn_result.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/icam.png is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/icam.png Delete Success\n" );
    }
    nn_result = nn::fs::TryDeleteFile( L"sdmc:/uji/ocamL.png" );
    if( nn_result.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/ocamL.png is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/ocamL.png Delete Success\n" );
    }
    nn_result = nn::fs::TryDeleteFile( L"sdmc:/uji/ocamR.png" );
    if( nn_result.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/ocamR.png is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/ocamR.png Delete Success\n" );
    }
    nn::fs::Unmount("sdmc:");
// ܂SDJ[hmF

    TestCamera *camera = new TestCamera;
    camera->Initialize();

    // INJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_IN1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_IN1, true);   // L
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        result.m_Result = false;
        delete camera;
        delete sp;
        return result.m_Result;
    }
    s8_Exposure = -3;
    camera->SetExposure( s8_Exposure );

    // AWB L
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_IN1, true);
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        result.m_Result = false;
        delete camera;
        delete sp;
        return result.m_Result;
    }

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;
    bool capture_flag = true;
    
    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            ::ShowMessage ( gfx, "Chart Capture", "Push HOME to take a picture." );
        }
        else
        {
            ::ShowMessage ( gfx, "Chart Capture", "Push A,L,R,DOWN or HOME to take a picture." );
        }
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        // ͂߂BJn̂{^͂Ŏ󂯕t
        // FTRł͎B̂ HOME{^݂̂ɐ
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
            {
                nn::applet::CTR::ClearHomeButtonState();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }
        else
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE || pad.IsButtonDown(Pad::BUTTON_A)
                || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
            {
                if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
                {
                    nn::applet::CTR::ClearHomeButtonState();
                }
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();

    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    // ۑ
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    int cam_result = camera->SavePng( "sdmc:/uji/icam.png");
    
    if( cam_result == 0 )
    {
        // ۑ
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Save", "Success." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 1 )
    {
        // SDJ[hȂ
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 2 )
    {
        // SD}Egs
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Mount", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 7 )
    {
        // SD LOCK
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Locked", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else
    {
        // ̗Rŕۑs
        char cam_temp[2];
        sprintf( cam_temp,"%d", cam_result ); 
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
        gfx->m_DrawFramework->SwapBuffers();
    }

    // OUTJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT2 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT2, true);   // L
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        result.m_Result = false;
        delete camera;
        delete sp;
        return result.m_Result;
    }
    s8_Exposure = -4;
    camera->SetExposure( s8_Exposure );

    // AWB L
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT2, true);
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        result.m_Result = false;
        delete camera;
        delete sp;
        return result.m_Result;
    }

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    cam_result = camera->SavePng( "sdmc:/uji/ocamL.png");
    
    if( cam_result == 0 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Save", "Success." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 1 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 2 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Mount", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 7 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Locked", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else
    {
        char cam_temp[2];
        sprintf( cam_temp,"%d", cam_result ); 
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
        gfx->m_DrawFramework->SwapBuffers();
    }

    // EOUTJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT1, true);   // L
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        result.m_Result = false;
        delete camera;
        delete sp;
        return result.m_Result;
    }
    s8_Exposure = -4;
    camera->SetExposure( s8_Exposure );

    // AWB L
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT1, true);
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        result.m_Result = false;
        delete camera;
        delete sp;
        return result.m_Result;
    }

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();

    cam_result = camera->SavePng( "sdmc:/uji/ocamR.png");
    
    if( cam_result == 0 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Save", "Success." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 1 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 2 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Mount", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 7 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Locked", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else
    {
        char cam_temp[2];
        sprintf( cam_temp,"%d", cam_result ); 
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
        gfx->m_DrawFramework->SwapBuffers();
    }

    // `[gBeI特炷
    sp->UjiSoundPlayer( "rom:/SoundPlayer/fanfare_16bit_fs32kHz_1ch.wav", 1500 );

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
  `[gBH to Heap
  ************************************************************************/
bool uji::eva::camera::Capture3PicturesChartToHeap( u8 *heap_chart_in, u8 *heap_chart_out_L, u8 *heap_chart_out_R )
{
    s64 WAIT_TIME = 2000;   // ҂(mS)
    s8 sharpness = 0;       // V[vlX -4`5
    s8 s8_Exposure = -3;    // Il   -5`5
    nn::Result nn_result;   // ̌ʕێp

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();
    
    // B摜̃AhX|C^
    u8 *buffer;
    buffer = heap_chart_in;

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;

    TestCamera *camera = new TestCamera;
    camera->Initialize();

    // INJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    if( !camera->TryStart( heap_result, nn::camera::CTR::SELECT_IN1 ) )
    {
        camera->Finalize();
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_IN1, true);   // L
    if (nn_result.IsFailure())
    {
        camera->Finalize();
        heap_result.m_Result = false;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    s8_Exposure = -3;
    camera->SetExposure( s8_Exposure );

    // AWB L
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_IN1, true);
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        heap_result.m_Result = false;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;
    bool capture_flag = true;
    
    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            ::ShowMessage ( gfx, "Chart Capture", "Push HOME to take a picture." );
        }
        else
        {
            ::ShowMessage ( gfx, "Chart Capture", "Push A,L,R,DOWN or HOME to take a picture." );
        }
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        // ͂߂BJn̂{^͂Ŏ󂯕t
        // FTRł͎B̂ HOME{^݂̂ɐ
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
            {
                nn::applet::CTR::ClearHomeButtonState();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }
        else
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE || pad.IsButtonDown(Pad::BUTTON_A)
                || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
            {
                if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
                {
                    nn::applet::CTR::ClearHomeButtonState();
                }
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();

    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    // ۑ
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    // PNG` SDJ[hɕۑɁABMP` Heapɕۑ
    BmpTexture *bt = new BmpTexture;
    
    bt->ConvertTextureToBmp( buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    NN_LOG("Convert Finished.\n");

    // OUTJLv`
    // 摜ۑύX
    buffer = heap_chart_out_L;

    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    if( !camera->TryStart( heap_result, nn::camera::CTR::SELECT_OUT2 ) )
    {
        camera->Finalize();
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT2, true);   // L
    if (nn_result.IsFailure())
    {
        camera->Finalize();
        heap_result.m_Result = false;
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    s8_Exposure = -4;
    camera->SetExposure( s8_Exposure );

    // AWB L
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT2, true);
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        heap_result.m_Result = false;
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();

    // PNG` SDJ[hɕۑɁABMP` Heapɕۑ
    bt->ConvertTextureToBmp( buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    NN_LOG("Convert Finished.\n");

    // EOUTJLv`
    // 摜ۑύX
    buffer = heap_chart_out_R;

    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    if( !camera->TryStart( heap_result, nn::camera::CTR::SELECT_OUT1 ) )
    {
        camera->Finalize();
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT1, true);   // L
    if (nn_result.IsFailure())
    {
        camera->Finalize();
        heap_result.m_Result = false;
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    s8_Exposure = -4;
    camera->SetExposure( s8_Exposure );

    // AWB L
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT1, true);
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        heap_result.m_Result = false;
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    // PNG` SDJ[hɕۑɁABMP` Heapɕۑ
    bt->ConvertTextureToBmp( buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    NN_LOG("Convert Finished.\n");
    
    // `[gBeI特炷
    sp->UjiSoundPlayer( "rom:/SoundPlayer/fanfare_16bit_fs32kHz_1ch.wav", 1500 );
    
    delete bt;

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    return heap_result.m_Result;
}

/************************************************************************
  ׂBH
  ************************************************************************/
bool uji::eva::camera::Capture3PicturesWhite(TestResult &result)
{
    s64 WAIT_TIME = 2000;   // ҂(mS)
    s8 sharpness = 0;       // V[vlX -4`5
    s8 s8_Exposure = 0;     // Il   -5`5
    result.m_Micro = PASS;  // G[}CNR[h
    nn::Result nn_result;   // ̌ʕێp

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;

    // `[gBe{ꍇ͑}҂摜\Ȃ
    if( !chart_captured )
    {
        // ܂SDJ[hgݍݎw
        sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
        jpegDrawer->OpenPicture(L"rom:/jpeg/setSD.jpg");
        jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SwapBuffers();
        
        // SDJ[h܂Ń[v
        do
        {
            // C҂Ԃ
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        }while( !nn::fs::IsSdmcInserted() );

        // 摜
        jpegDrawer->ClosePicture();
        delete jpegDrawer;
    }

// ۑOSDJ[hmF
    // LOCKĂȂmF
    if( !nn::fs::IsSdmcWritable() )
    {
        NN_LOG( "SD Card is Locked(Not Writable)\n" );
    }
    // SDJ[h}Eg
    nn::fs::MountSdmc();
    
    // ujifBNgȂ쐬
    nn::fs::Directory dir;
    nn_result = dir.TryInitialize( L"sdmc:/uji" );
    
    // fBNgȂꍇ͐VK쐬
    if(nn_result.IsFailure())
    {
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Can't Initialize!", "Create Directory..." );
        NN_LOG( "Can't Initialize! Create Directory...\n" );
        gfx->m_DrawFramework->SwapBuffers();

        nn_result = nn::fs::TryCreateDirectory( L"sdmc:/uji" );
        if(nn_result.IsFailure())
        {
            gfx->m_DrawFramework->Clear();
            ::ShowMessage ( gfx, "Warning", "Fail to Create Directory!" );
            NN_LOG( "Can't Create Directory!\n" );
            gfx->m_DrawFramework->SwapBuffers();
        }
        else
        {
            NN_LOG( "Create Directory Success!\n" );
        }
    }
    else
    {
        dir.Finalize();
        NN_LOG( "Directory is Already Exist\n" );
    }

    // ɓt@Cꍇ͍폜
    nn_result = nn::fs::TryDeleteFile( L"sdmc:/uji/icam_white.png" );
    if( nn_result.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/icam_white.png is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/icam_white.png Delete Success\n" );
    }
    nn_result = nn::fs::TryDeleteFile( L"sdmc:/uji/ocamL_white.png" );
    if( nn_result.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/ocamL_white.png is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/ocamL_white.png Delete Success\n" );
    }
    nn_result = nn::fs::TryDeleteFile( L"sdmc:/uji/ocamR_white.png" );
    if( nn_result.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/ocamR_white.png is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/ocamR_white.png Delete Success\n" );
    }
    // SDJ[hA}Eg
    nn::fs::Unmount("sdmc:");
// ܂ŕۑOSDJ[hmF

    TestCamera *camera = new TestCamera;
    camera->Initialize();

    // INJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_IN1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_IN1, true);   // L
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        result.m_Result = false;
        delete camera;
        delete sp;
        return result.m_Result;
    }
    s8_Exposure = 0;
    camera->SetExposure( s8_Exposure );

    // AWB 𖳌AWBlŒl
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_IN1, false);
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
	    result.m_Result = false;
        delete camera;
        delete sp;
	    return result.m_Result;
    }
    // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
    u32_WhiteBalance = 5;
    camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;
    bool capture_flag = true;
    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            ::ShowMessage ( gfx, "White Capture", "Push HOME to take a picture." );
        }
        else
        {
            ::ShowMessage ( gfx, "White Capture", "Push A,L,R,DOWN or HOME to take a picture." );
        }
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        // ͂߂BJn̂{^͂Ŏ󂯕t
        // FTRł͎B̂ HOME{^݂̂ɐ
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
            {
                nn::applet::CTR::ClearHomeButtonState();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }
        else
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE || pad.IsButtonDown(Pad::BUTTON_A)
                || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
            {
                if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
                {
                    nn::applet::CTR::ClearHomeButtonState();
                }
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();

    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    // PNG` SDJ[hɕۑO BMP`ɕϊĔƂу`FbNs
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();
    u32 bmpSize = (uji::eva::TestCamera::CAMERA_WIDTH * uji::eva::TestCamera::CAMERA_HEIGHT *3 );
    u8 *bof_buffer = (u8*)sysApp->AllocateDeviceMemory( bmpSize );
    BmpTexture *bt = new BmpTexture;
#if 1
    bt->ConvertTextureToBmp( bof_buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    // Ƃу`FbN
    if( !CheckBoh( bof_buffer ) )
    {
        sprintf( result.m_String, "icam blown out highlights" );
        result.m_Micro = BLOWN_OUT_HIGHLIGHTS_ICAM;
        result.m_Result = false;
        delete camera;
        delete sp;
        delete bt;
        sysApp->Free( bof_buffer );
        return result.m_Result;
    }
#endif

    // ۑ
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    int cam_result = camera->SavePng( "sdmc:/uji/icam_white.png");
    
    if( cam_result == 0 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Save", "Success." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 1 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 2 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Mount", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 7 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Locked", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else
    {
        char cam_temp[2];
        sprintf( cam_temp,"%d", cam_result ); 
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
        gfx->m_DrawFramework->SwapBuffers();
    }

    // EOUTJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT1, true);   // L
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        result.m_Result = false;
        delete camera;
        delete sp;
        delete bt;
        sysApp->Free( bof_buffer );
        return result.m_Result;
    }
    s8_Exposure = 0;
    camera->SetExposure( s8_Exposure );

    // AWB 𖳌AzCgoXŒlݒ
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT1, false);
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
	    result.m_Result = false;
        delete camera;
        delete sp;
        delete bt;
        sysApp->Free( bof_buffer );
        return result.m_Result;
    }
    // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
    u32_WhiteBalance = 5;
    camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

#if 1
    // PNG` SDJ[hɕۑO BMP`ɕϊĔƂу`FbNs
    bt->ConvertTextureToBmp( bof_buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    // Ƃу`FbN
    if( !CheckBoh( bof_buffer ) )
    {
        sprintf( result.m_String, "ocamR blown out highlights" );
        result.m_Result = false;
        result.m_Micro = BLOWN_OUT_HIGHLIGHTS_OCAM_R;
        delete camera;
        delete sp;
        delete bt;
        sysApp->Free( bof_buffer );
        return result.m_Result;
    }
#endif

    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    cam_result = camera->SavePng( "sdmc:/uji/ocamR_white.png");
    
    if( cam_result == 0 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Save", "Success." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 1 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 2 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Mount", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 7 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Locked", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else
    {
        char cam_temp[2];
        sprintf( cam_temp,"%d", cam_result ); 
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
        gfx->m_DrawFramework->SwapBuffers();
    }

    // OUTJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT2 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT2, true);   // L
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
        result.m_Result = false;
        delete camera;
        delete sp;
        delete bt;
        sysApp->Free( bof_buffer );
        return result.m_Result;
    }
    s8_Exposure = 0;
    camera->SetExposure( s8_Exposure );

    // AWB 𖳌AzCgoXŒlݒ
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT2, false);
    if (nn_result.IsFailure())
    {
        camera -> Finalize();
	    result.m_Result = false;
        delete camera;
        delete sp;
        delete bt;
        sysApp->Free( bof_buffer );
        return result.m_Result;
    }
    // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
    u32_WhiteBalance = 5;
    camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

#if 1
    // PNG` SDJ[hɕۑO BMP`ɕϊĔƂу`FbNs
    bt->ConvertTextureToBmp( bof_buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    // Ƃу`FbN
    if( !CheckBoh( bof_buffer ) )
    {
        sprintf( result.m_String, "ocamL blown out highlights" );
        result.m_Result = false;
        result.m_Micro = BLOWN_OUT_HIGHLIGHTS_OCAM_L;
        delete camera;
        delete sp;
        delete bt;
        sysApp->Free( bof_buffer );
        return result.m_Result;
    }
#endif

    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    cam_result = camera->SavePng( "sdmc:/uji/ocamL_white.png");
    
    if( cam_result == 0 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Save", "Success." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 1 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 2 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Mount", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else if( cam_result == 7 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "SD Locked", "Failed." );
        gfx->m_DrawFramework->SwapBuffers();
    }
    else
    {
        char cam_temp[2];
        sprintf( cam_temp,"%d", cam_result ); 
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
        gfx->m_DrawFramework->SwapBuffers();
    }

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;
    delete bt;
    sysApp->Free( bof_buffer );

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
  ׂBH to Heap
  ************************************************************************/
bool uji::eva::camera::Capture3PicturesWhiteToHeap( u8 *heap_white_in, u8 *heap_white_out_L, u8 *heap_white_out_R )
{
    s64 WAIT_TIME = 2000;   // ҂(mS)
    s8 sharpness = 0;       // V[vlX -4`5
    s8 s8_Exposure = 0;     // Il   -5`5
    nn::Result nn_result;   // ̌ʕێp

    heap_result.m_Micro = PASS;  // G[}CNR[h

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();

    // B摜̃AhX|C^
    u8 *buffer;
    buffer = heap_white_in;

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    // V[PXJnȎ҂bZ[W\
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Please Wait...", "Now Preparing." );
    gfx->m_DrawFramework->SwapBuffers();

    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;
    sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 1 );

    TestCamera *camera = new TestCamera;
    camera->Initialize();

    // INJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    if( !camera->TryStart( heap_result, nn::camera::CTR::SELECT_IN1 ) )
    {
        camera->Finalize();
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_IN1, true);   // L
    if (nn_result.IsFailure())
    {
        camera->Finalize();
        heap_result.m_Result = false;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    s8_Exposure = 0;
    camera->SetExposure( s8_Exposure );

    // AWB 𖳌AzCgoXŒlݒ
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_IN1, false);
    if ( nn_result.IsFailure() )
    {
        camera->Finalize();
        heap_result.m_Result = false;
        delete camera;
        delete sp;
	    return heap_result.m_Result;
    }
    // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
    u32_WhiteBalance = 5;
    camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;
    bool capture_flag = true;
    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            ::ShowMessage ( gfx, "White Capture", "Push HOME to take a picture." );
        }
        else
        {
            ::ShowMessage ( gfx, "White Capture", "Push A,L,R,DOWN or HOME to take a picture." );
        }
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        // ͂߂BJn̂{^͂Ŏ󂯕t
        // FTRł͎B̂ HOME{^݂̂ɐ
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
            {
                nn::applet::CTR::ClearHomeButtonState();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }
        else
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE || pad.IsButtonDown(Pad::BUTTON_A)
                || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
            {
                if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
                {
                    nn::applet::CTR::ClearHomeButtonState();
                }
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();

    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    // ۑ
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    // PNG` SDJ[hɕۑɁABMP` Heapɕۑ
    BmpTexture *bt = new BmpTexture;
    
    bt->ConvertTextureToBmp( buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    NN_LOG("Convert Finished.\n");

#if 1
    // ŔƂу`FbNI
    if( !CheckBoh( buffer ) )
    {
        camera->Finalize();
        delete bt;
        delete camera;
        delete sp;
        heap_result.m_Micro = BLOWN_OUT_HIGHLIGHTS_ICAM;
        heap_result.m_Result = false;
        sprintf( heap_result.m_String, "icam blown out highlights" );
        return heap_result.m_Result;
    }
#endif

    // OUTJLv`
    // 摜ۑύX
    buffer = heap_white_out_L;

    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    if( !camera->TryStart( heap_result, nn::camera::CTR::SELECT_OUT2 ) )
    {
        camera->Finalize();
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT2, true);   // L
    if (nn_result.IsFailure())
    {
        camera->Finalize();
        heap_result.m_Result = false;
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    s8_Exposure = 0;
    camera->SetExposure( s8_Exposure );

    // AWB 𖳌AzCgoXŒlݒ
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT2, false);
    if ( nn_result.IsFailure() )
    {
        camera->Finalize();
        heap_result.m_Result = false;
        delete bt;
        delete camera;
        delete sp;
	    return heap_result.m_Result;
    }
    // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
    u32_WhiteBalance = 5;
    camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    // PNG` SDJ[hɕۑɁABMP` Heapɕۑ
    bt->ConvertTextureToBmp( buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    NN_LOG("Convert Finished.\n");

#if 1
    // ŔƂу`FbNI
    if( !CheckBoh( buffer ) )
    {
        camera->Finalize();
        delete bt;
        delete camera;
        delete sp;
        heap_result.m_Micro = BLOWN_OUT_HIGHLIGHTS_OCAM_L;
        heap_result.m_Result = false;
        sprintf( heap_result.m_String, "ocam L blown out highlights" );
        return heap_result.m_Result;
    }
#endif

    // EOUTJLv`
    // 摜ۑύX
    buffer = heap_white_out_R;

    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    if( !camera->TryStart( heap_result, nn::camera::CTR::SELECT_OUT1 ) )
    {
        camera->Finalize();
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    // I̎@\
    nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT1, true);   // L
    if (nn_result.IsFailure())
    {
        camera->Finalize();
        heap_result.m_Result = false;
        delete bt;
        delete camera;
        delete sp;
        return heap_result.m_Result;
    }
    s8_Exposure = 0;
    camera->SetExposure( s8_Exposure );

    // AWB 𖳌AzCgoXŒlݒ
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT1, false);
    if ( nn_result.IsFailure() )
    {
        camera->Finalize();
        heap_result.m_Result = false;
        delete bt;
        delete camera;
        delete sp;
	    return heap_result.m_Result;
    }
    // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
    u32_WhiteBalance = 5;
    camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now Saving...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    
    // PNG` SDJ[hɕۑɁABMP` Heapɕۑ
    bt->ConvertTextureToBmp( buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    NN_LOG("Convert Finished.\n");

#if 1
    // ŔƂу`FbNI
    if( !CheckBoh( buffer ) )
    {
        camera->Finalize();
        delete bt;
        delete camera;
        delete sp;
        heap_result.m_Micro = BLOWN_OUT_HIGHLIGHTS_OCAM_R;
        heap_result.m_Result = false;
        sprintf( heap_result.m_String, "ocam R blown out highlights" );
        return heap_result.m_Result;
    }
#endif

    delete bt;

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    heap_result.m_Result = true;
    return heap_result.m_Result;
}

/************************************************************************
  NAND Avp̏܂Ƃ߂֐
  ************************************************************************/
void uji::eva::camera::CaptureToHeap( u8 *cam_buf, TextWindow *m_CamWindow )
{
    // JnOʕ\
    int maxWaitTime = 9999;         // s͎~

    nn::os::Tick::Tick  startTick;  // Jn̂shbj

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config *m_Config = new Config;
    uji::seq::TestListManager *m_TestListManager = new TestListManager;

    //RtBOΉ̃eXgXgK肷
    m_TestListManager->SetCurrentTestList( m_Config->GetAlternative().TestList );

    sprintf( heap_result.m_String, "" );
    
    const int FONT_SIZE = 14;
    uji::sys::TextWindow *m_Window = new TextWindow( GraphicsDrawing::DISPLAY0_WIDTH/(FONT_SIZE/2), GraphicsDrawing::DISPLAY0_HEIGHT/FONT_SIZE, FONT_SIZE );
    m_Window->SetTitle( "SEQUENCER" );
    uji::sys::Menu::m_WindowManager.CreateWindow(m_Window, NN_GX_DISPLAY0,0,0 );

    //JnɕKvȏ
    m_Window->Printf( "\f" );
    m_Window->Printf( "[CTR Eva]\n" );
    m_Window->Printf( "\n" );
    m_Window->Printf( "\n" );
    m_Window->Printf( "Mode:%s\n", m_TestListManager->GetCurrentTestListName() );
    m_Window->Printf( "\n" );
    m_Window->Printf( "\n" );
    m_Window->Printf( "Version    :%s\n", UJI_APPVER_CAM_CAPTURE    );
    m_Window->Printf( "Last Update:%s\n", VERSION_DATE      );
    m_Window->Printf( "\n" );
    m_Window->Printf( "Test Sequence check code %04d\n", m_TestListManager->GetCheckCode()  );
    m_Window->Printf( "Configuration check code %04d\n", m_Config->GetCheckCode()   );
    m_Window->Printf( "\n" );
    m_Window->Printf( "\n" );

    //I҂
    int second;

    m_Window->Printf( "- Push A Key -" );

    startTick = nn::os::Tick::GetSystemCurrent();

    //j[[v
    do {
        second = (int)( nn::os::Tick::GetSystemCurrent()-startTick ).ToTimeSpan().GetSeconds();

        //pbhXV
        pad.UpdatePad();
        //EChE
        Menu::m_WindowManager.Update();
        // ʕ`
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->Clear();
        uji::sys::Menu::m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        ShowPicture( L"rom:/jpeg/Start.jpg" );
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }
    while( second<maxWaitTime && !pad.IsButtonRepeat(Pad::BUTTON_A) );
    pad.WaitReleaseKey();

    Menu::m_WindowManager.DestroyWindow(m_Window);
    m_Window->Destroy();
    delete m_Window;
    delete m_TestListManager;
    delete m_Config;
    // ܂ŌJnOʕ\

    // B摜̃AhX|C^
    static u8 *buffer_chart_in;
    static u8 *buffer_white_in;
    static u8 *buffer_chart_out_L;
    static u8 *buffer_white_out_L;
    static u8 *buffer_chart_out_R;
    static u8 *buffer_white_out_R;

    // ł BMPt@C6̃obt@؂
    u32 bmpSize = (uji::eva::TestCamera::CAMERA_WIDTH * uji::eva::TestCamera::CAMERA_HEIGHT *3 );
    buffer_chart_in    = cam_buf;
    buffer_white_in    = buffer_chart_in    + bmpSize;
    buffer_chart_out_L = buffer_white_in    + bmpSize;
    buffer_white_out_L = buffer_chart_out_L + bmpSize;
    buffer_chart_out_R = buffer_white_out_L + bmpSize;
    buffer_white_out_R = buffer_chart_out_R + bmpSize;

    // Be
    // `[gBe
    uji::eva::camera::Capture3PicturesChartToHeap( buffer_chart_in, buffer_chart_out_L, buffer_chart_out_R );
    // NGI
    if( heap_result.m_Result == false )   goto CAPTURE_FINISHED;
    // ׂBe
    uji::eva::camera::Capture3PicturesWhiteToHeap( buffer_white_in, buffer_white_out_L, buffer_white_out_R );

CAPTURE_FINISHED:

    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    uji::seq::Config  *c = new uji::seq::Config;
    SoundPlayer *sp = new SoundPlayer;

    // ʗpEBhE쐬
    m_CamWindow->SetTitle( "CAMERA CAPTURE" );
    Menu::m_WindowManager.CreateWindow(m_CamWindow, NN_GX_DISPLAY0,0,0 );

    //xʃNA
    m_CamWindow->Printf( "\f" );

    //ʏ\
    m_CamWindow->Gotoxy( 0, 0 );
    m_CamWindow->Printf( "[TEST Ver.%s]", UJI_APPVER_CAM_CAPTURE );
    m_CamWindow->Gotoxy( 0, 1 );
    m_CamWindow->Printf( "CamCapture" );

    if( heap_result.m_Result == true )
    {
        //  OK O
        pdl->Initialize();
        if( 0 <= pdl->Add_1Line( c->Get().TestMode, "CamCapture", "OK", UJI_APPVER_CAM_CAPTURE, "", "", "", heap_result.m_String ))
        {
            NN_LOG( "Write OK Log Success\n" );
            sprintf( heap_result.m_String, "Camera Capture OK" );
        }
        else
        {
            heap_result.m_Result = false;
            NN_LOG( "Write OK Log Error\n" );
            sprintf( heap_result.m_String, "Write OK Log Error" );
        }
    }
    else
    {
        //  NG O
        pdl->Initialize();
        if( 0 <= pdl->Add_1Line( c->Get().TestMode, "CamCapture", "NG", UJI_APPVER_CAM_CAPTURE, "", "", "", heap_result.m_String ))
        {
            NN_LOG( "Write NG Log Success\n" );
        }
        else
        {
            NN_LOG( "Write NG Log Error\n" );
            sprintf( heap_result.m_String, "Write NG Log Error" );
        }
    }
    pdl->Finalize();

    // MESSAGE
    m_CamWindow->Gotoxy( 0, 6 );
    m_CamWindow->SetTextColor( ATTR_COLOR_WHITE );
    m_CamWindow->Printf( "MESSAGE:\n%s\n",heap_result.m_String );

    // ʕ\
    if( heap_result.m_Result == true )
    {
        ShowPicture( L"rom:/jpeg/Pass.jpg" );
        // EBhEւ̌ʕ\
        m_CamWindow->Gotoxy( 22, 15 );
        m_CamWindow->SetTextColor( ATTR_COLOR_GREEN );
        m_CamWindow->Printf( "TOTAL:PASS" );
    }
    else
    {
        ShowPicture( L"rom:/jpeg/Fail.jpg" );
        // EBhEւ̌ʕ\
        m_CamWindow->Gotoxy( 22, 15 );
        m_CamWindow->SetTextColor( ATTR_COLOR_RED );
        m_CamWindow->Printf( "TOTAL:FAIL" );
    }

    //EChE
    Menu::m_WindowManager.Update();
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    Menu::m_WindowManager.DrawDisplay0();

    // `揈
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

    // 
    if( heap_result.m_Result == true )  sp->UjiSoundPlayer( "rom:/SoundPlayer/ok.wav", 1500 );
    else                                sp->UjiSoundPlayer( "rom:/SoundPlayer/ng.wav", 1500 );

    delete sp;
    delete c;
    delete pdl;

}

/************************************************************************
 Ƃу`FbN
  ************************************************************************/
bool uji::eva::camera::CheckBoh( u8 *buffer )// Blown out highlightsiƂсj
{
    bool boh_flag = true;   
    int boh_counter = 40;   // TODO:ǂmFn߂悤 
    do
    {
        if( buffer[boh_counter] < 0XF0 )   boh_flag = false;
        boh_counter++;
        if( boh_counter > uji::eva::TestCamera::CAMERA_WIDTH * uji::eva::TestCamera::CAMERA_HEIGHT )    // TODO:ǂ܂ŊmF悤 
        {
            return false;
        }
    }while( boh_flag );

    return true;
}


// ~IpWBݒ肵SDɕۑ֐
/************************************************************************
hmJ݌
  ************************************************************************/
bool uji::eva::camera::TestInCameraMio(TestResult &result)
{
    // ҂(mS)
    s64 WAIT_TIME = 2000;

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();
    
    // {̂Ԃŉo悤ɂ܂
    // ꂢȂˁH
    //nn::snd::SetHeadphoneOutOnShellClose(false);

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;
    sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 1 );

    // ܂SDJ[hgݍݎw
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    jpegDrawer->OpenPicture(L"rom:/jpeg/setSD.jpg");
    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->SwapBuffers();
    
    // SDJ[h܂Ń[v
    do
    {
        // C҂Ԃ
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }while( !nn::fs::IsSdmcInserted() );

    // 摜
    jpegDrawer->ClosePicture();

// SDJ[hmF
    // LOCKĂȂmF
    if( !nn::fs::IsSdmcWritable() )
    {
        NN_LOG( "SD Card is Locked(Not Writable)\n" );
    }
    // SDJ[h}Eg
    nn::fs::MountSdmc();
    
    // ujifBNgȂ쐬
    nn::fs::Directory dir;
    nn::Result nnResult = dir.TryInitialize( L"sdmc:/uji" );
    
    // fBNgȂꍇ͐VK쐬
    if(nnResult.IsFailure())
    {
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Can't Initialize!", "Create Directory..." );
        NN_LOG( "Can't Initialize! Create Directory...\n" );
        gfx->m_DrawFramework->SwapBuffers();

        nnResult = nn::fs::TryCreateDirectory( L"sdmc:/uji" );
        if(nnResult.IsFailure())
        {
            gfx->m_DrawFramework->Clear();
            ::ShowMessage ( gfx, "Warning", "Fail to Create Directory!" );
            NN_LOG( "Can't Create Directory!\n" );
            gfx->m_DrawFramework->SwapBuffers();
        }
        else
        {
            NN_LOG( "Create Directory Success!\n" );
        }
    }
    else
    {
        dir.Finalize();
        NN_LOG( "Directory is Already Exist\n" );
    }

    // ɓt@Cꍇ͍폜
    nnResult = nn::fs::TryDeleteFile( L"sdmc:/uji/icam.bmp" );
    if( nnResult.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/icam.bmp is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/icam.bmp Delete Success\n" );
    }
    nnResult = nn::fs::TryDeleteFile( L"sdmc:/uji/ocamL.bmp" );
    if( nnResult.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/ocamL.bmp is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/ocamL.bmp Delete Success\n" );
    }
    nnResult = nn::fs::TryDeleteFile( L"sdmc:/uji/ocamR.bmp" );
    if( nnResult.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/ocamR.bmp is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/ocamR.bmp Delete Success\n" );
    }
    // SDJ[hA}Eg
    nn::fs::Unmount("sdmc:");
// ܂SDJ[hmF

    TestCamera *camera = new TestCamera;
    camera->Initialize();

    // INJLv`
    // ŘI肳ړIŁAɎBOUT2JActiveɂĂ?
   // camera->Start( nn::camera::CTR::SELECT_OUT2 );
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_IN1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    s8 sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;
    bool capture_flag = true;
    
    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            ::ShowMessage ( gfx, "Chart Capture", "Push HOME to take a picture." );
        }
        else
        {
            ::ShowMessage ( gfx, "Chart Capture", "Push A,L,R,DOWN or HOME to take a picture." );
        }
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        // ͂߂BJn̂{^͂Ŏ󂯕t
        // FTRł͎B̂ HOME{^݂̂ɐ
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
            {
                nn::applet::CTR::ClearHomeButtonState();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }
        else
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE || pad.IsButtonDown(Pad::BUTTON_A)
                || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
            {
                if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
                {
                    nn::applet::CTR::ClearHomeButtonState();
                }
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();

    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    camera->SaveBmp( L"sdmc:/uji/icam.bmp" );



    // OUTJLv`
    // ŘI肳ړIŁAɎBOUT1JActiveɂĂ
    // OUT2J͎OActiveɂȂĂ̂StartȂ
    //camera->Start( nn::camera::CTR::SELECT_OUT1 );
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT2 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    
    camera->SaveBmp( L"sdmc:/uji/ocamL.bmp" );
    
    // EOUTJLv`
    // OUT1J͎OActiveɂȂĂ̂StartȂ
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    camera->SaveBmp( L"sdmc:/uji/ocamR.bmp" );

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
ntsJiEj݌
  ************************************************************************/
bool uji::eva::camera::TestOutRightCameraMio(TestResult &result)
{
    //҂(mS)
    s64 WAIT_TIME = 2000;

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();
    
    // {̂Ԃŉo悤ɂ܂
    // ꂢȂˁH
    //nn::snd::SetHeadphoneOutOnShellClose(false);

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;
    sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 1 );

    // ܂SDJ[hgݍݎw
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    jpegDrawer->OpenPicture(L"rom:/jpeg/setSD.jpg");
    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->SwapBuffers();
    
    // SDJ[h܂Ń[v
    do
    {
        // C҂Ԃ
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }while( !nn::fs::IsSdmcInserted() );

    // 摜
    jpegDrawer->ClosePicture();

// ۑOSDJ[hmF
    // LOCKĂȂmF
    if( !nn::fs::IsSdmcWritable() )
    {
        NN_LOG( "SD Card is Locked(Not Writable)\n" );
    }
    // SDJ[h}Eg
    nn::fs::MountSdmc();
    
    // ujifBNgȂ쐬
    nn::fs::Directory dir;
    nn::Result nnResult = dir.TryInitialize( L"sdmc:/uji" );
    
    // fBNgȂꍇ͐VK쐬
    if(nnResult.IsFailure())
    {
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Can't Initialize!", "Create Directory..." );
        NN_LOG( "Can't Initialize! Create Directory...\n" );
        gfx->m_DrawFramework->SwapBuffers();

        nnResult = nn::fs::TryCreateDirectory( L"sdmc:/uji" );
        if(nnResult.IsFailure())
        {
            gfx->m_DrawFramework->Clear();
            ::ShowMessage ( gfx, "Warning", "Fail to Create Directory!" );
            NN_LOG( "Can't Create Directory!\n" );
            gfx->m_DrawFramework->SwapBuffers();
        }
        else
        {
            NN_LOG( "Create Directory Success!\n" );
        }
    }
    else
    {
        dir.Finalize();
        NN_LOG( "Directory is Already Exist\n" );
    }

    // ɓt@Cꍇ͍폜
    nnResult = nn::fs::TryDeleteFile( L"sdmc:/uji/icam_white.bmp" );
    if( nnResult.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/icam_white.bmp is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/icam_white.bmp Delete Success\n" );
    }
    nnResult = nn::fs::TryDeleteFile( L"sdmc:/uji/ocamL_white.bmp" );
    if( nnResult.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/ocamL_white.bmp is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/ocamL_white.bmp Delete Success\n" );
    }
    nnResult = nn::fs::TryDeleteFile( L"sdmc:/uji/ocamR_white.bmp" );
    if( nnResult.IsFailure() )
    {
        NN_LOG( "sdmc:/uji/ocamR_white.bmp is not Exist\n" );
    }
    else
    {
        NN_LOG( "sdmc:/uji/ocamR_white.bmp Delete Success\n" );
    }
    // SDJ[hA}Eg
    nn::fs::Unmount("sdmc:");
// ܂ŕۑOSDJ[hmF

    TestCamera *camera = new TestCamera;
    camera->Initialize();

    // INJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_IN1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    s8 sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

// zCgoXŒlݒ
    // AWB 𖳌
    nn::Result nn_result;
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_IN1, false);
    if (nn_result.IsFailure())
    {
	    result.m_Result = false;
	    return result.m_Result;
    }
    // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
    u32_WhiteBalance = 5;
    camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );
// ܂

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;
    bool capture_flag = true;
    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            ::ShowMessage ( gfx, "White Capture", "Push HOME to take a picture." );
        }
        else
        {
            ::ShowMessage ( gfx, "White Capture", "Push A,L,R,DOWN or HOME to take a picture." );
        }
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        // ͂߂BJn̂{^͂Ŏ󂯕t
        // FTRł͎B̂ HOME{^݂̂ɐ
        if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
            {
                nn::applet::CTR::ClearHomeButtonState();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }
        else
        {
            if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE || pad.IsButtonDown(Pad::BUTTON_A)
                || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
            {
                if( nn::applet::GetHomeButtonState() != nn::applet::CTR::HOME_BUTTON_NONE )
                {
                    nn::applet::CTR::ClearHomeButtonState();
                }
                sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
                isTimerStart = true;
                startTick = nn::os::Tick::GetSystemCurrent();
                capture_flag = false;
            }
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();

    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    camera->SaveBmp( L"sdmc:/uji/icam_white.bmp" );

    // EOUTJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

// zCgoXŒlݒ
    // AWB 𖳌
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT1, false);
    if (nn_result.IsFailure())
    {
	    result.m_Result = false;
	    return result.m_Result;
    }
    // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
    u32_WhiteBalance = 5;
    camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );
// ܂

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    
    camera->SaveBmp( L"sdmc:/uji/ocamR_white.bmp" );

    // OUTJLv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT2 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

// zCgoXŒlݒ
    // AWB 𖳌
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT2, false);
    if (nn_result.IsFailure())
    {
	    result.m_Result = false;
	    return result.m_Result;
    }
    // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
    u32_WhiteBalance = 5;
    camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );
// ܂

    isCaptured = false;
    isTimerStart = false;
    capture_flag = true;

    // Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN or HOME to take a picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( capture_flag )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
            capture_flag = false;
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }
    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    camera->SaveBmp( L"sdmc:/uji/ocamL_white.bmp" );

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
ntsJij݌
  ************************************************************************/
bool uji::eva::camera::TestOutLeftCameraMio(TestResult &result)
{
    // ҂(mS)
    s64 WAIT_TIME = 2000;

    // {̂Ԃŉo悤ɂ܂
    nn::snd::SetHeadphoneOutOnShellClose(false);

	uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;

    TestCamera *camera = new TestCamera;
    camera->Initialize();


    // Lv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT2 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );


    s8 sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

// AWB؂悤ɒǉ
    // zCgoX̎@\
    nn::Result nn_result;
    nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT2, false);   // 
    if (nn_result.IsFailure())
    {
	    result.m_Result = false;
	    return result.m_Result;
    }
// ܂

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;

    u32_WhiteBalance = 1;
    bool isWhiteBalanceChanged = false;
    bool once_flag = true;

    // Be
    do
    {
        camera->Update();

        if( once_flag )
        {
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
            gfx->m_DrawFramework->Clear();
            ::ShowMessage ( gfx, "Push RIGHT to change white balance", "Push A,L,R,DOWN to take picture." );
            gfx->m_DrawFramework->SwapBuffers();
        }
        once_flag = false;

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();

// IEzCgoXŒlݒp
        // zCgoXݒ
        if( pad.IsButtonDown(Pad::BUTTON_RIGHT ) )
        {
	        u32_WhiteBalance++;
	        if( WHITEBALANCE_STR[u32_WhiteBalance]==NULL ) u32_WhiteBalance=1;
            camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );
	        isWhiteBalanceChanged = true;
        }

        // ʕ\ؑ
        if( isWhiteBalanceChanged )
        {
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
            gfx->m_DrawFramework->Clear();
            switch(u32_WhiteBalance)
            {
                case 1:
                    ::ShowMessage ( gfx, "Push A,L,R,DOWN to take picture.", "3200K" );
                    break;
                case 2:
                    ::ShowMessage ( gfx, "Push A,L,R,DOWN to take picture.", "4150K" );
                    break;
                case 3:
                    ::ShowMessage ( gfx, "Push A,L,R,DOWN to take picture.", "5200K." );
                    break;
                case 4:
                    ::ShowMessage ( gfx, "Push A,L,R,DOWN to take picture.", "6000K." );
                    break;
                case 5:
                    ::ShowMessage ( gfx, "Push A,L,R,DOWN to take picture.", "7000K." );
                    break;
                default:
                    ::ShowMessage ( gfx, "Push A,L,R,DOWN to take picture.", "default." );
            }
            gfx->m_DrawFramework->SwapBuffers();
            isWhiteBalanceChanged = false;
        }

        if( pad.IsButtonDown(Pad::BUTTON_A) || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }

    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Watch", "Push A to next." );
    gfx->m_DrawFramework->SwapBuffers();

#if 1
    // PNGɏo͂
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Now saving ...", "Please wait a moment." );
    gfx->m_DrawFramework->SwapBuffers();
    int cam_result = camera->SavePng( "sdmc:/uji/ocamL.png");
    if( cam_result == 0 )
    {
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "PNG Save", "Success." );
        gfx->m_DrawFramework->SwapBuffers();
    }else{
        char cam_temp[2];
        sprintf( cam_temp,"%d", cam_result ); 
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "PNG Save", cam_temp );
        gfx->m_DrawFramework->SwapBuffers();
    }
#endif

    Config lcdConfig;
    if( !lcdConfig.Load() ) lcdConfig.Initialize();
    Config::Member lcdMember = lcdConfig.Get();
	int waitTime = lcdMember.LcdTimeWait;			// ʕ\mFp҂

    // mF
    do{
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        pad.UpdatePad();
        if( waitTime>0 ) waitTime--;
		if( pad.IsButtonDown(Pad::BUTTON_A) && waitTime == 0 )	break;
    }while( 1 );
    pad.ClearTriggerFlag();

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}
