/************************************************************************
J
  ************************************************************************/
/* dCN[h̉ */
#ifndef TESTCAMERA_H_INCLUDED
#define TESTCAMERA_H_INCLUDED

#include <vector>
#include <nn.h>
#include <nn/camera.h>
#include "sys.h"
#include "../seq/TestResult.h"

// libpng, zlib̃wb_ǉ
#include "lpng1513/png.h"
#include "zlib-1.2.7/zlib.h"

namespace uji{
namespace eva{


class TestCamera
{
public:
    TestCamera():m_ScrollX(0),m_ScrollY(0),m_IsZoomOut(false),m_IsCaptureStarted(false){}
    ~TestCamera()
    {
        uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        gfx->ReInitRenderSystem();
    }
    void Initialize(void);                                          //
    void Finalize(void);                                            //I
    void Draw( demo::RenderSystemDrawing *fw );                     //`
    
    // OpenShortCheckpvoidbool^ɕύXATestResult̒ǉ
    bool TryStart( uji::seq::TestResult& tResult, nn::camera::CameraSelect select = nn::camera::SELECT_OUT1 );     //JN
    void Start( nn::camera::CameraSelect select = nn::camera::SELECT_OUT1 )
    {
        uji::seq::TestResult dummyResult;
        if( !TryStart( dummyResult, select ))
        {
            SYS_PANIC( dummyResult.m_String );
        }
    }
    
    void Stop(void);                                                //J~
    void Update(void);                                              //摜XV
    void UpdateToAverage(void);                                     //ω摜֍XV
    void SetScroll( int x, int y ){ m_ScrollX=x; m_ScrollY=y; }     //\摜_ݒ
    void EnableZoomOut( void ){ m_IsZoomOut = true; }               //Y[AEgL
    void DesableZoomOut( void ){ m_IsZoomOut = false; }             //Y[AEg
    void Pause( bool enable );                                      //ꎞ~
    bool SaveBmp( const wchar_t *fileName );                        //BMPt@CZ[u
    bool Save( void );                                              //Z[u
    bool SaveAverage( void );                                       //ϒlZ[u
    const u16* GetYuv(void) const;                                  //xtuobt@̎擾
    const u16* GetYuvAverage(void) const;                           //xtuobt@̕ώ擾
    u16 *GetCameraTexture(void) const{ return m_CameraTexture; }    //JeNX`̎擾
    void SetWhiteBalance( nn::camera::WhiteBalance wb );            //zCgoXݒiI[g܂ށj
	void SetExposure( s8 exposure );                                //Iݒ
    void FlipImage( nn::camera::Flip flip );                        //tbvݒ
    void SetSharpness( s8 sharpness );                              //Nxݒ
    void SetPhotoMode( nn::camera::PhotoMode photoMode );           //Be[hݒ
    void DeleteTexture( demo::RenderSystemDrawing *fw );            //t[[NJeNX`폜

    static const nn::camera::Size CAMERA_SIZE = nn::camera::SIZE_VGA;
    static const int CAMERA_WIDTH  = 640;
    static const int CAMERA_HEIGHT = 480;
    static const int CAMERA_TEXTURE_WIDTH = 1024;
    static const int CAMERA_TEXTURE_HEIGHT = 512;

    static void PreInitialize(void);                                //WŌꍇAW󂫎ɈxR[KvLB

    // ؗpboolint^ɕύX
    int  SavePng(char *file_name);                                  //PNG`Ńt@Cɕۑ
    void CopyPngBuffer(void);                                       //eNX`f[^PNGobt@ɃRs[
    

private:
    class YuvRingBuffer;
    class DoubleBuffer;

    // OpenShortCheckpvoidbool^ɕύXATestResult̒ǉ
    bool InitCamera( uji::seq::TestResult& tResult );
    
    void InitY2r(void);
    void FitToCameraTexture(void);
    nn::camera::Port GetPort(void);

    YuvRingBuffer *m_YuvRingBuffer;
    DoubleBuffer *m_RgbBuffer;
    u16 *m_CameraTexture;
    u8 *m_PngBuffer;

    nn::os::Event m_ErrorIntr;
    nn::os::Event m_TransEndIntr;
    nn::os::Event m_CameraTransEndIntr;
 
    s32 m_TransferUnit;
    size_t m_CameraOutputSize;
    u32 m_Y2rOutputSize;

    nn::camera::CameraSelect m_Select;

    int m_ScrollX;
    int m_ScrollY;
    bool m_IsZoomOut;

    bool m_IsCaptureStarted;

    static bool m_IsHardwareInitialized;
};

/************************************************************************
xtuOobt@

ŕt[̃f[^擾ĕω鏈܂B
t[f[^߂邽߂̃Oobt@łB

Lȋ@\ł
Eobt@i߂
Eobt@gp

  ************************************************************************/


class TestCamera::YuvRingBuffer
{
  public:
    static const int DEFAULT_TOTAL_BUFFERS = 6;
    static const int ELEMENT_SIZE = 2;

    YuvRingBuffer( s16 Width, s16 Height, s16 TotalBuffers=DEFAULT_TOTAL_BUFFERS )
        :m_Width(Width), m_Height(Height), m_TotalBuffers(TotalBuffers), m_CurrentBufferId(0){}

    ~YuvRingBuffer(){}

    void Initialize(void);          //@CX^X쐬ŏɓǂł
    void Finalize(void);            //I
    void *GetCurrent(void) const;   //݂̃obt@擾
    void *GetNext(void) const;      //̃obt@擾
    void *GetPrevious(void) const;  //Õobt@擾
    void Forward(void);             //obt@𑗂
    void *GetAverage(void);         //Sobt@̕ϒl

private: 
    s16 m_Width;
    s16 m_Height;
    s16 m_TotalBuffers;
    s16 m_CurrentBufferId;  //O͓ʗprɎgpAʏ͂P

    std::vector<u16*> m_Buffers;

};


/************************************************************************
_uobt@
  ************************************************************************/
class TestCamera::DoubleBuffer
{
  public:

    DoubleBuffer( s16 Width, s16 Height )
        :m_Width(Width), m_Height(Height), m_CurrentBufferId(0){}

    ~DoubleBuffer(){}

    void Initialize(void);              //@CX^X쐬ŏɓǂł
    void Finalize(void);                //I
    void *GetBackBuffer(void) const;    //`pobt@擾
    void *GetFrontBuffer(void) const;   //\pobt@擾
    void Swap(void);                    //obt@؂ւ

private: 
    s16 m_Width;
    s16 m_Height;
    s16 m_CurrentBufferId;

    std::vector<u16*> m_Buffers;

    static const int ELEMENT_SIZE = 2;

};

} // namespace eva
} // namespace uji

/* dCN[h̉ */
#endif
