/********************************************************************
J
********************************************************************/

#include <nn.h>
#include <nn/gx.h>
#include <nn/camera.h>
#include <nn/y2r.h>
#include <nn/fs.h>
#include <nn/camera/CTR/camera_ApiForHardwareCheck.h>
#include <string.h>
#include "sys.h"
#include "../sys/sys_BmpTexture.h"
#include "../seq/Config.h"
#include "TestCamera.h"
using namespace uji;
using namespace uji::sys;
using namespace uji::eva;
using namespace uji::seq;
using namespace nn;
using namespace nn::camera;
using namespace nn::y2r;

const int Y2R_YUV_BYTES = 2;
const int Y2R_RGB_BYTES = 2;

static GLuint s_TextureId = 0;


bool uji::eva::TestCamera::m_IsHardwareInitialized = false;

// ܂肽ȂǁANXϐgȂ̂ŃO[o
static bit8 *g_png_file_buffer;
static int   g_png_file_size;
static int   g_func_call_cnt;

/************************************************************************
fobOo
  ***********************************************************************/
static void DebugOut( const char *str )
{
    Config c;
    if( c.Get().EnableDebugOut ){
        if (nn::fs::IsSdmcInserted())
        {

                nn::Result nnr;
                nnr = nn::fs::MountSdmc();
                if( nnr.IsFailure() ) SYS_PANIC( "FAIL TO MOUNT SDMC" );

                nn::fs::FileOutputStream ofile;
                nn::fs::TryCreateDirectory(L"sdmc:/uji" );
                nnr = ofile.TryInitialize( L"sdmc:/uji/debug.txt", true );
                ofile.Seek( ofile.GetSize(), nn::fs::POSITION_BASE_BEGIN );
                ofile.Write( str, strlen(str) );
                ofile.Finalize();

                nn::fs::Unmount("sdmc:");
        }
    }
}

/************************************************************************
 J`
  ***********************************************************************/
void TestCamera::Draw( demo::RenderSystemDrawing *fw )
{
    const u32 bmpWidth = CAMERA_TEXTURE_WIDTH;
    const u32 bmpHeight= CAMERA_TEXTURE_HEIGHT;

    if( s_TextureId != 0 )
    {
        fw->DeleteTexture(s_TextureId);
    }

    GLenum internalFormat = GL_RGB_NATIVE_DMP;
    GLenum format = GL_RGB_NATIVE_DMP;
    GLenum type = GL_UNSIGNED_SHORT_5_6_5;
    u32 textureWidth = bmpWidth;
    u32 textureHeight = bmpHeight;
    FitToCameraTexture();
    if( !fw->GenerateTexture( GL_TEXTURE_2D, internalFormat, textureWidth, textureHeight, format, type, (void*)m_CameraTexture, s_TextureId) )
    {
        NN_LOG( "Fail to generate texture." );
    }


    fw->SetRenderTarget(NN_GX_DISPLAY0);
    fw->SetColor(0.0f, 0.0f, 1.0f, 0.0f);


    f32 coefficient     = m_IsZoomOut?0.5f:1.0f;
    f32 offsetX         = (static_cast<f32>(m_ScrollX) )/static_cast<f32>( CAMERA_TEXTURE_WIDTH );
    f32 offsetY         = (static_cast<f32>(m_ScrollY) )/static_cast<f32>( CAMERA_TEXTURE_HEIGHT);
    f32 rectangleWidth  = coefficient*static_cast<f32>( bmpWidth  );
    f32 rectangleHeight = coefficient*static_cast<f32>( bmpHeight );

    fw->FillTexturedTriangle(s_TextureId,
        0.0f,           0.0f,               offsetX,        1.0f-offsetY,
        rectangleWidth, rectangleHeight,    1.0f+offsetX,   -offsetY,
        rectangleWidth, 0.0f,               1.0f+offsetX,   1.0f-offsetY );
    fw->FillTexturedTriangle(s_TextureId,
        0.0f,           0.0f,               offsetX,        1.0f-offsetY,
        0.0f,           rectangleHeight,    offsetX,        -offsetY,
        rectangleWidth, rectangleHeight,    1.0f+offsetX,   -offsetY    );

}

/************************************************************************
t[[NJeNX`폜
  ***********************************************************************/
void TestCamera::DeleteTexture( demo::RenderSystemDrawing *fw )
{
    if( s_TextureId != 0 )
    {
        fw->DeleteTexture(s_TextureId);
        s_TextureId = 0;
    }
}


/************************************************************************

  ***********************************************************************/
void TestCamera::Initialize( void )
{
    DebugOut( "INITIALIZE\n" );
    m_YuvRingBuffer = new YuvRingBuffer( CAMERA_WIDTH, CAMERA_HEIGHT );
    m_RgbBuffer = new DoubleBuffer( CAMERA_WIDTH, CAMERA_HEIGHT );
    m_CameraTexture = reinterpret_cast<u16*>(SysApp::GetInstance()->AllocateDeviceMemory(TestCamera::CAMERA_TEXTURE_WIDTH*TestCamera::CAMERA_TEXTURE_HEIGHT*Y2R_RGB_BYTES, 64) );

    std::memset( m_CameraTexture, 0x00, TestCamera::CAMERA_TEXTURE_WIDTH*TestCamera::CAMERA_TEXTURE_HEIGHT*Y2R_RGB_BYTES );

    // PNGpɃm
    m_PngBuffer = new bit8[CAMERA_WIDTH*CAMERA_HEIGHT*3];
    std::memset( m_PngBuffer, 0x00, CAMERA_WIDTH * CAMERA_HEIGHT * 3 );

    m_YuvRingBuffer->Initialize();
    m_RgbBuffer->Initialize();
}

/************************************************************************
I
  ***********************************************************************/
void TestCamera::Finalize( void )
{
    DebugOut( "FINALIZE\n" );
    m_RgbBuffer->Finalize();
    m_YuvRingBuffer->Finalize();
    SysApp::GetInstance()->Free( m_CameraTexture );
    delete m_RgbBuffer;
    delete m_YuvRingBuffer;
	delete [] m_PngBuffer;

}
/************************************************************************
JX^[g
 ************************************************************************/
bool TestCamera::TryStart( uji::seq::TestResult& tResult, nn::camera::CameraSelect select )
{
    char str[0x100];
    sprintf( str, "START CAM=%d\n", select );
    DebugOut( str );

    m_Select = select;

    if( !InitCamera( tResult ))
    {
        return tResult.m_Result;
    }
    InitY2r();

    m_TransferUnit = nn::camera::GetTransferBytes( GetPort() );
    m_CameraOutputSize = nn::camera::GetFrameBytes(CAMERA_WIDTH, CAMERA_HEIGHT);
    m_Y2rOutputSize = nn::y2r::GetOutputImageSize(CAMERA_WIDTH, CAMERA_HEIGHT, OUTPUT_RGB_16_565);

    nn::camera::SetReceiving(&m_CameraTransEndIntr, m_YuvRingBuffer->GetCurrent(), GetPort(), m_CameraOutputSize, m_TransferUnit);

    nn::camera::ClearBuffer( GetPort() );
    if( !m_IsCaptureStarted )
    {
        nn::camera::StartCapture( GetPort() );
        m_IsCaptureStarted = true;
    }
    return tResult.m_Result = true;
}
/************************************************************************
J~
  ************************************************************************/
void TestCamera::Stop(void)
{
    if( m_IsCaptureStarted )
    {
        nn::camera::StopCapture( GetPort() );
        m_IsCaptureStarted = false;
    }
    nn::y2r::Finalize();
}

/************************************************************************
J@\
  ************************************************************************/
bool TestCamera::InitCamera( uji::seq::TestResult& tResult )
{
    nn::Result nnr;

    if( !m_IsHardwareInitialized )
    {
        nnr = nn::camera::InitializeHardwareCheck();
        if( nnr.IsFailure() ){
            char str[100];
            s32 level = (s32)nnr.GetLevel();
            sprintf( tResult.m_String, "Fail to initialize. level=%d", level );
            tResult.m_Result = false;
            return tResult.m_Result;
        }
        m_IsHardwareInitialized = true;
    }

    s16 transferLine = nn::camera::GetMaxLines( CAMERA_WIDTH, CAMERA_HEIGHT );
    nn::camera::SetTransferLines( GetPort(), transferLine, CAMERA_WIDTH, CAMERA_HEIGHT );
    nn::camera::GetBufferErrorInterruptEvent( &m_ErrorIntr, GetPort() );
    nnr = nn::camera::SetFrameRate( m_Select, FRAME_RATE_5 );
    if( nnr.IsFailure() )
    {
        sprintf( tResult.m_String, "ERROR:SetFrameRate" );
        tResult.m_Result = false;
        return tResult.m_Result;
    }
    nnr = nn::camera::SetSize( m_Select, CAMERA_SIZE, CONTEXT_A );
    if( nnr.IsFailure() )
    {
        sprintf( tResult.m_String, "ERROR:SetSize" );
        tResult.m_Result = false;
        return tResult.m_Result;
    }
    nnr = nn::camera::Activate( m_Select );
    if( nnr.IsFailure() )
    {
        sprintf( tResult.m_String, "ERROR:Activate" );
        tResult.m_Result = false;
        return tResult.m_Result;
    }

    nnr = nn::camera::SetWhiteBalanceWithoutBaseUp( m_Select, WHITE_BALANCE_AUTO );
    if( nnr.IsFailure() )
    {
        sprintf( tResult.m_String, "ERROR:Without base up" );
        tResult.m_Result = false;
        return tResult.m_Result;
    }
    return tResult.m_Result = true;
}

/************************************************************************
xQq@\
  ************************************************************************/
void TestCamera::InitY2r(void)
{
    nn::y2r::Initialize();
    nn::y2r::StopConversion();

    while( nn::y2r::IsBusyConversion() ){}
    
    nn::y2r::SetInputFormat(INPUT_YUV422_BATCH);
    nn::y2r::SetOutputFormat(OUTPUT_RGB_16_565);
    nn::y2r::SetRotation(ROTATION_NONE);
    nn::y2r::SetBlockAlignment(BLOCK_8_BY_8);
    nn::y2r::SetTransferEndInterrupt(true);
    nn::y2r::GetTransferEndEvent( &m_TransEndIntr );
    nn::y2r::SetInputLineWidth( CAMERA_WIDTH );
    nn::y2r::SetInputLines( CAMERA_HEIGHT );
    nn::y2r::SetStandardCoefficient( COEFFICIENT_ITU_R_BT_709 );
    nn::y2r::SetAlpha(0xff);
}

/************************************************************************
JBef[^̍XV
  ************************************************************************/
void TestCamera::Update( void )
{
    if( m_ErrorIntr.Wait(0) )
    {
        m_ErrorIntr.ClearSignal();
        DebugOut( "X" );
        NN_LOG( "X" );
        nn::camera::StopCapture(GetPort());
        nn::camera::ClearBuffer(GetPort());
        nn::y2r::StopConversion();
        nn::camera::SetReceiving( &m_CameraTransEndIntr, m_YuvRingBuffer->GetCurrent(), GetPort(), m_CameraOutputSize, m_TransferUnit );
        m_TransEndIntr.ClearSignal();
        nn::camera::StartCapture(GetPort());
    }

    bool isFinished = nn::camera::IsFinishedReceiving(GetPort());
    if( isFinished )
    {
        DebugOut( "O" );

        //_uobt@؂ւ
        m_RgbBuffer->Swap();

        //xtuqfaobt@֕ϊJn
        nn::y2r::SetSendingYuv( m_YuvRingBuffer->GetCurrent(), m_CameraOutputSize, CAMERA_WIDTH * Y2R_YUV_BYTES);
        nn::y2r::SetReceiving( m_RgbBuffer->GetBackBuffer(), m_Y2rOutputSize, CAMERA_WIDTH * Y2R_RGB_BYTES);
        nn::y2r::StartConversion();

        //̉摜MJn
        m_YuvRingBuffer->Forward();
        nn::camera::SetReceiving(&m_CameraTransEndIntr, m_YuvRingBuffer->GetCurrent(), GetPort(), m_CameraOutputSize, m_TransferUnit);

    }
}

/************************************************************************
Bef[^JeNX`ɍ킹

POQS~TPQ̃eNX`ɂUSO~SWÕJLv`\t

  ************************************************************************/
void TestCamera::FitToCameraTexture( void )
{
    u16 *Src = reinterpret_cast<u16*>(m_RgbBuffer->GetFrontBuffer());
    u16 *Dst = m_CameraTexture;

    const int BLOCK_SIZE = 8*8;
    const int NUM_SRC_HORIZONTAL_BLOCK = CAMERA_WIDTH/8;
    const int NUM_SRC_VERTICAL_BLOCK   = CAMERA_HEIGHT/8;
    const int NUM_DST_HORIZONTAL_BLOCK = CAMERA_TEXTURE_WIDTH/8;

    for(int  i=0 ; i<NUM_SRC_VERTICAL_BLOCK ; i++ )
    {
        memcpy( Dst, Src, NUM_SRC_HORIZONTAL_BLOCK * BLOCK_SIZE * sizeof(u16) );
        Src += NUM_SRC_HORIZONTAL_BLOCK * BLOCK_SIZE;
        Dst += NUM_DST_HORIZONTAL_BLOCK * BLOCK_SIZE;
    }

}

/************************************************************************
 Rgb888\́@
  RGBɂ邩ABGRɂ邩
 ************************************************************************/
struct Rgb888
{

#if 1
	// RGB
    u8 r;
    u8 g;
    u8 b;
#else
	// BGR
    u8 b;
    u8 g;
    u8 r;
#endif
};

/************************************************************************
 qfaTUT̃f[^qfaWWWialot@ĈQSrbg`jɕϊ܂B
 ************************************************************************/
static Rgb888 Rgb565ToRgb888( u16 rgb565 )
{
    Rgb888 ret;

#if 1
	//ʂ0
    ret.r = (rgb565>>11 & 0x1f)<<3;
    ret.g = (rgb565>>5  & 0x3f)<<2;
    ret.b = (rgb565     & 0x1f)<<3;

#else
	//ʂ0߂Ȃ
    ret.r =  rgb565>>11 & 0x1f;
    ret.g =  rgb565>>5  & 0x3f;
    ret.b =  rgb565     & 0x1f;
#endif

    return ret;
}

/************************************************************************
 GfBAϊ 16bit̏ꍇ
 ************************************************************************/
void swap_endian16(u16 & value)
{
    value = ((value & 0xFF) << 8) | ((value >> 8) & 0xFF);
}

/************************************************************************
 ϊf[^͗pfobOo͕t
 ************************************************************************/
// PNǴAf[^rbOGfBAň
// BMṔAf[^gGfBAň

// BMṔAf[^{ EAAAとE} ̏ɕׂĂ
// PNǴAf[^{ とEAAA} ̏ɕׂĂ
#if 0 
void TestCamera::CopyPngBuffer0( void )
{
    u16 *Src = reinterpret_cast<u16*>(m_RgbBuffer->GetFrontBuffer());
    u8  *Dst = m_PngBuffer;

    u16 * ptr16 = Src;
    u8  * ptr8  = reinterpret_cast<u8 *> (Dst);

	Rgb888  r888;

    for(int i=0; i < (CAMERA_WIDTH * CAMERA_HEIGHT) ; i++)
	{

#if 0
		swap_endian16(*ptr16);
#endif

		r888 = Rgb565ToRgb888(*ptr16);

		if ( 0 == i )      
		{ 
	        NN_LOG("-left top -\n");
			NN_LOG("ptr16       %p \n", ptr16);
			NN_LOG("ptr16 value %p \n", *ptr16);
			NN_LOG("ptr8        %p \n", ptr8);
			NN_LOG("ptr8  value %p \n", *ptr8);
			NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); 
		}

		if ( 1 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 2 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 3 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 4 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 5 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 6 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 7 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 8 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }

        
		if ( 636 == i )      
		{
			NN_LOG("-right top -\n"); 
			NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); 
		}
		if ( 637 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 638 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 639 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }

		if ( 640 == i )      
		{
	        NN_LOG("-left top+1 -\n");
			NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); 
		}
		if ( 641 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 642 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 643 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }

		if ( 1276 == i )
		{ 
			NN_LOG("-right top+1 -\n");
			NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); 
		}
		if ( 1277 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 1278 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 1279 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }

		if ( 306540 == i )      
		{ 
			NN_LOG("-left bottom -\n");
			NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); 
		}
		if ( 306541 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 306542 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 306543 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }

        
		if ( 307196 == i )      
		{ 
			NN_LOG("-right bottom -\n");
			NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); 
		}
		if ( 307197 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 307198 == i )      { NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); }
		if ( 307199 == i )      
		{ 
			NN_LOG("ptr16       %p \n", ptr16);
			NN_LOG("ptr16 value %p \n", *ptr16);
			NN_LOG("ptr8        %p \n", ptr8);
			NN_LOG("ptr8  value %p \n", *ptr8);
			NN_LOG("%d %lu (%x,%x,%x) %x\n", i, *ptr16, r888.r,r888.g,r888.b); 
		}

        memcpy(ptr8, &r888, sizeof(r888));

		ptr16++;
		ptr8++;
		ptr8++;
		ptr8++;
	}

    NN_LOG( "Convert Finished.\n" );
}
#endif

/************************************************************************
 ̃f[^ieNX`f[^jPNGobt@ɃRs[
@iIWi -> [sys_BmpTexture] void BmpTexture::GetBmpFileDataFromTextureData( void ) )
  ************************************************************************/
void TestCamera::CopyPngBuffer( void )
{
    u16    *src = reinterpret_cast<u16*>(m_RgbBuffer->GetFrontBuffer());
    Rgb888 *dst = reinterpret_cast<Rgb888*> (m_PngBuffer);

    const int BLOCK_SIZE =8;
    const int SUB_BLOCK_QTY = 16;

    const int OFFSET_X[SUB_BLOCK_QTY]={ 0, 2, 0, 2, 4, 6, 4, 6, 0, 2, 0, 2, 4, 6, 4, 6 };
    const int OFFSET_Y[SUB_BLOCK_QTY]={ 0, 0, 2, 2, 0, 0, 2, 2, 4, 4, 6, 6, 4, 4, 6, 6 };

    //clo|m`shudtH[}bgjAtH[}bgɕϊ
    for( u32 blockY=0 ; blockY<CAMERA_HEIGHT ; blockY+=BLOCK_SIZE )
    {
        for( u32 blockX=0 ; blockX<CAMERA_WIDTH ; blockX+=BLOCK_SIZE )
        {
            if( (blockX<CAMERA_WIDTH) && (blockY<CAMERA_HEIGHT ) )
            {
                for( int i=0; i<SUB_BLOCK_QTY ; i++ ){
                    dst[ (blockY+OFFSET_Y[i]    ) * CAMERA_WIDTH + blockX+OFFSET_X[i]   ] = Rgb565ToRgb888(*src++);
                    dst[ (blockY+OFFSET_Y[i]    ) * CAMERA_WIDTH + blockX+OFFSET_X[i]+1 ] = Rgb565ToRgb888(*src++);
                    dst[ (blockY+OFFSET_Y[i]+1  ) * CAMERA_WIDTH + blockX+OFFSET_X[i]   ] = Rgb565ToRgb888(*src++);
                    dst[ (blockY+OFFSET_Y[i]+1  ) * CAMERA_WIDTH + blockX+OFFSET_X[i]+1 ] = Rgb565ToRgb888(*src++);
                }

            }else{
                src+=BLOCK_SIZE*BLOCK_SIZE;
            }
        }
    }

    NN_LOG( "CopyPngBuffer Finished.\n" );
}

/************************************************************************
J̉ʏo͂ꎞ~
  ************************************************************************/
void TestCamera::Pause( bool enable )
{
    if( enable )
    {
        nn::camera::StopCapture(GetPort());
    }
    else
    {
        nn::camera::StartCapture(GetPort());
    }
}

/************************************************************************
J̕ω摜ɍXV
  ************************************************************************/
void TestCamera::UpdateToAverage( void )
{
    //xtuqfaobt@֕ϊJn
    nn::y2r::SetSendingYuv( m_YuvRingBuffer->GetAverage(), m_CameraOutputSize, CAMERA_WIDTH * Y2R_YUV_BYTES);
    nn::y2r::SetReceiving( m_RgbBuffer->GetFrontBuffer(), m_Y2rOutputSize, CAMERA_WIDTH * Y2R_RGB_BYTES);
    nn::y2r::StartConversion();

    bool isYuvBusy = true;
    while( nn::y2r::IsBusyConversion() );

}

/************************************************************************
J̉ʏo͂ۑipXł炤j

alot@Čɂxtu̐f[^ǉB
  ************************************************************************/
bool TestCamera::SaveBmp( const wchar_t *fileName )
{

    bool result;

    bool previousState = m_IsCaptureStarted;    


    if( !nn::fs::IsSdmcInserted() ) return false;
    if( nn::fs::MountSdmc().IsFailure() ) return false;

    if( m_IsCaptureStarted )
    {
        nn::camera::StopCapture(GetPort());
    }

    BmpTexture *bt = new BmpTexture;

    result = bt->Save( fileName, CAMERA_WIDTH, CAMERA_HEIGHT, 
                        reinterpret_cast<u8*>(m_CameraTexture) );

    delete bt;


    if( previousState )
    {
        nn::camera::StartCapture(GetPort());
    }

    nn::fs::Unmount("sdmc:");

    return result;
}

/************************************************************************
J̉ʏo͂ۑ

alot@Čɂxtu̐f[^ǉĂ܂B
  ************************************************************************/
bool TestCamera::Save(void )
{

    bool result;

    bool previousState = m_IsCaptureStarted;    


    if( !nn::fs::IsSdmcInserted() ) return false;
    if( nn::fs::MountSdmc().IsFailure() ) return false;

    if( m_IsCaptureStarted )
    {
        nn::camera::StopCapture(GetPort());
    }

    BmpTexture *bt = new BmpTexture;

    wchar_t fileName[IniFile::Element::MAX_VALUE_SIZE];

    if( GenerateFileName( fileName, L"sdmc:/uji/camera/imgfilename.ini", L"rom:/ini/imgfilename.ini"  ) )
    {

        result = bt->Save( fileName, CAMERA_WIDTH, CAMERA_HEIGHT, 
                            reinterpret_cast<u8*>(m_CameraTexture),
                            reinterpret_cast<u8*>( m_YuvRingBuffer->GetCurrent() ) );
    }else{
        result = false;
    }

    delete bt;


    if( previousState )
    {
        nn::camera::StartCapture(GetPort());
    }

    nn::fs::Unmount("sdmc:");

    return result;
}

/************************************************************************
J̉ʏo͂ۑ
iOɕϒl摜\ĂȂƂalo摜Ƃxtu摜svɂȂ܂B

alot@Čɂxtuϒlf[^ǉĂ܂B
  ************************************************************************/
bool TestCamera::SaveAverage(void )
{
    bool result;

    bool previousState = m_IsCaptureStarted;    

    if( !nn::fs::IsSdmcInserted() ) return false;
    if( nn::fs::MountSdmc().IsFailure() ) return false;

    if( m_IsCaptureStarted )
    {
        nn::camera::StopCapture(GetPort());
    }

    BmpTexture *bt = new BmpTexture;

    wchar_t fileName[IniFile::Element::MAX_VALUE_SIZE];

    if( GenerateFileName( fileName, L"sdmc:/uji/camera/imgfilename.ini", L"rom:/ini/imgfilename.ini"  ) )
    {

        result = bt->Save( fileName, CAMERA_WIDTH, CAMERA_HEIGHT, 
                            reinterpret_cast<u8*>(m_CameraTexture),
                            reinterpret_cast<u8*>( m_YuvRingBuffer->GetAverage() ) );
    }else{
        result = false;
    }

    delete bt;


    if( previousState )
    {
        nn::camera::StartCapture(GetPort());
    }

    nn::fs::Unmount("sdmc:");

    return result;
}
/************************************************************************
|[g̎擾
************************************************************************/
nn::camera::Port TestCamera::GetPort( void )
{
    nn::camera::Port port;

    switch( m_Select )
    {
        case SELECT_NONE:       port = PORT_NONE;   break;
        case SELECT_OUT1:       port = PORT_CAM1;   break;
        case SELECT_IN1:        port = PORT_CAM1;   break;
        case SELECT_IN1_OUT1:   port = PORT_CAM1;   break;
        case SELECT_OUT2:       port = PORT_CAM2;   break;
        case SELECT_OUT1_OUT2:  port = PORT_BOTH;   break;
        case SELECT_IN1_OUT2:   port = PORT_BOTH;   break;
        case SELECT_ALL:        port = PORT_BOTH;   break;
        default:                port = PORT_NONE;   break;
    }
    
    return port;
}


/************************************************************************
xtuobt@̎擾
************************************************************************/
const u16* TestCamera::GetYuv(void) const
{
    return static_cast<u16*>(m_YuvRingBuffer->GetPrevious() );
}

/************************************************************************
xtuobt@̕ώ擾
************************************************************************/
const u16* TestCamera::GetYuvAverage(void) const
{
    return static_cast<u16*>(m_YuvRingBuffer->GetAverage() );
}
/************************************************************************
zCgoXݒ
************************************************************************/
void TestCamera::SetWhiteBalance( nn::camera::WhiteBalance wb )
{
    nn::Result nnr;

    //zCgoXݒ
    nnr = nn::camera::SetWhiteBalance( m_Select, wb );
    if( nnr.IsFailure() ) SYS_PANIC( "ERROR:SetWhiteBalance" );

    //zCgoXWHITE_BALANCE_NORMALɐݒ肵ꍇAIɃI[gLɂ
    if( wb==nn::camera::WHITE_BALANCE_NORMAL )
    {
        nnr = nn::camera::SetAutoWhiteBalance( m_Select, true );
        if( nnr.IsFailure() ) SYS_PANIC( "ERROR:SetWhiteBalance" );
    }
}

/************************************************************************
Iݒ
************************************************************************/
void TestCamera::SetExposure( s8 exposure )
{
    nn::Result nnr;

    //Iݒ
    nnr = nn::camera::SetExposure( m_Select, exposure );
    if( nnr.IsFailure() ) SYS_PANIC( "ERROR:SetExposure" );

}

/************************************************************************
tbvݒ
************************************************************************/
void TestCamera::FlipImage( nn::camera::Flip flip )
{
    nn::Result nnr;
    nnr = nn::camera::FlipImage( m_Select, flip );
    if( nnr.IsFailure() ) SYS_PANIC( "ERROR:FlipImage" );
}

/************************************************************************
Nxݒ
************************************************************************/
void TestCamera::SetSharpness( s8 sharpness )
{
    nn::Result nnr;
    nnr = nn::camera::SetSharpness( m_Select, sharpness );
    if( nnr.IsFailure() ) SYS_PANIC( "ERROR:SetSharpness" );
}

/************************************************************************
Be[hxݒ
************************************************************************/
void TestCamera::SetPhotoMode( nn::camera::PhotoMode photoMode )
{
    nn::Result nnr;
    nnr = nn::camera::SetPhotoMode( m_Select, photoMode );
    if( nnr.IsFailure() ) SYS_PANIC( "ERROR:SetPhotoMode" );
}


/************************************************************************
xtuOobt@
  ************************************************************************/

/************************************************************************
Oobt@̏
************************************************************************/
void TestCamera::YuvRingBuffer::Initialize(void)
{
    for( int i=0 ; i<m_TotalBuffers; i ++ )
    {
        u32 newArea = reinterpret_cast<u32>
                      (SysApp::GetInstance()->AllocateDeviceMemory(m_Width*m_Height*ELEMENT_SIZE, 64) );
        std::memset( reinterpret_cast<u16*>( newArea ), 0x00, m_Width*m_Height*ELEMENT_SIZE );
        m_Buffers.push_back( reinterpret_cast<u16*>( newArea ) );
    }

}

/************************************************************************
Oobt@̏I
************************************************************************/
void TestCamera::YuvRingBuffer::Finalize()
{
    //Oobt@J
    for( int i=0 ; i<m_TotalBuffers; i ++ )
    {
        SysApp::GetInstance()->Free( m_Buffers[i] );
    }
}

/************************************************************************
̃obt@ɐi߂
************************************************************************/
void TestCamera::YuvRingBuffer::Forward(void)
{
    if( m_CurrentBufferId < m_Buffers.size()-1 )
    {
        m_CurrentBufferId++;
    }else{
        m_CurrentBufferId=1;
    }
}

/************************************************************************
݂̃obt@擾
************************************************************************/
void *TestCamera::YuvRingBuffer::GetCurrent(void) const
{
    return reinterpret_cast<void*>(m_Buffers[m_CurrentBufferId]);
}

/************************************************************************
̃obt@擾
************************************************************************/
void *TestCamera::YuvRingBuffer::GetNext(void) const
{
    s16 nextBufferId;

    if( m_CurrentBufferId < m_Buffers.size()-1 )
    {
        nextBufferId =m_CurrentBufferId+1;
    }else{
        nextBufferId=1;
    }


    return reinterpret_cast<void*>(m_Buffers[nextBufferId]);
}
/************************************************************************
Õobt@擾
************************************************************************/
void *TestCamera::YuvRingBuffer::GetPrevious(void) const
{
    s16 previousBufferId;

    if( m_CurrentBufferId > 1 )
    {
        previousBufferId =m_CurrentBufferId-1;
    }else{
        previousBufferId=m_Buffers.size()-1;
    }


    return reinterpret_cast<void*>(m_Buffers[previousBufferId]);
}
/************************************************************************
Sobt@̕ς擾
************************************************************************/
void *TestCamera::YuvRingBuffer::GetAverage(void)
{
    u16 u;
    u16 l;
    union
    {
        struct{
            u8 u;
            u8 l;
        } bitField;
        u16 raw;
    };

    for( int i=0 ; i<m_Width*m_Height ; i++ )
    {
        u=0;
        l=0;
        for(int j=1 ; j<m_TotalBuffers ; j++ )
        {
            raw=*( m_Buffers[j]+i );
            u+=bitField.u;
            l+=bitField.l;
        }
        bitField.u = u/(m_TotalBuffers-1);
        bitField.l = l/(m_TotalBuffers-1);
        m_Buffers[0][i]=raw;
    }

    return reinterpret_cast<void*>(m_Buffers[0]);
}

/************************************************************************
_uobt@
  ************************************************************************/

/************************************************************************

************************************************************************/
void TestCamera::DoubleBuffer::Initialize(void)
{
    for( int i=0 ; i<2; i ++ )
    {
        u32 newArea = reinterpret_cast<u32>
                      (SysApp::GetInstance()->AllocateDeviceMemory(m_Width*m_Height*ELEMENT_SIZE, 64) );
                      
        std::memset( reinterpret_cast<u16*>( newArea ), 0x00, m_Width*m_Height*ELEMENT_SIZE );
        m_Buffers.push_back( reinterpret_cast<u16*>( newArea ) );
    }

}

/************************************************************************
I
************************************************************************/
void TestCamera::DoubleBuffer::Finalize()
{
    //Oobt@J
    for( int i=0 ; i<2; i ++ )
    {
        SysApp::GetInstance()->Free( m_Buffers[i] );
    }
}

/************************************************************************
؂ւ
************************************************************************/
void TestCamera::DoubleBuffer::Swap(void)
{
    m_CurrentBufferId++;
    m_CurrentBufferId%=2;
}

/************************************************************************
`pobt@擾
************************************************************************/
void *TestCamera::DoubleBuffer::GetBackBuffer(void) const
{
    return reinterpret_cast<void*>(m_Buffers[(m_CurrentBufferId+1)%2]);
}

/************************************************************************
̃obt@擾
************************************************************************/
void *TestCamera::DoubleBuffer::GetFrontBuffer(void) const
{
    return reinterpret_cast<void*>(m_Buffers[m_CurrentBufferId]);
}

/************************************************************************
J@\
  ************************************************************************/
void TestCamera::PreInitialize(void)
{
    nn::Result nnr;

    if( !m_IsHardwareInitialized )
    {
        nnr = nn::camera::InitializeHardwareCheck();
        if( nnr.IsFailure() ){
            char str[100];
            s32 level = (s32)nnr.GetLevel();
            sprintf( str, "Fail to initialize. level=%d", level );
            SYS_PANIC( str );
        }
        m_IsHardwareInitialized = true;
    }
}

/************************************************************************
J̉ʏo͂PNG`ŕۑ
  ************************************************************************/
int TestCamera::SavePng( char *file_name )
{
#pragma diag_suppress 826

    nn::Result result;
    
    if( !nn::fs::IsSdmcInserted() ) return 1;
    if( !nn::fs::IsSdmcWritable() ) return 7;
    if( nn::fs::MountSdmc().IsFailure() ) return 2;

	// v
    nn::os::Tick tick_start;
    nn::os::Tick tick_end;
	int  elapsed = 0;
    tick_start=  nn::os::Tick::GetSystemCurrent();

	// eNX`f[^PNGobt@ɃRs[
	bool previousState = m_IsCaptureStarted;
    if( m_IsCaptureStarted )
    {
        nn::camera::StopCapture(GetPort());
    }
	CopyPngBuffer();

	tick_end =  nn::os::Tick::GetSystemCurrent();
    elapsed = (int)(tick_end - tick_start).ToTimeSpan().GetMilliSeconds();
   	NN_LOG("%s %s elapsedMsec(%d)\n",__func__,"CopyPngBuffer done.",elapsed);
	
	//1MB̃m
	g_png_file_buffer = new bit8[1024*1024];
 
	g_png_file_size = 0;
    g_func_call_cnt = 0;

	// PNGt@C̐
	{
	    png_structp	png_ptr;
	    png_infop	info_ptr;

	    NN_LOG( "PNG_LIBPNG_VER_STRING %s\n", PNG_LIBPNG_VER_STRING);

	    //  png_ptr\̂mہE png_struct
	    png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	    if (NULL == png_ptr) 
	    {
	        return 4;
	    }

	    // info_ptr\̂mہE png_info
	    info_ptr = png_create_info_struct(png_ptr);
	    if (info_ptr == NULL) 
	    {
	        png_destroy_write_struct(&png_ptr,  (png_infopp)NULL);
	        return 5;
	    }

#if 0
	    // G[nhO̐ݒ
	    if (setjmp(png_jmpbuf(png_ptr)))
	    {
	        png_destroy_write_struct(&png_ptr,  &info_ptr);
	        return 6;
	    }
	    // R[obN֐libpngɒm点
	    //png_set_write_status_fn(png_ptr, write_row_callback);

#endif

		int width  = CAMERA_WIDTH;
		int height = CAMERA_HEIGHT;

	    // IHDR`Nݒ
	    png_set_IHDR(png_ptr, info_ptr, width, height, 8, PNG_COLOR_TYPE_RGB,
	        PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);

	    // sBIT`N̐ݒ
	    /* Optional significant bit (sBIT) chunk */
	    png_color_8 sig_bit;

	    /* If we are dealing with a grayscale image then */
	    //sig_bit.gray = true_bit_depth;

	    /* Otherwise, if we are dealing with a color image then */
	    sig_bit.red   = 8;
	    sig_bit.green = 8;   
	    sig_bit.blue  = 8;

	    /* If the image has an alpha channel then */
	    //sig_bit.alpha = true_alpha_bit_depth;
	    png_set_sBIT(png_ptr, info_ptr, &sig_bit);

	    // t@CEK}̐ݒ
	    png_set_gAMA(png_ptr, info_ptr, 1.0);

	    // tB^шkx̐ݒ
	    png_set_filter(png_ptr, 0, PNG_ALL_FILTERS);
	    //png_set_compression_level(png_ptr, Z_NO_COMPRESSION);     //900KB,  2.0b
	    //png_set_compression_level(png_ptr, Z_BEST_SPEED);         //261KB,  2.4b
	    //png_set_compression_level Ă΂Ȃ;                       //208KB,  7.8b 
        // w肵ȂΓKxȈkŎsihttp://dencha.ojaru.jp/programs_07/pg_graphic_10a2.htmlj
	    //png_set_compression_level(png_ptr, Z_BEST_COMPRESSION);   //189KB, 61.6b

	    png_set_compression_level(png_ptr, Z_BEST_SPEED);


	    // TEXT`N{^CgCҁCC\tgEFA}ݒ
		{
	        png_text	text_ptr[4];

	        text_ptr[0].key = "Title";
	        text_ptr[0].text = "CameraTester";
	        text_ptr[0].compression = PNG_TEXT_COMPRESSION_NONE;
	        text_ptr[1].key = "Author";
	        text_ptr[1].text = "Product Engineering Dept";
	        text_ptr[1].compression = PNG_TEXT_COMPRESSION_NONE;
	        text_ptr[2].key = "Description";
	        text_ptr[2].text = "ICAM Test";
	        text_ptr[2].compression = PNG_TEXT_COMPRESSION_NONE;      
	        text_ptr[3].key = "Software";
	        text_ptr[3].text = "TestCamera.cpp";
	        text_ptr[3].compression = PNG_TEXT_COMPRESSION_NONE;

	        png_set_text(png_ptr, info_ptr, text_ptr, 4);
		}
	 
		// pngt@C̃wb_(IHDR)
	    png_write_info(png_ptr, info_ptr);

	    tick_end =  nn::os::Tick::GetSystemCurrent();
        elapsed = (int)(tick_end - tick_start).ToTimeSpan().GetMilliSeconds();
    	NN_LOG("%s %s elapsedMsec(%d)\n",__func__,"png IHDR wrote.",elapsed);

	    // pngt@C̃f[^(IDAT)
		unsigned char ** image = NULL;
	    image = reinterpret_cast<unsigned char **> (&m_PngBuffer);

	    png_bytep row_pointers[height];

	   /* Set up pointers into your "image" byte array */
	    for (int k = 0; k < height; k++)
	    {
	     	row_pointers[k] = *image + k * width * 3 ; //bytes_per_pixel  RGB888Ȃ̂ 3oCg
		}

		tick_end =  nn::os::Tick::GetSystemCurrent();
        elapsed = (int)(tick_end - tick_start).ToTimeSpan().GetMilliSeconds();
    	NN_LOG("%s %s elapsedMsec(%d)\n",__func__,"png set row_pointers",elapsed);

#if 0
	   png_write_image(png_ptr, image);
#else
	   /* The number of passes is either 1 for non-interlaced images,
	    * or 7 for interlaced images.
	    */
	   for (int pass = 0; pass < 1; pass++)                // number_passes non-interlaceȂ̂ 1
	   {
	      ///* Write a few rows at a time. */
	      //png_write_rows(png_ptr, &row_pointers[first_row], number_of_rows);

	        /* If you are only writing one row at a time, this works */
	      	for (int y = 0; y < height; y=y+240)
			{
				png_write_rows(png_ptr, &row_pointers[y], 240); //240sĂ
			    tick_end =  nn::os::Tick::GetSystemCurrent();
        		elapsed = (int)(tick_end - tick_start).ToTimeSpan().GetMilliSeconds();
    			NN_LOG("%s %s (%d) elapsedMsec(%d)\n",__func__,"png IDAT wrote",(y+240),elapsed);
		  	}

		}
#endif

		// pngt@C̃C[WeC[(IEND)
	    png_write_end(png_ptr, info_ptr);

		// fXgN^n
	    png_destroy_write_struct(&png_ptr, &info_ptr);

	}

    tick_end =  nn::os::Tick::GetSystemCurrent();
    elapsed = (int)(tick_end - tick_start).ToTimeSpan().GetMilliSeconds();
    NN_LOG("%s %s elapsedMsec(%d)\n",__func__,"png data moved g_png_file_buffer.",elapsed);

	// g_png_file_bufferAf[^SD̃t@Cɏ
	nn::fs::FileOutputStream fos;
    fos.Initialize( file_name, true);//t@CJ
//	fos.TrySeek(0, nn::fs::POSITION_BASE_END);// t@C̃ItZbgw肷
	fos.TrySeek(0, nn::fs::POSITION_BASE_BEGIN);// t@C̃ItZbgw肷
	fos.Write(g_png_file_buffer,g_png_file_size, false);
	fos.Flush();
    fos.Finalize(); // t@C

	// FileBufferJ
	delete [] g_png_file_buffer;

	// v̏o
    tick_end =  nn::os::Tick::GetSystemCurrent();//vI
    elapsed = (int)(tick_end - tick_start).ToTimeSpan().GetMilliSeconds();
    NN_LOG("%s %s elapsedMsec(%d)\n",__func__,"png completed.",elapsed);

    NN_LOG("pngWrite write %d bytes\n",g_png_file_size);
    NN_LOG("pngWrite called %d\n",g_func_call_cnt);

    if( previousState )
    {
        nn::camera::StartCapture(GetPort());
    }

    nn::fs::Unmount("sdmc:");
    
    return 0;
}

/************************************************************************
@pngWrite : f[^w胁(g_png_file_buffer)ɏ
  @@@@@ libpngĂ΂郉bp[API
  ************************************************************************/
extern "C" png_size_t pngWrite(png_bytep data, png_size_t length)
{
	png_size_t  pst = 0;
	g_func_call_cnt = g_func_call_cnt + 1;

    u8 * ptr;
	ptr = g_png_file_buffer + g_png_file_size;

#if 0
    nn::os::Tick tick_start;//vJn
    nn::os::Tick tick_end;  //vI
	int  elapsed = 0;
    tick_start=  nn::os::Tick::GetSystemCurrent();
#endif

	std::memcpy(ptr,data,length);
	g_png_file_size = g_png_file_size + length;

#if 0
    tick_end =  nn::os::Tick::GetSystemCurrent();
    elapsed = (int)(tick_end - tick_start).ToTimeSpan().GetMilliSeconds();
    NN_LOG("%s %s elapsedMsec(%d)\n",__func__,"memcpy",elapsed);
#endif

	return length;
}

/************************************************************************
@pngMalloc : q[vmۂ
              libpngĂ΂郉bp[API
  ************************************************************************/
extern "C"  png_voidp  pngMalloc(png_alloc_size_t  size)
{
    png_voidp ret;

	ret = new int [size];

	return ret;

}

/************************************************************************
@pngDelete : q[vɕԋp
              libpngĂ΂郉bp[API
  ************************************************************************/
extern "C"  void pngDelete(png_voidp  pvp)
{
	delete [] pvp;

	return;
}

