/************************************************************************

 TestCamAndIFvO

 *************************************************************************/
/* dCN[h */
#ifndef TEST_CAM_AND_IF_H_INCLUDED
#define TEST_CAM_AND_IF_H_INCLUDED

#include <string.h>
#include <nn.h>
#include <nn/socket.h>
#include <nn/ac.h>
#include <nn/ac/CTR/private/ac_Internal.h>

#pragma diag_suppress 1301,2530
#include "sys.h"
#include "../seq/config.h"
#include "../seq/TestResult.h"
#include "../seq/TestSample.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../sys/sys_TextWindow.h"
#include "../wireless/CommandUtil.h"
#include "../seq/CommCamera.h" 

#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>

//// pfBOɊւxvO}
//#pragma diag_warning 1301,2530

namespace uji{
namespace eva{

// WL_AUDIOŒ`ς݂Ȃ̂ŕsv?
enum TEST_RESULT_CAM
{
    RESULT_DEFAULT_CAM  = 0,
    RESULT_OK_CAM,
    RESULT_NG_CAM
};

class TestCamAndIF
{
    public:
    
    // ֐Xg\\
    struct FuncMapping
    {
        u16  opcode;                 // IyR[hiR}hID̓X|XIDj
        char funcname[40];           // ֐
        const char* ( TestCamAndIF::*func )( const char * );  // ֐|C^
        bool PADDING[2];
    };
    
    TestCamAndIF(): m_CommWindow( 400/(FONT_SIZE/2), 160/FONT_SIZE, FONT_SIZE ),
                    m_StatWindow( 300/(FONT_SIZE/2), 220/FONT_SIZE, FONT_SIZE ),
                    m_InfoWindow( 400/(FONT_SIZE/2),  80/FONT_SIZE, FONT_SIZE ),
                    gfx( uji::sys::GraphicsDrawing::GetInstance()),
                    m_isRecvStart( false ),
                    m_isTestFin( false ),
                    m_isBackUp( false ),
                    m_isQCChart( false ),
                    m_isQCWhite( false ),
                    m_RenderFlag( true ),
                    m_TestMode( uji::seq::pl::DEBUG ),
                    m_AllTestResult( RESULT_DEFAULT_CAM ),
                    m_SendCommCount(0),
                    m_RecvCommCount(0),
                    m_RxTimeOutSec(15)
    {
        // MAyуvOp̃obt@mۂ0ŏ
        m_RecvCommandBuf = new char[ MAX_COMMAND_SIZE ];
        m_SendCommandBuf = new char[ MAX_COMMAND_SIZE ];
        m_WorkBuf        = new char[ MAX_COMMAND_SIZE ];

        std::memset( m_RecvCommandBuf, 0x00, MAX_COMMAND_SIZE );
        std::memset( m_SendCommandBuf, 0x00, MAX_COMMAND_SIZE );
        std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );

        // J[hSPȈ
        m_CommSpi.Initialize( uji::seq::CommCamera::SpiType_1Mx1 );
    }
    
    ~TestCamAndIF()
    {
        delete[] m_RecvCommandBuf;
        delete[] m_SendCommandBuf;
        delete[] m_WorkBuf;
    }
    
    // J&I/F{̂N郉bp[
    static void ExecuteTestCamAndIF()
    {
        TestCamAndIF ci;
        ci.TestCamAndIFCommon();
    }
    
    static void ExecuteTestCamAndIF2( u8 *cam_buf )
    {
        TestCamAndIF ci;
        ci.TestCamAndIFCommon2( cam_buf );
    }
    
    //--------------------------------------------------------------------------
    // p֐
    //--------------------------------------------------------------------------
    const char* DummyResponce( const char* arg );
    const char* DummyResponceArg( const char* arg );

    // FTR I/Fp
    const char* FTR_TestAttest( const char* arg );
    const char* FTR_MicPowerOn( const char* arg );
    const char* FTR_GetBatteryType( const char* arg );
    const char* FTR_GetVcell( const char* arg );
    const char* FTR_GetBatteryRemain( const char* arg );
    const char* FTR_WaitSoundVolMax( const char* arg );
    const char* FTR_WaitJackInsert( const char* arg );
    const char* FTR_OutputSpeakerR( const char* arg );
    const char* FTR_StopSpeakerR( const char* arg );
    const char* FTR_OutputSpeakerL( const char* arg );
    const char* FTR_StopSpeakerL( const char* arg );
    const char* FTR_MicSamplingSilent( const char* arg );
    const char* FTR_MicSamplingSignal( const char* arg );
    const char* FTR_TestRemoteKey( const char* arg );
    const char* FTR_TestIrAccess( const char* arg );
    const char* FTR_TestIrCommunication( const char* arg );
    const char* FTR_TestIrTxRc( const char* arg );
    const char* FTR_TestIrRxdReceive( const char* arg );
    const char* FTR_TestIrPowerDown( const char* arg );

    // FTR Jp
    const char* FTR_CAM_GetPictureSize( const char* arg );
    const char* FTR_CAM_GetPictureSizeFromHeap( const char* arg );
    const char* FTR_CAM_SendPicture( const char* arg );
    const char* FTR_CAM_SendPictureFromHeap( const char* arg );
    const char* FTR_CAM_Capture_In( const char* arg );
    const char* FTR_CAM_Capture_OutL( const char* arg );
    const char* FTR_CAM_Capture_OutR( const char* arg );
    const char* FTR_CAM_SendPictureFromMemory( const char* arg );

    // CTR瑶݂R}h
    const char* CTR_GetMacAddress( const char* arg );
    const char* CTR_GetModuleID( const char* arg );
    const char* CTR_GetSerialNumber( const char* arg );
    const char* CTR_WriteSerialNumber( const char* arg );
    const char* CTR_GetEmsLabel( const char* arg );
    const char* CTR_GetRegion( const char* arg );
    const char* CTR_SetPowerOff( const char* arg );
    
    const char* TESTER_GetVersion( const char* arg );
    const char* TESTER_GetBuildDate( const char* arg );
    const char* TESTER_SetTime( const char* arg );
    const char* TESTER_SetTestMode( const char* arg );
    const char* TESTER_WriteStartLog( const char* arg );
    const char* TESTER_WriteOKLog( const char* arg );
    const char* TESTER_WriteNGLog( const char* arg );
    const char* TESTER_WriteEMSLog( const char* arg );
    const char* TESTER_GetTimeCounter( const char* arg );
    
    private:
    //--------------------------------------------------------------------------
    // ֐
    //--------------------------------------------------------------------------
    void TestCamAndIFCommon();
    void TestCamAndIFCommon2( u8 *cam_buf );
    
    static void WrappingExecuteCommandThread( void* param );
    void ExecuteCommandThread();
    
    //--------------------------------------------------------------------------
    // R}hM&sp֐
    static int GetGroupIDFromCommandID( const u16 &commID );
    bool ScanCardSlot();
    bool ReceiveCommand();
    void SendCommand( const char* str );
    
    const char* ExecuteCommandFunction( const CommPack &commPack );
    const char* GetCommandName( const CommPack &commPack );
    // ܂
    //--------------------------------------------------------------------------
    bool AllInit();
    bool AllInit2( u8 *cam_buf );

    void PrintRecvCommand( const CommPack commPack );
    void PrintSendCommand( const char* str );
                
    //--------------------------------------------------------------------------
    // 萔
    //--------------------------------------------------------------------------
    static const u8 MAX_COMMAND_SIZE = 128;
    static const u8 FONT_SIZE        = 12;
    static const u8 BUFFER_SIZE      = FONT_SIZE*5;
    
    static const u8 START_DATE_SIZE  = 11;
    static const u8 START_TIME_SIZE  = 6;
    static const u8 NG_CODE_SIZE     = 20;
    static const u8 TESTER_ID_SIZE   = 24;

    // G[R[hp萔(}CNR[h2ڂɓl)
    // ̒lsǃfoCXł悤ɂ
    static const u8 ERROR_CODE_ATTEST    = 0;
    static const u8 ERROR_CODE_MIC       = 1;
    static const u8 ERROR_CODE_HEADPHONE = 2;
    static const u8 ERROR_CODE_VOLUME    = 3;
    static const u8 ERROR_CODE_BATTERY   = 4;
    static const u8 ERROR_CODE_SOUND     = 5;
    static const u8 ERROR_CODE_SD        = 6;
    static const u8 ERROR_CODE_IR        = 7;
    static const u8 ERROR_CODE_CAMERA    = 8;
    static const u8 ERROR_CODE_CAL       = 9;
    static const u8 ERROR_CODE_LOG       = 10;
    static const u8 ERROR_CODE_OTHER     = 11;

    // G[R[hp萔(}CNR[h3ڂɓl)
    // ̒lǂ̊֐NGɂȂĂ̂肷ifobOp̏j
    static const u8 ERROR_CODE_NUM0 = 0;
    static const u8 ERROR_CODE_NUM1 = 1;
    static const u8 ERROR_CODE_NUM2 = 2;
    static const u8 ERROR_CODE_NUM3 = 3;
    static const u8 ERROR_CODE_NUM4 = 4;
    static const u8 ERROR_CODE_NUM5 = 5;

    //--------------------------------------------------------------------------
    // ϐ
    //--------------------------------------------------------------------------
    uji::sys::TextWindow m_CommWindow;
    uji::sys::TextWindow m_StatWindow;
    uji::sys::TextWindow m_InfoWindow;
    
    uji::sys::GraphicsDrawing* gfx;
    
    nn::socket::InAddr m_MyIpAddress;
    nn::socket::SockAddrIn m_Send_Addr;
    
    uji::seq::CommCamera  m_CommSpi;
    uji::eva::TimeCounter m_TimeCounter;
    
    bool  m_isRecvStart;
    bool  m_isTestFin;
    bool  m_isBackUp;
    
    // o׌ptO
    bool  m_isQCChart;
    bool  m_isQCWhite;
    
    // J\ƃR}hEBhE؂ւptO
    bool m_RenderFlag;
    
    // J[hԊmFptO
    bool m_isF2USBActive;       // F2USBSPIڑłĂ邩̃tO
    bool m_isCardPowerActive;   // J[hhĂĒʓdĂ邩̃tO
    
    bit8  m_MacAddress[ nn::uds::MAC_ADDRESS_SIZE ];
    u8    m_TestMode;
    u8    m_AllTestResult;
    
    char* m_RecvCommandBuf;
    char* m_SendCommandBuf;
    char* m_WorkBuf;
    
    char  m_StartTestDate[ START_DATE_SIZE ];
    char  m_StartTestTime[ START_TIME_SIZE ];
    char  m_TesterID[ TESTER_ID_SIZE ];
    
    int   m_SendCommCount;
    int   m_RecvCommCount;
    
    int   m_RxTimeOutSec;
    
    // NG̃G[R[hi[p
    u8 err_micro;       // G[}CNR[h̉2ɓlԂiNĜ݁j
    u8 err_micro2;      // G[}CNR[h2ڂɓl
    u8 err_micro3;      // G[}CNR[h3ڂɓl

};

//// pfBOɊւxɖ߂
//#pragma diag_suppress 1301,2530

} // namespace eva
} // namespace uji

#endif /* TEST_CAM_AND_IF_H_INCLUDED */
