/****************************************************************************

    FTRJI/F
    I/FFTRł͖{ASNAKE/CLOSERJnB

****************************************************************************/

#include <nn.h>
#include <nn/gx.h>
//#include <nn/nwm.h>
#include <nn/cfg.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/cfg/CTR/cfg_ApiNor.h>

#include "sys.h"
#include "sys_GetSerialNumber.h"
#include "sys_GetRegionCode.h"
#include "sys_GetBondingOption.h"
#include "sys_WriteSerialNumber.h"
#include "TestCamAndIF.h"
#include "TestCamera.h"
#include "../Application.h"
#include "../misc/TestAttest.h"
#include "../wireless/CommandUtil.h"
#include "../mcu/McuInitializer.h"
#include "../mcu/TestMcuNotification.h"
#include "../mcu/TestPowerOff.h"
#include "../mcu/TestMcu.h"
#include "../sound/TestSound.h"
#include "../mic/mic_BoardInterface.h"
#include "../key/TestKey.h"
#include "../ir/TestIr.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../seq/TestResult.h"
#include "../seq/Reception_camera.h"
#include "../seq/TestSequencer.h"

static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

#ifdef EVA_COMPOSITE
static void ShowPicture( wchar_t *file );
#endif

using namespace uji::seq;
using namespace uji::sys;
using namespace nn::ac::CTR::detail;

namespace uji{
namespace eva{

namespace
{
    // B摜̃AhXO[o|C^
    static u8 *buffer_chart_in;
    static u8 *buffer_white_in;
    static u8 *buffer_chart_out_L;
    static u8 *buffer_white_out_L;
    static u8 *buffer_chart_out_R;
    static u8 *buffer_white_out_R;

    const TestCamAndIF::FuncMapping FuncMap[] =
    {
        // 0x0400nIFA0x0450nJ
        { 0x0401,   "ATTEST",                   &TestCamAndIF::FTR_TestAttest           },
        { 0x0402,   "MIC POWER ON",             &TestCamAndIF::FTR_MicPowerOn           },
        { 0x0403,   "GET BATTERY TYPE",         &TestCamAndIF::FTR_GetBatteryType       },
        { 0x0404,   "GET VCELL BOARD",          &TestCamAndIF::FTR_GetVcell             },
        { 0x0405,   "GET BATTERY REMAIN",       &TestCamAndIF::FTR_GetBatteryRemain     },
        { 0x0406,   "SOUND VOL MAX",            &TestCamAndIF::FTR_WaitSoundVolMax      },
        { 0x0407,   "WAIT JACK INSERT",         &TestCamAndIF::FTR_WaitJackInsert       },
        { 0x0408,   "OUTPUT SPEAKER R",         &TestCamAndIF::FTR_OutputSpeakerR       },
        { 0x0409,   "STOP SPEAKER R",           &TestCamAndIF::FTR_StopSpeakerR         },
        { 0x0410,   "OUTPUT SPEAKER L",         &TestCamAndIF::FTR_OutputSpeakerL       },
        { 0x0411,   "STOP SPEAKER L",           &TestCamAndIF::FTR_StopSpeakerL         },
        { 0x0412,   "MIC SAMPLING SILENT",      &TestCamAndIF::FTR_MicSamplingSilent    },
        { 0x0413,   "MIC SAMPLING SIGNAL",      &TestCamAndIF::FTR_MicSamplingSignal    },
        //{ 0x04**,   "MIC POWER OFF",           uji::eva::mic::TestPowerOff            },
        { 0x0414,   "REMOTE KEY",               &TestCamAndIF::FTR_TestRemoteKey        },
        { 0x0415,   "IR ACCESS TEST",           &TestCamAndIF::FTR_TestIrAccess         },
        { 0x0416,   "IR COMMUNICATION",         &TestCamAndIF::FTR_TestIrCommunication  },
        { 0x0417,   "IR TX-RC TEST",            &TestCamAndIF::FTR_TestIrTxRc           },
        { 0x0418,   "IR RXD RECEIVE TEST",      &TestCamAndIF::FTR_TestIrRxdReceive     },
        { 0x0419,   "IR POWERDOWN TEST",        &TestCamAndIF::FTR_TestIrPowerDown      },
#ifdef EVA_COMPOSITE
        // Heapɉ摜ۑۂ̊֐
        { 0x0450,   "Get Picture Size",         &TestCamAndIF::FTR_CAM_GetPictureSizeFromHeap   },
        { 0x0451,   "Send Picture",             &TestCamAndIF::FTR_CAM_SendPictureFromHeap      },
#else
        // SDJ[hɉ摜ۑĂ̊֐
        { 0x0450,   "Get Picture Size",         &TestCamAndIF::FTR_CAM_GetPictureSize   },
        { 0x0451,   "Send Picture",             &TestCamAndIF::FTR_CAM_SendPicture      },
#endif
        { 0x0453,   "Capture In",               &TestCamAndIF::FTR_CAM_Capture_In       },
        { 0x0454,   "Capture Out L",            &TestCamAndIF::FTR_CAM_Capture_OutL     },
        { 0x0455,   "Capture Out R",            &TestCamAndIF::FTR_CAM_Capture_OutR     },
        { 0x0456,   "Send Picture From Memory", &TestCamAndIF::FTR_CAM_SendPictureFromMemory },// ؗpR}h
        // 疳Ƌʂ̃R}h
        { 0x0801,   "CTR_GetMacAddress"         ,&TestCamAndIF::CTR_GetMacAddress       },
        { 0x0802,   "CTR_GetModuleID"           ,&TestCamAndIF::CTR_GetModuleID         },
        
        { 0x0805,   "CTR_GetRegion"             ,&TestCamAndIF::CTR_GetRegion           },
        { 0x0806,   "CTR_GetSerialNumber"       ,&TestCamAndIF::CTR_GetSerialNumber     },
        { 0x0807,   "CTR_WriteSerialNumber"     ,&TestCamAndIF::CTR_WriteSerialNumber   },
        { 0x0809,   "CTR_GetEMSLabel"           ,&TestCamAndIF::CTR_GetEmsLabel         },
        
        { 0x0814,   "CTR_SetPowerOff"           ,&TestCamAndIF::CTR_SetPowerOff         },

        { 0x0901,   "TESTER_GetVersion"         ,&TestCamAndIF::TESTER_GetVersion       },
        { 0x0902,   "TESTER_GetBuildDate"       ,&TestCamAndIF::TESTER_GetBuildDate     },
        { 0x0903,   "TESTER_SetTime"            ,&TestCamAndIF::TESTER_SetTime          },
        { 0x0904,   "TESTER_SetTestMode"        ,&TestCamAndIF::TESTER_SetTestMode      },
        { 0x0905,   "TESTER_WriteStartLog"      ,&TestCamAndIF::TESTER_WriteStartLog    },
        { 0x0906,   "TESTER_WriteOKLog"         ,&TestCamAndIF::TESTER_WriteOKLog       },
        { 0x0907,   "TESTER_WriteNGLog"         ,&TestCamAndIF::TESTER_WriteNGLog       },
        { 0x0908,   "TESTER_GetTimeCounter"     ,&TestCamAndIF::TESTER_GetTimeCounter   },
#if 0   // ؗp_~[EMSO
        { 0x0999,   "TESTER_WriteEMSLog"        ,&TestCamAndIF::TESTER_WriteEMSLog      },
#endif
    };
}

//------------------------------------------------------------------------------
// JnȌ
//------------------------------------------------------------------------------
bool TestCamAndIF::AllInit()
{
    uji::sys::GetMacAddress( m_MacAddress );

    // G[R[hpϐ
    err_micro  = 0;   // G[}CNR[h̉2ɓl
    err_micro2 = 0;   // G[}CNR[h2ڂɓl
    err_micro3 = 0;   // G[}CNR[h3ڂɓl

    return true;
}

//------------------------------------------------------------------------------
// JnȌ
//------------------------------------------------------------------------------
bool TestCamAndIF::AllInit2( u8 *cam_buf )
{
    uji::sys::GetMacAddress( m_MacAddress );
    
    u32 bmpSize = (uji::eva::TestCamera::CAMERA_WIDTH * uji::eva::TestCamera::CAMERA_HEIGHT *3 );
    buffer_chart_in    = cam_buf;
    buffer_white_in    = buffer_chart_in    + bmpSize;
    buffer_chart_out_L = buffer_white_in    + bmpSize;
    buffer_white_out_L = buffer_chart_out_L + bmpSize;
    buffer_chart_out_R = buffer_white_out_L + bmpSize;
    buffer_white_out_R = buffer_chart_out_R + bmpSize;

    // G[R[hpϐ
    err_micro  = 0;   // G[}CNR[h̉2ɓl
    err_micro2 = 0;   // G[}CNR[h2ڂɓl
    err_micro3 = 0;   // G[}CNR[h3ڂɓl

    return true;
}

//------------------------------------------------------------------------------
// JI/F{
//------------------------------------------------------------------------------
void TestCamAndIF::TestCamAndIFCommon()
{
    AllInit();

    nn::os::Thread execCommThread;
    execCommThread.StartUsingAutoStack( WrappingExecuteCommandThread, this, 4096, nn::os::DEFAULT_THREAD_PRIORITY - 1 );

    uji::sys::WindowManager windowManager;

    m_CommWindow.SetTitle("Command  ( Press L+R : Clear )");
    m_StatWindow.SetTitle("Test Cam&I/F Status");
    m_InfoWindow.SetTitle("Cam&I/F Info");

    windowManager.CreateWindow( &m_CommWindow, NN_GX_DISPLAY0, 0, 0 );
    windowManager.CreateWindow( &m_StatWindow, NN_GX_DISPLAY1, 0, 0 );
    windowManager.CreateWindow( &m_InfoWindow, NN_GX_DISPLAY0, 0, 160 );

    m_TimeCounter.InitTime();

    //VAio[擾
    char serial[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN+1];
    uji::sys::GetSerialNumber(serial);

    // REGION \p
    const char *REGION_NAME[]=
    {
        "JPN",
        "USA",
        "EUR",
        "AUS",
        "CHN",
        "KOR",
        "TWN"
    };

    m_RenderFlag = true;
    
    NN_LOG("Test Start!\n");
    m_StatWindow.Printf("Test Start!\n");
    

    // FIFOmFāAłȂΓǂݏoċɂ
    // ...
    
    u32 r_Count = 0;
    
    r_Count = m_CommSpi.GetReadFifoCount();
    if( r_Count != 0 )
    {
        m_StatWindow.Printf("%d data remained at FIFO\n", r_Count );
    }
/*
    do
    {
        // ۂFifoǂݏoAeʂɕ\
        m_StatWindow.Printf("FIFO Clear\n" );
        std::memset( m_RecvCommandBuf, 0x00, MAX_COMMAND_SIZE );
        m_CommSpi.ReadFifo( reinterpret_cast< u8* >( m_RecvCommandBuf ), r_Count );
        r_Count = m_CommSpi.GetReadFifoCount();
    }while(r_Count == 0);
*/

    while( true )
    {
        Pad().UpdatePad();
        // L+R+START ŃR}h҂󂯏ԉ
        if( Pad().IsButtonPress( Pad::BUTTON_L ) && Pad().IsButtonPress( Pad::BUTTON_R ) && Pad().IsButtonPress( Pad::BUTTON_START ))
        {
            m_isTestFin = true;
        }
        if( m_isTestFin )  // R}heXgIł悤ɔ蕔𕪂܂B
        {
            m_StatWindow.Printf("Test is finished.\n");
            break;
        }
/*
        //{AŖ{̃Zbg
        if( Pad().IsButtonPress( Pad::BUTTON_DOWN ) && Pad().IsButtonPress( Pad::BUTTON_A ))
        {
            uji::eva::mcu::EvaReset();
        }

        //{BŖ{̓dOFF
        if( Pad().IsButtonPress( Pad::BUTTON_DOWN ) && Pad().IsButtonPress( Pad::BUTTON_B ))
        {
            uji::eva::mcu::EvaPowerOff();
        }
*/
        // L+R ŃR}h/Xe[^X EBhE̕\Zbg
        if( Pad().IsButtonPress( Pad::BUTTON_L ) && Pad().IsButtonPress( Pad::BUTTON_R ) )
        {
            m_RenderFlag = true;
            m_CommWindow.Printf("\f");
            m_StatWindow.Printf("\f");
            m_SendCommCount = 0;
            m_RecvCommCount = 0;
        }

        // Xbhs̊֐ƃOtBbNXobeBOȂ悤ɂ
        if( m_RenderFlag )
        {
            if(m_isF2USBActive) // 펞 EBhE\
            {
                // CtH[VEBhE\
                m_InfoWindow.Printf("\f");
                m_InfoWindow.Printf("Cam & I/F Test Program\n" );
                m_InfoWindow.Printf("MacAddress = %02X:%02X:%02X:%02X:%02X:%02X   ", m_MacAddress[0], m_MacAddress[1], m_MacAddress[2],
                                                                                     m_MacAddress[3], m_MacAddress[4], m_MacAddress[5] );
                m_InfoWindow.Printf("TimeCount  = %s \n", CommandUtil::ConvertStringFromTimeSpan( m_TimeCounter.GetTimeSpan()) );
                m_InfoWindow.Printf( "PRG VERSION  [%s (" __DATE__ " " __TIME__  ")]\n", UJI_APPVER_CAM_AND_IF );
                m_InfoWindow.Printf( "SDK VERSION  [%d.%d.%d %d %d(%s)]\n",
                                        NN_VERSION_MAJOR, NN_VERSION_MINOR, NN_VERSION_MICRO, NN_VERSION_RELSTEP, NN_VERSION_REVISION, NN_VERSION_PATCH );
                m_InfoWindow.Printf( "SERIAL NUM.  [%s]  REGION [%s]\n", serial, REGION_NAME[(int)GetRegionCode()] );
                
                // ㉺ʍXV
                gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
                gfx->m_DrawFramework->Clear();
                windowManager.Update();
                windowManager.DrawDisplay0();
                gfx->m_DrawFramework->SwapBuffers();

                gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
                gfx->m_DrawFramework->Clear();
                windowManager.Update();
                windowManager.DrawDisplay1();
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if(!m_isCardPowerActive)   // J[hdOFF ԉ
            {
                //BGNAJ[ݒ肷
                gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 1.0f, 0.0f, 0.0f, 1.0f );
                gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 1.0f, 0.0f, 0.0f, 1.0f );
                
                //ʃNA
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->Clear();
                gfx->m_DrawFramework->SwapBuffers();
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
                gfx->m_DrawFramework->Clear();
                gfx->m_DrawFramework->SwapBuffers();
                
                //BGNAJ[ɖ߂
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
            }
            else    // SPIʐMs 
            {
                //BGNAJ[ݒ肷
                gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 1.0f, 1.0f, 1.0f, 1.0f );
                gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 1.0f, 1.0f, 1.0f, 1.0f );
                
                //ʃNA
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->Clear();
                gfx->m_DrawFramework->SwapBuffers();
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
                gfx->m_DrawFramework->Clear();
                gfx->m_DrawFramework->SwapBuffers();
                
                //BGNAJ[ɖ߂
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
            }
            gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        }
    }

#ifdef EVA_COMPOSITE    //FTR DP2p
    switch(m_AllTestResult)
    {
        case RESULT_OK_CAM:
            ShowPicture( L"rom:/jpeg/Pass.jpg" );
        break;
        
        case RESULT_NG_CAM:
            ShowPicture( L"rom:/jpeg/Fail.jpg" );
        break;
    }
#endif
    execCommThread.Join();
    execCommThread.Finalize();
}

//------------------------------------------------------------------------------
// JI/F{
//------------------------------------------------------------------------------
void TestCamAndIF::TestCamAndIFCommon2( u8 *cam_buf )
{
    AllInit2( cam_buf );

    nn::os::Thread execCommThread;
    execCommThread.StartUsingAutoStack( WrappingExecuteCommandThread, this, 4096, nn::os::DEFAULT_THREAD_PRIORITY - 1 );

    uji::sys::WindowManager windowManager;

    m_CommWindow.SetTitle("Command  ( Press L+R : Clear )");
    m_StatWindow.SetTitle("Test Cam&I/F Status");
    m_InfoWindow.SetTitle("Cam&I/F Info");

    windowManager.CreateWindow( &m_CommWindow, NN_GX_DISPLAY0, 0, 0 );
    windowManager.CreateWindow( &m_StatWindow, NN_GX_DISPLAY1, 0, 0 );
    windowManager.CreateWindow( &m_InfoWindow, NN_GX_DISPLAY0, 0, 160 );

    m_TimeCounter.InitTime();

    //VAio[擾
    char serial[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN+1];
    uji::sys::GetSerialNumber(serial);

    // REGION \p
    const char *REGION_NAME[]=
    {
        "JPN",
        "USA",
        "EUR",
        "AUS",
        "CHN",
        "KOR",
        "TWN"
    };

    m_RenderFlag = true;
    
    NN_LOG("Test Start!\n");
    m_StatWindow.Printf("Test Start!\n");
    

    // FIFOmFāAłȂΓǂݏoċɂ
    // ...
    
    u32 r_Count = 0;
    
    r_Count = m_CommSpi.GetReadFifoCount();
    if( r_Count != 0 )
    {
        m_StatWindow.Printf("%d data remained at FIFO\n", r_Count );
    }
/*
    do
    {
        // ۂFifoǂݏoAeʂɕ\
        m_StatWindow.Printf("FIFO Clear\n" );
        std::memset( m_RecvCommandBuf, 0x00, MAX_COMMAND_SIZE );
        m_CommSpi.ReadFifo( reinterpret_cast< u8* >( m_RecvCommandBuf ), r_Count );
        r_Count = m_CommSpi.GetReadFifoCount();
    }while(r_Count == 0);
*/

    while( true )
    {
        Pad().UpdatePad();
        // L+R+START ŃR}h҂󂯏ԉ
        if( Pad().IsButtonPress( Pad::BUTTON_L ) && Pad().IsButtonPress( Pad::BUTTON_R ) && Pad().IsButtonPress( Pad::BUTTON_START ))
        {
            m_isTestFin = true;
        }
        if( m_isTestFin )  // R}heXgIł悤ɔ蕔𕪂܂B
        {
            m_StatWindow.Printf("Test is finished.\n");
            break;
        }
        // L+R ŃR}h/Xe[^X EBhE̕\Zbg
        if( Pad().IsButtonPress( Pad::BUTTON_L ) && Pad().IsButtonPress( Pad::BUTTON_R ) )
        {
            m_RenderFlag = true;
            m_CommWindow.Printf("\f");
            m_StatWindow.Printf("\f");
            m_SendCommCount = 0;
            m_RecvCommCount = 0;
        }

        // Xbhs̊֐ƃOtBbNXobeBOȂ悤ɂ
        if( m_RenderFlag )
        {
            if( m_isF2USBActive ) // 펞 EBhE\
            {
                // CtH[VEBhE\
                m_InfoWindow.Printf("\f");
                m_InfoWindow.Printf("Cam & I/F Test Program\n" );
                m_InfoWindow.Printf("MacAddress = %02X:%02X:%02X:%02X:%02X:%02X   ", m_MacAddress[0], m_MacAddress[1], m_MacAddress[2],
                                                                                     m_MacAddress[3], m_MacAddress[4], m_MacAddress[5] );
                m_InfoWindow.Printf("TimeCount  = %s \n", CommandUtil::ConvertStringFromTimeSpan( m_TimeCounter.GetTimeSpan()) );
                m_InfoWindow.Printf( "PRG VERSION  [%s (" __DATE__ " " __TIME__  ")]\n", UJI_APPVER_CAM_AND_IF );
                m_InfoWindow.Printf( "SDK VERSION  [%d.%d.%d %d %d(%s)]\n",
                                        NN_VERSION_MAJOR, NN_VERSION_MINOR, NN_VERSION_MICRO, NN_VERSION_RELSTEP, NN_VERSION_REVISION, NN_VERSION_PATCH );
                m_InfoWindow.Printf( "SERIAL NUM.  [%s]  REGION [%s]\n", serial, REGION_NAME[(int)GetRegionCode()] );
                
                // ㉺ʍXV
                gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
                gfx->m_DrawFramework->Clear();
                windowManager.Update();
                windowManager.DrawDisplay0();
                gfx->m_DrawFramework->SwapBuffers();

                gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
                gfx->m_DrawFramework->Clear();
                windowManager.Update();
                windowManager.DrawDisplay1();
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if(!m_isCardPowerActive)   // J[hdOFF ԉ
            {
                //BGNAJ[ݒ肷
                gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 1.0f, 0.0f, 0.0f, 1.0f );
                gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 1.0f, 0.0f, 0.0f, 1.0f );
                
                //ʃNA
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->Clear();
                gfx->m_DrawFramework->SwapBuffers();
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
                gfx->m_DrawFramework->Clear();
                gfx->m_DrawFramework->SwapBuffers();
                
                //BGNAJ[ɖ߂
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
            }
            else    // SPIʐMs 
            {
                //BGNAJ[ݒ肷
                gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 1.0f, 1.0f, 1.0f, 1.0f );
                gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 1.0f, 1.0f, 1.0f, 1.0f );
                
                //ʃNA
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->Clear();
                gfx->m_DrawFramework->SwapBuffers();
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
                gfx->m_DrawFramework->Clear();
                gfx->m_DrawFramework->SwapBuffers();
                
                //BGNAJ[ɖ߂
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                    GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
            }
            gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        }
    }

#ifdef EVA_COMPOSITE    //FTR DP2p
    switch(m_AllTestResult)
    {
        case RESULT_OK_CAM:
            ShowPicture( L"rom:/jpeg/Pass.jpg" );
        break;
        
        case RESULT_NG_CAM:
            ShowPicture( L"rom:/jpeg/Fail.jpg" );
        break;
    }
#endif
    execCommThread.Join();
    execCommThread.Finalize();
}

//------------------------------------------------------------------------------
// ɓdāAJ[h̑}Ԃ𒲍B
//------------------------------------------------------------------------------
bool TestCamAndIF::ScanCardSlot()
{
    u8 PowerState, CardState;
    
    //dĂ݂
    nn::fs::CardSlotPowerOn(&PowerState);
    
    //Jڒ߂
    do
    {
        nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    }while(CardState == 0x0C);
    
    //Jڌ̏ԂmF
    nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    if(!CardState) return false;
    else if(CardState == 0x04)
    {
        nn::fs::CardSlotPowerOff(&PowerState);
        
        return false;
    }
    else if(CardState == 0x08) return true;
    
    //ɗ̂s
    nn::fs::CardSlotPowerOff(&PowerState);
    return false;
}

//------------------------------------------------------------------------------
// R}h̑M֐
//------------------------------------------------------------------------------
void TestCamAndIF::SendCommand( const char* str )
{
    u32 w_Count;

COMMAND_SEND_RETRY: // obt@ɋ󂫂Ȃꍇ͂烊gC
    w_Count = m_CommSpi.GetWriteFifoCount();

    // FIFŐ󂫂0x0FFF-0x0F38=200Byteȏ㖳ꍇ͋󂭂܂ő҂B
    if( w_Count >= 0x0F38 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));
        goto COMMAND_SEND_RETRY;
    }

    m_CommSpi.WriteFifo( reinterpret_cast< const u8* >( str ), std::strlen( str ));
    m_CommWindow.SetTextColor( ATTR_COLOR_YELLOW );
    m_CommWindow.Printf("->%02x:", m_SendCommCount );
    PrintSendCommand( str );
    m_SendCommCount++;
}

//------------------------------------------------------------------------------
// f[^MBf[^FIFOɂȂꍇfalseԂ
//------------------------------------------------------------------------------
bool TestCamAndIF::ReceiveCommand()
{
    u8 CardState;
    u32 r_Count = 0;
    
    //J[hd̊mF
    nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    if(!CardState || CardState == 0x0C)
    {
        //J[hdĂȂA͏ԑJڒ̏ꍇ
        m_isCardPowerActive = false;
        
        //J[hď
        while(!m_isCardPowerActive)
        {
            //J[hd̏Ԏ擾
            nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
            
            if(!CardState)  //J[hdOFF
            {
                //xdĂ݂āAXe[gǂ]Ԃ`FbN
                if(ScanCardSlot())  m_isCardPowerActive = true;
                else                m_isCardPowerActive = false;
            }
            else if(CardState == 0x04 || CardState == 0x08)
            {
                //0x08̏ꍇ͐ɒʓdA0x04ɂȂXe[g͖mFON̖͗l
                m_isCardPowerActive = true;
            }
            else if(CardState == 0x0C)
            {
                //JڒȂ̂ōă[v
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
            }
            else
            {
                //ɗXe[g͖͂H
            }
        }
    }
    else m_isCardPowerActive = true;    //̍s0x04zȌԂłȂΗvȂ͂

    //ɓB_ŁẢ̎MɂĂ͓dONO
    
    r_Count = m_CommSpi.GetReadFifoCount();
    // R}h10(ŏR}h)Zꍇ͒Ȃ܂ő҂
    if( r_Count < 10 )
    {
        //F2USBFłĂ邱ƂtOɊi[Ă
        m_isF2USBActive = true;
        return false;
    }
    // SPIʐMoX̊}ΉiSPIʐMoXȂꍇ r_Count̒l 255ɂȂĂ܂Bj
    else if(r_Count > MAX_COMMAND_SIZE)
    {
        //F2USBƂSPIʐMɈُ킪Ăꍇ
        m_isF2USBActive = false;
        return false;
    }

    // R}h܂ĂꍇAxԂuĂǂ݂Ȃ
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));
    r_Count = m_CommSpi.GetReadFifoCount();

    // ۂFifoǂݏoAeʂɕ\
    std::memset( m_RecvCommandBuf, 0x00, MAX_COMMAND_SIZE );
    m_CommSpi.ReadFifo( reinterpret_cast< u8* >( m_RecvCommandBuf ), r_Count );

    m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
    m_CommWindow.Printf("  %02x:", m_RecvCommCount );
    //PrintRecvCommand( m_RecvCommandBuf );

    // R}hǂݍ݃tOZbgAR}hJEg𑝂₷
    m_RecvCommCount++;
    return true;
}

//------------------------------------------------------------------------------
// o֐XbhƂċN邽߂̃bp[
//------------------------------------------------------------------------------
void TestCamAndIF::WrappingExecuteCommandThread( void* param )
{
    TestCamAndIF* pCI = reinterpret_cast< TestCamAndIF* >( param );
    pCI->ExecuteCommandThread();
}

//------------------------------------------------------------------------------
// R}h猟NXbhB
//------------------------------------------------------------------------------
void TestCamAndIF::ExecuteCommandThread()
{
    CommPack commPack;
    NN_LOG("ExecuteCommandThread\n");

    const char CHECKSUM_ERROR_COMMAND[] = "0000000000";

    while( true )
    {
        if( m_isTestFin )
        {
            break;
        }
        if( ReceiveCommand() ) // R}hMmF
        {
            if( !CommandUtil::isCorrectCheckSum( m_RecvCommandBuf, std::strlen( m_RecvCommandBuf )))
            {
                NN_LOG("CheckSum Error!\n");
                m_StatWindow.Printf("%02x: Command CheckSum Error!\n", m_RecvCommCount - 1 );
                m_StatWindow.Printf("%s\n", m_RecvCommandBuf );

                commPack = CommandUtil::AnalysisCommand( CHECKSUM_ERROR_COMMAND );

                const char* RSCStr = CommandUtil::CreateResponseString( commPack,
                                                  CommandUtil::CreateRSCAndResponseArgString( CommandUtil::CHECKSUM ));
                SendCommand( RSCStr );
                continue;
            }
            commPack = CommandUtil::AnalysisCommand( m_RecvCommandBuf );
            PrintRecvCommand( commPack );
            const char* RSCStr = CommandUtil::CreateResponseString( commPack, ExecuteCommandFunction( commPack ));
            SendCommand( RSCStr );
            if(m_AllTestResult) m_isTestFin = true;
        }
        else
        {
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMicroSeconds(1000));
        }
    }
}

//------------------------------------------------------------------------------
// R}hpPbg猟֐sAԂlԂ
//------------------------------------------------------------------------------
const char* TestCamAndIF::ExecuteCommandFunction( const CommPack &commPack )
{
    int gID = GetGroupIDFromCommandID( commPack.CommID );
    if( gID < 0 )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    else
    {
        return ( this->*( FuncMap[ gID ].func ))( commPack.Arg );
    }
}

//------------------------------------------------------------------------------
// R}hpPbg猟֐Ԃ
//------------------------------------------------------------------------------
const char* TestCamAndIF::GetCommandName( const CommPack &commPack )
{
    int gID = GetGroupIDFromCommandID( commPack.CommID );
    if( gID < 0 )
    {
        return "No Command";
    }
    else
    {
        return FuncMap[ gID ].funcname;
    }
}

//------------------------------------------------------------------------------
// R}hpPbgCommIĎ̔ԍԂ
//------------------------------------------------------------------------------
int TestCamAndIF::GetGroupIDFromCommandID( const u16 &commID )
{
    int groupID;
    u32 max_GroupID = ( sizeof( FuncMap ) / sizeof( FuncMap[0] ));

    for( groupID = 0; groupID <= max_GroupID; groupID++ )
    {
        if( commID == FuncMap[ groupID ].opcode )
        {
            return groupID;
        }
    }
    NN_LOG("Bad Return! %d\n", __LINE__);
    const int ERROR_NUMBER = -1;
    return ERROR_NUMBER;
}

//------------------------------------------------------------------------------
// ȉA֐
// Return FȂƂȂĂ̂́ARSĈ݂Ԃ
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Desc   F_~[X|XԂ *~Iop
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::DummyResponce( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

/*
    if( nn::fs::MountSdmc().IsFailure() )
    {
        NN_LOG("FAIL TO MOUNT SDMC\n");
        err_micro = 15;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
*/
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

//------------------------------------------------------------------------------
// Desc   Ft̃_~[X|XԂ *~Iop
// Arg    FȂ
// Return F_~[
//------------------------------------------------------------------------------
const char* TestCamAndIF::DummyResponceArg( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    /*
    if( nn::fs::MountSdmc().IsFailure() )
    {
        NN_LOG("FAIL TO MOUNT SDMC\n");
        err_micro = 15;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    */
    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf,"3.14" );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );
}

//------------------------------------------------------------------------------
// Desc   FƂ̐ڑmF
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_TestAttest( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    // QCptȌ
    m_isQCChart = false;
    m_isQCWhite = false;

    NN_LOG("QC flag initialized\n");
    m_StatWindow.Printf("QC flag initialized\n");

    TestResult m_TestResult;
    TestAttest( m_TestResult );
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicPowerOn FAIL\n");
        err_micro2 = ERROR_CODE_ATTEST;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   F}CN̓dON
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_MicPowerOn( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    mic::TestPowerOn( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicPowerOn FAIL\n");
        err_micro2 = ERROR_CODE_MIC;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   F[dr̃[J[擾
// Arg    FȂ
// Return F[J[ *tH[}bgvmF
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_GetBatteryType( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    mcu::GetBatteryType( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_GetBatteryType FAIL\n");
        err_micro2 = ERROR_CODE_BATTERY;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_TestResult.Pad[0] );
}

//------------------------------------------------------------------------------
// Desc   F[dr̓dl擾
// Arg    FȂ
// Return Fdl *tH[}bgvmF
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_GetVcell( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    mcu::GetVcellBoard( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_GetVcell FAIL\n");
        err_micro2 = ERROR_CODE_BATTERY;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_TestResult.Pad[0] );
}

//------------------------------------------------------------------------------
// Desc   F[dr̎cʒl擾
// Arg    FȂ
// Return Fcʒl *tH[}bgvmF
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_GetBatteryRemain( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    mcu::GetBatteryRemainBoard( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_GetBatteryRemain FAIL\n");
        err_micro2 = ERROR_CODE_BATTERY;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_TestResult.Pad[0] );
}

//------------------------------------------------------------------------------
// Desc   FTEh{[ő҂
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_WaitSoundVolMax( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    mcu::WaitSoundVolMax( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_WaitSoundVolMax FAIL\n");
        err_micro2 = ERROR_CODE_VOLUME;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

//------------------------------------------------------------------------------
// Desc   FCzWbN}҂
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_WaitJackInsert( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    sound::TestWaitJackInsert( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_WaitJackInsert FAIL\n");
        err_micro2 = ERROR_CODE_HEADPHONE;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

//------------------------------------------------------------------------------
// Desc   FwbhzRɐMo͊Jn
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_OutputSpeakerR( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    sound::TestOutputSpeakerR( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_OutputSpeakerR FAIL\n");
        err_micro2 = ERROR_CODE_SOUND;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

//------------------------------------------------------------------------------
// Desc   FwbhzR̐Mo͒~
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_StopSpeakerR( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    sound::TestDeleteInstance1( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_StopSpeakerR FAIL\n");
        err_micro2 = ERROR_CODE_SOUND;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

//------------------------------------------------------------------------------
// Desc   FwbhzLɐMo͊Jn
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_OutputSpeakerL( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    sound::TestOutputSpeakerL( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_OutputSpeakerL FAIL\n");
        err_micro2 = ERROR_CODE_SOUND;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

//------------------------------------------------------------------------------
// Desc   FwbhzL̐Mo͒~
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_StopSpeakerL( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    sound::TestDeleteInstance2( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_StopSpeakerL FAIL\n");
        err_micro2 = ERROR_CODE_SOUND;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

//------------------------------------------------------------------------------
// Desc   F}CN̖TvO
// Arg    FȂ
// Return FTvOl
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_MicSamplingSilent( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    u16 ampAve = 0;
    TestResult m_TestResult;
    mic::TestSamplingFTR( m_TestResult, &ampAve );
    char sample_amplitude[10];
    MicLib* m_pMicLib = MicLib::GetInstance();
    sprintf( sample_amplitude, "%x", ampAve );

    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicSamplingSilent FAIL\n");
        err_micro2 = ERROR_CODE_MIC;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, sample_amplitude );
}

//------------------------------------------------------------------------------
// Desc   F}CN̐M͎TvO(Ă邱Ƃ͖ƓŁAG[R[hĂ)
// Arg    FȂ
// Return FTvOl
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_MicSamplingSignal( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    u16 ampAve = 0;
    TestResult m_TestResult;
    mic::TestSamplingFTR( m_TestResult, &ampAve );
    char sample_amplitude[10];
    MicLib* m_pMicLib = MicLib::GetInstance();
    sprintf( sample_amplitude, "%x", ampAve );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicSamplingSignal FAIL\n");
        err_micro2 = ERROR_CODE_MIC;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, sample_amplitude );
}

//------------------------------------------------------------------------------
// Desc   F[gL[͊mF
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_TestRemoteKey( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    key::TestRemoteKey( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicSamplingSignal FAIL\n");
        err_micro2 = ERROR_CODE_MIC;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FFTRIreXg
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_TestIrAccess( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    ir::TestIrAccess( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicSamplingSignal FAIL\n");
        err_micro2 = ERROR_CODE_IR;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FʏdlIrMeXg
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_TestIrCommunication( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    ir::TestIrCommunication( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicSamplingSignal FAIL\n");
        err_micro2 = ERROR_CODE_IR;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   F_TxMeXg
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_TestIrTxRc( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    ir::TestIrTxRc( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicSamplingSignal FAIL\n");
        err_micro2 = ERROR_CODE_IR;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   F_RxMeXg
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_TestIrRxdReceive( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    ir::TestIrRxdReceive( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicSamplingSignal FAIL\n");
        err_micro2 = ERROR_CODE_IR;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FIrW[̃p[_EeXg
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_TestIrPowerDown( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    TestResult m_TestResult;
    ir::TestIrPowerDown( m_TestResult );
    
    if( !m_TestResult.m_Result )
    {
        NN_LOG("FTR_MicSamplingSignal FAIL\n");
        err_micro2 = ERROR_CODE_IR;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FSD̉摜t@C̃TCY擾iʎYJngpj
// Arg    Ft@C̃pX
// Return Fw肵t@C̃TCY
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_CAM_GetPictureSize( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    uji::seq::Config  *config = new uji::seq::Config;
    g_CommPacketCamera = new CommPacketCamera;

    g_CommPacketCamera->Initialize( static_cast<CommCamera::SpiType>(config->Get().CspiMode) );
    NN_LOG("CSPI MODE=%d\n", config->Get().CspiMode );
    
    delete g_CommPacketCamera;
    delete config;

    // LOCKĂȂmF
    if( !nn::fs::IsSdmcWritable() )
    {
        NN_LOG( "SD Card is Locked(Not Writable)\n" );
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    // SDJ[h̃}Eg
    if( nn::fs::MountSdmc().IsFailure() )
    {
        NN_LOG("FAIL TO MOUNT SDMC\n");
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    NN_LOG("SUCCESS TO MOUNT SDMC\n");
    
    nn::fs::FileReader file;
    if( file.TryInitialize( arg ).IsFailure() )
    {
        NN_LOG("FAIL TO OPEN PATH\n");
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
//    file.TryInitialize( arg );
    // t@CTCY擾
    size_t fileSize = file.GetSize();
    NN_LOG("  fileSize = %d (Byte)\n", fileSize);
    // X|XŕԂpɕƂĊi[
    char c_size[10];
    sprintf( c_size, "%u", fileSize );

    if ( fileSize == 0 )
    {
        NN_LOG("Failed to open File.\n");
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    nn::Result nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        NN_LOG("FAIL TO UNMOUNT SDMC\n");
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM4;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    // ͈Ƀt@CTCYڂĕԂ
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, c_size );
}

//------------------------------------------------------------------------------
// Desc   FSD̉摜𑗐MiʎYJngpj
// Arg    Ft@C̃pX
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_CAM_SendPicture( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    uji::seq::Config  *config = new uji::seq::Config;
    g_CommPacketCamera = new CommPacketCamera;

    g_CommPacketCamera->Initialize( static_cast<CommCamera::SpiType>(config->Get().CspiMode) );
    NN_LOG("CSPI MODE=%d\n", config->Get().CspiMode );

    delete config;

    // LOCKĂȂmF
    if( !nn::fs::IsSdmcWritable() )
    {
        NN_LOG( "SD Card is Locked(Not Writable)\n" );
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    // SDJ[h̃}Eg
    if( nn::fs::MountSdmc().IsFailure() )
    {
        NN_LOG("FAIL TO MOUNT SDMC\n");
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    
    nn::fs::FileReader file( arg );
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();

    size_t fileSize = file.GetSize();
    NN_LOG("  fileSize = %d (Byte)\n", fileSize);
    if ( fileSize == 0 )
    {
        NN_LOG("Failed to open File.\n");
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    u8 *buffer = (u8*)sysApp->Allocate(fileSize);
    s32 readSize = file.Read(buffer, fileSize);
    NN_LOG("  readSize = %d (Byte)\n", readSize);
    if ( readSize == 0 )
    {
        NN_LOG("Failed to read File.\n");
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    //摜f[^ehenɑ
    u32 transSize;                  // ]ׂf[^
    u32 residualQuantity = fileSize;// ]cf[^
    u32 fifoCount;                  // f[^FIFOɗ܂Ăf[^
    u32 transedSize = 0;            // ]ς݂̃f[^
    const u8 *current = buffer;
    NN_LOG("residualQuantity = filesize(%d)\n", residualQuantity);

    while( residualQuantity != 0)   // ]cf[^ʂ0ɂȂ܂ő
    {
        //̓]ʌ
        fifoCount = g_CommPacketCamera->m_CommCamera.GetDataFifoCount();    // f[^FIFO̒ɗ܂Ăf[^ʂ擾
        // Ȃ݂ uji::seq::CommCamera::FIFO_SIZE = 4096
        //transSize = uji::seq::CommCamera::FIFO_SIZE - fifoCount;            // f[^FIFOɓ邾
        transSize = 4088 - fifoCount;            // f[^FIFOɓ邾

        // ͈Ӑ}𗝉ĎȂKvۂ
        // RgAEgԂŃ~IɃ\tg[XBȂ΂̂܂܍폜悤B
        //]Pʂ16oCgPʂɂ
        /*
        transSize = transSize & 0xfff0;
        NN_LOG("16byted transSize = %d\n", transSize);
        */
        
        if( transSize > residualQuantity ) transSize = residualQuantity; //Ō̓]ʍ킹

        // fobOo
        /*
        NN_LOG("fifoCount = %d\n", fifoCount);
        NN_LOG("transSize = %d\n", transSize);
        */

        //]
        if( transSize != 0 )
        {
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            transedSize += transSize;
            residualQuantity -= transSize;
//            NN_LOG("residualQuantity = %d\n", residualQuantity);
        }
        
        /*
        // 4096Byte l߂Ƀf[^]
        if( transSize > residualQuantity )
        {
            transSize = residualQuantity; //Ō̓]ʍ킹
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            transedSize += transSize;
            residualQuantity -= transSize;
            NN_LOG("residualQuantity = %d\n", residualQuantity);
        }
        else if( transSize == uji::seq::CommCamera::FIFO_SIZE )
        {
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            transedSize += transSize;
            residualQuantity -= transSize;
            NN_LOG("residualQuantity = %d\n", residualQuantity);
        }
        */
    }
    NN_LOG("transedSize = %d\n", transedSize);
    NN_LOG("fileSize = %d\n", fileSize);
    
    //ehenȂȂ܂ő҂
    // f[^FIFOɃf[^cĂꍇ[vˁHƂƂłRgAEg
    /*
    while( g_CommPacketCamera->m_CommCamera.GetDataFifoCount()!=0 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
    }
    */

    delete g_CommPacketCamera;
    sysApp->Free( buffer );

    nn::Result nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        NN_LOG("FAIL TO UNMOUNT SDMC\n");
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM4;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FHeap̉摜t@C̃TCY擾
// Arg    Ft@C̃pX
// Return Fw肵t@C̃TCY
// 
// **摜̂̑MŃ^CAEg NG0.1%xĂB**
// **ʐMx 8MHzɂĂ̔͌ĂȂAԂΏBTODOB**
// 
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_CAM_GetPictureSizeFromHeap( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    uji::seq::Config  *config = new uji::seq::Config;
    g_CommPacketCamera = new CommPacketCamera;

    g_CommPacketCamera->Initialize( static_cast<CommCamera::SpiType>(config->Get().CspiMode) );
    NN_LOG("CSPI MODE=%d\n", config->Get().CspiMode );
    
    delete g_CommPacketCamera;
    delete config;
    
    // t@CTCYBMP`Ȃ̂921654Œ
    // ۂHeap̃f[^TCY擾
    char c_size[10];
    sprintf( c_size, "921654" );

    // ͈Ƀt@CTCYڂĕԂ
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, c_size );
}

//------------------------------------------------------------------------------
// Desc   FHeap̉摜𑗐M
// Arg    Ft@C̃pX
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_CAM_SendPictureFromHeap( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    uji::seq::Config  *config = new uji::seq::Config;
    g_CommPacketCamera = new CommPacketCamera;

    g_CommPacketCamera->Initialize( static_cast<CommCamera::SpiType>(config->Get().CspiMode) );
    NN_LOG("CSPI MODE=%d\n", config->Get().CspiMode );

    delete config;

    size_t fileSize = 921600;

    //摜f[^ehenɑ

    //wb_FIFOɑ
    BitmapFileHeader *bmpFileHeader = new BitmapFileHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    BitmapInfoHeader *bmpInfoHeader = new BitmapInfoHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpFileHeader, sizeof(BitmapFileHeader) );
    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpInfoHeader, sizeof(BitmapInfoHeader) );

    delete bmpInfoHeader;
    delete bmpFileHeader;

    NN_LOG("Header Write Finished.\n");

    // {̂FIFOɑ
    u32 transSize;                  // ]ׂf[^
    u32 residualQuantity = fileSize;  // ]cf[^
    u32 fifoCount;                  // f[^FIFOɗ܂Ăf[^
    u32 transedSize = 0;            // ]ς݂̃f[^
    u8 *current;
    
    // ~I񑤃\tg̈ɂĂǂ̃q[v̈悩ǂݏoύX
    if     ( strcmp( arg, "sdmc:/uji/icam.png\0" ) == 0 )         current = buffer_chart_in;
    else if( strcmp( arg, "sdmc:/uji/icam_white.png\0" ) == 0 )   current = buffer_white_in;
    else if( strcmp( arg, "sdmc:/uji/ocamL.png\0" ) == 0 )        current = buffer_chart_out_L;
    else if( strcmp( arg, "sdmc:/uji/ocamL_white.png\0" ) == 0 )  current = buffer_white_out_L;
    else if( strcmp( arg, "sdmc:/uji/ocamR.png\0" ) == 0 )        current = buffer_chart_out_R;
    else if( strcmp( arg, "sdmc:/uji/ocamR_white.png\0" ) == 0 )  current = buffer_white_out_R;
    else
    {
        // ɂ͗Ȃ
        NN_LOG("filename is incorrect\n", sizeof(BitmapFileHeader) );
        err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    NN_LOG("residualQuantity = fileSize(%d)\n", residualQuantity);

    while( residualQuantity != 0)   // ]cf[^ʂ0ɂȂ܂ő
    {
        //̓]ʌ
        fifoCount = g_CommPacketCamera->m_CommCamera.GetDataFifoCount();    // f[^FIFO̒ɗ܂Ăf[^ʂ擾
        // Ȃ݂ uji::seq::CommCamera::FIFO_SIZE = 4096

        // ̓]ʂ4088ByteiSPI-USBϊjbg̎dlŁAxɓ]\Ȃ̂512ByteȂ̂ł̔{ɂĂB
        transSize = 4088 - fifoCount;            // f[^FIFOɓ邾
        
        if( transSize > residualQuantity ) transSize = residualQuantity; //Ō̓]ʍ킹
        
        //]
        if( transSize != 0 )
        {
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            transedSize += transSize;
            residualQuantity -= transSize;
        }
    }

    NN_LOG("transedSize = %d\n", transedSize);
    NN_LOG("fileSize = %d\n", fileSize);
    
    delete g_CommPacketCamera;

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FINJŃLv`
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_CAM_Capture_In( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    // QC[hłȂꍇNGŕԂ
    if( !m_isQCChart && !m_isQCWhite )
    {
        err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    m_RenderFlag = false;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    TestCamera *t_camera = new TestCamera;
    
    t_camera->Initialize();

    NN_LOG("before Start\n");
    t_camera->Start( nn::camera::CTR::SELECT_IN1 );
    NN_LOG("t_camera -> Start Passed\n");
    
    t_camera->EnableZoomOut();
    t_camera->SetScroll( -80, 0 );
    t_camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    t_camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );
    
    // tOgă`[gׂfĒl𕪂
    if( m_isQCChart )
    {
        s8 sharpness = 2;
        if( sharpness > 9 )         sharpness = 9;
        else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
        sharpness -=4;
        t_camera->SetSharpness( sharpness );

        // I̎@\
        nn::Result nn_result;
        nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_IN1, true);   // L
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        s8 s8_Exposure = -3;
        t_camera->SetExposure( s8_Exposure );

        // AWB L
        nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_IN1, true);
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
    }
    else if( m_isQCWhite )
    {
        s8 sharpness = 5;
        if( sharpness > 9 )         sharpness = 9;
        else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
        sharpness -=4;
        t_camera->SetSharpness( sharpness );

        // I̎@\
        nn::Result nn_result;
        nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_IN1, true);   // L
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        s8 s8_Exposure = 0;
        t_camera->SetExposure( s8_Exposure );

        // AWB 𖳌AWBlŒl
        nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_IN1, false);
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
        u32 u32_WhiteBalance = 5;
        t_camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );
    }

    // 120t[i2bj҂
    for( int i=0 ; i<120 ; i++ )
    {
        t_camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        t_camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }
    NN_LOG("Capture Finished.\n");
    
    t_camera -> Stop();
    
    m_RenderFlag = true;
    m_StatWindow.Printf("IN CAM Capture Finished.\n");
    
    // BMPt@C`œ]
    
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();

    u32 bmpSize = (TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *3 );
    u8 *buffer = (u8*)sysApp->Allocate( bmpSize );
    BmpTexture *bt = new BmpTexture;
    
    bt->ConvertTextureToBmp( buffer, (u8*)t_camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    delete bt;

    NN_LOG("Convert Finished.\n");

    uji::seq::Config  *config = new uji::seq::Config;
    g_CommPacketCamera = new CommPacketCamera;

    g_CommPacketCamera->Initialize( static_cast<CommCamera::SpiType>(config->Get().CspiMode) );
    NN_LOG("CSPI MODE=%d\n", config->Get().CspiMode );

    delete config;

    //wb_FIFOɑ
    BitmapFileHeader *bmpFileHeader = new BitmapFileHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    BitmapInfoHeader *bmpInfoHeader = new BitmapInfoHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpFileHeader, sizeof(BitmapFileHeader) );
    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpInfoHeader, sizeof(BitmapInfoHeader) );

    NN_LOG("sizeof(BitmapFileHeader) = %d\n", sizeof(BitmapFileHeader) );
    NN_LOG("sizeof(BitmapInfoHeader) = %d\n", sizeof(BitmapInfoHeader) );

    delete bmpInfoHeader;
    delete bmpFileHeader;

    NN_LOG("Header Write Finished.\n");

    //摜f[^FIFOɑ
    u32 transSize;
    u32 fifoCount;
    u32 transedSize = 0;            // ]ς݂̃f[^
    u32 residualQuantity = bmpSize;
    const u8 *current = buffer;

    NN_LOG("Before Data Transfer.\n");

    while( residualQuantity != 0)
    {
        //̓]ʌ
        fifoCount = g_CommPacketCamera->m_CommCamera.GetDataFifoCount();
        // Ȃ݂ uji::seq::CommCamera::FIFO_SIZE = 4096
        //transSize = uji::seq::CommCamera::FIFO_SIZE - fifoCount;            // f[^FIFOɓ邾
        transSize = 4088 - fifoCount;            // f[^FIFOɓ邾

        if( transSize > residualQuantity ) transSize = residualQuantity; //Ō̓]ʍ킹

        //]
        if( transSize != 0 )
        {
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            transedSize += transSize;
            residualQuantity -= transSize;
            
            if( ( transedSize>100000 && transedSize<105000) || ( transedSize>400000 && transedSize<405000) || ( transedSize>800000 && transedSize<805000) )
            {
                m_StatWindow.Printf("transedSize = %d\n", transedSize);
            }

        }
    }
    NN_LOG("transedSize = %d\n", transedSize);
    NN_LOG("fileSize = %d\n", bmpSize);

    delete g_CommPacketCamera;

    sysApp->Free( buffer );
    t_camera -> Finalize();
    
    // deleteĂ܂Ɖʕ`悪܂ȂȂ
    //delete t_camera;
    
    m_StatWindow.SetTextColor( ATTR_COLOR_WHITE );
    m_StatWindow.Printf("FTR_CAM_Capture_In Finished\n" );
    
    NN_LOG("FTR_CAM_Capture_In Finished\n");
    
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FOUT LJŃLv`
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_CAM_Capture_OutL( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    // QC[hłȂꍇNGŕԂ
    if( !m_isQCChart && !m_isQCWhite )
    {
        err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    m_RenderFlag = false;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    TestCamera *t_camera = new TestCamera;
    
    t_camera->Initialize();

    t_camera->EnableZoomOut();
    t_camera->SetScroll( -80, 0 );
    t_camera->Start( nn::camera::CTR::SELECT_OUT2 );
    t_camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    t_camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );
    
    // tOgă`[gׂfĒl𕪂
    if( m_isQCChart )
    {
        s8 sharpness = 2;
        if( sharpness > 9 )         sharpness = 9;
        else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
        sharpness -=4;
        t_camera->SetSharpness( sharpness );

        // I̎@\
        nn::Result nn_result;
        nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT2, true);   // L
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        s8 s8_Exposure = -4;
        t_camera->SetExposure( s8_Exposure );

        // AWB L
        nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT2, true);
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
    }
    else if( m_isQCWhite )
    {
        s8 sharpness = 5;
        if( sharpness > 9 )         sharpness = 9;
        else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
        sharpness -=4;
        t_camera->SetSharpness( sharpness );
        
        // I̎@\
        nn::Result nn_result;
        nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT2, true);   // L
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        s8 s8_Exposure = 0;
        t_camera->SetExposure( s8_Exposure );

        // AWB 𖳌AWBlŒl
        nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT2, false);
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
        u32 u32_WhiteBalance = 5;
        t_camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );
    }
    NN_LOG("OutL Capture Start.\n");
    // 120t[i2bj҂
    for( int i=0 ; i<120 ; i++ )
    {
        t_camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        t_camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }
    NN_LOG("OutL Capture Finished.\n");
    
    t_camera -> Stop();
    
    m_RenderFlag = true;
    m_StatWindow.Printf("OUT L CAM Capture Finished.\n");
    
    // BMPt@C`œ]
    
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();

    u32 bmpSize = (TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *3 );
    u8 *buffer = (u8*)sysApp->Allocate( bmpSize );
    BmpTexture *bt = new BmpTexture;
    
    bt->ConvertTextureToBmp( buffer, (u8*)t_camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    delete bt;

    NN_LOG("Convert Finished.\n");

    uji::seq::Config  *config = new uji::seq::Config;
    g_CommPacketCamera = new CommPacketCamera;

    g_CommPacketCamera->Initialize( static_cast<CommCamera::SpiType>(config->Get().CspiMode) );
    NN_LOG("CSPI MODE=%d\n", config->Get().CspiMode );

    delete config;

    //wb_FIFOɑ
    BitmapFileHeader *bmpFileHeader = new BitmapFileHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    BitmapInfoHeader *bmpInfoHeader = new BitmapInfoHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpFileHeader, sizeof(BitmapFileHeader) );
    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpInfoHeader, sizeof(BitmapInfoHeader) );

    delete bmpInfoHeader;
    delete bmpFileHeader;

    NN_LOG("Header Write Finished.\n");

    //摜f[^FIFOɑ
    u32 transSize;
    u32 fifoCount;
    u32 transedSize = 0;            // ]ς݂̃f[^
    u32 residualQuantity = bmpSize;
    const u8 *current = buffer;

    NN_LOG("Before Data Transfer.\n");

    while( residualQuantity != 0)
    {
        //̓]ʌ
        fifoCount = g_CommPacketCamera->m_CommCamera.GetDataFifoCount();
        // Ȃ݂ uji::seq::CommCamera::FIFO_SIZE = 4096
        //transSize = uji::seq::CommCamera::FIFO_SIZE - fifoCount;            // f[^FIFOɓ邾
        transSize = 4088 - fifoCount;            // f[^FIFOɓ邾

        if( transSize > residualQuantity ) transSize = residualQuantity; //Ō̓]ʍ킹

        //]
        if( transSize != 0 )
        {
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            transedSize += transSize;
            residualQuantity -= transSize;


            if( ( transedSize>100000 && transedSize<105000) || ( transedSize>400000 && transedSize<405000) || ( transedSize>800000 && transedSize<805000) )
            {
                m_StatWindow.Printf("transedSize = %d\n", transedSize);
            }
        }
    }
    NN_LOG("transedSize = %d\n", transedSize);
    NN_LOG("fileSize = %d\n", bmpSize);

    delete g_CommPacketCamera;

    sysApp->Free( buffer );
    t_camera -> Finalize();

    //delete t_camera;

    m_StatWindow.SetTextColor( ATTR_COLOR_WHITE );
    m_StatWindow.Printf("FTR_CAM_Capture_OutL Finished\n" );
    
    NN_LOG("FTR_CAM_Capture_OutL Finished\n");
    
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FOUT RJŃLv`
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_CAM_Capture_OutR( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    // QC[hłȂꍇNGŕԂ
    if( !m_isQCChart && !m_isQCWhite )
    {
        err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    m_RenderFlag = false;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    TestCamera *t_camera = new TestCamera;
    
    t_camera->Initialize();

    t_camera->EnableZoomOut();
    t_camera->SetScroll( -80, 0 );
    t_camera->Start( nn::camera::CTR::SELECT_OUT1 );
    t_camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    t_camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );
    
    // tOgă`[gׂfĒl𕪂
    // s8 sharpness = (s8)(config.Get().ChartSharpness or DustSharpness);
    if( m_isQCChart )
    {
        s8 sharpness = 2;
        if( sharpness > 9 )         sharpness = 9;
        else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
        sharpness -=4;
        t_camera->SetSharpness( sharpness );
        
        // I̎@\
        nn::Result nn_result;
        nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT1, true);   // L
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        s8 s8_Exposure = -4;
        t_camera->SetExposure( s8_Exposure );

        // AWB L
        nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT1, true);
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
    }
    else if( m_isQCWhite )
    {
        s8 sharpness = 5;
        if( sharpness > 9 )         sharpness = 9;
        else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
        sharpness -=4;
        t_camera->SetSharpness( sharpness );
        
        // I̎@\
        nn::Result nn_result;
        nn_result = nn::camera::SetAutoExposure(nn::camera::CTR::SELECT_OUT1, true);   // L
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        s8 s8_Exposure = 0;
        t_camera->SetExposure( s8_Exposure );

        // AWB 𖳌AWBlŒl
        nn_result = nn::camera::SetAutoWhiteBalance(nn::camera::CTR::SELECT_OUT1, false);
        if (nn_result.IsFailure())
        {
            err_micro2 = ERROR_CODE_CAMERA; // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            t_camera->Finalize();
            delete t_camera;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        // "AUTO"=0 "3200K"=1 "4150K"=2 "5200K"=3 "6000K"=4 "7000K"=5
        u32 u32_WhiteBalance = 5;
        t_camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(u32_WhiteBalance) );
    }

    NN_LOG("OutR Capture Start.\n");
    // 120t[i2bj҂
    for( int i=0 ; i<120 ; i++ )
    {
        t_camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        t_camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }
    NN_LOG("OutR Capture Finished.\n");
    
    t_camera -> Stop();
    
    m_RenderFlag = true;
    m_StatWindow.Printf("OUT R CAM Capture Finished.\n");
    
    // BMPt@C`œ]
    
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();

    u32 bmpSize = (TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *3 );
    u8 *buffer = (u8*)sysApp->Allocate( bmpSize );
    BmpTexture *bt = new BmpTexture;
    
    bt->ConvertTextureToBmp( buffer, (u8*)t_camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    delete bt;

    NN_LOG("Convert Finished.\n");

    uji::seq::Config  *config = new uji::seq::Config;
    g_CommPacketCamera = new CommPacketCamera;

    g_CommPacketCamera->Initialize( static_cast<CommCamera::SpiType>(config->Get().CspiMode) );
    NN_LOG("CSPI MODE=%d\n", config->Get().CspiMode );

    delete config;

    //wb_FIFOɑ
    BitmapFileHeader *bmpFileHeader = new BitmapFileHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    BitmapInfoHeader *bmpInfoHeader = new BitmapInfoHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpFileHeader, sizeof(BitmapFileHeader) );
    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpInfoHeader, sizeof(BitmapInfoHeader) );

    delete bmpInfoHeader;
    delete bmpFileHeader;

    NN_LOG("Header Write Finished.\n");

    //摜f[^FIFOɑ
    u32 transSize;
    u32 fifoCount;
    u32 transedSize = 0;            // ]ς݂̃f[^
    u32 residualQuantity = bmpSize;
    const u8 *current = buffer;

    NN_LOG("Before Data Transfer.\n");

    while( residualQuantity != 0)
    {
        //̓]ʌ
        fifoCount = g_CommPacketCamera->m_CommCamera.GetDataFifoCount();
        // Ȃ݂ uji::seq::CommCamera::FIFO_SIZE = 4096
        //transSize = uji::seq::CommCamera::FIFO_SIZE - fifoCount;            // f[^FIFOɓ邾
        transSize = 4088 - fifoCount;            // f[^FIFOɓ邾

        if( transSize > residualQuantity ) transSize = residualQuantity; //Ō̓]ʍ킹

        //]
        if( transSize != 0 )
        {
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            transedSize += transSize;
            residualQuantity -= transSize;


            if( ( transedSize>100000 && transedSize<105000) || ( transedSize>400000 && transedSize<405000) || ( transedSize>800000 && transedSize<805000) )
            {
                m_StatWindow.Printf("transedSize = %d\n", transedSize);
            }
        }
    }
    NN_LOG("transedSize = %d\n", transedSize);
    NN_LOG("fileSize = %d\n", bmpSize);

    delete g_CommPacketCamera;

    sysApp->Free( buffer );
    t_camera -> Finalize();

    //delete t_camera;

    m_StatWindow.SetTextColor( ATTR_COLOR_WHITE );
    m_StatWindow.Printf("FTR_CAM_Capture_OutR Finished\n" );
    
    
    NN_LOG("FTR_CAM_Capture_OutR Finished\n");
    
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FLv`摜f[^()]
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::FTR_CAM_SendPictureFromMemory( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    // udl̓]@
    /*
    TestCamera *camera = new TestCamera;
    camera->Stop();
    u32 transSize;
    u32 residualQuantity = TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *2;

    u8 *current;
    current = (u8 *)camera->GetYuv();

    g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *2 );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    */
#if 0
    // BMPt@C`œ]
    TestCamera *t_camera = new TestCamera;
    
    t_camera->Stop();
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();

    u32 bmpSize = (TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *3 );
    u8 *buffer = (u8*)sysApp->Allocate( bmpSize );
    BmpTexture *bt = new BmpTexture;
    
    // Ŏ~܂ĂII
    bt->ConvertTextureToBmp( buffer, (u8*)t_camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    //ehenȂȂ܂ő҂
    while( g_CommPacketCamera->m_CommCamera.GetDataFifoCount()!=0 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1));
    }

    //wb_M
    BitmapFileHeader *bmpFileHeader = new BitmapFileHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    BitmapInfoHeader *bmpInfoHeader = new BitmapInfoHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpFileHeader, sizeof(BitmapFileHeader) );
    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpInfoHeader, sizeof(BitmapInfoHeader) );

    delete bmpInfoHeader;
    delete bmpFileHeader;

    //ehenȂȂ܂ő҂
    while( g_CommPacketCamera->m_CommCamera.GetDataFifoCount()!=0 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1));
    }

    //alof[^ehenɑ
    u32 transSize;
    u32 fifoCount;
    u32 residualQuantity = bmpSize;
    const u8 *current = buffer;

    while( residualQuantity != 0)
    {
        //̓]ʌ
        fifoCount = g_CommPacketCamera->m_CommCamera.GetDataFifoCount();
        transSize = uji::seq::CommCamera::FIFO_SIZE - fifoCount;

        //]Pʂ16oCgPʂɂ
        transSize = transSize & 0xfff0;
        if( transSize > residualQuantity ) transSize = residualQuantity; //Ō̓]ʍ킹

        //]
        if( transSize != 0 )
        {
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            residualQuantity -= transSize;
        }
    }

    //ehenȂȂ܂ő҂
    while( g_CommPacketCamera->m_CommCamera.GetDataFifoCount()!=0 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1));
    }
    sysApp->Free( buffer );



    TestCamera *t_camera = new TestCamera;
    
    if( !t_camera->Save() )
    {
        NN_LOG( "t_camera->Save() Failed\n" );
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    t_camera -> Finalize();
    
#endif
    
    
    
    
    
    
    
    TestCamera *t_camera = new TestCamera;
    t_camera -> Stop();
    
    int cam_result = t_camera -> SavePng( "sdmc:/uji/icam.png");
    
    if( cam_result != 0 )
    {
        // ̗Rŕۑs
        NN_LOG( "t_camera->SavePng() Failed\n" );
        err_micro2 = ERROR_CODE_SD;     // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        t_camera -> Finalize();
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
    
    NN_LOG( "t_camera->SavePng() Success\n" );
    t_camera -> Finalize();
    
    
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FWRFUW[MacAddress擾
// Arg    FȂ
// Return FMacAddress(12)
//------------------------------------------------------------------------------
const char* TestCamAndIF::CTR_GetMacAddress( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf,"%02X%02X%02X%02X%02X%02X", m_MacAddress[0], m_MacAddress[1], m_MacAddress[2],
                                                        m_MacAddress[3], m_MacAddress[4], m_MacAddress[5] );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );

}

//------------------------------------------------------------------------------
// Desc   FVAio[̓ǂݍ
// Arg    FȂ
// Return FVAio[
//------------------------------------------------------------------------------
const char* TestCamAndIF::CTR_GetSerialNumber( const char* arg )
{
    NN_UNUSED_VAR( arg );
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    uji::sys::GetSerialNumber( m_WorkBuf );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );

}

//------------------------------------------------------------------------------
// Desc   FEMSxl擾
// Arg    FȂ
// Return FEMSxl
//------------------------------------------------------------------------------
const char* TestCamAndIF::CTR_GetEmsLabel( const char* arg )
{
    NN_UNUSED_VAR( arg );
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );

    uji::seq::ProductionLog * productionLog = new uji::seq::ProductionLog;
    productionLog->Initialize();

    int id = -1;
    id = productionLog->Get_LatestLogEntryIndex("EmsLabel"); // EMSx̍ŐVO
    if ( id == -1 )
    {
        std::memmove(m_WorkBuf, "", sizeof(m_WorkBuf));
    }
    else
    {
        LogEntry logEntry;
        logEntry = productionLog->Get_LogEntry(id);
        std::memmove(m_WorkBuf, logEntry.message, sizeof(logEntry.message));
    }
    delete productionLog;
    
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );
}

//------------------------------------------------------------------------------
// Desc   FModuleID̓ǂݍ
// Arg    FȂ
// Return FModuleID
//------------------------------------------------------------------------------
const char* TestCamAndIF::CTR_GetModuleID( const char* arg )
{
    NN_UNUSED_VAR( arg );
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    u8 moduleID;
    const int MODULE_ID_ADDR = 0x2F;

    nn::cfg::nor::CTR::Initialize();
    nn::cfg::nor::CTR::Read( MODULE_ID_ADDR, &moduleID, sizeof(u8) );

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf, "%02X", moduleID );
    nn::cfg::nor::CTR::Finalize();

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );

}

//------------------------------------------------------------------------------
// Desc   FVAio[̏
// Arg    FȂ
// Return F
//------------------------------------------------------------------------------
const char* TestCamAndIF::CTR_WriteSerialNumber( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    if( !uji::seq::pl::LINE == m_TestMode )
    {
        std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
        std::strcpy( m_WorkBuf, arg );
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }
    
    if( uji::sys::WriteSerialNumber( arg ))
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        err_micro2 = ERROR_CODE_OTHER;  // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM0;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        m_StatWindow.Printf("Write SerialNumber Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

}

//------------------------------------------------------------------------------
// Desc   F{̂̃[W擾
// Arg    FȂ
// Return F{̂̃[W
//------------------------------------------------------------------------------
const char* TestCamAndIF::CTR_GetRegion( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    nn::cfg::CTR::CfgRegionCode region;
    
    region = uji::sys::GetRegionCode();

    switch( region )
    {
        case nn::cfg::CFG_REGION_AMERICA    :
            std::sprintf( m_WorkBuf, "USA");
            break;

        case nn::cfg::CFG_REGION_CHINA      :
            std::sprintf( m_WorkBuf, "CHN");
            break;

        case nn::cfg::CFG_REGION_EUROPE     :
            std::sprintf( m_WorkBuf, "EUR");
            break;
        case nn::cfg::CFG_REGION_JAPAN      :
            std::sprintf( m_WorkBuf, "JPN");
            break;

        case nn::cfg::CFG_REGION_KOREA      :
            std::sprintf( m_WorkBuf, "KOR");
            break;

        case nn::cfg::CFG_REGION_TAIWAN     :
            std::sprintf( m_WorkBuf, "TWN");
            break;

        case nn::cfg::CFG_REGION_AUSTRALIA  :
            std::sprintf( m_WorkBuf, "AUS");
            break;

        default  :
            std::sprintf( m_WorkBuf, "UNKNOWN REGION");
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );
}

//------------------------------------------------------------------------------
// Desc   FCTR{̂̓d𗎂Ƃ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestCamAndIF::CTR_SetPowerOff( const char* arg )
{
    NN_UNUSED_VAR( arg )


    uji::eva::mcu::EvaPowerOff();


    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromSeconds(10));  // d܂łŎ~܂


    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FvÕo[W擾
// Arg    FȂ
// Return FvOo[W
//------------------------------------------------------------------------------
const char* TestCamAndIF::TESTER_GetVersion( const char* arg )
{
    NN_UNUSED_VAR( arg )


    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, UJI_APPVER_CAM_AND_IF );
}
//------------------------------------------------------------------------------
// Desc   FvÕrh擾
// Arg    FȂ
// Return FvÕrh
//------------------------------------------------------------------------------
const char* TestCamAndIF::TESTER_GetBuildDate( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, VERSION_DATE );
}
//------------------------------------------------------------------------------
// Desc   FiOpjJnԐݒ
// Arg    FJn
// Return FȂ
//------------------------------------------------------------------------------
const char* TestCamAndIF::TESTER_SetTime( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    const u8 DATA_AND_TIME_LEN = 16;

    if( std::strlen( arg ) != DATA_AND_TIME_LEN )  // ̒̂e
    {
        err_micro2 = ERROR_CODE_OTHER;  // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        m_StatWindow.Printf("Data Length Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    const u8 SEPARATOR_POSITION = 10;

    if( arg[ SEPARATOR_POSITION ] != '#' )  // ̔ẑe
    {
        err_micro2 = ERROR_CODE_OTHER;  // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        m_StatWindow.Printf("Data Format Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    const u8 DATE_NUM   = 10;
    const u8 TIME_START = 11;
    const u8 TIME_NUM   = 5;

    std::memset( m_StartTestDate, 0x00, sizeof( m_StartTestDate ));
    std::memset( m_StartTestTime, 0x00 ,sizeof( m_StartTestTime ));

    std::memcpy( m_StartTestDate, &arg[0], DATE_NUM );
    std::memcpy( m_StartTestTime, &arg[ TIME_START ], TIME_NUM );

    NN_LOG("TestDate = %s\n", m_StartTestDate );
    NN_LOG("TestTime = %s\n", m_StartTestTime );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FiOpj[hݒ
// Arg    F[h,TESTER ID
// Return FȂ
//------------------------------------------------------------------------------
const char* TestCamAndIF::TESTER_SetTestMode( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    const u8 SEPARATOR_POSITION = 1;
    if( '#' != arg[ SEPARATOR_POSITION ])
    {
        err_micro2 = ERROR_CODE_OTHER;  // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM3;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        m_StatWindow.Printf("TestMode Set Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    m_TestMode = CommandUtil::ConvertNumFromString( arg, 1 );

    // QC_CHART(3),QC_WHITE(4)̏BtOĂ m_TestMode QC(1)ɁB
    if( m_TestMode == 3)
    {
        m_isQCChart = true;
        m_TestMode = 1;
    }
    else if( m_TestMode == 4)
    {
        m_isQCWhite = true;
        m_TestMode = 1;
    }

    // LINE[ĥݎBeH̃O邩mFiČɂ͈ӖȂǁcj
    if( m_TestMode == uji::seq::pl::LINE )
    {
        uji::seq::ProductionLog * pl = new uji::seq::ProductionLog;
        pl->Initialize();
        if ( pl->LogTable_LatestLogEntryIsOK( "CamCapture", uji::seq::pl::LINE ) == false)
        {
            err_micro2 = ERROR_CODE_LOG;   // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM0;     // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            delete pl;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
        delete pl;
    }

    const u8 TESTER_ID_START  = 2;
    const u8 TESTER_ID_LENGTH = 6;

    std::memset( m_TesterID, 0x00, sizeof( m_TesterID ));
    std::memcpy( m_TesterID, &arg[ TESTER_ID_START ], TESTER_ID_LENGTH );

    NN_LOG("TestMode = %d TesterID = %s\n", m_TestMode, m_TesterID );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FiOpjJnO
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestCamAndIF::TESTER_WriteStartLog( const char* arg )
{
    // NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    if( m_TestMode == uji::seq::pl::DEBUG )
    {
        err_micro2 = ERROR_CODE_LOG;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;     // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    // O
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    // QC_CHART[h̏ꍇ CamCapture QC[hO
    if( m_isQCChart )
    {
        if( 0 <= pdl->Add_1Line( m_TestMode, "CamCapture", "START", UJI_APPVER_CAM_AND_IF, m_StartTestDate, m_StartTestTime, m_TesterID, arg ))
        {
            pdl->Finalize();
            delete pdl;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
        }else
        {
            pdl->Finalize();
            delete pdl;
            m_StatWindow.Printf("Write StartLog Error\n");
            err_micro2 = ERROR_CODE_LOG;    // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
    }
    else
    {
        if( 0 <= pdl->Add_1Line( m_TestMode, "CamAndIf", "START", UJI_APPVER_CAM_AND_IF, m_StartTestDate, m_StartTestTime, m_TesterID, arg ))
        {
            pdl->Finalize();
            delete pdl;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
        }else
        {
            pdl->Finalize();
            delete pdl;
            m_StatWindow.Printf("Write StartLog Error\n");
            err_micro2 = ERROR_CODE_LOG;    // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
    }
}

//------------------------------------------------------------------------------
// Desc   FiOpjOKO
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestCamAndIF::TESTER_WriteOKLog( const char* arg )
{
    // NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    if( m_TestMode == uji::seq::pl::DEBUG )
    {
        err_micro2 = ERROR_CODE_LOG;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;     // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    const u8 LOG_MESSAGE_MAX = 80;
    char logMessage[ LOG_MESSAGE_MAX ] = "";
    std::sprintf( logMessage, "Message");
    NN_LOG("%s\n", logMessage );
    
    // O
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    // QC_CHART[h̏ꍇ CamCapture QC[hO
    if( m_isQCChart )
    {
        if( 0 <= pdl->Add_1Line( m_TestMode, "CamCapture", "OK", UJI_APPVER_CAM_AND_IF, m_StartTestDate, m_StartTestTime, m_TesterID, arg ))
        {
            pdl->Finalize();
            delete pdl;
#ifdef EVA_COMPOSITE    //FTR DP2Ή
            m_AllTestResult = RESULT_OK_CAM;
#endif
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
        }else
        {
            pdl->Finalize();
            delete pdl;
            m_StatWindow.Printf("Write OKLog Error\n");
#ifdef EVA_COMPOSITE    //FTR DP2Ή
            m_AllTestResult = RESULT_NG_CAM;
#endif
            err_micro2 = ERROR_CODE_LOG;    // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
    }
    else
    {
        if( 0 <= pdl->Add_1Line( m_TestMode, "CamAndIf", "OK", UJI_APPVER_CAM_AND_IF, m_StartTestDate, m_StartTestTime, m_TesterID, arg ))
        {
            pdl->Finalize();
            delete pdl;
#ifdef EVA_COMPOSITE    //FTR DP2Ή
            m_AllTestResult = RESULT_OK_CAM;
#endif
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
        }else
        {
            pdl->Finalize();
            delete pdl;
            m_StatWindow.Printf("Write OKLog Error\n");
#ifdef EVA_COMPOSITE    //FTR DP2Ή
            m_AllTestResult = RESULT_NG_CAM;
#endif
            err_micro2 = ERROR_CODE_LOG;    // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
    }
}

//------------------------------------------------------------------------------
// Desc   FiOpjNGR[h
// Arg    FNGR[h
// Return FȂ
//------------------------------------------------------------------------------
const char* TestCamAndIF::TESTER_WriteNGLog( const char* arg )
{
    // NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );
    
    if( m_TestMode == uji::seq::pl::DEBUG )
    {
        err_micro2 = ERROR_CODE_LOG;    // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    // O
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
#ifdef EVA_COMPOSITE    //FTR DP2Ή
    m_AllTestResult = RESULT_NG_CAM;
#endif
    // QC_CHART[h̏ꍇ CamCapture QC[hO
    if( m_isQCChart )
    {
        if( 0<= pdl->Add_1Line( m_TestMode, "CamCapture", "NG", UJI_APPVER_CAM_AND_IF, m_StartTestDate, m_StartTestTime, m_TesterID, arg ))
        {
            pdl->Finalize();
            delete pdl;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
        }else
        {
            pdl->Finalize();
            delete pdl;
            m_StatWindow.Printf("Write NGLog Error\n");
            err_micro2 = ERROR_CODE_LOG;    // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
    }
    else
    {
        if( 0<= pdl->Add_1Line( m_TestMode, "CamAndIf", "NG", UJI_APPVER_CAM_AND_IF, m_StartTestDate, m_StartTestTime, m_TesterID, arg ))
        {
            pdl->Finalize();
            delete pdl;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
        }else
        {
            pdl->Finalize();
            delete pdl;
            m_StatWindow.Printf("Write NGLog Error\n");
            err_micro2 = ERROR_CODE_LOG;    // G[}CNR[h2ڂɓl
            err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
            err_micro = err_micro2 * 16 + err_micro3;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
        }
    }
}

//------------------------------------------------------------------------------
// Desc   FiOؗpjEms LabelO
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestCamAndIF::TESTER_WriteEMSLog( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    if( m_TestMode == uji::seq::pl::DEBUG )
    {
        err_micro2 = ERROR_CODE_LOG;   // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM1;     // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }

    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    
    if( 0 <= pdl->Add_1Line( m_TestMode, "EmsLabel", "OK", UJI_APPVER_CAM_AND_IF, m_StartTestDate, m_StartTestTime, m_TesterID, "TEST123456789" ))
    {
        pdl->Finalize();
        delete pdl;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }
    else
    {
        pdl->Finalize();
        delete pdl;
        m_StatWindow.Printf("Write OKLog Error\n");
        err_micro2 = ERROR_CODE_LOG;    // G[}CNR[h2ڂɓl
        err_micro3 = ERROR_CODE_NUM2;   // G[}CNR[h3ڂɓl
        err_micro = err_micro2 * 16 + err_micro3;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE, err_micro );
    }
}

//------------------------------------------------------------------------------
// Desc   FCTR̃^CJE^[擾
// Arg    FȂ
// Return F^CJE^[̒l
//------------------------------------------------------------------------------
const char* TestCamAndIF::TESTER_GetTimeCounter( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS,
                        CommandUtil::ConvertStringFromTimeSpan( m_TimeCounter.GetTimeSpan()));
}

//------------------------------------------------------------------------------
// ܂Ō֐
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// MR}hFĉʕ\
//------------------------------------------------------------------------------
void TestCamAndIF::PrintRecvCommand( const CommPack commPack )
{
    //const int MAX_PRINT_BUF = 100;
    //char PrintBuf[ MAX_PRINT_BUF ] = "";
    //
    //std::memcpy( PrintBuf, &str[0], 4 );
    //m_CommWindow.SetTextColor( ATTR_COLOR_CYAN );
    //m_CommWindow.Printf( PrintBuf );
    //std::memset( PrintBuf, 0x00, 4 );
    //
    //std::memcpy( PrintBuf, &str[4], 4 );
    //m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
    //m_CommWindow.Printf( PrintBuf );
    //std::memset( PrintBuf, 0x00, 4 );
    //
    //std::memcpy( PrintBuf, &str[8], 2 );
    //m_CommWindow.SetTextColor( ATTR_COLOR_CYAN );
    //m_CommWindow.Printf( PrintBuf );
    //std::memset( PrintBuf, 0x00, 2 );
    //
    //m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
    //m_CommWindow.Printf( "%s\n", &str[10]);
    m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
    m_CommWindow.Printf( "%s Arg = %s\n", GetCommandName( commPack ), commPack.Arg );
    m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
}

//------------------------------------------------------------------------------
// MR}hFĉʕ\
//------------------------------------------------------------------------------
void TestCamAndIF::PrintSendCommand( const char* str )
{
    const int MAX_PRINT_BUF = 100;
    char PrintBuf[ MAX_PRINT_BUF ] = "";

    std::memcpy( PrintBuf, &str[0], 4 );
    m_CommWindow.SetTextColor( ATTR_COLOR_GREEN );
    m_CommWindow.Printf("%s", PrintBuf );
    std::memset( PrintBuf, 0x00, 4 );

    std::memcpy( PrintBuf, &str[4], 4 );
    m_CommWindow.SetTextColor( ATTR_COLOR_YELLOW );
    m_CommWindow.Printf("%s", PrintBuf );
    std::memset( PrintBuf, 0x00, 4 );

    std::memcpy( PrintBuf, &str[8], 2 );
    m_CommWindow.SetTextColor( ATTR_COLOR_GREEN );
    m_CommWindow.Printf("%s", PrintBuf );
    std::memset( PrintBuf, 0x00, 2 );

    if( str[10] == '0' && str[11] == '0' )
    {
        m_CommWindow.SetTextColor( ATTR_COLOR_BLUE );
    }else
    {
        m_CommWindow.SetTextColor( ATTR_COLOR_RED );
    }
    std::memcpy( PrintBuf, &str[10], 2 );
    m_CommWindow.Printf("%s", PrintBuf );
    m_CommWindow.SetTextColor( ATTR_COLOR_YELLOW );
    m_CommWindow.Printf( "%s\n", &str[12]);
}

} // namespace eva
} // namespace uji

/************************************************************************
ʂɊG\

************************************************************************/
static void ShowPicture( wchar_t *file )
{
    GLuint s_TextureId;

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    JpegTexture jt;

    jt.Open( file );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            GL_RGB_NATIVE_DMP,
                                            jt.GetWidth(),
                                            jt.GetHeight(),
                                            GL_RGB_NATIVE_DMP,
                                            GL_UNSIGNED_SHORT_5_6_5,
                                            jt.GetTextureDataPointer(),
                                            s_TextureId );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->m_DrawFramework->FillTexturedRectangle(s_TextureId,
                                                0.0f, 0.0f,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                jt.GetWidth(), jt.GetHeight() );
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->DeleteTexture(s_TextureId);
    jt.Close();

}
