/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     y2r_manager.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 20433 $
 *---------------------------------------------------------------------------*/

#include <nn/camera/CTR/camera_Api.h>
//#include <nn/camera/CTR/camera_ApiForHardwareCheck.h>

#include "y2r_manager.h"

using namespace camera_exp;

namespace {

    nn::os::CriticalSection  s_CsSet;

} //namespace

namespace camera_exp {

    //==============================================================================
    void SetY2rSize(
        size_t imageWidth,
        size_t imageHeight,
        nn::y2r::StandardCoefficient coefficient,
        nn::y2r::OutputFormat format,
        nn::y2r::BlockAlignment alignment )
    {
        // ϊȂ狭~B
        nn::y2r::StopConversion();
        while(nn::y2r::IsBusyConversion()) // Enable̊Ԃ͐ݒłȂ̂ő҂
        {
        }

        // ̓tH[}bg̕ύX
        nn::y2r::SetInputFormat( nn::y2r::INPUT_YUV422_BATCH );

        // o̓tH[}bg̕ύX
        nn::y2r::SetOutputFormat( format );

        // o̓f[^̉]px̕ύX
        nn::y2r::SetRotation( nn::y2r::ROTATION_NONE );

        // o̓f[^̕я̕ύX
        nn::y2r::SetBlockAlignment( alignment );

        // 荞݂̐ݒ
        nn::y2r::SetTransferEndInterrupt( true );

        // ̓f[^̃TCYw
        nn::y2r::SetInputLineWidth( imageWidth );
        nn::y2r::SetInputLines( imageHeight );

        // ϊW̐ݒ
        nn::y2r::SetStandardCoefficient( coefficient );

        // At@l̐ݒ(̃fł͎gpȂ)
        nn::y2r::SetAlpha(0xFF);
    }

} //namespace camera_exp


//==============================================================================
nn::y2r::StandardCoefficient Y2rManager_cl::m_Coefficient;
nn::y2r::OutputFormat Y2rManager_cl::m_Format;
nn::y2r::BlockAlignment Y2rManager_cl::m_Alignment;
size_t Y2rManager_cl::m_SendTransferUnit;
size_t Y2rManager_cl::m_SendSize;
size_t Y2rManager_cl::m_RecvTransferUnit;
size_t Y2rManager_cl::m_RecvSize;
s32    Y2rManager_cl::m_RecvOffset;
size_t Y2rManager_cl::m_ImageWidth;
size_t Y2rManager_cl::m_ImageHeight;
size_t Y2rManager_cl::m_TextureWidth;
size_t Y2rManager_cl::m_TextureHeight;
s32    Y2rManager_cl::m_WorkIndex;
u8   * Y2rManager_cl::mpa_RgbBuffers[ 2 ][ 2 ];
s32    Y2rManager_cl::m_RgbRp[ 2 ];
nn::os::Event  Y2rManager_cl::ma_Events[ Y2rManager_cl::e_EVENT_NUM ];
nn::math::VEC3 Y2rManager_cl::m_TextureScale;

//==============================================================================
void Y2rManager_cl::InitializeInternalWork( void )
{
    s_CsSet.Initialize();    
}

//==============================================================================
void Y2rManager_cl::FinalizeInternalWork( void )
{
    s_CsSet.Finalize();
}

//==============================================================================
void Y2rManager_cl::SwapBuffer( void )
{
    nn::os::CriticalSection::ScopedLock sl( s_CsSet );

    m_RgbRp[ m_WorkIndex ] ^= 1;
}

//==============================================================================
void Y2rManager_cl::SwapBuffer( s32 index )
{
    nn::os::CriticalSection::ScopedLock sl( s_CsSet );

    m_RgbRp[ index ] ^= 1;
}

//==============================================================================
u8 * Y2rManager_cl::GetRecvBuffer( s32 index )
{
    s32 rp = 0;
    u8 *pBuffer = NULL;
    {
        nn::os::CriticalSection::ScopedLock sl( s_CsSet );
        rp = m_RgbRp[ index ];
        pBuffer = mpa_RgbBuffers[ index ][ rp ^ 1 ];
    }
    return &pBuffer[ m_RecvOffset ];
}

//==============================================================================
u8 * Y2rManager_cl::GetTextureBuffer( s32 index )
{
    s32 rp = 0;
    {
        nn::os::CriticalSection::ScopedLock sl( s_CsSet );
        rp = m_RgbRp[ index ];
    }
    return mpa_RgbBuffers[ index ][ rp ];
}

//==============================================================================
void Y2rManager_cl::SetWorkIndex( s32 index )
{
    m_WorkIndex = index;
}

//==============================================================================
void Y2rManager_cl::StartDmaConversion( s32 index, u8 * p_YuvBuffer )
{
    nn::y2r::StopConversion();
    //while( nn::y2r::IsBusyConversion() )
    //{
    //}

    SetWorkIndex( index );

    nn::y2r::SetReceiving(
                reinterpret_cast<void*>( GetRecvBuffer( index ) ),
                m_RecvSize,
                m_RecvTransferUnit );

    nn::y2r::SetSendingYuv(
                reinterpret_cast<void*>( p_YuvBuffer ),
                m_SendSize,
                m_SendTransferUnit );

    // Y2RϊJn
    nn::y2r::StartConversion();
}

//==============================================================================
void Y2rManager_cl::EndDmaConversion( void )
{
}
