/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     camera_exp_util.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 18837 $
 *---------------------------------------------------------------------------*/

#ifndef UTIL_H_
#define UTIL_H_

#include <nn/camera/CTR/camera_ApiForHardwareCheck.h>
//#include <nn/camera/CTR/camera_Api.h>
#include <nn/y2r.h>

namespace camera_exp {

    //==============================================================================
    /** |[gƑΉJ̕ϊ
     */
    static inline nn::camera::CameraSelect GetCamera( nn::camera::Port port )
    {
        nn::camera::CameraSelect camera = nn::camera::SELECT_NONE;
        if( port & nn::camera::PORT_CAM1 )
        {
            camera = static_cast< nn::camera::CameraSelect >( camera | nn::camera::SELECT_IN1_OUT1 );
        }
        if( port & nn::camera::PORT_CAM2 )
        {
            camera = static_cast< nn::camera::CameraSelect >( camera | nn::camera::SELECT_OUT2 );
        }
        return camera;
    }

    //==============================================================================
    /** JƑΉ|[g̕ϊ
     */
    static inline nn::camera::Port GetPort( nn::camera::CameraSelect camera )
    {
        nn::camera::Port port = nn::camera::PORT_NONE;
        if( camera & nn::camera::SELECT_IN1_OUT1 )
        {
            port = static_cast< nn::camera::Port >( port | nn::camera::PORT_CAM1 ); 
        }
        if( camera & nn::camera::SELECT_OUT2 )
        {
            port = static_cast< nn::camera::Port >( port | nn::camera::PORT_CAM2 ); 
        }
        return port;
    }

    //==============================================================================
    /** |[gƔzCfbNX̕ϊ
     */
    inline s32 GetPortIndex( nn::camera::Port port )
    {
        return ( ( port == nn::camera::PORT_CAM1 ) ? 0 : 1 );
    }

    //==============================================================================
    /** 񒷂Ԃ
     */
    static inline s32 GetStrNLen( const char * str, s32 max )
    {
        s32  len = 0;
        for( len=0; (len < max) && (str[len] != 0); len++ )
        {
            // do nothing
        }
        return len;
    }

    //==============================================================================
    /** 摜̕Ԃ
     */
    static inline size_t GetCameraWidth( nn::camera::Size size )
    {
        size_t width = 0;
        switch( size )
        {
        case nn::camera::SIZE_VGA:         width = 640; break;
        case nn::camera::SIZE_QVGA:        width = 320; break;
        case nn::camera::SIZE_QQVGA:       width = 160; break;
        case nn::camera::SIZE_CIF:         width = 352; break;
        case nn::camera::SIZE_QCIF:        width = 176; break;
        case nn::camera::SIZE_DS_LCD:      width = 256; break;
        case nn::camera::SIZE_DS_LCDx4:    width = 512; break;
        case nn::camera::SIZE_CTR_TOP_LCD: width = 400; break;
        }
        return width;
    }

    //==============================================================================
    /** 摜̍Ԃ
     */
    static inline size_t GetCameraHeight( nn::camera::Size size )
    {
        size_t height = 0;
        switch( size )
        {
        case nn::camera::SIZE_VGA:         height = 480; break;
        case nn::camera::SIZE_QVGA:        height = 240; break;
        case nn::camera::SIZE_QQVGA:       height = 120; break;
        case nn::camera::SIZE_CIF:         height = 288; break;
        case nn::camera::SIZE_QCIF:        height = 144; break;
        case nn::camera::SIZE_DS_LCD:      height = 192; break;
        case nn::camera::SIZE_DS_LCDx4:    height = 384; break;
        case nn::camera::SIZE_CTR_TOP_LCD: height = 240; break;
        }
        return height;
    }

    //==============================================================================
    /** 摜TCYɍ킹eNX`Ԃ
     */
    static inline size_t GetTextureWidth( nn::camera::Size size )
    {
        size_t width = 0;
        switch( size )
        {
        case nn::camera::SIZE_VGA:         width = 512; break;
        case nn::camera::SIZE_QVGA:        width = 256; break;
        case nn::camera::SIZE_QQVGA:       width = 128; break;
        case nn::camera::SIZE_CIF:         width = 256; break;
        case nn::camera::SIZE_QCIF:        width = 128; break;
        case nn::camera::SIZE_DS_LCD:      width = 256; break;
        case nn::camera::SIZE_DS_LCDx4:    width = 512; break;
        case nn::camera::SIZE_CTR_TOP_LCD: width = 256; break;
        }
        return width;
    }

    //==============================================================================
    /** 摜TCYɍ킹eNX`̍Ԃ
     */
    static inline size_t GetTextureHeight( nn::camera::Size size )
    {
        // ƍ킹
        return GetTextureWidth( size );
    }

    //==============================================================================
    /** eNX`Ɏ܂摜̃g~OԂ
     */
    static inline size_t GetTrimmingWidthInTexture( nn::camera::Size size )
    {
        return GetTextureWidth( size );
    }

    //==============================================================================
    /** eNX`Ɏ܂摜̃g~OԂ
     */
    static inline size_t GetTrimmingHeightInTexture( nn::camera::Size size )
    {
        // 4:3 ɂ
        return ( GetTextureWidth( size ) * 3 / 4 );
    }

} //camera_exp

#endif //#ifndef UTIL_H_
