/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     tp_manager.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 18253 $
 *---------------------------------------------------------------------------*/

#ifndef TP_MANAGER_H_
#define TP_MANAGER_H_

#include <nn/hid.h>

namespace camera_exp {

    //==============================================================================
    /** ^b`plǗNX : static
     */
    class TpManager_cl
    {
    public:
        TpManager_cl()
        {}

    public:
        static void Initialize( nn::hid::TouchPanelReader * p_Reader,
                                nn::hid::TouchPanelStatus * p_Status )
        {
            mp_Reader    = p_Reader;
            mp_Status    = p_Status;
            m_X          = 0;
            m_Y          = 0;
            m_XBack      = 0;
            m_YBack      = 0;
            m_IsTrigger  = false;
            m_IsRelease  = false;
            m_IsHold     = false;
            m_IsHoldBack = false;
        }

    public:
        /** [hXV
         */
        static void Read( void );

        /** W̎擾
         */
        static s32 GetX( void )
        {
            return m_X;
        }

        static s32 GetY( void )
        {
            return m_Y;
        }

        /** ^b`ꂽǂԂ (W͂ǂł)
         */
        static bool IsTrigger( void )
        {
            return m_IsTrigger;
        }

        static bool IsRelease( void )
        {
            return m_IsRelease;
        }

        static bool IsHold( void )
        {
            return m_IsHold;
        }

        /** ^b`ꂽǂԂ (Ww)
         */
        static bool IsTrigger( s32 sx, s32 sy, s32 width, s32 height )
        {
            return ( IsTrigger() && IsIn( sx, sy, width, height ) );
        }

        static bool IsRelease( s32 sx, s32 sy, s32 width, s32 height )
        {
            return ( IsRelease() && IsInBack( sx, sy, width, height ) );
        }

        static bool IsHold( s32 sx, s32 sy, s32 width, s32 height )
        {
            return ( IsHold() && IsIn( sx, sy, width, height ) && IsInBack( sx, sy, width, height ) );
        }

        /** ^b`ẄɓĂ邩Ԃ
         */
        static bool IsIn( s32 sx, s32 sy, s32 width, s32 height );

    private:
        static bool IsInBack( s32 sx, s32 sy, s32 width, s32 height );

    private:
        // [_
        static nn::hid::TouchPanelReader * mp_Reader;

        // [hi[
        static nn::hid::TouchPanelStatus * mp_Status;

        // W
        static s32 m_X;
        static s32 m_Y;
        static s32 m_XBack;
        static s32 m_YBack;

        // ^b`Ă邩ǂ
        static bool m_IsTrigger;
        static bool m_IsRelease;
        static bool m_IsHold;
        static bool m_IsHoldBack;

    }; // TpManager_cl

} //namespace camera_exp

#endif //#ifndef TP_MANAGER_H_

