/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     tp_manager.cpp

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 18253 $
 *---------------------------------------------------------------------------*/

#include <nn/hid.h>

#include "tp_manager.h"

using namespace camera_exp;

namespace
{
    /** ^b`pl̗̈攻̗V
     */
    const s32 s_Margin = 8;
}

nn::hid::TouchPanelReader * TpManager_cl::mp_Reader;
nn::hid::TouchPanelStatus * TpManager_cl::mp_Status;
s32 TpManager_cl::m_X;
s32 TpManager_cl::m_Y;
s32 TpManager_cl::m_XBack;
s32 TpManager_cl::m_YBack;
bool TpManager_cl::m_IsTrigger;
bool TpManager_cl::m_IsRelease;
bool TpManager_cl::m_IsHold;
bool TpManager_cl::m_IsHoldBack;

//==============================================================================
void TpManager_cl::Read( void )
{
    mp_Reader->ReadLatest( mp_Status );

    m_XBack = m_X;
    m_YBack = m_Y;
    m_X     = mp_Status->x;
    m_Y     = mp_Status->y;

    m_IsHoldBack = m_IsHold;
    m_IsHold     = mp_Status->touch;

    if( !m_IsHoldBack && m_IsHold )
    {
        m_IsTrigger = true;
    }
    else
    {
        m_IsTrigger = false;
    }

    if( m_IsHoldBack && !m_IsHold )
    {
        m_IsRelease = true;
    }
    else
    {
        m_IsRelease = false;
    }
} //TpManager_cl::Read

//==============================================================================
bool TpManager_cl::IsIn( s32 sx, s32 sy, s32 width, s32 height )
{
    sx = sx - s_Margin;
    sy = sy - s_Margin;
    s32 ex = sx + width  - 1 + s_Margin;
    s32 ey = sy + height - 1 + s_Margin;
    if(    ( sx <= m_X ) && ( m_X <= ex ) 
        && ( sy <= m_Y ) && ( m_Y <= ey ) )
    {
        return true;
    }
    return false;
}

//==============================================================================
bool TpManager_cl::IsInBack( s32 sx, s32 sy, s32 width, s32 height )
{
    sx = sx - s_Margin;
    sy = sy - s_Margin;
    s32 ex = sx + width  - 1 + s_Margin;
    s32 ey = sy + height - 1 + s_Margin;
    if(    ( sx <= m_XBack ) && ( m_XBack <= ex ) 
        && ( sy <= m_YBack ) && ( m_YBack <= ey ) )
    {
        return true;
    }
    return false;
}


