/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     menu.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 24525 $
 *---------------------------------------------------------------------------*/

#ifndef SETTING_MENU_H_
#define SETTING_MENU_H_

#include <nn/os.h>
#include <nn/fnd.h>
#include <string.h>

#include "camera_manager.h"
#include "key_manager.h"

namespace camera_exp {

    //==============================================================================
    /** j[̍\
     *
     *  JƁC1̃JłĂReLXgƂ
     *  ݒς邱Ƃł悤Ƀj[͈ȉ̊Kw\Ă
     *    * j[ (SettingMenu_cl)
     *       |-- j[1 (SettingMenuItem_st) : j[1ڂ̐ݒ
     *       |    |-- J OUT1 (SettingMenuCameraItem_st) : Jʂ̐ݒ
     *       |    |    |-- ReLXgA (SettingMenuContextItem_st) : ReLXgʂ̐ݒ
     *       |    |    *-- ReLXgB (SettingMenuContextItem_st)
     *       |    |-- J IN1  (SettingMenuCameraItem_st)
     *       |    |    |..
     *       |    *-- J OUT2 (SettingMenuCameraItem_st)
     *       |         |..
     *       |
     *       |-- j[2
     *       |    |-- J
     *       |    |...
     *       |
     *       ... (ȉCj[̍ڐ)
     */

    //==============================================================================
    /** ReLXgʂ̐ݒ
     */
    struct SettingMenuContextItem_st
    {
        enum
        {
            e_INDEX_CONTEXT_A = 0,
            e_INDEX_CONTEXT_B,

            e_INDEX_CONTEXT_NUM
        };

        s32   decided;        // ς݂̐ݒl(݂̐ݒl)
        s32   changing;       // ύX̐ݒl
    };

    //==============================================================================
    /** Jʂ̐ݒ
     */
    struct SettingMenuCameraItem_st
    {
        enum
        {
            e_INDEX_CAMERA_OUT1 = 0,
            e_INDEX_CAMERA_IN1,
            e_INDEX_CAMERA_OUT2,

            e_INDEX_CAMERA_NUM
        };

        // ReLXgƂ݂̌̐ݒl
        SettingMenuContextItem_st  a_ContextItem[ SettingMenuContextItem_st::e_INDEX_CONTEXT_NUM ];
    };

    //==============================================================================
    /** j[1ڂ\邽߂̃p[^
     */
    struct SettingMenuItem_st
    {
        // \p[^
        f32   x;                    // \ʒu
        f32   y;
        const char *title;          // ^Cg
        const char **nameList;      // eݒp[^̖O

        // enum ̏ꍇ
        s32   numOfParam;           // p[^

        // l̏ꍇ
        bool  isCount;
        NN_PADDING3;
        s32   countMin;
        s32   countMax;
        s32   countStep;
        const char *countFormat;

        // JƂ݂̌̐ݒl
        SettingMenuCameraItem_st  a_CameraItem[ SettingMenuCameraItem_st::e_INDEX_CAMERA_NUM ];

        // ̃ReLXgɔf鍀ڂ
        bool  isBothContext;

        // SJɔf鍀ڂ
        bool  isAllCamera;

        // J[\
        bool  isEditable;           // ҏW\ǂ

        NN_PADDING1;

    }; //struct SettingMenuItem_st

    //==============================================================================
    /** j[\NX
     *  gp RenderSystem ƃNGXg̃rbgev[gŎw肷
     */
    template <class T_FW, class T_REQ>
    class SettingMenu_cl
    {
    public:
        SettingMenu_cl(){}

    public:
        void Initialize(
            T_FW        * p_RenderSystem,
            SettingMenuItem_st * a_MenuItem,
            s32         menuNum )
        {
            mp_RenderSystem  = p_RenderSystem;
            ma_MenuItems     = a_MenuItem;
            m_MenuNum        = menuNum;
            m_Selecting      = 0;
            m_Request        = static_cast<T_REQ>( 0 );

            m_CsRequest.Initialize();
        }

    public:
        /** j[`
         *  @param[in] currentCamera  : \Ώۂ̃J
         *  @param[in] currentContext : \Ώۂ̃ReLXg
         */
        void Draw( nn::camera::CameraSelect currentCamera,
                   nn::camera::Context      currentContext );

        /** NGXgZbg
         */
        void SetRequest( T_REQ request )
        {
            nn::os::CriticalSection::ScopedLock sl( m_CsRequest );

            m_Request = request;
        }

        /** 1̃NGXg
         */
        void AddRequest( T_REQ request )
        {
            nn::os::CriticalSection::ScopedLock sl( m_CsRequest );

            m_Request |= request;
        }

        /** NGXgԂ
         */
        T_REQ GetRequest( void ) const
        {
            return m_Request;
        }

        /** j[ڂւ̎QƂԂ
         */
        SettingMenuItem_st & GetMenuItem( s32 index )
        {
            return ma_MenuItems[ index ];
        }

        /** Jݒ̃CfbNXԂ
         */
        s32 GetCameraIndex( nn::camera::CameraSelect camera )
        {
            s32 index = 0;
            switch( camera )
            {
            case nn::camera::SELECT_OUT1:
            case nn::camera::SELECT_OUT1_OUT2:
            case nn::camera::SELECT_NONE:
            case nn::camera::SELECT_ALL:
                index = SettingMenuCameraItem_st::e_INDEX_CAMERA_OUT1;
                break;
            case nn::camera::SELECT_IN1:
            case nn::camera::SELECT_IN1_OUT2:
                index = SettingMenuCameraItem_st::e_INDEX_CAMERA_IN1;
                break;
            case nn::camera::SELECT_OUT2:
                index = SettingMenuCameraItem_st::e_INDEX_CAMERA_OUT2;
                break;
            }
            return index;
        }

        /** ReLXgݒ̃CfbNXԂ
         */
        s32 GetContextIndex( nn::camera::Context context )
        {
            s32 index = (context == nn::camera::CONTEXT_B)
                            ? SettingMenuContextItem_st::e_INDEX_CONTEXT_B
                            : SettingMenuContextItem_st::e_INDEX_CONTEXT_A;  // BOTH ̂Ƃɂ A ̃CfbNXԂ

            index = SettingMenuContextItem_st::e_INDEX_CONTEXT_A;  // A ̃CfbNXԂ
            return index;
        }

        /** ReLXgݒZbg(㏑) 
         */
        void SetContextItem( s32 menuIndex, s32 cameraIndex, s32 contextIndex,
                             s32 changing, s32 decided )
        {
            SettingMenuContextItem_st & dst_context = 
                ma_MenuItems[ menuIndex ].a_CameraItem[ cameraIndex ].a_ContextItem[ contextIndex ];

            dst_context.changing = changing;
            dst_context.decided  = decided;
        }

        /** ReLXgݒւ̎QƂԂ
         */
        SettingMenuContextItem_st & GetContextItem( s32 menu, s32 camera, s32 context )
        {
            return ma_MenuItems[ menu ].a_CameraItem[ camera ].a_ContextItem[ context ];
        }

    protected:
        // `Ɏgpt[[N
        // nn::demo::RenderSystemEx x[X or
        // RenderSystem x[XłȂ΂ȂȂ
        T_FW        * mp_RenderSystem;

        // j[ڂ̔zw|C^
        // 炩ߎgpŒ`ꂽj[ڔzn
        SettingMenuItem_st * ma_MenuItems;

        // j[ڂ̐
        s32         m_MenuNum;

        // IĂ鍀
        s32         m_Selecting;

        // j[IŌ肳ꂽNGXg
        // ߂͎gpɂ䂾˂
        T_REQ       m_Request;

        // NGXg݂̏ɔr
        nn::os::CriticalSection  m_CsRequest;

    }; //class SettingMenu_cl

    //==============================================================================
    template <class T_FW, class T_REQ>
    void SettingMenu_cl<T_FW, T_REQ>::Draw( nn::camera::CameraSelect currentCamera,
                                            nn::camera::Context      currentContext )
    {
        T_REQ   request = 0;          // ύXv

        // ݂̃JƃReLXgŕ\ݒ؂ւ
        s32 cameraIndex  = GetCameraIndex(  currentCamera );
        s32 contextIndex = GetContextIndex( currentContext );

        // IĂȂJ/ReLXg̐ݒ͑I𒆂łȌԂɖ߂
        for( s32 k=0; k < m_MenuNum; k++ )
        {
            for( s32 i=0; i < SettingMenuCameraItem_st::e_INDEX_CAMERA_NUM; i++ )
            {
                for( s32 j=0; j < SettingMenuContextItem_st::e_INDEX_CONTEXT_NUM; j++ )
                {
                    if( (i != cameraIndex) || (j != contextIndex) )
                    {
                        ma_MenuItems[ k ].a_CameraItem[ i ].a_ContextItem[ j ].changing
                            = ma_MenuItems[ k ].a_CameraItem[ i ].a_ContextItem[ j ].decided;
                    }
                }
            }
        }

        // ύXvL
        if( request != 0 )
        {
            SetRequest( request );
        }
    } //Draw()

} //namespace camera_exp


#endif //SETTING_MENU_H_
